# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from pyesi_openapi.models.characters_character_id_planets_planet_id_get_pins_inner_contents_inner import CharactersCharacterIdPlanetsPlanetIdGetPinsInnerContentsInner
from pyesi_openapi.models.characters_character_id_planets_planet_id_get_pins_inner_extractor_details import CharactersCharacterIdPlanetsPlanetIdGetPinsInnerExtractorDetails
from pyesi_openapi.models.characters_character_id_planets_planet_id_get_pins_inner_factory_details import CharactersCharacterIdPlanetsPlanetIdGetPinsInnerFactoryDetails
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdPlanetsPlanetIdGetPinsInner(BaseModel):
    """
    pin object
    """ # noqa: E501
    contents: Optional[List[CharactersCharacterIdPlanetsPlanetIdGetPinsInnerContentsInner]] = None
    expiry_time: Optional[datetime] = None
    extractor_details: Optional[CharactersCharacterIdPlanetsPlanetIdGetPinsInnerExtractorDetails] = None
    factory_details: Optional[CharactersCharacterIdPlanetsPlanetIdGetPinsInnerFactoryDetails] = None
    install_time: Optional[datetime] = None
    last_cycle_start: Optional[datetime] = None
    latitude: Union[StrictFloat, StrictInt]
    longitude: Union[StrictFloat, StrictInt]
    pin_id: StrictInt
    schematic_id: Optional[StrictInt] = None
    type_id: StrictInt
    __properties: ClassVar[List[str]] = ["contents", "expiry_time", "extractor_details", "factory_details", "install_time", "last_cycle_start", "latitude", "longitude", "pin_id", "schematic_id", "type_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdPlanetsPlanetIdGetPinsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in contents (list)
        _items = []
        if self.contents:
            for _item_contents in self.contents:
                if _item_contents:
                    _items.append(_item_contents.to_dict())
            _dict['contents'] = _items
        # override the default output from pydantic by calling `to_dict()` of extractor_details
        if self.extractor_details:
            _dict['extractor_details'] = self.extractor_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of factory_details
        if self.factory_details:
            _dict['factory_details'] = self.factory_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdPlanetsPlanetIdGetPinsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "contents": [CharactersCharacterIdPlanetsPlanetIdGetPinsInnerContentsInner.from_dict(_item) for _item in obj["contents"]] if obj.get("contents") is not None else None,
            "expiry_time": obj.get("expiry_time"),
            "extractor_details": CharactersCharacterIdPlanetsPlanetIdGetPinsInnerExtractorDetails.from_dict(obj["extractor_details"]) if obj.get("extractor_details") is not None else None,
            "factory_details": CharactersCharacterIdPlanetsPlanetIdGetPinsInnerFactoryDetails.from_dict(obj["factory_details"]) if obj.get("factory_details") is not None else None,
            "install_time": obj.get("install_time"),
            "last_cycle_start": obj.get("last_cycle_start"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "pin_id": obj.get("pin_id"),
            "schematic_id": obj.get("schematic_id"),
            "type_id": obj.get("type_id")
        })
        return _obj


