# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdSearchGet(BaseModel):
    """
    CharactersCharacterIdSearchGet
    """ # noqa: E501
    agent: Optional[List[StrictInt]] = None
    alliance: Optional[List[StrictInt]] = None
    character: Optional[List[StrictInt]] = None
    constellation: Optional[List[StrictInt]] = None
    corporation: Optional[List[StrictInt]] = None
    faction: Optional[List[StrictInt]] = None
    inventory_type: Optional[List[StrictInt]] = None
    region: Optional[List[StrictInt]] = None
    solar_system: Optional[List[StrictInt]] = None
    station: Optional[List[StrictInt]] = None
    structure: Optional[List[StrictInt]] = None
    __properties: ClassVar[List[str]] = ["agent", "alliance", "character", "constellation", "corporation", "faction", "inventory_type", "region", "solar_system", "station", "structure"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdSearchGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdSearchGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agent": obj.get("agent"),
            "alliance": obj.get("alliance"),
            "character": obj.get("character"),
            "constellation": obj.get("constellation"),
            "corporation": obj.get("corporation"),
            "faction": obj.get("faction"),
            "inventory_type": obj.get("inventory_type"),
            "region": obj.get("region"),
            "solar_system": obj.get("solar_system"),
            "station": obj.get("station"),
            "structure": obj.get("structure")
        })
        return _obj


