# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdSkillqueueGetInner(BaseModel):
    """
    CharactersCharacterIdSkillqueueGetInner
    """ # noqa: E501
    finish_date: Optional[datetime] = Field(default=None, description="Date on which training of the skill will complete. Omitted if the skill queue is paused.")
    finished_level: StrictInt
    level_end_sp: Optional[StrictInt] = None
    level_start_sp: Optional[StrictInt] = Field(default=None, description="Amount of SP that was in the skill when it started training it's current level. Used to calculate % of current level complete.")
    queue_position: StrictInt
    skill_id: StrictInt
    start_date: Optional[datetime] = None
    training_start_sp: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["finish_date", "finished_level", "level_end_sp", "level_start_sp", "queue_position", "skill_id", "start_date", "training_start_sp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdSkillqueueGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdSkillqueueGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "finish_date": obj.get("finish_date"),
            "finished_level": obj.get("finished_level"),
            "level_end_sp": obj.get("level_end_sp"),
            "level_start_sp": obj.get("level_start_sp"),
            "queue_position": obj.get("queue_position"),
            "skill_id": obj.get("skill_id"),
            "start_date": obj.get("start_date"),
            "training_start_sp": obj.get("training_start_sp")
        })
        return _obj


