# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdWalletJournalGetInner(BaseModel):
    """
    CharactersCharacterIdWalletJournalGetInner
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount of ISK given or taken from the wallet as a result of the given transaction. Positive when ISK is deposited into the wallet and negative when ISK is withdrawn")
    balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Wallet balance after transaction occurred")
    context_id: Optional[StrictInt] = Field(default=None, description="An ID that gives extra context to the particular transaction. Because of legacy reasons the context is completely different per ref_type and means different things. It is also possible to not have a context_id")
    context_id_type: Optional[StrictStr] = Field(default=None, description="The type of the given context_id if present")
    var_date: datetime = Field(description="Date and time of transaction", alias="date")
    description: StrictStr = Field(description="The reason for the transaction, mirrors what is seen in the client")
    first_party_id: Optional[StrictInt] = Field(default=None, description="The id of the first party involved in the transaction. This attribute has no consistency and is different or non existant for particular ref_types. The description attribute will help make sense of what this attribute means. For more info about the given ID it can be dropped into the /universe/names/ ESI route to determine its type and name")
    id: StrictInt = Field(description="Unique journal reference ID")
    reason: Optional[StrictStr] = Field(default=None, description="The user stated reason for the transaction. Only applies to some ref_types")
    ref_type: StrictStr = Field(description="\"The transaction type for the given. transaction. Different transaction types will populate different attributes.\"")
    second_party_id: Optional[StrictInt] = Field(default=None, description="The id of the second party involved in the transaction. This attribute has no consistency and is different or non existant for particular ref_types. The description attribute will help make sense of what this attribute means. For more info about the given ID it can be dropped into the /universe/names/ ESI route to determine its type and name")
    tax: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Tax amount received. Only applies to tax related transactions")
    tax_receiver_id: Optional[StrictInt] = Field(default=None, description="The corporation ID receiving any tax paid. Only applies to tax related transactions")
    __properties: ClassVar[List[str]] = ["amount", "balance", "context_id", "context_id_type", "date", "description", "first_party_id", "id", "reason", "ref_type", "second_party_id", "tax", "tax_receiver_id"]

    @field_validator('context_id_type')
    def context_id_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['structure_id', 'station_id', 'market_transaction_id', 'character_id', 'corporation_id', 'alliance_id', 'eve_system', 'industry_job_id', 'contract_id', 'planet_id', 'system_id', 'type_id']):
            raise ValueError("must be one of enum values ('structure_id', 'station_id', 'market_transaction_id', 'character_id', 'corporation_id', 'alliance_id', 'eve_system', 'industry_job_id', 'contract_id', 'planet_id', 'system_id', 'type_id')")
        return value

    @field_validator('ref_type')
    def ref_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['acceleration_gate_fee', 'advertisement_listing_fee', 'agent_donation', 'agent_location_services', 'agent_miscellaneous', 'agent_mission_collateral_paid', 'agent_mission_collateral_refunded', 'agent_mission_reward', 'agent_mission_reward_corporation_tax', 'agent_mission_time_bonus_reward', 'agent_mission_time_bonus_reward_corporation_tax', 'agent_security_services', 'agent_services_rendered', 'agents_preward', 'air_career_program_reward', 'alliance_maintainance_fee', 'alliance_registration_fee', 'allignment_based_gate_toll', 'asset_safety_recovery_tax', 'bounty', 'bounty_prize', 'bounty_prize_corporation_tax', 'bounty_prizes', 'bounty_reimbursement', 'bounty_surcharge', 'brokers_fee', 'clone_activation', 'clone_transfer', 'contraband_fine', 'contract_auction_bid', 'contract_auction_bid_corp', 'contract_auction_bid_refund', 'contract_auction_sold', 'contract_brokers_fee', 'contract_brokers_fee_corp', 'contract_collateral', 'contract_collateral_deposited_corp', 'contract_collateral_payout', 'contract_collateral_refund', 'contract_deposit', 'contract_deposit_corp', 'contract_deposit_refund', 'contract_deposit_sales_tax', 'contract_price', 'contract_price_payment_corp', 'contract_reversal', 'contract_reward', 'contract_reward_deposited', 'contract_reward_deposited_corp', 'contract_reward_refund', 'contract_sales_tax', 'copying', 'corporate_reward_payout', 'corporate_reward_tax', 'corporation_account_withdrawal', 'corporation_bulk_payment', 'corporation_dividend_payment', 'corporation_liquidation', 'corporation_logo_change_cost', 'corporation_payment', 'corporation_registration_fee', 'cosmetic_market_component_item_purchase', 'cosmetic_market_skin_purchase', 'cosmetic_market_skin_sale', 'cosmetic_market_skin_sale_broker_fee', 'cosmetic_market_skin_sale_tax', 'cosmetic_market_skin_transaction', 'courier_mission_escrow', 'cspa', 'cspaofflinerefund', 'daily_challenge_reward', 'daily_goal_payouts', 'daily_goal_payouts_tax', 'datacore_fee', 'dna_modification_fee', 'docking_fee', 'duel_wager_escrow', 'duel_wager_payment', 'duel_wager_refund', 'ess_escrow_transfer', 'external_trade_delivery', 'external_trade_freeze', 'external_trade_thaw', 'factory_slot_rental_fee', 'flux_payout', 'flux_tax', 'flux_ticket_repayment', 'flux_ticket_sale', 'freelance_jobs_broadcasting_fee', 'freelance_jobs_duration_fee', 'freelance_jobs_escrow_refund', 'freelance_jobs_reward', 'freelance_jobs_reward_corporation_tax', 'freelance_jobs_reward_escrow', 'gm_cash_transfer', 'gm_plex_fee_refund', 'industry_job_tax', 'infrastructure_hub_maintenance', 'inheritance', 'insurance', 'insurgency_corruption_contribution_reward', 'insurgency_suppression_contribution_reward', 'item_trader_payment', 'jump_clone_activation_fee', 'jump_clone_installation_fee', 'kill_right_fee', 'lp_store', 'manufacturing', 'market_escrow', 'market_fine_paid', 'market_provider_tax', 'market_transaction', 'medal_creation', 'medal_issued', 'milestone_reward_payment', 'mission_completion', 'mission_cost', 'mission_expiration', 'mission_reward', 'office_rental_fee', 'operation_bonus', 'opportunity_reward', 'planetary_construction', 'planetary_export_tax', 'planetary_import_tax', 'player_donation', 'player_trading', 'project_discovery_reward', 'project_discovery_tax', 'project_payouts', 'reaction', 'redeemed_isk_token', 'release_of_impounded_property', 'repair_bill', 'reprocessing_tax', 'researching_material_productivity', 'researching_technology', 'researching_time_productivity', 'resource_wars_reward', 'reverse_engineering', 'season_challenge_reward', 'security_processing_fee', 'shares', 'skill_purchase', 'skyhook_claim_fee', 'sovereignity_bill', 'store_purchase', 'store_purchase_refund', 'structure_gate_jump', 'transaction_tax', 'under_construction', 'upkeep_adjustment_fee', 'war_ally_contract', 'war_fee', 'war_fee_surrender']):
            raise ValueError("must be one of enum values ('acceleration_gate_fee', 'advertisement_listing_fee', 'agent_donation', 'agent_location_services', 'agent_miscellaneous', 'agent_mission_collateral_paid', 'agent_mission_collateral_refunded', 'agent_mission_reward', 'agent_mission_reward_corporation_tax', 'agent_mission_time_bonus_reward', 'agent_mission_time_bonus_reward_corporation_tax', 'agent_security_services', 'agent_services_rendered', 'agents_preward', 'air_career_program_reward', 'alliance_maintainance_fee', 'alliance_registration_fee', 'allignment_based_gate_toll', 'asset_safety_recovery_tax', 'bounty', 'bounty_prize', 'bounty_prize_corporation_tax', 'bounty_prizes', 'bounty_reimbursement', 'bounty_surcharge', 'brokers_fee', 'clone_activation', 'clone_transfer', 'contraband_fine', 'contract_auction_bid', 'contract_auction_bid_corp', 'contract_auction_bid_refund', 'contract_auction_sold', 'contract_brokers_fee', 'contract_brokers_fee_corp', 'contract_collateral', 'contract_collateral_deposited_corp', 'contract_collateral_payout', 'contract_collateral_refund', 'contract_deposit', 'contract_deposit_corp', 'contract_deposit_refund', 'contract_deposit_sales_tax', 'contract_price', 'contract_price_payment_corp', 'contract_reversal', 'contract_reward', 'contract_reward_deposited', 'contract_reward_deposited_corp', 'contract_reward_refund', 'contract_sales_tax', 'copying', 'corporate_reward_payout', 'corporate_reward_tax', 'corporation_account_withdrawal', 'corporation_bulk_payment', 'corporation_dividend_payment', 'corporation_liquidation', 'corporation_logo_change_cost', 'corporation_payment', 'corporation_registration_fee', 'cosmetic_market_component_item_purchase', 'cosmetic_market_skin_purchase', 'cosmetic_market_skin_sale', 'cosmetic_market_skin_sale_broker_fee', 'cosmetic_market_skin_sale_tax', 'cosmetic_market_skin_transaction', 'courier_mission_escrow', 'cspa', 'cspaofflinerefund', 'daily_challenge_reward', 'daily_goal_payouts', 'daily_goal_payouts_tax', 'datacore_fee', 'dna_modification_fee', 'docking_fee', 'duel_wager_escrow', 'duel_wager_payment', 'duel_wager_refund', 'ess_escrow_transfer', 'external_trade_delivery', 'external_trade_freeze', 'external_trade_thaw', 'factory_slot_rental_fee', 'flux_payout', 'flux_tax', 'flux_ticket_repayment', 'flux_ticket_sale', 'freelance_jobs_broadcasting_fee', 'freelance_jobs_duration_fee', 'freelance_jobs_escrow_refund', 'freelance_jobs_reward', 'freelance_jobs_reward_corporation_tax', 'freelance_jobs_reward_escrow', 'gm_cash_transfer', 'gm_plex_fee_refund', 'industry_job_tax', 'infrastructure_hub_maintenance', 'inheritance', 'insurance', 'insurgency_corruption_contribution_reward', 'insurgency_suppression_contribution_reward', 'item_trader_payment', 'jump_clone_activation_fee', 'jump_clone_installation_fee', 'kill_right_fee', 'lp_store', 'manufacturing', 'market_escrow', 'market_fine_paid', 'market_provider_tax', 'market_transaction', 'medal_creation', 'medal_issued', 'milestone_reward_payment', 'mission_completion', 'mission_cost', 'mission_expiration', 'mission_reward', 'office_rental_fee', 'operation_bonus', 'opportunity_reward', 'planetary_construction', 'planetary_export_tax', 'planetary_import_tax', 'player_donation', 'player_trading', 'project_discovery_reward', 'project_discovery_tax', 'project_payouts', 'reaction', 'redeemed_isk_token', 'release_of_impounded_property', 'repair_bill', 'reprocessing_tax', 'researching_material_productivity', 'researching_technology', 'researching_time_productivity', 'resource_wars_reward', 'reverse_engineering', 'season_challenge_reward', 'security_processing_fee', 'shares', 'skill_purchase', 'skyhook_claim_fee', 'sovereignity_bill', 'store_purchase', 'store_purchase_refund', 'structure_gate_jump', 'transaction_tax', 'under_construction', 'upkeep_adjustment_fee', 'war_ally_contract', 'war_fee', 'war_fee_surrender')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdWalletJournalGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdWalletJournalGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "balance": obj.get("balance"),
            "context_id": obj.get("context_id"),
            "context_id_type": obj.get("context_id_type"),
            "date": obj.get("date"),
            "description": obj.get("description"),
            "first_party_id": obj.get("first_party_id"),
            "id": obj.get("id"),
            "reason": obj.get("reason"),
            "ref_type": obj.get("ref_type"),
            "second_party_id": obj.get("second_party_id"),
            "tax": obj.get("tax"),
            "tax_receiver_id": obj.get("tax_receiver_id")
        })
        return _obj


