# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CorporationsCorporationIdGet(BaseModel):
    """
    CorporationsCorporationIdGet
    """ # noqa: E501
    alliance_id: Optional[StrictInt] = Field(default=None, description="ID of the alliance that corporation is a member of, if any")
    ceo_id: StrictInt
    creator_id: StrictInt
    date_founded: Optional[datetime] = None
    description: Optional[StrictStr] = None
    faction_id: Optional[StrictInt] = None
    home_station_id: Optional[StrictInt] = None
    member_count: StrictInt
    name: StrictStr = Field(description="the full name of the corporation")
    shares: Optional[StrictInt] = None
    tax_rate: Union[StrictFloat, StrictInt]
    ticker: StrictStr = Field(description="the short name of the corporation")
    url: Optional[StrictStr] = None
    war_eligible: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["alliance_id", "ceo_id", "creator_id", "date_founded", "description", "faction_id", "home_station_id", "member_count", "name", "shares", "tax_rate", "ticker", "url", "war_eligible"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CorporationsCorporationIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CorporationsCorporationIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alliance_id": obj.get("alliance_id"),
            "ceo_id": obj.get("ceo_id"),
            "creator_id": obj.get("creator_id"),
            "date_founded": obj.get("date_founded"),
            "description": obj.get("description"),
            "faction_id": obj.get("faction_id"),
            "home_station_id": obj.get("home_station_id"),
            "member_count": obj.get("member_count"),
            "name": obj.get("name"),
            "shares": obj.get("shares"),
            "tax_rate": obj.get("tax_rate"),
            "ticker": obj.get("ticker"),
            "url": obj.get("url"),
            "war_eligible": obj.get("war_eligible")
        })
        return _obj


