# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CorporationsCorporationIdOrdersHistoryGetInner(BaseModel):
    """
    CorporationsCorporationIdOrdersHistoryGetInner
    """ # noqa: E501
    duration: StrictInt = Field(description="Number of days the order was valid for (starting from the issued date). An order expires at time issued + duration")
    escrow: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="For buy orders, the amount of ISK in escrow")
    is_buy_order: Optional[StrictBool] = Field(default=None, description="True if the order is a bid (buy) order")
    issued: datetime = Field(description="Date and time when this order was issued")
    issued_by: Optional[StrictInt] = Field(default=None, description="The character who issued this order")
    location_id: StrictInt = Field(description="ID of the location where order was placed")
    min_volume: Optional[StrictInt] = Field(default=None, description="For buy orders, the minimum quantity that will be accepted in a matching sell order")
    order_id: StrictInt = Field(description="Unique order ID")
    price: Union[StrictFloat, StrictInt] = Field(description="Cost per unit for this order")
    range: StrictStr = Field(description="Valid order range, numbers are ranges in jumps")
    region_id: StrictInt = Field(description="ID of the region where order was placed")
    state: StrictStr = Field(description="Current order state")
    type_id: StrictInt = Field(description="The type ID of the item transacted in this order")
    volume_remain: StrictInt = Field(description="Quantity of items still required or offered")
    volume_total: StrictInt = Field(description="Quantity of items required or offered at time order was placed")
    wallet_division: StrictInt = Field(description="The corporation wallet division used for this order")
    __properties: ClassVar[List[str]] = ["duration", "escrow", "is_buy_order", "issued", "issued_by", "location_id", "min_volume", "order_id", "price", "range", "region_id", "state", "type_id", "volume_remain", "volume_total", "wallet_division"]

    @field_validator('range')
    def range_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['1', '10', '2', '20', '3', '30', '4', '40', '5', 'region', 'solarsystem', 'station']):
            raise ValueError("must be one of enum values ('1', '10', '2', '20', '3', '30', '4', '40', '5', 'region', 'solarsystem', 'station')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['cancelled', 'expired']):
            raise ValueError("must be one of enum values ('cancelled', 'expired')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CorporationsCorporationIdOrdersHistoryGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CorporationsCorporationIdOrdersHistoryGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "duration": obj.get("duration"),
            "escrow": obj.get("escrow"),
            "is_buy_order": obj.get("is_buy_order"),
            "issued": obj.get("issued"),
            "issued_by": obj.get("issued_by"),
            "location_id": obj.get("location_id"),
            "min_volume": obj.get("min_volume"),
            "order_id": obj.get("order_id"),
            "price": obj.get("price"),
            "range": obj.get("range"),
            "region_id": obj.get("region_id"),
            "state": obj.get("state"),
            "type_id": obj.get("type_id"),
            "volume_remain": obj.get("volume_remain"),
            "volume_total": obj.get("volume_total"),
            "wallet_division": obj.get("wallet_division")
        })
        return _obj


