# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pyesi_openapi.models.corporations_corporation_id_starbases_starbase_id_get_fuels_inner import CorporationsCorporationIdStarbasesStarbaseIdGetFuelsInner
from typing import Optional, Set
from typing_extensions import Self

class CorporationsCorporationIdStarbasesStarbaseIdGet(BaseModel):
    """
    CorporationsCorporationIdStarbasesStarbaseIdGet
    """ # noqa: E501
    allow_alliance_members: StrictBool
    allow_corporation_members: StrictBool
    anchor: StrictStr = Field(description="Who can anchor starbase (POS) and its structures")
    attack_if_at_war: StrictBool
    attack_if_other_security_status_dropping: StrictBool
    attack_security_status_threshold: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Starbase (POS) will attack if target's security standing is lower than this value")
    attack_standing_threshold: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Starbase (POS) will attack if target's standing is lower than this value")
    fuel_bay_take: StrictStr = Field(description="Who can take fuel blocks out of the starbase (POS)'s fuel bay")
    fuel_bay_view: StrictStr = Field(description="Who can view the starbase (POS)'s fule bay. Characters either need to have required role or belong to the starbase (POS) owner's corporation or alliance, as described by the enum, all other access settings follows the same scheme")
    fuels: Optional[List[CorporationsCorporationIdStarbasesStarbaseIdGetFuelsInner]] = Field(default=None, description="Fuel blocks and other things that will be consumed when operating a starbase (POS)")
    offline: StrictStr = Field(description="Who can offline starbase (POS) and its structures")
    online: StrictStr = Field(description="Who can online starbase (POS) and its structures")
    unanchor: StrictStr = Field(description="Who can unanchor starbase (POS) and its structures")
    use_alliance_standings: StrictBool = Field(description="True if the starbase (POS) is using alliance standings, otherwise using corporation's")
    __properties: ClassVar[List[str]] = ["allow_alliance_members", "allow_corporation_members", "anchor", "attack_if_at_war", "attack_if_other_security_status_dropping", "attack_security_status_threshold", "attack_standing_threshold", "fuel_bay_take", "fuel_bay_view", "fuels", "offline", "online", "unanchor", "use_alliance_standings"]

    @field_validator('anchor')
    def anchor_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role']):
            raise ValueError("must be one of enum values ('alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role')")
        return value

    @field_validator('fuel_bay_take')
    def fuel_bay_take_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role']):
            raise ValueError("must be one of enum values ('alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role')")
        return value

    @field_validator('fuel_bay_view')
    def fuel_bay_view_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role']):
            raise ValueError("must be one of enum values ('alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role')")
        return value

    @field_validator('offline')
    def offline_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role']):
            raise ValueError("must be one of enum values ('alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role')")
        return value

    @field_validator('online')
    def online_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role']):
            raise ValueError("must be one of enum values ('alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role')")
        return value

    @field_validator('unanchor')
    def unanchor_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role']):
            raise ValueError("must be one of enum values ('alliance_member', 'config_starbase_equipment_role', 'corporation_member', 'starbase_fuel_technician_role')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CorporationsCorporationIdStarbasesStarbaseIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fuels (list)
        _items = []
        if self.fuels:
            for _item_fuels in self.fuels:
                if _item_fuels:
                    _items.append(_item_fuels.to_dict())
            _dict['fuels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CorporationsCorporationIdStarbasesStarbaseIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allow_alliance_members": obj.get("allow_alliance_members"),
            "allow_corporation_members": obj.get("allow_corporation_members"),
            "anchor": obj.get("anchor"),
            "attack_if_at_war": obj.get("attack_if_at_war"),
            "attack_if_other_security_status_dropping": obj.get("attack_if_other_security_status_dropping"),
            "attack_security_status_threshold": obj.get("attack_security_status_threshold"),
            "attack_standing_threshold": obj.get("attack_standing_threshold"),
            "fuel_bay_take": obj.get("fuel_bay_take"),
            "fuel_bay_view": obj.get("fuel_bay_view"),
            "fuels": [CorporationsCorporationIdStarbasesStarbaseIdGetFuelsInner.from_dict(_item) for _item in obj["fuels"]] if obj.get("fuels") is not None else None,
            "offline": obj.get("offline"),
            "online": obj.get("online"),
            "unanchor": obj.get("unanchor"),
            "use_alliance_standings": obj.get("use_alliance_standings")
        })
        return _obj


