# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from pyesi_openapi.models.corporations_corporation_id_structures_get_inner_services_inner import CorporationsCorporationIdStructuresGetInnerServicesInner
from typing import Optional, Set
from typing_extensions import Self

class CorporationsCorporationIdStructuresGetInner(BaseModel):
    """
    CorporationsCorporationIdStructuresGetInner
    """ # noqa: E501
    corporation_id: StrictInt = Field(description="ID of the corporation that owns the structure")
    fuel_expires: Optional[datetime] = Field(default=None, description="Date on which the structure will run out of fuel")
    name: Optional[StrictStr] = Field(default=None, description="The structure name")
    next_reinforce_apply: Optional[datetime] = Field(default=None, description="The date and time when the structure's newly requested reinforcement times (e.g. next_reinforce_hour and next_reinforce_day) will take effect")
    next_reinforce_hour: Optional[StrictInt] = Field(default=None, description="The requested change to reinforce_hour that will take effect at the time shown by next_reinforce_apply")
    profile_id: StrictInt = Field(description="The id of the ACL profile for this citadel")
    reinforce_hour: Optional[StrictInt] = Field(default=None, description="The hour of day that determines the four hour window when the structure will randomly exit its reinforcement periods and become vulnerable to attack against its armor and/or hull. The structure will become vulnerable at a random time that is +/- 2 hours centered on the value of this property")
    services: Optional[List[CorporationsCorporationIdStructuresGetInnerServicesInner]] = Field(default=None, description="Contains a list of service upgrades, and their state")
    state: StrictStr
    state_timer_end: Optional[datetime] = Field(default=None, description="Date at which the structure will move to it's next state")
    state_timer_start: Optional[datetime] = Field(default=None, description="Date at which the structure entered it's current state")
    structure_id: StrictInt = Field(description="The Item ID of the structure")
    system_id: StrictInt = Field(description="The solar system the structure is in")
    type_id: StrictInt = Field(description="The type id of the structure")
    unanchors_at: Optional[datetime] = Field(default=None, description="Date at which the structure will unanchor")
    __properties: ClassVar[List[str]] = ["corporation_id", "fuel_expires", "name", "next_reinforce_apply", "next_reinforce_hour", "profile_id", "reinforce_hour", "services", "state", "state_timer_end", "state_timer_start", "structure_id", "system_id", "type_id", "unanchors_at"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['anchor_vulnerable', 'anchoring', 'armor_reinforce', 'armor_vulnerable', 'deploy_vulnerable', 'fitting_invulnerable', 'hull_reinforce', 'hull_vulnerable', 'online_deprecated', 'onlining_vulnerable', 'shield_vulnerable', 'unanchored', 'unknown']):
            raise ValueError("must be one of enum values ('anchor_vulnerable', 'anchoring', 'armor_reinforce', 'armor_vulnerable', 'deploy_vulnerable', 'fitting_invulnerable', 'hull_reinforce', 'hull_vulnerable', 'online_deprecated', 'onlining_vulnerable', 'shield_vulnerable', 'unanchored', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CorporationsCorporationIdStructuresGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in services (list)
        _items = []
        if self.services:
            for _item_services in self.services:
                if _item_services:
                    _items.append(_item_services.to_dict())
            _dict['services'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CorporationsCorporationIdStructuresGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "corporation_id": obj.get("corporation_id"),
            "fuel_expires": obj.get("fuel_expires"),
            "name": obj.get("name"),
            "next_reinforce_apply": obj.get("next_reinforce_apply"),
            "next_reinforce_hour": obj.get("next_reinforce_hour"),
            "profile_id": obj.get("profile_id"),
            "reinforce_hour": obj.get("reinforce_hour"),
            "services": [CorporationsCorporationIdStructuresGetInnerServicesInner.from_dict(_item) for _item in obj["services"]] if obj.get("services") is not None else None,
            "state": obj.get("state"),
            "state_timer_end": obj.get("state_timer_end"),
            "state_timer_start": obj.get("state_timer_start"),
            "structure_id": obj.get("structure_id"),
            "system_id": obj.get("system_id"),
            "type_id": obj.get("type_id"),
            "unanchors_at": obj.get("unanchors_at")
        })
        return _obj


