# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pyesi_openapi.models.dogma_effects_effect_id_get_modifiers_inner import DogmaEffectsEffectIdGetModifiersInner
from typing import Optional, Set
from typing_extensions import Self

class DogmaEffectsEffectIdGet(BaseModel):
    """
    DogmaEffectsEffectIdGet
    """ # noqa: E501
    description: Optional[StrictStr] = None
    disallow_auto_repeat: Optional[StrictBool] = None
    discharge_attribute_id: Optional[StrictInt] = None
    display_name: Optional[StrictStr] = None
    duration_attribute_id: Optional[StrictInt] = None
    effect_category: Optional[StrictInt] = None
    effect_id: StrictInt
    electronic_chance: Optional[StrictBool] = None
    falloff_attribute_id: Optional[StrictInt] = None
    icon_id: Optional[StrictInt] = None
    is_assistance: Optional[StrictBool] = None
    is_offensive: Optional[StrictBool] = None
    is_warp_safe: Optional[StrictBool] = None
    modifiers: Optional[List[DogmaEffectsEffectIdGetModifiersInner]] = None
    name: Optional[StrictStr] = None
    post_expression: Optional[StrictInt] = None
    pre_expression: Optional[StrictInt] = None
    published: Optional[StrictBool] = None
    range_attribute_id: Optional[StrictInt] = None
    range_chance: Optional[StrictBool] = None
    tracking_speed_attribute_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["description", "disallow_auto_repeat", "discharge_attribute_id", "display_name", "duration_attribute_id", "effect_category", "effect_id", "electronic_chance", "falloff_attribute_id", "icon_id", "is_assistance", "is_offensive", "is_warp_safe", "modifiers", "name", "post_expression", "pre_expression", "published", "range_attribute_id", "range_chance", "tracking_speed_attribute_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DogmaEffectsEffectIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in modifiers (list)
        _items = []
        if self.modifiers:
            for _item_modifiers in self.modifiers:
                if _item_modifiers:
                    _items.append(_item_modifiers.to_dict())
            _dict['modifiers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DogmaEffectsEffectIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "disallow_auto_repeat": obj.get("disallow_auto_repeat"),
            "discharge_attribute_id": obj.get("discharge_attribute_id"),
            "display_name": obj.get("display_name"),
            "duration_attribute_id": obj.get("duration_attribute_id"),
            "effect_category": obj.get("effect_category"),
            "effect_id": obj.get("effect_id"),
            "electronic_chance": obj.get("electronic_chance"),
            "falloff_attribute_id": obj.get("falloff_attribute_id"),
            "icon_id": obj.get("icon_id"),
            "is_assistance": obj.get("is_assistance"),
            "is_offensive": obj.get("is_offensive"),
            "is_warp_safe": obj.get("is_warp_safe"),
            "modifiers": [DogmaEffectsEffectIdGetModifiersInner.from_dict(_item) for _item in obj["modifiers"]] if obj.get("modifiers") is not None else None,
            "name": obj.get("name"),
            "post_expression": obj.get("post_expression"),
            "pre_expression": obj.get("pre_expression"),
            "published": obj.get("published"),
            "range_attribute_id": obj.get("range_attribute_id"),
            "range_chance": obj.get("range_chance"),
            "tracking_speed_attribute_id": obj.get("tracking_speed_attribute_id")
        })
        return _obj


