# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FleetsFleetIdMembersGetInner(BaseModel):
    """
    FleetsFleetIdMembersGetInner
    """ # noqa: E501
    character_id: StrictInt
    join_time: datetime
    role: StrictStr = Field(description="Member’s role in fleet")
    role_name: StrictStr = Field(description="Localized role names")
    ship_type_id: StrictInt
    solar_system_id: StrictInt = Field(description="Solar system the member is located in")
    squad_id: StrictInt = Field(description="ID of the squad the member is in. If not applicable, will be set to -1")
    station_id: Optional[StrictInt] = Field(default=None, description="Station in which the member is docked in, if applicable")
    takes_fleet_warp: StrictBool = Field(description="Whether the member take fleet warps")
    wing_id: StrictInt = Field(description="ID of the wing the member is in. If not applicable, will be set to -1")
    __properties: ClassVar[List[str]] = ["character_id", "join_time", "role", "role_name", "ship_type_id", "solar_system_id", "squad_id", "station_id", "takes_fleet_warp", "wing_id"]

    @field_validator('role')
    def role_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['fleet_commander', 'wing_commander', 'squad_commander', 'squad_member']):
            raise ValueError("must be one of enum values ('fleet_commander', 'wing_commander', 'squad_commander', 'squad_member')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FleetsFleetIdMembersGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FleetsFleetIdMembersGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "character_id": obj.get("character_id"),
            "join_time": obj.get("join_time"),
            "role": obj.get("role"),
            "role_name": obj.get("role_name"),
            "ship_type_id": obj.get("ship_type_id"),
            "solar_system_id": obj.get("solar_system_id"),
            "squad_id": obj.get("squad_id"),
            "station_id": obj.get("station_id"),
            "takes_fleet_warp": obj.get("takes_fleet_warp"),
            "wing_id": obj.get("wing_id")
        })
        return _obj


