# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from pyesi_openapi.models.fw_leaderboards_corporations_get_victory_points_active_total_inner import FwLeaderboardsCorporationsGetVictoryPointsActiveTotalInner
from pyesi_openapi.models.fw_leaderboards_corporations_get_victory_points_last_week_inner import FwLeaderboardsCorporationsGetVictoryPointsLastWeekInner
from pyesi_openapi.models.fw_leaderboards_corporations_get_victory_points_yesterday_inner import FwLeaderboardsCorporationsGetVictoryPointsYesterdayInner
from typing import Optional, Set
from typing_extensions import Self

class FwLeaderboardsCorporationsGetVictoryPoints(BaseModel):
    """
    Top 10 rankings of corporations by victory points from yesterday, last week and in total
    """ # noqa: E501
    active_total: List[FwLeaderboardsCorporationsGetVictoryPointsActiveTotalInner] = Field(description="Top 10 ranking of corporations active in faction warfare by total victory points. A corporation is considered \"active\" if they have participated in faction warfare in the past 14 days")
    last_week: List[FwLeaderboardsCorporationsGetVictoryPointsLastWeekInner] = Field(description="Top 10 ranking of corporations by victory points in the past week")
    yesterday: List[FwLeaderboardsCorporationsGetVictoryPointsYesterdayInner] = Field(description="Top 10 ranking of corporations by victory points in the past day")
    __properties: ClassVar[List[str]] = ["active_total", "last_week", "yesterday"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FwLeaderboardsCorporationsGetVictoryPoints from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in active_total (list)
        _items = []
        if self.active_total:
            for _item_active_total in self.active_total:
                if _item_active_total:
                    _items.append(_item_active_total.to_dict())
            _dict['active_total'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in last_week (list)
        _items = []
        if self.last_week:
            for _item_last_week in self.last_week:
                if _item_last_week:
                    _items.append(_item_last_week.to_dict())
            _dict['last_week'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in yesterday (list)
        _items = []
        if self.yesterday:
            for _item_yesterday in self.yesterday:
                if _item_yesterday:
                    _items.append(_item_yesterday.to_dict())
            _dict['yesterday'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FwLeaderboardsCorporationsGetVictoryPoints from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active_total": [FwLeaderboardsCorporationsGetVictoryPointsActiveTotalInner.from_dict(_item) for _item in obj["active_total"]] if obj.get("active_total") is not None else None,
            "last_week": [FwLeaderboardsCorporationsGetVictoryPointsLastWeekInner.from_dict(_item) for _item in obj["last_week"]] if obj.get("last_week") is not None else None,
            "yesterday": [FwLeaderboardsCorporationsGetVictoryPointsYesterdayInner.from_dict(_item) for _item in obj["yesterday"]] if obj.get("yesterday") is not None else None
        })
        return _obj


