# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class IncursionsGetInner(BaseModel):
    """
    IncursionsGetInner
    """ # noqa: E501
    constellation_id: StrictInt = Field(description="The constellation id in which this incursion takes place")
    faction_id: StrictInt = Field(description="The attacking faction's id")
    has_boss: StrictBool = Field(description="Whether the final encounter has boss or not")
    infested_solar_systems: List[StrictInt] = Field(description="A list of infested solar system ids that are a part of this incursion")
    influence: Union[StrictFloat, StrictInt] = Field(description="Influence of this incursion as a float from 0 to 1")
    staging_solar_system_id: StrictInt = Field(description="Staging solar system for this incursion")
    state: StrictStr = Field(description="The state of this incursion")
    type: StrictStr = Field(description="The type of this incursion")
    __properties: ClassVar[List[str]] = ["constellation_id", "faction_id", "has_boss", "infested_solar_systems", "influence", "staging_solar_system_id", "state", "type"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['withdrawing', 'mobilizing', 'established']):
            raise ValueError("must be one of enum values ('withdrawing', 'mobilizing', 'established')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IncursionsGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IncursionsGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "constellation_id": obj.get("constellation_id"),
            "faction_id": obj.get("faction_id"),
            "has_boss": obj.get("has_boss"),
            "infested_solar_systems": obj.get("infested_solar_systems"),
            "influence": obj.get("influence"),
            "staging_solar_system_id": obj.get("staging_solar_system_id"),
            "state": obj.get("state"),
            "type": obj.get("type")
        })
        return _obj


