# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from pyesi_openapi.models.killmails_killmail_id_killmail_hash_get_attackers_inner import KillmailsKillmailIdKillmailHashGetAttackersInner
from pyesi_openapi.models.killmails_killmail_id_killmail_hash_get_victim import KillmailsKillmailIdKillmailHashGetVictim
from typing import Optional, Set
from typing_extensions import Self

class KillmailsKillmailIdKillmailHashGet(BaseModel):
    """
    KillmailsKillmailIdKillmailHashGet
    """ # noqa: E501
    attackers: List[KillmailsKillmailIdKillmailHashGetAttackersInner]
    killmail_id: StrictInt = Field(description="ID of the killmail")
    killmail_time: datetime = Field(description="Time that the victim was killed and the killmail generated ")
    moon_id: Optional[StrictInt] = Field(default=None, description="Moon if the kill took place at one")
    solar_system_id: StrictInt = Field(description="Solar system that the kill took place in ")
    victim: KillmailsKillmailIdKillmailHashGetVictim
    war_id: Optional[StrictInt] = Field(default=None, description="War if the killmail is generated in relation to an official war ")
    __properties: ClassVar[List[str]] = ["attackers", "killmail_id", "killmail_time", "moon_id", "solar_system_id", "victim", "war_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KillmailsKillmailIdKillmailHashGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attackers (list)
        _items = []
        if self.attackers:
            for _item_attackers in self.attackers:
                if _item_attackers:
                    _items.append(_item_attackers.to_dict())
            _dict['attackers'] = _items
        # override the default output from pydantic by calling `to_dict()` of victim
        if self.victim:
            _dict['victim'] = self.victim.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KillmailsKillmailIdKillmailHashGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attackers": [KillmailsKillmailIdKillmailHashGetAttackersInner.from_dict(_item) for _item in obj["attackers"]] if obj.get("attackers") is not None else None,
            "killmail_id": obj.get("killmail_id"),
            "killmail_time": obj.get("killmail_time"),
            "moon_id": obj.get("moon_id"),
            "solar_system_id": obj.get("solar_system_id"),
            "victim": KillmailsKillmailIdKillmailHashGetVictim.from_dict(obj["victim"]) if obj.get("victim") is not None else None,
            "war_id": obj.get("war_id")
        })
        return _obj


