# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class MarketsRegionIdOrdersGetInner(BaseModel):
    """
    MarketsRegionIdOrdersGetInner
    """ # noqa: E501
    duration: StrictInt
    is_buy_order: StrictBool
    issued: datetime
    location_id: StrictInt
    min_volume: StrictInt
    order_id: StrictInt
    price: Union[StrictFloat, StrictInt]
    range: StrictStr
    system_id: StrictInt = Field(description="The solar system this order was placed")
    type_id: StrictInt
    volume_remain: StrictInt
    volume_total: StrictInt
    __properties: ClassVar[List[str]] = ["duration", "is_buy_order", "issued", "location_id", "min_volume", "order_id", "price", "range", "system_id", "type_id", "volume_remain", "volume_total"]

    @field_validator('range')
    def range_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['station', 'region', 'solarsystem', '1', '2', '3', '4', '5', '10', '20', '30', '40']):
            raise ValueError("must be one of enum values ('station', 'region', 'solarsystem', '1', '2', '3', '4', '5', '10', '20', '30', '40')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MarketsRegionIdOrdersGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MarketsRegionIdOrdersGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "duration": obj.get("duration"),
            "is_buy_order": obj.get("is_buy_order"),
            "issued": obj.get("issued"),
            "location_id": obj.get("location_id"),
            "min_volume": obj.get("min_volume"),
            "order_id": obj.get("order_id"),
            "price": obj.get("price"),
            "range": obj.get("range"),
            "system_id": obj.get("system_id"),
            "type_id": obj.get("type_id"),
            "volume_remain": obj.get("volume_remain"),
            "volume_total": obj.get("volume_total")
        })
        return _obj


