# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pyesi_openapi.models.sovereignty_campaigns_get_inner_participants_inner import SovereigntyCampaignsGetInnerParticipantsInner
from typing import Optional, Set
from typing_extensions import Self

class SovereigntyCampaignsGetInner(BaseModel):
    """
    SovereigntyCampaignsGetInner
    """ # noqa: E501
    attackers_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Score for all attacking parties, only present in Defense Events. ")
    campaign_id: StrictInt = Field(description="Unique ID for this campaign.")
    constellation_id: StrictInt = Field(description="The constellation in which the campaign will take place. ")
    defender_id: Optional[StrictInt] = Field(default=None, description="Defending alliance, only present in Defense Events ")
    defender_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Score for the defending alliance, only present in Defense Events. ")
    event_type: StrictStr = Field(description="Type of event this campaign is for. tcu_defense, ihub_defense and station_defense are referred to as \"Defense Events\", station_freeport as \"Freeport Events\". ")
    participants: Optional[List[SovereigntyCampaignsGetInnerParticipantsInner]] = Field(default=None, description="Alliance participating and their respective scores, only present in Freeport Events. ")
    solar_system_id: StrictInt = Field(description="The solar system the structure is located in. ")
    start_time: datetime = Field(description="Time the event is scheduled to start. ")
    structure_id: StrictInt = Field(description="The structure item ID that is related to this campaign. ")
    __properties: ClassVar[List[str]] = ["attackers_score", "campaign_id", "constellation_id", "defender_id", "defender_score", "event_type", "participants", "solar_system_id", "start_time", "structure_id"]

    @field_validator('event_type')
    def event_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['tcu_defense', 'ihub_defense', 'station_defense', 'station_freeport']):
            raise ValueError("must be one of enum values ('tcu_defense', 'ihub_defense', 'station_defense', 'station_freeport')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SovereigntyCampaignsGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in participants (list)
        _items = []
        if self.participants:
            for _item_participants in self.participants:
                if _item_participants:
                    _items.append(_item_participants.to_dict())
            _dict['participants'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SovereigntyCampaignsGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attackers_score": obj.get("attackers_score"),
            "campaign_id": obj.get("campaign_id"),
            "constellation_id": obj.get("constellation_id"),
            "defender_id": obj.get("defender_id"),
            "defender_score": obj.get("defender_score"),
            "event_type": obj.get("event_type"),
            "participants": [SovereigntyCampaignsGetInnerParticipantsInner.from_dict(_item) for _item in obj["participants"]] if obj.get("participants") is not None else None,
            "solar_system_id": obj.get("solar_system_id"),
            "start_time": obj.get("start_time"),
            "structure_id": obj.get("structure_id")
        })
        return _obj


