# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from pyesi_openapi.models.universe_ids_post_agents_inner import UniverseIdsPostAgentsInner
from pyesi_openapi.models.universe_ids_post_alliances_inner import UniverseIdsPostAlliancesInner
from pyesi_openapi.models.universe_ids_post_characters_inner import UniverseIdsPostCharactersInner
from pyesi_openapi.models.universe_ids_post_constellations_inner import UniverseIdsPostConstellationsInner
from pyesi_openapi.models.universe_ids_post_corporations_inner import UniverseIdsPostCorporationsInner
from pyesi_openapi.models.universe_ids_post_factions_inner import UniverseIdsPostFactionsInner
from pyesi_openapi.models.universe_ids_post_inventory_types_inner import UniverseIdsPostInventoryTypesInner
from pyesi_openapi.models.universe_ids_post_regions_inner import UniverseIdsPostRegionsInner
from pyesi_openapi.models.universe_ids_post_stations_inner import UniverseIdsPostStationsInner
from pyesi_openapi.models.universe_ids_post_systems_inner import UniverseIdsPostSystemsInner
from typing import Optional, Set
from typing_extensions import Self

class UniverseIdsPost(BaseModel):
    """
    UniverseIdsPost
    """ # noqa: E501
    agents: Optional[List[UniverseIdsPostAgentsInner]] = None
    alliances: Optional[List[UniverseIdsPostAlliancesInner]] = None
    characters: Optional[List[UniverseIdsPostCharactersInner]] = None
    constellations: Optional[List[UniverseIdsPostConstellationsInner]] = None
    corporations: Optional[List[UniverseIdsPostCorporationsInner]] = None
    factions: Optional[List[UniverseIdsPostFactionsInner]] = None
    inventory_types: Optional[List[UniverseIdsPostInventoryTypesInner]] = None
    regions: Optional[List[UniverseIdsPostRegionsInner]] = None
    stations: Optional[List[UniverseIdsPostStationsInner]] = None
    systems: Optional[List[UniverseIdsPostSystemsInner]] = None
    __properties: ClassVar[List[str]] = ["agents", "alliances", "characters", "constellations", "corporations", "factions", "inventory_types", "regions", "stations", "systems"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UniverseIdsPost from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in agents (list)
        _items = []
        if self.agents:
            for _item_agents in self.agents:
                if _item_agents:
                    _items.append(_item_agents.to_dict())
            _dict['agents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in alliances (list)
        _items = []
        if self.alliances:
            for _item_alliances in self.alliances:
                if _item_alliances:
                    _items.append(_item_alliances.to_dict())
            _dict['alliances'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in characters (list)
        _items = []
        if self.characters:
            for _item_characters in self.characters:
                if _item_characters:
                    _items.append(_item_characters.to_dict())
            _dict['characters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in constellations (list)
        _items = []
        if self.constellations:
            for _item_constellations in self.constellations:
                if _item_constellations:
                    _items.append(_item_constellations.to_dict())
            _dict['constellations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in corporations (list)
        _items = []
        if self.corporations:
            for _item_corporations in self.corporations:
                if _item_corporations:
                    _items.append(_item_corporations.to_dict())
            _dict['corporations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in factions (list)
        _items = []
        if self.factions:
            for _item_factions in self.factions:
                if _item_factions:
                    _items.append(_item_factions.to_dict())
            _dict['factions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in inventory_types (list)
        _items = []
        if self.inventory_types:
            for _item_inventory_types in self.inventory_types:
                if _item_inventory_types:
                    _items.append(_item_inventory_types.to_dict())
            _dict['inventory_types'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in regions (list)
        _items = []
        if self.regions:
            for _item_regions in self.regions:
                if _item_regions:
                    _items.append(_item_regions.to_dict())
            _dict['regions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in stations (list)
        _items = []
        if self.stations:
            for _item_stations in self.stations:
                if _item_stations:
                    _items.append(_item_stations.to_dict())
            _dict['stations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in systems (list)
        _items = []
        if self.systems:
            for _item_systems in self.systems:
                if _item_systems:
                    _items.append(_item_systems.to_dict())
            _dict['systems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UniverseIdsPost from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agents": [UniverseIdsPostAgentsInner.from_dict(_item) for _item in obj["agents"]] if obj.get("agents") is not None else None,
            "alliances": [UniverseIdsPostAlliancesInner.from_dict(_item) for _item in obj["alliances"]] if obj.get("alliances") is not None else None,
            "characters": [UniverseIdsPostCharactersInner.from_dict(_item) for _item in obj["characters"]] if obj.get("characters") is not None else None,
            "constellations": [UniverseIdsPostConstellationsInner.from_dict(_item) for _item in obj["constellations"]] if obj.get("constellations") is not None else None,
            "corporations": [UniverseIdsPostCorporationsInner.from_dict(_item) for _item in obj["corporations"]] if obj.get("corporations") is not None else None,
            "factions": [UniverseIdsPostFactionsInner.from_dict(_item) for _item in obj["factions"]] if obj.get("factions") is not None else None,
            "inventory_types": [UniverseIdsPostInventoryTypesInner.from_dict(_item) for _item in obj["inventory_types"]] if obj.get("inventory_types") is not None else None,
            "regions": [UniverseIdsPostRegionsInner.from_dict(_item) for _item in obj["regions"]] if obj.get("regions") is not None else None,
            "stations": [UniverseIdsPostStationsInner.from_dict(_item) for _item in obj["stations"]] if obj.get("stations") is not None else None,
            "systems": [UniverseIdsPostSystemsInner.from_dict(_item) for _item in obj["systems"]] if obj.get("systems") is not None else None
        })
        return _obj


