# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class UniverseStarsStarIdGet(BaseModel):
    """
    UniverseStarsStarIdGet
    """ # noqa: E501
    age: StrictInt = Field(description="Age of star in years")
    luminosity: Union[StrictFloat, StrictInt]
    name: StrictStr
    radius: StrictInt
    solar_system_id: StrictInt
    spectral_class: StrictStr
    temperature: StrictInt
    type_id: StrictInt
    __properties: ClassVar[List[str]] = ["age", "luminosity", "name", "radius", "solar_system_id", "spectral_class", "temperature", "type_id"]

    @field_validator('spectral_class')
    def spectral_class_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['K2 V', 'K4 V', 'G2 V', 'G8 V', 'M7 V', 'K7 V', 'M2 V', 'K5 V', 'M3 V', 'G0 V', 'G7 V', 'G3 V', 'F9 V', 'G5 V', 'F6 V', 'K8 V', 'K9 V', 'K6 V', 'G9 V', 'G6 V', 'G4 VI', 'G4 V', 'F8 V', 'F2 V', 'F1 V', 'K3 V', 'F0 VI', 'G1 VI', 'G0 VI', 'K1 V', 'M4 V', 'M1 V', 'M6 V', 'M0 V', 'K2 IV', 'G2 VI', 'K0 V', 'K5 IV', 'F5 VI', 'G6 VI', 'F6 VI', 'F2 IV', 'G3 VI', 'M8 V', 'F1 VI', 'K1 IV', 'F7 V', 'G5 VI', 'M5 V', 'G7 VI', 'F5 V', 'F4 VI', 'F8 VI', 'K3 IV', 'F4 IV', 'F0 V', 'G7 IV', 'G8 VI', 'F2 VI', 'F4 V', 'F7 VI', 'F3 V', 'G1 V', 'G9 VI', 'F3 IV', 'F9 VI', 'M9 V', 'K0 IV', 'F1 IV', 'G4 IV', 'F3 VI', 'K4 IV', 'G5 IV', 'G3 IV', 'G1 IV', 'K7 IV', 'G0 IV', 'K6 IV', 'K9 IV', 'G2 IV', 'F9 IV', 'F0 IV', 'K8 IV', 'G8 IV', 'F6 IV', 'F5 IV', 'A0', 'A0IV', 'A0IV2']):
            raise ValueError("must be one of enum values ('K2 V', 'K4 V', 'G2 V', 'G8 V', 'M7 V', 'K7 V', 'M2 V', 'K5 V', 'M3 V', 'G0 V', 'G7 V', 'G3 V', 'F9 V', 'G5 V', 'F6 V', 'K8 V', 'K9 V', 'K6 V', 'G9 V', 'G6 V', 'G4 VI', 'G4 V', 'F8 V', 'F2 V', 'F1 V', 'K3 V', 'F0 VI', 'G1 VI', 'G0 VI', 'K1 V', 'M4 V', 'M1 V', 'M6 V', 'M0 V', 'K2 IV', 'G2 VI', 'K0 V', 'K5 IV', 'F5 VI', 'G6 VI', 'F6 VI', 'F2 IV', 'G3 VI', 'M8 V', 'F1 VI', 'K1 IV', 'F7 V', 'G5 VI', 'M5 V', 'G7 VI', 'F5 V', 'F4 VI', 'F8 VI', 'K3 IV', 'F4 IV', 'F0 V', 'G7 IV', 'G8 VI', 'F2 VI', 'F4 V', 'F7 VI', 'F3 V', 'G1 V', 'G9 VI', 'F3 IV', 'F9 VI', 'M9 V', 'K0 IV', 'F1 IV', 'G4 IV', 'F3 VI', 'K4 IV', 'G5 IV', 'G3 IV', 'G1 IV', 'K7 IV', 'G0 IV', 'K6 IV', 'K9 IV', 'G2 IV', 'F9 IV', 'F0 IV', 'K8 IV', 'G8 IV', 'F6 IV', 'F5 IV', 'A0', 'A0IV', 'A0IV2')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UniverseStarsStarIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UniverseStarsStarIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "age": obj.get("age"),
            "luminosity": obj.get("luminosity"),
            "name": obj.get("name"),
            "radius": obj.get("radius"),
            "solar_system_id": obj.get("solar_system_id"),
            "spectral_class": obj.get("spectral_class"),
            "temperature": obj.get("temperature"),
            "type_id": obj.get("type_id")
        })
        return _obj


