# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from pyesi_openapi.models.characters_character_id_assets_locations_post_inner_position import CharactersCharacterIdAssetsLocationsPostInnerPosition
from pyesi_openapi.models.universe_systems_system_id_get_planets_inner import UniverseSystemsSystemIdGetPlanetsInner
from typing import Optional, Set
from typing_extensions import Self

class UniverseSystemsSystemIdGet(BaseModel):
    """
    UniverseSystemsSystemIdGet
    """ # noqa: E501
    constellation_id: StrictInt = Field(description="The constellation this solar system is in")
    name: StrictStr
    planets: Optional[List[UniverseSystemsSystemIdGetPlanetsInner]] = None
    position: CharactersCharacterIdAssetsLocationsPostInnerPosition
    security_class: Optional[StrictStr] = None
    security_status: Union[StrictFloat, StrictInt]
    star_id: Optional[StrictInt] = None
    stargates: Optional[List[StrictInt]] = None
    stations: Optional[List[StrictInt]] = None
    system_id: StrictInt
    __properties: ClassVar[List[str]] = ["constellation_id", "name", "planets", "position", "security_class", "security_status", "star_id", "stargates", "stations", "system_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UniverseSystemsSystemIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in planets (list)
        _items = []
        if self.planets:
            for _item_planets in self.planets:
                if _item_planets:
                    _items.append(_item_planets.to_dict())
            _dict['planets'] = _items
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UniverseSystemsSystemIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "constellation_id": obj.get("constellation_id"),
            "name": obj.get("name"),
            "planets": [UniverseSystemsSystemIdGetPlanetsInner.from_dict(_item) for _item in obj["planets"]] if obj.get("planets") is not None else None,
            "position": CharactersCharacterIdAssetsLocationsPostInnerPosition.from_dict(obj["position"]) if obj.get("position") is not None else None,
            "security_class": obj.get("security_class"),
            "security_status": obj.get("security_status"),
            "star_id": obj.get("star_id"),
            "stargates": obj.get("stargates"),
            "stations": obj.get("stations"),
            "system_id": obj.get("system_id")
        })
        return _obj


