# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from pyesi_openapi.models.wars_war_id_get_aggressor import WarsWarIdGetAggressor
from pyesi_openapi.models.wars_war_id_get_allies_inner import WarsWarIdGetAlliesInner
from pyesi_openapi.models.wars_war_id_get_defender import WarsWarIdGetDefender
from typing import Optional, Set
from typing_extensions import Self

class WarsWarIdGet(BaseModel):
    """
    WarsWarIdGet
    """ # noqa: E501
    aggressor: WarsWarIdGetAggressor
    allies: Optional[List[WarsWarIdGetAlliesInner]] = Field(default=None, description="allied corporations or alliances, each object contains either corporation_id or alliance_id")
    declared: datetime = Field(description="Time that the war was declared")
    defender: WarsWarIdGetDefender
    finished: Optional[datetime] = Field(default=None, description="Time the war ended and shooting was no longer allowed")
    id: StrictInt = Field(description="ID of the specified war")
    mutual: StrictBool = Field(description="Was the war declared mutual by both parties")
    open_for_allies: StrictBool = Field(description="Is the war currently open for allies or not")
    retracted: Optional[datetime] = Field(default=None, description="Time the war was retracted but both sides could still shoot each other")
    started: Optional[datetime] = Field(default=None, description="Time when the war started and both sides could shoot each other")
    __properties: ClassVar[List[str]] = ["aggressor", "allies", "declared", "defender", "finished", "id", "mutual", "open_for_allies", "retracted", "started"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WarsWarIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of aggressor
        if self.aggressor:
            _dict['aggressor'] = self.aggressor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in allies (list)
        _items = []
        if self.allies:
            for _item_allies in self.allies:
                if _item_allies:
                    _items.append(_item_allies.to_dict())
            _dict['allies'] = _items
        # override the default output from pydantic by calling `to_dict()` of defender
        if self.defender:
            _dict['defender'] = self.defender.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WarsWarIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aggressor": WarsWarIdGetAggressor.from_dict(obj["aggressor"]) if obj.get("aggressor") is not None else None,
            "allies": [WarsWarIdGetAlliesInner.from_dict(_item) for _item in obj["allies"]] if obj.get("allies") is not None else None,
            "declared": obj.get("declared"),
            "defender": WarsWarIdGetDefender.from_dict(obj["defender"]) if obj.get("defender") is not None else None,
            "finished": obj.get("finished"),
            "id": obj.get("id"),
            "mutual": obj.get("mutual"),
            "open_for_allies": obj.get("open_for_allies"),
            "retracted": obj.get("retracted"),
            "started": obj.get("started")
        })
        return _obj


