# Generated by Django 5.2.6 on 2025-09-16 09:23

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_cfg_accounts', '0002_add_phone_otp_clean'),
    ]

    operations = [
        migrations.CreateModel(
            name='TwilioResponse',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('response_type', models.CharField(choices=[('api_send', 'API Send Request'), ('api_verify', 'API Verify Request'), ('webhook_status', 'Webhook Status Update'), ('webhook_delivery', 'Webhook Delivery Report')], max_length=20)),
                ('service_type', models.CharField(choices=[('whatsapp', 'WhatsApp'), ('sms', 'SMS'), ('voice', 'Voice'), ('email', 'Email'), ('verify', 'Verify API')], max_length=10)),
                ('message_sid', models.CharField(blank=True, help_text='Twilio Message SID', max_length=34)),
                ('verification_sid', models.CharField(blank=True, help_text='Twilio Verification SID', max_length=34)),
                ('request_data', models.JSONField(default=dict, help_text='Original request parameters')),
                ('response_data', models.JSONField(default=dict, help_text='Twilio API response')),
                ('status', models.CharField(blank=True, help_text='Message/Verification status', max_length=20)),
                ('error_code', models.CharField(blank=True, help_text='Twilio error code', max_length=10)),
                ('error_message', models.TextField(blank=True, help_text='Error description')),
                ('to_number', models.CharField(blank=True, help_text='Recipient phone/email', max_length=20)),
                ('from_number', models.CharField(blank=True, help_text='Sender phone/email', max_length=20)),
                ('price', models.DecimalField(blank=True, decimal_places=6, max_digits=10, null=True)),
                ('price_unit', models.CharField(blank=True, help_text='Currency code', max_length=3)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('twilio_created_at', models.DateTimeField(blank=True, help_text='Timestamp from Twilio', null=True)),
                ('otp_secret', models.ForeignKey(blank=True, help_text='Related OTP if applicable', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='twilio_responses', to='django_cfg_accounts.otpsecret')),
            ],
            options={
                'verbose_name': 'Twilio Response',
                'verbose_name_plural': 'Twilio Responses',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['message_sid'], name='django_cfg__message_c37dcd_idx'), models.Index(fields=['verification_sid'], name='django_cfg__verific_7de689_idx'), models.Index(fields=['status', 'created_at'], name='django_cfg__status_95d8c8_idx'), models.Index(fields=['response_type', 'service_type'], name='django_cfg__respons_20ca26_idx')],
            },
        ),
    ]
