<h1 align="center">
Spyre Plugin for vLLM
</h1>

<p align="center">
| <a href="https://vllm-spyre.readthedocs.io/en/latest/"><b>Documentation</b></a> | <a href="https://discuss.vllm.ai/c/hardware-support/vllm-spyre-support"><b>Users Forum</b></a> | <a href="https://slack.vllm.ai"><b>#sig-spyre</b></a> |
</p>

---
**IBM Spyre** is the first production-grade Artificial Intelligence Unit (AIU) accelerator born out of the IBM Research AIU family, and is part of a long-term strategy of developing novel architectures and full-stack technology solutions for the emerging space of generative AI. Spyre builds on the foundation of IBM’s internal AIU research and delivers a scalable, efficient architecture for accelerating AI in enterprise environments.

The vLLM Spyre plugin (`vllm-spyre`) is a dedicated backend extension that enables seamless integration of IBM Spyre Accelerator with vLLM. It follows the architecture described in [vLLM's Plugin System](https://docs.vllm.ai/en/latest/design/plugin_system.html), making it easy to integrate IBM's advanced AI acceleration into existing vLLM workflows.

For more information, check out the following:

- 📚 [Meet the IBM Artificial Intelligence Unit](https://research.ibm.com/blog/ibm-artificial-intelligence-unit-aiu)
- 📽️ [AI Accelerators: Transforming Scalability & Model Efficiency](https://www.youtube.com/watch?v=KX0qBM-ByAg)
- 🚀 [Spyre Accelerator for IBM Z](https://research.ibm.com/blog/spyre-for-z)

## Getting Started

Visit our [documentation](https://vllm-spyre.readthedocs.io/en/latest/):
- [Installation](https://vllm-spyre.readthedocs.io/en/latest/getting_started/installation.html)
- [List of Supported Models](https://vllm-spyre.readthedocs.io/en/latest/user_guide/supported_models.html)
- [List of Supported Features](https://vllm-spyre.readthedocs.io/en/latest/user_guide/supported_features.html)

## Contributing

We welcome and value any contributions and collaborations. Please check out [Contributing to vLLM Spyre](https://vllm-spyre.readthedocs.io/en/latest/contributing/index.html) for how to get involved.

## Contact

You can reach out for discussion or support in the `#sig-spyre` channel in the [vLLM Slack](https://inviter.co/vllm-slack) workspace or by [opening an issue](https://vllm-spyre.readthedocs.io/en/latest/contributing/index.html#issues).
