import numpy as np

C = np.array([0, 1/5, 3/10, 4/5, 8/9, 1])
A = np.array([
    [0, 0, 0, 0, 0],
    [1/5, 0, 0, 0, 0],
    [3/40, 9/40, 0, 0, 0],
    [44/45, -56/15, 32/9, 0, 0],
    [19372/6561, -25360/2187, 64448/6561, -212/729, 0],
    [9017/3168, -355/33, 46732/5247, 49/176, -5103/18656]
])

# 5th-order solution (high-order)
B_HIGH = np.array([35/384, 0, 500/1113, 125/192, -2187/6784, 11/84])

# 4th-order solution (low-order) - computed from B_HIGH - E
E = np.array([-71/57600, 0, 71/16695, -71/1920, 17253/339200, -22/525,
                1/40])
B_LOW = np.array([5179/57600, 0, 7571/16695, 393/640, -92097/339200, 187/2100])

# Keep original names for backward compatibility
B = B_HIGH

P = np.array([
    [1, -8048581381/2820520608, 8663915743/2820520608,
        -12715105075/11282082432],
    [0, 0, 0, 0],
    [0, 131558114200/32700410799, -68118460800/10900136933,
        87487479700/32700410799],
    [0, -1754552775/470086768, 14199869525/1410260304,
        -10690763975/1880347072],
    [0, 127303824393/49829197408, -318862633887/49829197408,
        701980252875 / 199316789632],
    [0, -282668133/205662961, 2019193451/616988883, -1453857185/822651844],
    [0, 40617522/29380423, -110615467/29380423, 69997945/29380423]])
