# API Reference <a name="API Reference" id="api-reference"></a>


## Structs <a name="Structs" id="structs"></a>

### NagPackProps <a name="monocdk-nag.NagPackProps" id="monocdknagnagpackprops"></a>

Interface for creating a Nag rule pack.

#### Initializer <a name="[object Object].Initializer" id="object-objectinitializer"></a>

```typescript
import { NagPackProps } from 'monocdk-nag'

const nagPackProps: NagPackProps = { ... }
```

#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logIgnores`](#monocdknagnagpackpropspropertylogignores) | `boolean` | Whether or not to log triggered rules that have been suppressed as informational messages (default: false). |
| [`reports`](#monocdknagnagpackpropspropertyreports) | `boolean` | Whether or not to generate CSV compliance reports for applied Stacks in the App's output directory (default: true). |
| [`verbose`](#monocdknagnagpackpropspropertyverbose) | `boolean` | Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false). |

---

##### `logIgnores`<sup>Optional</sup> <a name="monocdk-nag.NagPackProps.property.logIgnores" id="monocdknagnagpackpropspropertylogignores"></a>

```typescript
public readonly logIgnores: boolean;
```

- *Type:* `boolean`

Whether or not to log triggered rules that have been suppressed as informational messages (default: false).

---

##### `reports`<sup>Optional</sup> <a name="monocdk-nag.NagPackProps.property.reports" id="monocdknagnagpackpropspropertyreports"></a>

```typescript
public readonly reports: boolean;
```

- *Type:* `boolean`

Whether or not to generate CSV compliance reports for applied Stacks in the App's output directory (default: true).

---

##### `verbose`<sup>Optional</sup> <a name="monocdk-nag.NagPackProps.property.verbose" id="monocdknagnagpackpropspropertyverbose"></a>

```typescript
public readonly verbose: boolean;
```

- *Type:* `boolean`

Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false).

---

### NagPackSuppression <a name="monocdk-nag.NagPackSuppression" id="monocdknagnagpacksuppression"></a>

Interface for creating a rule suppression.

#### Initializer <a name="[object Object].Initializer" id="object-objectinitializer"></a>

```typescript
import { NagPackSuppression } from 'monocdk-nag'

const nagPackSuppression: NagPackSuppression = { ... }
```

#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`id`](#monocdknagnagpacksuppressionpropertyid)<span title="Required">*</span> | `string` | The id of the rule to ignore. |
| [`reason`](#monocdknagnagpacksuppressionpropertyreason)<span title="Required">*</span> | `string` | The reason to ignore the rule (minimum 10 characters). |
| [`appliesTo`](#monocdknagnagpacksuppressionpropertyappliesto) | `string` \| [`monocdk-nag.RegexAppliesTo`](#monocdk-nag.RegexAppliesTo)[] | Rule specific granular suppressions. |

---

##### `id`<sup>Required</sup> <a name="monocdk-nag.NagPackSuppression.property.id" id="monocdknagnagpacksuppressionpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

The id of the rule to ignore.

---

##### `reason`<sup>Required</sup> <a name="monocdk-nag.NagPackSuppression.property.reason" id="monocdknagnagpacksuppressionpropertyreason"></a>

```typescript
public readonly reason: string;
```

- *Type:* `string`

The reason to ignore the rule (minimum 10 characters).

---

##### `appliesTo`<sup>Optional</sup> <a name="monocdk-nag.NagPackSuppression.property.appliesTo" id="monocdknagnagpacksuppressionpropertyappliesto"></a>

```typescript
public readonly appliesTo: string | RegexAppliesTo[];
```

- *Type:* `string` | [`monocdk-nag.RegexAppliesTo`](#monocdk-nag.RegexAppliesTo)[]

Rule specific granular suppressions.

---

### RegexAppliesTo <a name="monocdk-nag.RegexAppliesTo" id="monocdknagregexappliesto"></a>

A regular expression to apply to matching findings.

#### Initializer <a name="[object Object].Initializer" id="object-objectinitializer"></a>

```typescript
import { RegexAppliesTo } from 'monocdk-nag'

const regexAppliesTo: RegexAppliesTo = { ... }
```

#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`regex`](#monocdknagregexappliestopropertyregex)<span title="Required">*</span> | `string` | An ECMA-262 regex string. |

---

##### `regex`<sup>Required</sup> <a name="monocdk-nag.RegexAppliesTo.property.regex" id="monocdknagregexappliestopropertyregex"></a>

```typescript
public readonly regex: string;
```

- *Type:* `string`

An ECMA-262 regex string.

---

## Classes <a name="Classes" id="classes"></a>

### AwsSolutionsChecks <a name="monocdk-nag.AwsSolutionsChecks" id="monocdknagawssolutionschecks"></a>

Check Best practices based on AWS Solutions Security Matrix.

#### Initializers <a name="monocdk-nag.AwsSolutionsChecks.Initializer" id="monocdknagawssolutionschecksinitializer"></a>

```typescript
import { AwsSolutionsChecks } from 'monocdk-nag'

new AwsSolutionsChecks(props?: NagPackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`props`](#monocdknagawssolutionschecksparameterprops) | [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps) | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="monocdk-nag.AwsSolutionsChecks.parameter.props" id="monocdknagawssolutionschecksparameterprops"></a>

- *Type:* [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`visit`](#monocdknagawssolutionschecksvisit) | All aspects can visit an IConstruct. |

---

##### `visit` <a name="monocdk-nag.AwsSolutionsChecks.visit" id="monocdknagawssolutionschecksvisit"></a>

```typescript
public visit(node: IConstruct)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.AwsSolutionsChecks.parameter.node" id="monocdknagawssolutionschecksparameternode"></a>

- *Type:* [`monocdk.IConstruct`](#monocdk.IConstruct)

---




### HIPAASecurityChecks <a name="monocdk-nag.HIPAASecurityChecks" id="monocdknaghipaasecuritychecks"></a>

Check for HIPAA Security compliance.

Based on the HIPAA Security AWS operational best practices: https://docs.aws.amazon.com/config/latest/developerguide/operational-best-practices-for-hipaa_security.html

#### Initializers <a name="monocdk-nag.HIPAASecurityChecks.Initializer" id="monocdknaghipaasecuritychecksinitializer"></a>

```typescript
import { HIPAASecurityChecks } from 'monocdk-nag'

new HIPAASecurityChecks(props?: NagPackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`props`](#monocdknaghipaasecuritychecksparameterprops) | [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps) | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="monocdk-nag.HIPAASecurityChecks.parameter.props" id="monocdknaghipaasecuritychecksparameterprops"></a>

- *Type:* [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`visit`](#monocdknaghipaasecuritychecksvisit) | All aspects can visit an IConstruct. |

---

##### `visit` <a name="monocdk-nag.HIPAASecurityChecks.visit" id="monocdknaghipaasecuritychecksvisit"></a>

```typescript
public visit(node: IConstruct)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.HIPAASecurityChecks.parameter.node" id="monocdknaghipaasecuritychecksparameternode"></a>

- *Type:* [`monocdk.IConstruct`](#monocdk.IConstruct)

---




### NagPack <a name="monocdk-nag.NagPack" id="monocdknagnagpack"></a>

- *Implements:* [`monocdk.IAspect`](#monocdk.IAspect)

Base class for all rule packs.

#### Initializers <a name="monocdk-nag.NagPack.Initializer" id="monocdknagnagpackinitializer"></a>

```typescript
import { NagPack } from 'monocdk-nag'

new NagPack(props?: NagPackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`props`](#monocdknagnagpackparameterprops) | [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps) | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="monocdk-nag.NagPack.parameter.props" id="monocdknagnagpackparameterprops"></a>

- *Type:* [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`visit`](#monocdknagnagpackvisit) | All aspects can visit an IConstruct. |

---

##### `visit` <a name="monocdk-nag.NagPack.visit" id="monocdknagnagpackvisit"></a>

```typescript
public visit(node: IConstruct)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.NagPack.parameter.node" id="monocdknagnagpackparameternode"></a>

- *Type:* [`monocdk.IConstruct`](#monocdk.IConstruct)

---


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`readPackName`](#monocdknagnagpackpropertyreadpackname)<span title="Required">*</span> | `string` | *No description.* |
| [`readReportStacks`](#monocdknagnagpackpropertyreadreportstacks)<span title="Required">*</span> | `string`[] | *No description.* |

---

##### `readPackName`<sup>Required</sup> <a name="monocdk-nag.NagPack.property.readPackName" id="monocdknagnagpackpropertyreadpackname"></a>

```typescript
public readonly readPackName: string;
```

- *Type:* `string`

---

##### `readReportStacks`<sup>Required</sup> <a name="monocdk-nag.NagPack.property.readReportStacks" id="monocdknagnagpackpropertyreadreportstacks"></a>

```typescript
public readonly readReportStacks: string[];
```

- *Type:* `string`[]

---


### NagRules <a name="monocdk-nag.NagRules" id="monocdknagnagrules"></a>

Helper class with methods for rule creation.

#### Initializers <a name="monocdk-nag.NagRules.Initializer" id="monocdknagnagrulesinitializer"></a>

```typescript
import { NagRules } from 'monocdk-nag'

new NagRules()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="static-functions"></a>

| **Name** | **Description** |
| --- | --- |
| [`resolveIfPrimitive`](#monocdknagnagrulesresolveifprimitive) | Use in cases where a primitive value must be known to pass a rule. |
| [`resolveResourceFromInstrinsic`](#monocdknagnagrulesresolveresourcefrominstrinsic) | Use in cases where a token resolves to an intrinsic function and the referenced resource must be known to pass a rule. |

---

##### `resolveIfPrimitive` <a name="monocdk-nag.NagRules.resolveIfPrimitive" id="monocdknagnagrulesresolveifprimitive"></a>

```typescript
import { NagRules } from 'monocdk-nag'

NagRules.resolveIfPrimitive(node: CfnResource, parameter: any)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.NagRules.parameter.node" id="monocdknagnagrulesparameternode"></a>

- *Type:* [`monocdk.CfnResource`](#monocdk.CfnResource)

The CfnResource to check.

---

###### `parameter`<sup>Required</sup> <a name="monocdk-nag.NagRules.parameter.parameter" id="monocdknagnagrulesparameterparameter"></a>

- *Type:* `any`

The value to attempt to resolve.

---

##### `resolveResourceFromInstrinsic` <a name="monocdk-nag.NagRules.resolveResourceFromInstrinsic" id="monocdknagnagrulesresolveresourcefrominstrinsic"></a>

```typescript
import { NagRules } from 'monocdk-nag'

NagRules.resolveResourceFromInstrinsic(node: CfnResource, parameter: any)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.NagRules.parameter.node" id="monocdknagnagrulesparameternode"></a>

- *Type:* [`monocdk.CfnResource`](#monocdk.CfnResource)

The CfnResource to check.

---

###### `parameter`<sup>Required</sup> <a name="monocdk-nag.NagRules.parameter.parameter" id="monocdknagnagrulesparameterparameter"></a>

- *Type:* `any`

The value to attempt to resolve.

---



### NagSuppressions <a name="monocdk-nag.NagSuppressions" id="monocdknagnagsuppressions"></a>

Helper class with methods to add cdk-nag suppressions to cdk resources.

#### Initializers <a name="monocdk-nag.NagSuppressions.Initializer" id="monocdknagnagsuppressionsinitializer"></a>

```typescript
import { NagSuppressions } from 'monocdk-nag'

new NagSuppressions()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="static-functions"></a>

| **Name** | **Description** |
| --- | --- |
| [`addResourceSuppressions`](#monocdknagnagsuppressionsaddresourcesuppressions) | Add cdk-nag suppressions to a CfnResource and optionally its children. |
| [`addResourceSuppressionsByPath`](#monocdknagnagsuppressionsaddresourcesuppressionsbypath) | Add cdk-nag suppressions to a CfnResource and optionally its children via its path. |
| [`addStackSuppressions`](#monocdknagnagsuppressionsaddstacksuppressions) | Apply cdk-nag suppressions to a Stack and optionally nested stacks. |

---

##### `addResourceSuppressions` <a name="monocdk-nag.NagSuppressions.addResourceSuppressions" id="monocdknagnagsuppressionsaddresourcesuppressions"></a>

```typescript
import { NagSuppressions } from 'monocdk-nag'

NagSuppressions.addResourceSuppressions(construct: IConstruct, suppressions: NagPackSuppression[], applyToChildren?: boolean)
```

###### `construct`<sup>Required</sup> <a name="monocdk-nag.NagSuppressions.parameter.construct" id="monocdknagnagsuppressionsparameterconstruct"></a>

- *Type:* [`monocdk.IConstruct`](#monocdk.IConstruct)

The IConstruct to apply the suppression to.

---

###### `suppressions`<sup>Required</sup> <a name="monocdk-nag.NagSuppressions.parameter.suppressions" id="monocdknagnagsuppressionsparametersuppressions"></a>

- *Type:* [`monocdk-nag.NagPackSuppression`](#monocdk-nag.NagPackSuppression)[]

A list of suppressions to apply to the resource.

---

###### `applyToChildren`<sup>Optional</sup> <a name="monocdk-nag.NagSuppressions.parameter.applyToChildren" id="monocdknagnagsuppressionsparameterapplytochildren"></a>

- *Type:* `boolean`

Apply the suppressions to children CfnResources  (default:false).

---

##### `addResourceSuppressionsByPath` <a name="monocdk-nag.NagSuppressions.addResourceSuppressionsByPath" id="monocdknagnagsuppressionsaddresourcesuppressionsbypath"></a>

```typescript
import { NagSuppressions } from 'monocdk-nag'

NagSuppressions.addResourceSuppressionsByPath(stack: Stack, path: string, suppressions: NagPackSuppression[], applyToChildren?: boolean)
```

###### `stack`<sup>Required</sup> <a name="monocdk-nag.NagSuppressions.parameter.stack" id="monocdknagnagsuppressionsparameterstack"></a>

- *Type:* [`monocdk.Stack`](#monocdk.Stack)

The Stack the construct belongs to.

---

###### `path`<sup>Required</sup> <a name="monocdk-nag.NagSuppressions.parameter.path" id="monocdknagnagsuppressionsparameterpath"></a>

- *Type:* `string`

The path to the construct in the provided stack.

---

###### `suppressions`<sup>Required</sup> <a name="monocdk-nag.NagSuppressions.parameter.suppressions" id="monocdknagnagsuppressionsparametersuppressions"></a>

- *Type:* [`monocdk-nag.NagPackSuppression`](#monocdk-nag.NagPackSuppression)[]

A list of suppressions to apply to the resource.

---

###### `applyToChildren`<sup>Optional</sup> <a name="monocdk-nag.NagSuppressions.parameter.applyToChildren" id="monocdknagnagsuppressionsparameterapplytochildren"></a>

- *Type:* `boolean`

Apply the suppressions to children CfnResources  (default:false).

---

##### `addStackSuppressions` <a name="monocdk-nag.NagSuppressions.addStackSuppressions" id="monocdknagnagsuppressionsaddstacksuppressions"></a>

```typescript
import { NagSuppressions } from 'monocdk-nag'

NagSuppressions.addStackSuppressions(stack: Stack, suppressions: NagPackSuppression[], applyToNestedStacks?: boolean)
```

###### `stack`<sup>Required</sup> <a name="monocdk-nag.NagSuppressions.parameter.stack" id="monocdknagnagsuppressionsparameterstack"></a>

- *Type:* [`monocdk.Stack`](#monocdk.Stack)

The Stack to apply the suppression to.

---

###### `suppressions`<sup>Required</sup> <a name="monocdk-nag.NagSuppressions.parameter.suppressions" id="monocdknagnagsuppressionsparametersuppressions"></a>

- *Type:* [`monocdk-nag.NagPackSuppression`](#monocdk-nag.NagPackSuppression)[]

A list of suppressions to apply to the stack.

---

###### `applyToNestedStacks`<sup>Optional</sup> <a name="monocdk-nag.NagSuppressions.parameter.applyToNestedStacks" id="monocdknagnagsuppressionsparameterapplytonestedstacks"></a>

- *Type:* `boolean`

Apply the suppressions to children stacks (default:false).

---



### NIST80053R4Checks <a name="monocdk-nag.NIST80053R4Checks" id="monocdknagnist80053r4checks"></a>

Check for NIST 800-53 rev 4 compliance.

Based on the NIST 800-53 rev 4 AWS operational best practices: https://docs.aws.amazon.com/config/latest/developerguide/operational-best-practices-for-nist-800-53_rev_4.html

#### Initializers <a name="monocdk-nag.NIST80053R4Checks.Initializer" id="monocdknagnist80053r4checksinitializer"></a>

```typescript
import { NIST80053R4Checks } from 'monocdk-nag'

new NIST80053R4Checks(props?: NagPackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`props`](#monocdknagnist80053r4checksparameterprops) | [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps) | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="monocdk-nag.NIST80053R4Checks.parameter.props" id="monocdknagnist80053r4checksparameterprops"></a>

- *Type:* [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`visit`](#monocdknagnist80053r4checksvisit) | All aspects can visit an IConstruct. |

---

##### `visit` <a name="monocdk-nag.NIST80053R4Checks.visit" id="monocdknagnist80053r4checksvisit"></a>

```typescript
public visit(node: IConstruct)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.NIST80053R4Checks.parameter.node" id="monocdknagnist80053r4checksparameternode"></a>

- *Type:* [`monocdk.IConstruct`](#monocdk.IConstruct)

---




### NIST80053R5Checks <a name="monocdk-nag.NIST80053R5Checks" id="monocdknagnist80053r5checks"></a>

Check for NIST 800-53 rev 5 compliance.

Based on the NIST 800-53 rev 5 AWS operational best practices: https://docs.aws.amazon.com/config/latest/developerguide/operational-best-practices-for-nist-800-53_rev_5.html

#### Initializers <a name="monocdk-nag.NIST80053R5Checks.Initializer" id="monocdknagnist80053r5checksinitializer"></a>

```typescript
import { NIST80053R5Checks } from 'monocdk-nag'

new NIST80053R5Checks(props?: NagPackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`props`](#monocdknagnist80053r5checksparameterprops) | [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps) | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="monocdk-nag.NIST80053R5Checks.parameter.props" id="monocdknagnist80053r5checksparameterprops"></a>

- *Type:* [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`visit`](#monocdknagnist80053r5checksvisit) | All aspects can visit an IConstruct. |

---

##### `visit` <a name="monocdk-nag.NIST80053R5Checks.visit" id="monocdknagnist80053r5checksvisit"></a>

```typescript
public visit(node: IConstruct)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.NIST80053R5Checks.parameter.node" id="monocdknagnist80053r5checksparameternode"></a>

- *Type:* [`monocdk.IConstruct`](#monocdk.IConstruct)

---




### PCIDSS321Checks <a name="monocdk-nag.PCIDSS321Checks" id="monocdknagpcidss321checks"></a>

Check for PCI DSS 3.2.1 compliance. Based on the PCI DSS 3.2.1 AWS operational best practices: https://docs.aws.amazon.com/config/latest/developerguide/operational-best-practices-for-pci-dss.html.

#### Initializers <a name="monocdk-nag.PCIDSS321Checks.Initializer" id="monocdknagpcidss321checksinitializer"></a>

```typescript
import { PCIDSS321Checks } from 'monocdk-nag'

new PCIDSS321Checks(props?: NagPackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`props`](#monocdknagpcidss321checksparameterprops) | [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps) | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="monocdk-nag.PCIDSS321Checks.parameter.props" id="monocdknagpcidss321checksparameterprops"></a>

- *Type:* [`monocdk-nag.NagPackProps`](#monocdk-nag.NagPackProps)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`visit`](#monocdknagpcidss321checksvisit) | All aspects can visit an IConstruct. |

---

##### `visit` <a name="monocdk-nag.PCIDSS321Checks.visit" id="monocdknagpcidss321checksvisit"></a>

```typescript
public visit(node: IConstruct)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.PCIDSS321Checks.parameter.node" id="monocdknagpcidss321checksparameternode"></a>

- *Type:* [`monocdk.IConstruct`](#monocdk.IConstruct)

---




## Protocols <a name="Protocols" id="protocols"></a>

### IApplyRule <a name="monocdk-nag.IApplyRule" id="monocdknagiapplyrule"></a>

- *Implemented By:* [`monocdk-nag.IApplyRule`](#monocdk-nag.IApplyRule)

Interface for JSII interoperability for passing parameters and the Rule Callback to @applyRule method.

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`rule`](#monocdknagiapplyrulerule) | The callback to the rule. |

---

##### `rule` <a name="monocdk-nag.IApplyRule.rule" id="monocdknagiapplyrulerule"></a>

```typescript
public rule(node: CfnResource)
```

###### `node`<sup>Required</sup> <a name="monocdk-nag.IApplyRule.parameter.node" id="monocdknagiapplyruleparameternode"></a>

- *Type:* [`monocdk.CfnResource`](#monocdk.CfnResource)

The CfnResource to check.

---

#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`explanation`](#monocdknagiapplyrulepropertyexplanation)<span title="Required">*</span> | `string` | Why the rule exists. |
| [`info`](#monocdknagiapplyrulepropertyinfo)<span title="Required">*</span> | `string` | Why the rule was triggered. |
| [`level`](#monocdknagiapplyrulepropertylevel)<span title="Required">*</span> | [`monocdk-nag.NagMessageLevel`](#monocdk-nag.NagMessageLevel) | The annotations message level to apply to the rule if triggered. |
| [`node`](#monocdknagiapplyrulepropertynode)<span title="Required">*</span> | [`monocdk.CfnResource`](#monocdk.CfnResource) | Ignores listed in cdk-nag metadata. |
| [`ruleSuffixOverride`](#monocdknagiapplyrulepropertyrulesuffixoverride) | `string` | Override for the suffix of the Rule ID for this rule. |

---

##### `explanation`<sup>Required</sup> <a name="monocdk-nag.IApplyRule.property.explanation" id="monocdknagiapplyrulepropertyexplanation"></a>

```typescript
public readonly explanation: string;
```

- *Type:* `string`

Why the rule exists.

---

##### `info`<sup>Required</sup> <a name="monocdk-nag.IApplyRule.property.info" id="monocdknagiapplyrulepropertyinfo"></a>

```typescript
public readonly info: string;
```

- *Type:* `string`

Why the rule was triggered.

---

##### `level`<sup>Required</sup> <a name="monocdk-nag.IApplyRule.property.level" id="monocdknagiapplyrulepropertylevel"></a>

```typescript
public readonly level: NagMessageLevel;
```

- *Type:* [`monocdk-nag.NagMessageLevel`](#monocdk-nag.NagMessageLevel)

The annotations message level to apply to the rule if triggered.

---

##### `node`<sup>Required</sup> <a name="monocdk-nag.IApplyRule.property.node" id="monocdknagiapplyrulepropertynode"></a>

```typescript
public readonly node: CfnResource;
```

- *Type:* [`monocdk.CfnResource`](#monocdk.CfnResource)

Ignores listed in cdk-nag metadata.

---

##### `ruleSuffixOverride`<sup>Optional</sup> <a name="monocdk-nag.IApplyRule.property.ruleSuffixOverride" id="monocdknagiapplyrulepropertyrulesuffixoverride"></a>

```typescript
public readonly ruleSuffixOverride: string;
```

- *Type:* `string`

Override for the suffix of the Rule ID for this rule.

---

## Enums <a name="Enums" id="enums"></a>

### NagMessageLevel <a name="NagMessageLevel" id="nagmessagelevel"></a>

| **Name** | **Description** |
| --- | --- |
| [`WARN`](#monocdknagnagmessagelevelwarn) | *No description.* |
| [`ERROR`](#monocdknagnagmessagelevelerror) | *No description.* |

---

The level of the message that the rule applies.

#### `WARN` <a name="monocdk-nag.NagMessageLevel.WARN" id="monocdknagnagmessagelevelwarn"></a>

---


#### `ERROR` <a name="monocdk-nag.NagMessageLevel.ERROR" id="monocdknagnagmessagelevelerror"></a>

---


### NagRuleCompliance <a name="NagRuleCompliance" id="nagrulecompliance"></a>

| **Name** | **Description** |
| --- | --- |
| [`COMPLIANT`](#monocdknagnagrulecompliancecompliant) | *No description.* |
| [`NON_COMPLIANT`](#monocdknagnagrulecompliancenoncompliant) | *No description.* |
| [`NOT_APPLICABLE`](#monocdknagnagrulecompliancenotapplicable) | *No description.* |

---

The compliance level of a resource in relation to a rule.

#### `COMPLIANT` <a name="monocdk-nag.NagRuleCompliance.COMPLIANT" id="monocdknagnagrulecompliancecompliant"></a>

---


#### `NON_COMPLIANT` <a name="monocdk-nag.NagRuleCompliance.NON_COMPLIANT" id="monocdknagnagrulecompliancenoncompliant"></a>

---


#### `NOT_APPLICABLE` <a name="monocdk-nag.NagRuleCompliance.NOT_APPLICABLE" id="monocdknagnagrulecompliancenotapplicable"></a>

---

