"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_rds_1 = require("monocdk/aws-rds");
const monocdk_1 = require("monocdk");
const nag_rules_1 = require("../../nag-rules");
/**
 * RDS Aurora MySQL serverless clusters have audit, error, general, and slowquery Log Exports enabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    var _a;
    if (node instanceof aws_rds_1.CfnDBCluster) {
        const engine = nag_rules_1.NagRules.resolveIfPrimitive(node, node.engine).toLowerCase();
        const engineMode = nag_rules_1.NagRules.resolveIfPrimitive(node, node.engineMode);
        if (engineMode != undefined &&
            engineMode.toLowerCase() == 'serverless' &&
            (engine.toLowerCase() == 'aurora' ||
                engine.toLowerCase() == 'aurora-mysql')) {
            const exports = (_a = monocdk_1.Stack.of(node).resolve(node.enableCloudwatchLogsExports)) !== null && _a !== void 0 ? _a : [];
            const needed = ['audit', 'error', 'general', 'slowquery'];
            const findings = needed
                .filter((log) => !exports.includes(log))
                .map((log) => `LogExport::${log}`);
            if (findings.length) {
                return findings;
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXVyb3JhTXlTUUxMb2dnaW5nLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3J1bGVzL3Jkcy9BdXJvcmFNeVNRTExvZ2dpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRiwrQkFBNkI7QUFDN0IsNkNBQStDO0FBQy9DLHFDQUE2QztBQUM3QywrQ0FLeUI7QUFFekI7OztHQUdHO0FBQ0gsa0JBQWUsTUFBTSxDQUFDLGNBQWMsQ0FDbEMsQ0FBQyxJQUFpQixFQUFpQixFQUFFOztJQUNuQyxJQUFJLElBQUksWUFBWSxzQkFBWSxFQUFFO1FBQ2hDLE1BQU0sTUFBTSxHQUFHLG9CQUFRLENBQUMsa0JBQWtCLENBQ3hDLElBQUksRUFDSixJQUFJLENBQUMsTUFBTSxDQUNaLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDaEIsTUFBTSxVQUFVLEdBQUcsb0JBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3RFLElBQ0UsVUFBVSxJQUFJLFNBQVM7WUFDdkIsVUFBVSxDQUFDLFdBQVcsRUFBRSxJQUFJLFlBQVk7WUFDeEMsQ0FBQyxNQUFNLENBQUMsV0FBVyxFQUFFLElBQUksUUFBUTtnQkFDL0IsTUFBTSxDQUFDLFdBQVcsRUFBRSxJQUFJLGNBQWMsQ0FBQyxFQUN6QztZQUNBLE1BQU0sT0FBTyxTQUNYLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQywyQkFBMkIsQ0FBQyxtQ0FBSSxFQUFFLENBQUM7WUFDakUsTUFBTSxNQUFNLEdBQUcsQ0FBQyxPQUFPLEVBQUUsT0FBTyxFQUFFLFNBQVMsRUFBRSxXQUFXLENBQUMsQ0FBQztZQUMxRCxNQUFNLFFBQVEsR0FBb0IsTUFBTTtpQkFDckMsTUFBTSxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUM7aUJBQ3ZDLEdBQUcsQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsY0FBYyxHQUFHLEVBQUUsQ0FBQyxDQUFDO1lBQ3JDLElBQUksUUFBUSxDQUFDLE1BQU0sRUFBRTtnQkFDbkIsT0FBTyxRQUFRLENBQUM7YUFDakI7U0FDRjtRQUNELE9BQU8sNkJBQWlCLENBQUMsU0FBUyxDQUFDO0tBQ3BDO1NBQU07UUFDTCxPQUFPLDZCQUFpQixDQUFDLGNBQWMsQ0FBQztLQUN6QztBQUNILENBQUMsRUFDRCxNQUFNLEVBQ04sRUFBRSxLQUFLLEVBQUUsWUFBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUNsQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBwYXJzZSB9IGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgQ2ZuREJDbHVzdGVyIH0gZnJvbSAnbW9ub2Nkay9hd3MtcmRzJztcbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHtcbiAgTmFnUnVsZUNvbXBsaWFuY2UsXG4gIE5hZ1J1bGVGaW5kaW5ncyxcbiAgTmFnUnVsZVJlc3VsdCxcbiAgTmFnUnVsZXMsXG59IGZyb20gJy4uLy4uL25hZy1ydWxlcyc7XG5cbi8qKlxuICogUkRTIEF1cm9yYSBNeVNRTCBzZXJ2ZXJsZXNzIGNsdXN0ZXJzIGhhdmUgYXVkaXQsIGVycm9yLCBnZW5lcmFsLCBhbmQgc2xvd3F1ZXJ5IExvZyBFeHBvcnRzIGVuYWJsZWRcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBPYmplY3QuZGVmaW5lUHJvcGVydHkoXG4gIChub2RlOiBDZm5SZXNvdXJjZSk6IE5hZ1J1bGVSZXN1bHQgPT4ge1xuICAgIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuREJDbHVzdGVyKSB7XG4gICAgICBjb25zdCBlbmdpbmUgPSBOYWdSdWxlcy5yZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICAgIG5vZGUsXG4gICAgICAgIG5vZGUuZW5naW5lXG4gICAgICApLnRvTG93ZXJDYXNlKCk7XG4gICAgICBjb25zdCBlbmdpbmVNb2RlID0gTmFnUnVsZXMucmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUuZW5naW5lTW9kZSk7XG4gICAgICBpZiAoXG4gICAgICAgIGVuZ2luZU1vZGUgIT0gdW5kZWZpbmVkICYmXG4gICAgICAgIGVuZ2luZU1vZGUudG9Mb3dlckNhc2UoKSA9PSAnc2VydmVybGVzcycgJiZcbiAgICAgICAgKGVuZ2luZS50b0xvd2VyQ2FzZSgpID09ICdhdXJvcmEnIHx8XG4gICAgICAgICAgZW5naW5lLnRvTG93ZXJDYXNlKCkgPT0gJ2F1cm9yYS1teXNxbCcpXG4gICAgICApIHtcbiAgICAgICAgY29uc3QgZXhwb3J0cyA9XG4gICAgICAgICAgU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLmVuYWJsZUNsb3Vkd2F0Y2hMb2dzRXhwb3J0cykgPz8gW107XG4gICAgICAgIGNvbnN0IG5lZWRlZCA9IFsnYXVkaXQnLCAnZXJyb3InLCAnZ2VuZXJhbCcsICdzbG93cXVlcnknXTtcbiAgICAgICAgY29uc3QgZmluZGluZ3M6IE5hZ1J1bGVGaW5kaW5ncyA9IG5lZWRlZFxuICAgICAgICAgIC5maWx0ZXIoKGxvZykgPT4gIWV4cG9ydHMuaW5jbHVkZXMobG9nKSlcbiAgICAgICAgICAubWFwKChsb2cpID0+IGBMb2dFeHBvcnQ6OiR7bG9nfWApO1xuICAgICAgICBpZiAoZmluZGluZ3MubGVuZ3RoKSB7XG4gICAgICAgICAgcmV0dXJuIGZpbmRpbmdzO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgICByZXR1cm4gTmFnUnVsZUNvbXBsaWFuY2UuQ09NUExJQU5UO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gTmFnUnVsZUNvbXBsaWFuY2UuTk9UX0FQUExJQ0FCTEU7XG4gICAgfVxuICB9LFxuICAnbmFtZScsXG4gIHsgdmFsdWU6IHBhcnNlKF9fZmlsZW5hbWUpLm5hbWUgfVxuKTtcbiJdfQ==