"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_rds_1 = require("monocdk/aws-rds");
const monocdk_1 = require("monocdk");
const nag_rules_1 = require("../../nag-rules");
/**
 * RDS DB instances are configured to export all possible log types to CloudWatch
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    var _a;
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const dbType = String(nag_rules_1.NagRules.resolveIfPrimitive(node, node.engine));
        const exports = (_a = monocdk_1.Stack.of(node).resolve(node.enableCloudwatchLogsExports)) !== null && _a !== void 0 ? _a : [];
        const needed = [];
        if (dbType.includes('mariadb') || dbType.includes('mysql')) {
            needed.push('audit', 'error', 'general', 'slowquery');
        }
        else if (dbType.includes('postgres')) {
            needed.push('postgresql', 'upgrade');
        }
        else if (dbType.includes('oracle')) {
            needed.push('audit', 'alert', 'listener', 'oemagent', 'trace');
        }
        else if (dbType.includes('sqlserver')) {
            needed.push('agent', 'error');
        }
        const findings = needed
            .filter((log) => !exports.includes(log))
            .map((log) => `LogExport::${log}`);
        return findings.length ? findings : nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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