"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_rds_1 = require("monocdk/aws-rds");
const monocdk_1 = require("monocdk");
const nag_rules_1 = require("../../nag-rules");
/**
 * RDS DB security groups do not allow for 0.0.0.0/0 inbound access
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_rds_1.CfnDBSecurityGroup) {
        const ingressRules = monocdk_1.Stack.of(node).resolve(node.dbSecurityGroupIngress);
        if (ingressRules != undefined) {
            for (const rule of ingressRules) {
                const resolvedRule = monocdk_1.Stack.of(node).resolve(rule);
                const resolvedcidrIp = nag_rules_1.NagRules.resolveIfPrimitive(node, resolvedRule.cidrip);
                if (resolvedcidrIp != undefined && resolvedcidrIp.includes('/0')) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else if (node instanceof aws_rds_1.CfnDBSecurityGroupIngress) {
        const resolvedcidrIp = nag_rules_1.NagRules.resolveIfPrimitive(node, node.cidrip);
        if (resolvedcidrIp != undefined && resolvedcidrIp.includes('/0')) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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