# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['DatabaseClusterArgs', 'DatabaseCluster']

@pulumi.input_type
class DatabaseClusterArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[str],
                 node_count: pulumi.Input[int],
                 region: pulumi.Input[Union[str, 'Region']],
                 size: pulumi.Input[Union[str, 'DatabaseSlug']],
                 backup_restore: Optional[pulumi.Input['DatabaseClusterBackupRestoreArgs']] = None,
                 eviction_policy: Optional[pulumi.Input[str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseClusterMaintenanceWindowArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_network_uuid: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 sql_mode: Optional[pulumi.Input[str]] = None,
                 storage_size_mib: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DatabaseCluster resource.
        :param pulumi.Input[str] engine: Database engine used by the cluster (ex. `pg` for PostgreSQL, `mysql` for MySQL, `redis` for Redis, `mongodb` for MongoDB, or `kafka` for Kafka).
        :param pulumi.Input[int] node_count: Number of nodes that will be included in the cluster. For `kafka` clusters, this must be 3.
        :param pulumi.Input[Union[str, 'Region']] region: DigitalOcean region where the cluster will reside.
        :param pulumi.Input[Union[str, 'DatabaseSlug']] size: Database Droplet size associated with the cluster (ex. `db-s-1vcpu-1gb`). See here for a [list of valid size slugs](https://docs.digitalocean.com/reference/api/api-reference/#tag/Databases).
        :param pulumi.Input[str] eviction_policy: A string specifying the eviction policy for a Redis cluster. Valid values are: `noeviction`, `allkeys_lru`, `allkeys_random`, `volatile_lru`, `volatile_random`, or `volatile_ttl`.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseClusterMaintenanceWindowArgs']]] maintenance_windows: Defines when the automatic maintenance should be performed for the database cluster.
        :param pulumi.Input[str] name: The name of the database cluster.
        :param pulumi.Input[str] private_network_uuid: The ID of the VPC where the database cluster will be located.
        :param pulumi.Input[str] project_id: The ID of the project that the database cluster is assigned to. If excluded when creating a new database cluster, it will be assigned to your default project.
        :param pulumi.Input[str] sql_mode: A comma separated string specifying the  SQL modes for a MySQL cluster.
        :param pulumi.Input[str] storage_size_mib: Defines the disk size, in MiB, allocated to the cluster. This can be adjusted on MySQL and PostgreSQL clusters based on predefined ranges for each slug/droplet size.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tag names to be applied to the database cluster.
        :param pulumi.Input[str] version: Engine version used by the cluster (ex. `14` for PostgreSQL 14).
               When this value is changed, a call to the [Upgrade major Version for a Database](https://docs.digitalocean.com/reference/api/api-reference/#operation/databases_update_major_version) API operation is made with the new version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        if backup_restore is not None:
            pulumi.set(__self__, "backup_restore", backup_restore)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_network_uuid is not None:
            pulumi.set(__self__, "private_network_uuid", private_network_uuid)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if sql_mode is not None:
            pulumi.set(__self__, "sql_mode", sql_mode)
        if storage_size_mib is not None:
            pulumi.set(__self__, "storage_size_mib", storage_size_mib)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[str]:
        """
        Database engine used by the cluster (ex. `pg` for PostgreSQL, `mysql` for MySQL, `redis` for Redis, `mongodb` for MongoDB, or `kafka` for Kafka).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[int]:
        """
        Number of nodes that will be included in the cluster. For `kafka` clusters, this must be 3.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[Union[str, 'Region']]:
        """
        DigitalOcean region where the cluster will reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[Union[str, 'Region']]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[Union[str, 'DatabaseSlug']]:
        """
        Database Droplet size associated with the cluster (ex. `db-s-1vcpu-1gb`). See here for a [list of valid size slugs](https://docs.digitalocean.com/reference/api/api-reference/#tag/Databases).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[Union[str, 'DatabaseSlug']]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="backupRestore")
    def backup_restore(self) -> Optional[pulumi.Input['DatabaseClusterBackupRestoreArgs']]:
        return pulumi.get(self, "backup_restore")

    @backup_restore.setter
    def backup_restore(self, value: Optional[pulumi.Input['DatabaseClusterBackupRestoreArgs']]):
        pulumi.set(self, "backup_restore", value)

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[str]]:
        """
        A string specifying the eviction policy for a Redis cluster. Valid values are: `noeviction`, `allkeys_lru`, `allkeys_random`, `volatile_lru`, `volatile_random`, or `volatile_ttl`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eviction_policy", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseClusterMaintenanceWindowArgs']]]]:
        """
        Defines when the automatic maintenance should be performed for the database cluster.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseClusterMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateNetworkUuid")
    def private_network_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where the database cluster will be located.
        """
        return pulumi.get(self, "private_network_uuid")

    @private_network_uuid.setter
    def private_network_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network_uuid", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project that the database cluster is assigned to. If excluded when creating a new database cluster, it will be assigned to your default project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> Optional[pulumi.Input[str]]:
        """
        A comma separated string specifying the  SQL modes for a MySQL cluster.
        """
        return pulumi.get(self, "sql_mode")

    @sql_mode.setter
    def sql_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_mode", value)

    @property
    @pulumi.getter(name="storageSizeMib")
    def storage_size_mib(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the disk size, in MiB, allocated to the cluster. This can be adjusted on MySQL and PostgreSQL clusters based on predefined ranges for each slug/droplet size.
        """
        return pulumi.get(self, "storage_size_mib")

    @storage_size_mib.setter
    def storage_size_mib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_size_mib", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tag names to be applied to the database cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Engine version used by the cluster (ex. `14` for PostgreSQL 14).
        When this value is changed, a call to the [Upgrade major Version for a Database](https://docs.digitalocean.com/reference/api/api-reference/#operation/databases_update_major_version) API operation is made with the new version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _DatabaseClusterState:
    def __init__(__self__, *,
                 backup_restore: Optional[pulumi.Input['DatabaseClusterBackupRestoreArgs']] = None,
                 cluster_urn: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 eviction_policy: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseClusterMaintenanceWindowArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_host: Optional[pulumi.Input[str]] = None,
                 private_network_uuid: Optional[pulumi.Input[str]] = None,
                 private_uri: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 size: Optional[pulumi.Input[Union[str, 'DatabaseSlug']]] = None,
                 sql_mode: Optional[pulumi.Input[str]] = None,
                 storage_size_mib: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ui_database: Optional[pulumi.Input[str]] = None,
                 ui_host: Optional[pulumi.Input[str]] = None,
                 ui_password: Optional[pulumi.Input[str]] = None,
                 ui_port: Optional[pulumi.Input[int]] = None,
                 ui_uri: Optional[pulumi.Input[str]] = None,
                 ui_user: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DatabaseCluster resources.
        :param pulumi.Input[str] cluster_urn: The uniform resource name of the database cluster.
        :param pulumi.Input[str] database: Name of the cluster's default database.
        :param pulumi.Input[str] engine: Database engine used by the cluster (ex. `pg` for PostgreSQL, `mysql` for MySQL, `redis` for Redis, `mongodb` for MongoDB, or `kafka` for Kafka).
        :param pulumi.Input[str] eviction_policy: A string specifying the eviction policy for a Redis cluster. Valid values are: `noeviction`, `allkeys_lru`, `allkeys_random`, `volatile_lru`, `volatile_random`, or `volatile_ttl`.
        :param pulumi.Input[str] host: Database cluster's hostname.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseClusterMaintenanceWindowArgs']]] maintenance_windows: Defines when the automatic maintenance should be performed for the database cluster.
        :param pulumi.Input[str] name: The name of the database cluster.
        :param pulumi.Input[int] node_count: Number of nodes that will be included in the cluster. For `kafka` clusters, this must be 3.
        :param pulumi.Input[str] password: Password for the cluster's default user.
        :param pulumi.Input[int] port: Network port that the database cluster is listening on.
        :param pulumi.Input[str] private_host: Same as `host`, but only accessible from resources within the account and in the same region.
        :param pulumi.Input[str] private_network_uuid: The ID of the VPC where the database cluster will be located.
        :param pulumi.Input[str] private_uri: Same as `uri`, but only accessible from resources within the account and in the same region.
        :param pulumi.Input[str] project_id: The ID of the project that the database cluster is assigned to. If excluded when creating a new database cluster, it will be assigned to your default project.
        :param pulumi.Input[Union[str, 'Region']] region: DigitalOcean region where the cluster will reside.
        :param pulumi.Input[Union[str, 'DatabaseSlug']] size: Database Droplet size associated with the cluster (ex. `db-s-1vcpu-1gb`). See here for a [list of valid size slugs](https://docs.digitalocean.com/reference/api/api-reference/#tag/Databases).
        :param pulumi.Input[str] sql_mode: A comma separated string specifying the  SQL modes for a MySQL cluster.
        :param pulumi.Input[str] storage_size_mib: Defines the disk size, in MiB, allocated to the cluster. This can be adjusted on MySQL and PostgreSQL clusters based on predefined ranges for each slug/droplet size.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tag names to be applied to the database cluster.
        :param pulumi.Input[str] ui_database: Name of the OpenSearch dashboard db.
        :param pulumi.Input[str] ui_host: Hostname for the OpenSearch dashboard.
        :param pulumi.Input[str] ui_password: Password for the OpenSearch dashboard's default user.
        :param pulumi.Input[int] ui_port: Network port that the OpenSearch dashboard is listening on.
        :param pulumi.Input[str] ui_uri: The full URI for connecting to the OpenSearch dashboard.
        :param pulumi.Input[str] ui_user: Username for OpenSearch dashboard's default user.
        :param pulumi.Input[str] uri: The full URI for connecting to the database cluster.
        :param pulumi.Input[str] user: Username for the cluster's default user.
        :param pulumi.Input[str] version: Engine version used by the cluster (ex. `14` for PostgreSQL 14).
               When this value is changed, a call to the [Upgrade major Version for a Database](https://docs.digitalocean.com/reference/api/api-reference/#operation/databases_update_major_version) API operation is made with the new version.
        """
        if backup_restore is not None:
            pulumi.set(__self__, "backup_restore", backup_restore)
        if cluster_urn is not None:
            pulumi.set(__self__, "cluster_urn", cluster_urn)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_host is not None:
            pulumi.set(__self__, "private_host", private_host)
        if private_network_uuid is not None:
            pulumi.set(__self__, "private_network_uuid", private_network_uuid)
        if private_uri is not None:
            pulumi.set(__self__, "private_uri", private_uri)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if sql_mode is not None:
            pulumi.set(__self__, "sql_mode", sql_mode)
        if storage_size_mib is not None:
            pulumi.set(__self__, "storage_size_mib", storage_size_mib)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ui_database is not None:
            pulumi.set(__self__, "ui_database", ui_database)
        if ui_host is not None:
            pulumi.set(__self__, "ui_host", ui_host)
        if ui_password is not None:
            pulumi.set(__self__, "ui_password", ui_password)
        if ui_port is not None:
            pulumi.set(__self__, "ui_port", ui_port)
        if ui_uri is not None:
            pulumi.set(__self__, "ui_uri", ui_uri)
        if ui_user is not None:
            pulumi.set(__self__, "ui_user", ui_user)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="backupRestore")
    def backup_restore(self) -> Optional[pulumi.Input['DatabaseClusterBackupRestoreArgs']]:
        return pulumi.get(self, "backup_restore")

    @backup_restore.setter
    def backup_restore(self, value: Optional[pulumi.Input['DatabaseClusterBackupRestoreArgs']]):
        pulumi.set(self, "backup_restore", value)

    @property
    @pulumi.getter(name="clusterUrn")
    def cluster_urn(self) -> Optional[pulumi.Input[str]]:
        """
        The uniform resource name of the database cluster.
        """
        return pulumi.get(self, "cluster_urn")

    @cluster_urn.setter
    def cluster_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_urn", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cluster's default database.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Database engine used by the cluster (ex. `pg` for PostgreSQL, `mysql` for MySQL, `redis` for Redis, `mongodb` for MongoDB, or `kafka` for Kafka).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[str]]:
        """
        A string specifying the eviction policy for a Redis cluster. Valid values are: `noeviction`, `allkeys_lru`, `allkeys_random`, `volatile_lru`, `volatile_random`, or `volatile_ttl`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eviction_policy", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Database cluster's hostname.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseClusterMaintenanceWindowArgs']]]]:
        """
        Defines when the automatic maintenance should be performed for the database cluster.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseClusterMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes that will be included in the cluster. For `kafka` clusters, this must be 3.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the cluster's default user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Network port that the database cluster is listening on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateHost")
    def private_host(self) -> Optional[pulumi.Input[str]]:
        """
        Same as `host`, but only accessible from resources within the account and in the same region.
        """
        return pulumi.get(self, "private_host")

    @private_host.setter
    def private_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_host", value)

    @property
    @pulumi.getter(name="privateNetworkUuid")
    def private_network_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where the database cluster will be located.
        """
        return pulumi.get(self, "private_network_uuid")

    @private_network_uuid.setter
    def private_network_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network_uuid", value)

    @property
    @pulumi.getter(name="privateUri")
    def private_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Same as `uri`, but only accessible from resources within the account and in the same region.
        """
        return pulumi.get(self, "private_uri")

    @private_uri.setter
    def private_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_uri", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project that the database cluster is assigned to. If excluded when creating a new database cluster, it will be assigned to your default project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[Union[str, 'Region']]]:
        """
        DigitalOcean region where the cluster will reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Union[str, 'Region']]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[Union[str, 'DatabaseSlug']]]:
        """
        Database Droplet size associated with the cluster (ex. `db-s-1vcpu-1gb`). See here for a [list of valid size slugs](https://docs.digitalocean.com/reference/api/api-reference/#tag/Databases).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[Union[str, 'DatabaseSlug']]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> Optional[pulumi.Input[str]]:
        """
        A comma separated string specifying the  SQL modes for a MySQL cluster.
        """
        return pulumi.get(self, "sql_mode")

    @sql_mode.setter
    def sql_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_mode", value)

    @property
    @pulumi.getter(name="storageSizeMib")
    def storage_size_mib(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the disk size, in MiB, allocated to the cluster. This can be adjusted on MySQL and PostgreSQL clusters based on predefined ranges for each slug/droplet size.
        """
        return pulumi.get(self, "storage_size_mib")

    @storage_size_mib.setter
    def storage_size_mib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_size_mib", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tag names to be applied to the database cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="uiDatabase")
    def ui_database(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the OpenSearch dashboard db.
        """
        return pulumi.get(self, "ui_database")

    @ui_database.setter
    def ui_database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ui_database", value)

    @property
    @pulumi.getter(name="uiHost")
    def ui_host(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname for the OpenSearch dashboard.
        """
        return pulumi.get(self, "ui_host")

    @ui_host.setter
    def ui_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ui_host", value)

    @property
    @pulumi.getter(name="uiPassword")
    def ui_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the OpenSearch dashboard's default user.
        """
        return pulumi.get(self, "ui_password")

    @ui_password.setter
    def ui_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ui_password", value)

    @property
    @pulumi.getter(name="uiPort")
    def ui_port(self) -> Optional[pulumi.Input[int]]:
        """
        Network port that the OpenSearch dashboard is listening on.
        """
        return pulumi.get(self, "ui_port")

    @ui_port.setter
    def ui_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ui_port", value)

    @property
    @pulumi.getter(name="uiUri")
    def ui_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The full URI for connecting to the OpenSearch dashboard.
        """
        return pulumi.get(self, "ui_uri")

    @ui_uri.setter
    def ui_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ui_uri", value)

    @property
    @pulumi.getter(name="uiUser")
    def ui_user(self) -> Optional[pulumi.Input[str]]:
        """
        Username for OpenSearch dashboard's default user.
        """
        return pulumi.get(self, "ui_user")

    @ui_user.setter
    def ui_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ui_user", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The full URI for connecting to the database cluster.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        Username for the cluster's default user.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Engine version used by the cluster (ex. `14` for PostgreSQL 14).
        When this value is changed, a call to the [Upgrade major Version for a Database](https://docs.digitalocean.com/reference/api/api-reference/#operation/databases_update_major_version) API operation is made with the new version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class DatabaseCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_restore: Optional[pulumi.Input[Union['DatabaseClusterBackupRestoreArgs', 'DatabaseClusterBackupRestoreArgsDict']]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 eviction_policy: Optional[pulumi.Input[str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseClusterMaintenanceWindowArgs', 'DatabaseClusterMaintenanceWindowArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 private_network_uuid: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 size: Optional[pulumi.Input[Union[str, 'DatabaseSlug']]] = None,
                 sql_mode: Optional[pulumi.Input[str]] = None,
                 storage_size_mib: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean database cluster resource.

        ## Example Usage

        ### Create a new PostgreSQL database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        postgres_example = digitalocean.DatabaseCluster("postgres-example",
            name="example-postgres-cluster",
            engine="pg",
            version="15",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        ```

        ### Create a new MySQL database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        mysql_example = digitalocean.DatabaseCluster("mysql-example",
            name="example-mysql-cluster",
            engine="mysql",
            version="8",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        ```

        ### Create a new Redis database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        redis_example = digitalocean.DatabaseCluster("redis-example",
            name="example-redis-cluster",
            engine="redis",
            version="7",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        ```

        ### Create a new Kafka database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        kafka_example = digitalocean.DatabaseCluster("kafka-example",
            name="example-kafka-cluster",
            engine="kafka",
            version="3.5",
            size="db-s-2vcpu-2gb",
            region=digitalocean.Region.NYC1,
            node_count=3)
        ```

        ### Create a new MongoDB database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        mongodb_example = digitalocean.DatabaseCluster("mongodb-example",
            name="example-mongo-cluster",
            engine="mongodb",
            version="6",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC3,
            node_count=1)
        ```

        ### Create a new OpenSearch database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        opensearch_example = digitalocean.DatabaseCluster("opensearch-example",
            name="example-opensearch-cluster",
            engine="opensearch",
            version="2",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU2_GB,
            region=digitalocean.Region.NYC3,
            node_count=1)
        ```

        ## Create a new database cluster based on a backup of an existing cluster.

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        doby = digitalocean.DatabaseCluster("doby",
            name="dobydb",
            engine="pg",
            version="15",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU2_GB,
            region=digitalocean.Region.NYC1,
            node_count=1,
            tags=["production"])
        doby_backup = digitalocean.DatabaseCluster("doby_backup",
            name="dobydupe",
            engine="pg",
            version="15",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU2_GB,
            region=digitalocean.Region.NYC1,
            node_count=1,
            tags=["production"],
            backup_restore={
                "database_name": "dobydb",
            },
            opts = pulumi.ResourceOptions(depends_on=[doby]))
        ```

        ## Import

        Database clusters can be imported using the `id` returned from DigitalOcean, e.g.

        ```sh
        $ pulumi import digitalocean:index/databaseCluster:DatabaseCluster mycluster 245bcfd0-7f31-4ce6-a2bc-475a116cca97
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] engine: Database engine used by the cluster (ex. `pg` for PostgreSQL, `mysql` for MySQL, `redis` for Redis, `mongodb` for MongoDB, or `kafka` for Kafka).
        :param pulumi.Input[str] eviction_policy: A string specifying the eviction policy for a Redis cluster. Valid values are: `noeviction`, `allkeys_lru`, `allkeys_random`, `volatile_lru`, `volatile_random`, or `volatile_ttl`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseClusterMaintenanceWindowArgs', 'DatabaseClusterMaintenanceWindowArgsDict']]]] maintenance_windows: Defines when the automatic maintenance should be performed for the database cluster.
        :param pulumi.Input[str] name: The name of the database cluster.
        :param pulumi.Input[int] node_count: Number of nodes that will be included in the cluster. For `kafka` clusters, this must be 3.
        :param pulumi.Input[str] private_network_uuid: The ID of the VPC where the database cluster will be located.
        :param pulumi.Input[str] project_id: The ID of the project that the database cluster is assigned to. If excluded when creating a new database cluster, it will be assigned to your default project.
        :param pulumi.Input[Union[str, 'Region']] region: DigitalOcean region where the cluster will reside.
        :param pulumi.Input[Union[str, 'DatabaseSlug']] size: Database Droplet size associated with the cluster (ex. `db-s-1vcpu-1gb`). See here for a [list of valid size slugs](https://docs.digitalocean.com/reference/api/api-reference/#tag/Databases).
        :param pulumi.Input[str] sql_mode: A comma separated string specifying the  SQL modes for a MySQL cluster.
        :param pulumi.Input[str] storage_size_mib: Defines the disk size, in MiB, allocated to the cluster. This can be adjusted on MySQL and PostgreSQL clusters based on predefined ranges for each slug/droplet size.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tag names to be applied to the database cluster.
        :param pulumi.Input[str] version: Engine version used by the cluster (ex. `14` for PostgreSQL 14).
               When this value is changed, a call to the [Upgrade major Version for a Database](https://docs.digitalocean.com/reference/api/api-reference/#operation/databases_update_major_version) API operation is made with the new version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean database cluster resource.

        ## Example Usage

        ### Create a new PostgreSQL database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        postgres_example = digitalocean.DatabaseCluster("postgres-example",
            name="example-postgres-cluster",
            engine="pg",
            version="15",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        ```

        ### Create a new MySQL database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        mysql_example = digitalocean.DatabaseCluster("mysql-example",
            name="example-mysql-cluster",
            engine="mysql",
            version="8",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        ```

        ### Create a new Redis database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        redis_example = digitalocean.DatabaseCluster("redis-example",
            name="example-redis-cluster",
            engine="redis",
            version="7",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        ```

        ### Create a new Kafka database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        kafka_example = digitalocean.DatabaseCluster("kafka-example",
            name="example-kafka-cluster",
            engine="kafka",
            version="3.5",
            size="db-s-2vcpu-2gb",
            region=digitalocean.Region.NYC1,
            node_count=3)
        ```

        ### Create a new MongoDB database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        mongodb_example = digitalocean.DatabaseCluster("mongodb-example",
            name="example-mongo-cluster",
            engine="mongodb",
            version="6",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC3,
            node_count=1)
        ```

        ### Create a new OpenSearch database cluster
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        opensearch_example = digitalocean.DatabaseCluster("opensearch-example",
            name="example-opensearch-cluster",
            engine="opensearch",
            version="2",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU2_GB,
            region=digitalocean.Region.NYC3,
            node_count=1)
        ```

        ## Create a new database cluster based on a backup of an existing cluster.

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        doby = digitalocean.DatabaseCluster("doby",
            name="dobydb",
            engine="pg",
            version="15",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU2_GB,
            region=digitalocean.Region.NYC1,
            node_count=1,
            tags=["production"])
        doby_backup = digitalocean.DatabaseCluster("doby_backup",
            name="dobydupe",
            engine="pg",
            version="15",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU2_GB,
            region=digitalocean.Region.NYC1,
            node_count=1,
            tags=["production"],
            backup_restore={
                "database_name": "dobydb",
            },
            opts = pulumi.ResourceOptions(depends_on=[doby]))
        ```

        ## Import

        Database clusters can be imported using the `id` returned from DigitalOcean, e.g.

        ```sh
        $ pulumi import digitalocean:index/databaseCluster:DatabaseCluster mycluster 245bcfd0-7f31-4ce6-a2bc-475a116cca97
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_restore: Optional[pulumi.Input[Union['DatabaseClusterBackupRestoreArgs', 'DatabaseClusterBackupRestoreArgsDict']]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 eviction_policy: Optional[pulumi.Input[str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseClusterMaintenanceWindowArgs', 'DatabaseClusterMaintenanceWindowArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 private_network_uuid: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 size: Optional[pulumi.Input[Union[str, 'DatabaseSlug']]] = None,
                 sql_mode: Optional[pulumi.Input[str]] = None,
                 storage_size_mib: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseClusterArgs.__new__(DatabaseClusterArgs)

            __props__.__dict__["backup_restore"] = backup_restore
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["maintenance_windows"] = maintenance_windows
            __props__.__dict__["name"] = name
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["private_network_uuid"] = private_network_uuid
            __props__.__dict__["project_id"] = project_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["sql_mode"] = sql_mode
            __props__.__dict__["storage_size_mib"] = storage_size_mib
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["cluster_urn"] = None
            __props__.__dict__["database"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["private_host"] = None
            __props__.__dict__["private_uri"] = None
            __props__.__dict__["ui_database"] = None
            __props__.__dict__["ui_host"] = None
            __props__.__dict__["ui_password"] = None
            __props__.__dict__["ui_port"] = None
            __props__.__dict__["ui_uri"] = None
            __props__.__dict__["ui_user"] = None
            __props__.__dict__["uri"] = None
            __props__.__dict__["user"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "privateUri", "uiPassword", "uiUri", "uri"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatabaseCluster, __self__).__init__(
            'digitalocean:index/databaseCluster:DatabaseCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_restore: Optional[pulumi.Input[Union['DatabaseClusterBackupRestoreArgs', 'DatabaseClusterBackupRestoreArgsDict']]] = None,
            cluster_urn: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            eviction_policy: Optional[pulumi.Input[str]] = None,
            host: Optional[pulumi.Input[str]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseClusterMaintenanceWindowArgs', 'DatabaseClusterMaintenanceWindowArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            password: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            private_host: Optional[pulumi.Input[str]] = None,
            private_network_uuid: Optional[pulumi.Input[str]] = None,
            private_uri: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
            size: Optional[pulumi.Input[Union[str, 'DatabaseSlug']]] = None,
            sql_mode: Optional[pulumi.Input[str]] = None,
            storage_size_mib: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ui_database: Optional[pulumi.Input[str]] = None,
            ui_host: Optional[pulumi.Input[str]] = None,
            ui_password: Optional[pulumi.Input[str]] = None,
            ui_port: Optional[pulumi.Input[int]] = None,
            ui_uri: Optional[pulumi.Input[str]] = None,
            ui_user: Optional[pulumi.Input[str]] = None,
            uri: Optional[pulumi.Input[str]] = None,
            user: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'DatabaseCluster':
        """
        Get an existing DatabaseCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_urn: The uniform resource name of the database cluster.
        :param pulumi.Input[str] database: Name of the cluster's default database.
        :param pulumi.Input[str] engine: Database engine used by the cluster (ex. `pg` for PostgreSQL, `mysql` for MySQL, `redis` for Redis, `mongodb` for MongoDB, or `kafka` for Kafka).
        :param pulumi.Input[str] eviction_policy: A string specifying the eviction policy for a Redis cluster. Valid values are: `noeviction`, `allkeys_lru`, `allkeys_random`, `volatile_lru`, `volatile_random`, or `volatile_ttl`.
        :param pulumi.Input[str] host: Database cluster's hostname.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseClusterMaintenanceWindowArgs', 'DatabaseClusterMaintenanceWindowArgsDict']]]] maintenance_windows: Defines when the automatic maintenance should be performed for the database cluster.
        :param pulumi.Input[str] name: The name of the database cluster.
        :param pulumi.Input[int] node_count: Number of nodes that will be included in the cluster. For `kafka` clusters, this must be 3.
        :param pulumi.Input[str] password: Password for the cluster's default user.
        :param pulumi.Input[int] port: Network port that the database cluster is listening on.
        :param pulumi.Input[str] private_host: Same as `host`, but only accessible from resources within the account and in the same region.
        :param pulumi.Input[str] private_network_uuid: The ID of the VPC where the database cluster will be located.
        :param pulumi.Input[str] private_uri: Same as `uri`, but only accessible from resources within the account and in the same region.
        :param pulumi.Input[str] project_id: The ID of the project that the database cluster is assigned to. If excluded when creating a new database cluster, it will be assigned to your default project.
        :param pulumi.Input[Union[str, 'Region']] region: DigitalOcean region where the cluster will reside.
        :param pulumi.Input[Union[str, 'DatabaseSlug']] size: Database Droplet size associated with the cluster (ex. `db-s-1vcpu-1gb`). See here for a [list of valid size slugs](https://docs.digitalocean.com/reference/api/api-reference/#tag/Databases).
        :param pulumi.Input[str] sql_mode: A comma separated string specifying the  SQL modes for a MySQL cluster.
        :param pulumi.Input[str] storage_size_mib: Defines the disk size, in MiB, allocated to the cluster. This can be adjusted on MySQL and PostgreSQL clusters based on predefined ranges for each slug/droplet size.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tag names to be applied to the database cluster.
        :param pulumi.Input[str] ui_database: Name of the OpenSearch dashboard db.
        :param pulumi.Input[str] ui_host: Hostname for the OpenSearch dashboard.
        :param pulumi.Input[str] ui_password: Password for the OpenSearch dashboard's default user.
        :param pulumi.Input[int] ui_port: Network port that the OpenSearch dashboard is listening on.
        :param pulumi.Input[str] ui_uri: The full URI for connecting to the OpenSearch dashboard.
        :param pulumi.Input[str] ui_user: Username for OpenSearch dashboard's default user.
        :param pulumi.Input[str] uri: The full URI for connecting to the database cluster.
        :param pulumi.Input[str] user: Username for the cluster's default user.
        :param pulumi.Input[str] version: Engine version used by the cluster (ex. `14` for PostgreSQL 14).
               When this value is changed, a call to the [Upgrade major Version for a Database](https://docs.digitalocean.com/reference/api/api-reference/#operation/databases_update_major_version) API operation is made with the new version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseClusterState.__new__(_DatabaseClusterState)

        __props__.__dict__["backup_restore"] = backup_restore
        __props__.__dict__["cluster_urn"] = cluster_urn
        __props__.__dict__["database"] = database
        __props__.__dict__["engine"] = engine
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["host"] = host
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["private_host"] = private_host
        __props__.__dict__["private_network_uuid"] = private_network_uuid
        __props__.__dict__["private_uri"] = private_uri
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["sql_mode"] = sql_mode
        __props__.__dict__["storage_size_mib"] = storage_size_mib
        __props__.__dict__["tags"] = tags
        __props__.__dict__["ui_database"] = ui_database
        __props__.__dict__["ui_host"] = ui_host
        __props__.__dict__["ui_password"] = ui_password
        __props__.__dict__["ui_port"] = ui_port
        __props__.__dict__["ui_uri"] = ui_uri
        __props__.__dict__["ui_user"] = ui_user
        __props__.__dict__["uri"] = uri
        __props__.__dict__["user"] = user
        __props__.__dict__["version"] = version
        return DatabaseCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupRestore")
    def backup_restore(self) -> pulumi.Output[Optional['outputs.DatabaseClusterBackupRestore']]:
        return pulumi.get(self, "backup_restore")

    @property
    @pulumi.getter(name="clusterUrn")
    def cluster_urn(self) -> pulumi.Output[str]:
        """
        The uniform resource name of the database cluster.
        """
        return pulumi.get(self, "cluster_urn")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        Name of the cluster's default database.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Database engine used by the cluster (ex. `pg` for PostgreSQL, `mysql` for MySQL, `redis` for Redis, `mongodb` for MongoDB, or `kafka` for Kafka).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[Optional[str]]:
        """
        A string specifying the eviction policy for a Redis cluster. Valid values are: `noeviction`, `allkeys_lru`, `allkeys_random`, `volatile_lru`, `volatile_random`, or `volatile_ttl`.
        """
        return pulumi.get(self, "eviction_policy")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Database cluster's hostname.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Optional[Sequence['outputs.DatabaseClusterMaintenanceWindow']]]:
        """
        Defines when the automatic maintenance should be performed for the database cluster.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the database cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        Number of nodes that will be included in the cluster. For `kafka` clusters, this must be 3.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password for the cluster's default user.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Network port that the database cluster is listening on.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateHost")
    def private_host(self) -> pulumi.Output[str]:
        """
        Same as `host`, but only accessible from resources within the account and in the same region.
        """
        return pulumi.get(self, "private_host")

    @property
    @pulumi.getter(name="privateNetworkUuid")
    def private_network_uuid(self) -> pulumi.Output[str]:
        """
        The ID of the VPC where the database cluster will be located.
        """
        return pulumi.get(self, "private_network_uuid")

    @property
    @pulumi.getter(name="privateUri")
    def private_uri(self) -> pulumi.Output[str]:
        """
        Same as `uri`, but only accessible from resources within the account and in the same region.
        """
        return pulumi.get(self, "private_uri")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project that the database cluster is assigned to. If excluded when creating a new database cluster, it will be assigned to your default project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        DigitalOcean region where the cluster will reside.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        Database Droplet size associated with the cluster (ex. `db-s-1vcpu-1gb`). See here for a [list of valid size slugs](https://docs.digitalocean.com/reference/api/api-reference/#tag/Databases).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> pulumi.Output[Optional[str]]:
        """
        A comma separated string specifying the  SQL modes for a MySQL cluster.
        """
        return pulumi.get(self, "sql_mode")

    @property
    @pulumi.getter(name="storageSizeMib")
    def storage_size_mib(self) -> pulumi.Output[str]:
        """
        Defines the disk size, in MiB, allocated to the cluster. This can be adjusted on MySQL and PostgreSQL clusters based on predefined ranges for each slug/droplet size.
        """
        return pulumi.get(self, "storage_size_mib")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tag names to be applied to the database cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="uiDatabase")
    def ui_database(self) -> pulumi.Output[str]:
        """
        Name of the OpenSearch dashboard db.
        """
        return pulumi.get(self, "ui_database")

    @property
    @pulumi.getter(name="uiHost")
    def ui_host(self) -> pulumi.Output[str]:
        """
        Hostname for the OpenSearch dashboard.
        """
        return pulumi.get(self, "ui_host")

    @property
    @pulumi.getter(name="uiPassword")
    def ui_password(self) -> pulumi.Output[str]:
        """
        Password for the OpenSearch dashboard's default user.
        """
        return pulumi.get(self, "ui_password")

    @property
    @pulumi.getter(name="uiPort")
    def ui_port(self) -> pulumi.Output[int]:
        """
        Network port that the OpenSearch dashboard is listening on.
        """
        return pulumi.get(self, "ui_port")

    @property
    @pulumi.getter(name="uiUri")
    def ui_uri(self) -> pulumi.Output[str]:
        """
        The full URI for connecting to the OpenSearch dashboard.
        """
        return pulumi.get(self, "ui_uri")

    @property
    @pulumi.getter(name="uiUser")
    def ui_user(self) -> pulumi.Output[str]:
        """
        Username for OpenSearch dashboard's default user.
        """
        return pulumi.get(self, "ui_user")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[str]:
        """
        The full URI for connecting to the database cluster.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[str]:
        """
        Username for the cluster's default user.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[str]]:
        """
        Engine version used by the cluster (ex. `14` for PostgreSQL 14).
        When this value is changed, a call to the [Upgrade major Version for a Database](https://docs.digitalocean.com/reference/api/api-reference/#operation/databases_update_major_version) API operation is made with the new version.
        """
        return pulumi.get(self, "version")

