# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetReservedIpResult',
    'AwaitableGetReservedIpResult',
    'get_reserved_ip',
    'get_reserved_ip_output',
]

@pulumi.output_type
class GetReservedIpResult:
    """
    A collection of values returned by getReservedIp.
    """
    def __init__(__self__, droplet_id=None, id=None, ip_address=None, region=None, urn=None):
        if droplet_id and not isinstance(droplet_id, int):
            raise TypeError("Expected argument 'droplet_id' to be a int")
        pulumi.set(__self__, "droplet_id", droplet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if urn and not isinstance(urn, str):
            raise TypeError("Expected argument 'urn' to be a str")
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> int:
        """
        The Droplet id that the reserved IP has been assigned to.
        """
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region that the reserved IP is reserved to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def urn(self) -> str:
        """
        The uniform resource name of the reserved IP.
        """
        return pulumi.get(self, "urn")


class AwaitableGetReservedIpResult(GetReservedIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReservedIpResult(
            droplet_id=self.droplet_id,
            id=self.id,
            ip_address=self.ip_address,
            region=self.region,
            urn=self.urn)


def get_reserved_ip(ip_address: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReservedIpResult:
    """
    ## Example Usage

    Get the reserved IP:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    config = pulumi.Config()
    public_ip = config.require_object("publicIp")
    example = digitalocean.get_reserved_ip(ip_address=public_ip)
    pulumi.export("fipOutput", example.droplet_id)
    ```


    :param str ip_address: The allocated IP address of the specific reserved IP to retrieve.
    """
    __args__ = dict()
    __args__['ipAddress'] = ip_address
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getReservedIp:getReservedIp', __args__, opts=opts, typ=GetReservedIpResult).value

    return AwaitableGetReservedIpResult(
        droplet_id=pulumi.get(__ret__, 'droplet_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        region=pulumi.get(__ret__, 'region'),
        urn=pulumi.get(__ret__, 'urn'))
def get_reserved_ip_output(ip_address: Optional[pulumi.Input[str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReservedIpResult]:
    """
    ## Example Usage

    Get the reserved IP:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    config = pulumi.Config()
    public_ip = config.require_object("publicIp")
    example = digitalocean.get_reserved_ip(ip_address=public_ip)
    pulumi.export("fipOutput", example.droplet_id)
    ```


    :param str ip_address: The allocated IP address of the specific reserved IP to retrieve.
    """
    __args__ = dict()
    __args__['ipAddress'] = ip_address
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('digitalocean:index/getReservedIp:getReservedIp', __args__, opts=opts, typ=GetReservedIpResult)
    return __ret__.apply(lambda __response__: GetReservedIpResult(
        droplet_id=pulumi.get(__response__, 'droplet_id'),
        id=pulumi.get(__response__, 'id'),
        ip_address=pulumi.get(__response__, 'ip_address'),
        region=pulumi.get(__response__, 'region'),
        urn=pulumi.get(__response__, 'urn')))
