# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_endpoint: Optional[pulumi.Input[str]] = None,
                 http_retry_max: Optional[pulumi.Input[int]] = None,
                 http_retry_wait_max: Optional[pulumi.Input[float]] = None,
                 http_retry_wait_min: Optional[pulumi.Input[float]] = None,
                 requests_per_second: Optional[pulumi.Input[float]] = None,
                 spaces_access_id: Optional[pulumi.Input[str]] = None,
                 spaces_endpoint: Optional[pulumi.Input[str]] = None,
                 spaces_secret_key: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] api_endpoint: The URL to use for the DigitalOcean API.
        :param pulumi.Input[int] http_retry_max: The maximum number of retries on a failed API request.
        :param pulumi.Input[float] http_retry_wait_max: The maximum wait time (in seconds) between failed API requests.
        :param pulumi.Input[float] http_retry_wait_min: The minimum wait time (in seconds) between failed API requests.
        :param pulumi.Input[float] requests_per_second: The rate of requests per second to limit the HTTP client.
        :param pulumi.Input[str] spaces_access_id: The access key ID for Spaces API operations.
        :param pulumi.Input[str] spaces_endpoint: The URL to use for the DigitalOcean Spaces API.
        :param pulumi.Input[str] spaces_secret_key: The secret access key for Spaces API operations.
        :param pulumi.Input[str] token: The token key for API operations.
        """
        if api_endpoint is None:
            api_endpoint = (_utilities.get_env('DIGITALOCEAN_API_URL') or 'https://api.digitalocean.com')
        if api_endpoint is not None:
            pulumi.set(__self__, "api_endpoint", api_endpoint)
        if http_retry_max is not None:
            pulumi.set(__self__, "http_retry_max", http_retry_max)
        if http_retry_wait_max is not None:
            pulumi.set(__self__, "http_retry_wait_max", http_retry_wait_max)
        if http_retry_wait_min is not None:
            pulumi.set(__self__, "http_retry_wait_min", http_retry_wait_min)
        if requests_per_second is not None:
            pulumi.set(__self__, "requests_per_second", requests_per_second)
        if spaces_access_id is not None:
            pulumi.set(__self__, "spaces_access_id", spaces_access_id)
        if spaces_endpoint is None:
            spaces_endpoint = _utilities.get_env('SPACES_ENDPOINT_URL')
        if spaces_endpoint is not None:
            pulumi.set(__self__, "spaces_endpoint", spaces_endpoint)
        if spaces_secret_key is not None:
            pulumi.set(__self__, "spaces_secret_key", spaces_secret_key)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to use for the DigitalOcean API.
        """
        return pulumi.get(self, "api_endpoint")

    @api_endpoint.setter
    def api_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_endpoint", value)

    @property
    @pulumi.getter(name="httpRetryMax")
    def http_retry_max(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of retries on a failed API request.
        """
        return pulumi.get(self, "http_retry_max")

    @http_retry_max.setter
    def http_retry_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_retry_max", value)

    @property
    @pulumi.getter(name="httpRetryWaitMax")
    def http_retry_wait_max(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum wait time (in seconds) between failed API requests.
        """
        return pulumi.get(self, "http_retry_wait_max")

    @http_retry_wait_max.setter
    def http_retry_wait_max(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "http_retry_wait_max", value)

    @property
    @pulumi.getter(name="httpRetryWaitMin")
    def http_retry_wait_min(self) -> Optional[pulumi.Input[float]]:
        """
        The minimum wait time (in seconds) between failed API requests.
        """
        return pulumi.get(self, "http_retry_wait_min")

    @http_retry_wait_min.setter
    def http_retry_wait_min(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "http_retry_wait_min", value)

    @property
    @pulumi.getter(name="requestsPerSecond")
    def requests_per_second(self) -> Optional[pulumi.Input[float]]:
        """
        The rate of requests per second to limit the HTTP client.
        """
        return pulumi.get(self, "requests_per_second")

    @requests_per_second.setter
    def requests_per_second(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "requests_per_second", value)

    @property
    @pulumi.getter(name="spacesAccessId")
    def spaces_access_id(self) -> Optional[pulumi.Input[str]]:
        """
        The access key ID for Spaces API operations.
        """
        return pulumi.get(self, "spaces_access_id")

    @spaces_access_id.setter
    def spaces_access_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spaces_access_id", value)

    @property
    @pulumi.getter(name="spacesEndpoint")
    def spaces_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to use for the DigitalOcean Spaces API.
        """
        return pulumi.get(self, "spaces_endpoint")

    @spaces_endpoint.setter
    def spaces_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spaces_endpoint", value)

    @property
    @pulumi.getter(name="spacesSecretKey")
    def spaces_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secret access key for Spaces API operations.
        """
        return pulumi.get(self, "spaces_secret_key")

    @spaces_secret_key.setter
    def spaces_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spaces_secret_key", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The token key for API operations.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_endpoint: Optional[pulumi.Input[str]] = None,
                 http_retry_max: Optional[pulumi.Input[int]] = None,
                 http_retry_wait_max: Optional[pulumi.Input[float]] = None,
                 http_retry_wait_min: Optional[pulumi.Input[float]] = None,
                 requests_per_second: Optional[pulumi.Input[float]] = None,
                 spaces_access_id: Optional[pulumi.Input[str]] = None,
                 spaces_endpoint: Optional[pulumi.Input[str]] = None,
                 spaces_secret_key: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the digitalocean package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_endpoint: The URL to use for the DigitalOcean API.
        :param pulumi.Input[int] http_retry_max: The maximum number of retries on a failed API request.
        :param pulumi.Input[float] http_retry_wait_max: The maximum wait time (in seconds) between failed API requests.
        :param pulumi.Input[float] http_retry_wait_min: The minimum wait time (in seconds) between failed API requests.
        :param pulumi.Input[float] requests_per_second: The rate of requests per second to limit the HTTP client.
        :param pulumi.Input[str] spaces_access_id: The access key ID for Spaces API operations.
        :param pulumi.Input[str] spaces_endpoint: The URL to use for the DigitalOcean Spaces API.
        :param pulumi.Input[str] spaces_secret_key: The secret access key for Spaces API operations.
        :param pulumi.Input[str] token: The token key for API operations.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the digitalocean package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_endpoint: Optional[pulumi.Input[str]] = None,
                 http_retry_max: Optional[pulumi.Input[int]] = None,
                 http_retry_wait_max: Optional[pulumi.Input[float]] = None,
                 http_retry_wait_min: Optional[pulumi.Input[float]] = None,
                 requests_per_second: Optional[pulumi.Input[float]] = None,
                 spaces_access_id: Optional[pulumi.Input[str]] = None,
                 spaces_endpoint: Optional[pulumi.Input[str]] = None,
                 spaces_secret_key: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if api_endpoint is None:
                api_endpoint = (_utilities.get_env('DIGITALOCEAN_API_URL') or 'https://api.digitalocean.com')
            __props__.__dict__["api_endpoint"] = api_endpoint
            __props__.__dict__["http_retry_max"] = pulumi.Output.from_input(http_retry_max).apply(pulumi.runtime.to_json) if http_retry_max is not None else None
            __props__.__dict__["http_retry_wait_max"] = pulumi.Output.from_input(http_retry_wait_max).apply(pulumi.runtime.to_json) if http_retry_wait_max is not None else None
            __props__.__dict__["http_retry_wait_min"] = pulumi.Output.from_input(http_retry_wait_min).apply(pulumi.runtime.to_json) if http_retry_wait_min is not None else None
            __props__.__dict__["requests_per_second"] = pulumi.Output.from_input(requests_per_second).apply(pulumi.runtime.to_json) if requests_per_second is not None else None
            __props__.__dict__["spaces_access_id"] = spaces_access_id
            if spaces_endpoint is None:
                spaces_endpoint = _utilities.get_env('SPACES_ENDPOINT_URL')
            __props__.__dict__["spaces_endpoint"] = spaces_endpoint
            __props__.__dict__["spaces_secret_key"] = spaces_secret_key
            __props__.__dict__["token"] = token
        super(Provider, __self__).__init__(
            'digitalocean',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The URL to use for the DigitalOcean API.
        """
        return pulumi.get(self, "api_endpoint")

    @property
    @pulumi.getter(name="spacesAccessId")
    def spaces_access_id(self) -> pulumi.Output[Optional[str]]:
        """
        The access key ID for Spaces API operations.
        """
        return pulumi.get(self, "spaces_access_id")

    @property
    @pulumi.getter(name="spacesEndpoint")
    def spaces_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The URL to use for the DigitalOcean Spaces API.
        """
        return pulumi.get(self, "spaces_endpoint")

    @property
    @pulumi.getter(name="spacesSecretKey")
    def spaces_secret_key(self) -> pulumi.Output[Optional[str]]:
        """
        The secret access key for Spaces API operations.
        """
        return pulumi.get(self, "spaces_secret_key")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        The token key for API operations.
        """
        return pulumi.get(self, "token")

