# BlueLamp AI - 日本語対応AIエージェントシステム

BlueLamp AIは、日本語で対話できるAIエージェントシステムです。オーケストレーターと拡張マネージャーの2つのエージェントが連携して、あなたのプロジェクトを支援します。

## 🚀 インストール

```bash
pip install bluelamp-ai
```

## 💡 使用方法

### オーケストレーターエージェント
プロジェクトの設計と統括を行います：

```bash
ブルーランプ
```

### 拡張マネージャーエージェント
プロジェクトの実装と拡張を行います：

```bash
ブルーランプ拡張
```

## 🔧 機能

- **日本語対応**: 完全日本語でのAI対話
- **オーケストレーター**: プロジェクト設計と統括管理
- **拡張マネージャー**: 実装と機能拡張
- **シームレス連携**: 2つのエージェントが連携して作業

## 📋 必要条件

- Python 3.12以上
- 適切なAPIキー設定（Claude、OpenAI等）

### オプショナル機能のインストール

```bash
# ドキュメント処理機能（PDF、PPTX、DOCX対応）
poetry install --with runtime

# クラウドサービス統合機能（Redis、AWS、GCP等）
poetry install --with integrations

# 開発・テスト環境
poetry install --with dev,test
```

## 🎯 使用例

1. 新しいプロジェクトディレクトリで `ブルーランプ` を実行
2. プロジェクトの要件を日本語で説明
3. 必要に応じて `ブルーランプ拡張` で機能を追加・実装

## 📝 ライセンス

MIT License

## 🤝 サポート

問題や質問がある場合は、GitHubのIssuesをご利用ください。