from __future__ import annotations

from core.config.condenser_config import NoOpCondenserConfig
from core.storage.condenser.condenser import Condensation, Condenser, View


class NoOpCondenser(Condenser):
    """A condenser that does nothing to the event sequence."""

    def condense(self, view: View) -> View | Condensation:
        """Returns the list of events unchanged."""
        return view

    @classmethod
    def from_config(cls, config: NoOpCondenserConfig) -> NoOpCondenser:  # type: ignore
        return NoOpCondenser()


NoOpCondenser.register_config(NoOpCondenserConfig)
