# AI-Friendliness診断プロンプト v2.0

## 指示
現在のプロジェクトディレクトリのAI-Friendlinessを包括的に分析し、定量的なスコアと具体的な改善提案を提供してください。

## 🔧 AI-Friendlyなコード整備チェックリスト

### AI運用前の必須整備

#### 1. 構造の整理 (25点満点)
- [ ] 一貫性のあるディレクトリ構造 (最大3-4階層)
- [ ] 機能単位でのモジュール分割
- [ ] 明確な命名規則の適用
- [ ] core/extensions/resourcesの論理的分離

#### 2. 依存関係の明確化 (20点満点)
- [ ] 循環依存の解消
- [ ] 暗黙的なグローバル依存の排除
- [ ] import/exportの整理
- [ ] オプショナル依存の分離

#### 3. デッドコードの削除 (15点満点)
- [ ] 未使用ファイルの削除
- [ ] 未使用関数・変数の削除
- [ ] コメントアウトされた古いコードの削除
- [ ] TODO/FIXMEコメントの解決

#### 4. 型定義の充実 (10点満点)
- [ ] TypeScript化 or 型ヒントの充実
- [ ] 引数・戻り値の型を明示
- [ ] any型の排除
- [ ] py.typedファイルの配置

#### 5. コンテキストの文書化 (15点満点)
- [ ] 各モジュールの役割をREADMEに
- [ ] ビジネスロジックのコメント
- [ ] 設計判断の記録
- [ ] インストール・使用方法の明記

#### 6. AI理解しやすさ (15点満点)
- [ ] 自己説明的な変数名・関数名
- [ ] 動的コード生成の最小化
- [ ] 予測可能な副作用
- [ ] 明示的な制御フロー

## 💡 実践的な分析アプローチ

### Step 1: 現状分析（自動化可能）
```bash
# Python プロジェクトの場合
# 複雑度の測定
find . -name "*.py" | wc -l  # ファイル数
find . -type d | awk -F'/' '{print NF-1}' | sort -n | tail -1  # 最大階層
grep -r "TODO\|FIXME\|HACK" --include="*.py" . | wc -l  # TODO数

# 依存関係分析
grep -r "from.*import" --include="*.py" . | wc -l  # import数
grep -r "global " --include="*.py" . | wc -l  # グローバル変数

# JavaScript/TypeScript プロジェクトの場合
npx madge --circular src # 循環依存
npx madge --orphans src  # 未使用ファイル
npx jscpd src           # 重複コード検出
```

### Step 2: AI向け最適化の確認
```python
# Before: 人間は理解できるがAIには難しい
users.forEach(u => {
  if(u.s) proc(u); // sって何？
});

# After: AIが理解しやすい
users.forEach(user => {
  if(user.isActive) {
    processActiveUser(user); // 関数名で意図が明確
  }
});
```

## 🚀 AI-First Development原則

### 評価基準
```javascript
const aiFirstPrinciples = {
  "明示性": "暗黙的な動作を避ける",
  "静的解析可能": "動的な関数呼び出しを最小化", 
  "自己文書化": "コードが仕様書になる",
  "単一責任": "1関数1目的",
  "予測可能": "副作用を最小化"
};
```

## 📊 評価項目と配点

### カテゴリ別重み付けスコア算出
```
1. 構造の整理: 25点 × スコア率 = ___点
2. 依存関係の明確化: 20点 × スコア率 = ___点  
3. デッドコードの削除: 15点 × スコア率 = ___点
4. 型定義の充実: 10点 × スコア率 = ___点
5. コンテキストの文書化: 15点 × スコア率 = ___点
6. AI理解しやすさ: 15点 × スコア率 = ___点

総合スコア: ___/100点
```

## 📈 効果測定の目安

### スコア別評価
- **95-100点**: AI-Friendlyの業界最高水準
- **90-94点**: 非常に良好、AIが効率的に作業可能
- **80-89点**: 良好、基本的なAI作業に適している  
- **70-79点**: 改善必要、AIの理解に時間がかかる
- **70点未満**: 大幅改善必要、AI作業は困難

### 期待される効果実例
```
整備前：
- AI理解率: 40%
- 修正成功率: 60%  
- デバッグ時間: 2時間

整備後：
- AI理解率: 85%
- 修正成功率: 90%
- デバッグ時間: 30分
```

## 🎯 出力形式

### 必須出力項目
1. **各カテゴリーのスコア** (6項目 × 配点)
2. **総合AI-Friendlinessスコア** (/100点)
3. **最も改善効果の高い3つのアクション**
4. **各アクションの予想改善スコア**
5. **具体的な実装手順**

### 改善提案テンプレート
```markdown
## 改善提案

### 優先度1: [改善項目] (+X点)
- **現状**: [問題点]
- **改善案**: [具体的な解決策]
- **実装方法**: [ステップバイステップ]
- **期待効果**: [定量的な改善]

### 優先度2: [改善項目] (+X点)
...
```

---

この診断プロンプトを使用して、プロジェクトのAI-Friendlinessを定期的に測定し、継続的な改善を図ってください。
