　　# Universal AI-Friendliness診断プロンプト v3.0

## 🎯 目的
どんなプロジェクト（Web、モバイル、API、ライブラリ、データ分析等）でも、AIが効率的に理解・操作できるコードベースかを診断します。

## 📋 診断手順

### 1. プロジェクト基本情報の収集
```
プロジェクトタイプ: [Web/Mobile/API/Library/Data/Other]
主要言語: [Python/JavaScript/TypeScript/Java/Go/Other]
プロジェクト規模: [小(~100ファイル)/中(~1000)/大(1000+)]
開発フェーズ: [初期/成長期/成熟期/メンテナンス]
```

## 🔍 汎用AI-Friendliness評価基準

### 1. 構造の明確性 (25点)
**言語非依存の評価項目:**

#### a) ディレクトリ構造 (10点)
```
✅ 良い例（どの言語でも）:
├── src/          # ソースコード
├── tests/        # テスト
├── docs/         # ドキュメント
└── config/       # 設定

❌ 悪い例:
├── stuff/
├── old/
├── temp/
└── final_final_v2/
```

#### b) ファイル配置の一貫性 (8点)
- 機能単位でのグループ化
- 命名規則の統一
- 適切な粒度での分割

#### c) 階層の深さ (7点)
- 理想: 3-5階層
- 各階層で10個以下のアイテム
- 論理的な階層構造

### 2. 依存関係の健全性 (20点)
**プロジェクトタイプ別の確認方法:**

#### Webフロントエンド
```bash
# React/Vue/Angular
npm list --depth=0  # 直接依存の数
npx depcheck       # 未使用依存の検出
npx madge --circular src  # 循環依存
```

#### Pythonプロジェクト
```bash
pip list | wc -l   # 依存の総数
pipdeptree         # 依存ツリー
vulture .          # 未使用コード検出
```

#### その他の言語
- 依存の明示的な宣言
- バージョン固定
- 最小限の外部依存

### 3. コードの可読性 (20点)
**AIが理解しやすいコードの特徴:**

#### a) 命名の明確性 (8点)
```python
# ❌ AIには難しい
def proc(d):
    return d * 0.1

# ✅ AIが理解しやすい
def calculate_discount_rate(price):
    """商品価格から割引率を計算"""
    DISCOUNT_PERCENTAGE = 0.1
    return price * DISCOUNT_PERCENTAGE
```

#### b) 関数の単一責任 (7点)
- 1関数1目的
- 副作用の最小化
- 予測可能な入出力

#### c) コメントとドキュメント (5点)
- なぜそうするかの説明
- ビジネスロジックの明文化
- 複雑な処理の解説

### 4. エラーハンドリング (15点)
**AIがデバッグしやすい実装:**

#### a) 明示的なエラー処理 (8点)
```javascript
// ❌ 暗黙的
data.users.map(u => u.name)

// ✅ 明示的
if (!data || !data.users) {
    throw new Error('データ構造が不正です: usersが存在しません');
}
data.users.map(user => user.name)
```

#### b) エラーメッセージの充実度 (7点)
- 何が起きたか
- どこで起きたか
- どう対処すべきか

### 5. テストとドキュメント (10点)

#### a) テストカバレッジ (5点)
- 主要機能のテスト存在
- E2Eテストシナリオ
- テストの実行可能性

#### b) ドキュメントの完備 (5点)
- README.mdの充実度
- APIドキュメント
- アーキテクチャ図

### 6. 開発環境の再現性 (10点)

#### a) 環境構築の自動化 (5点)
```yaml
# docker-compose.yml や Makefile の存在
# ワンコマンドでの環境構築
make setup  # または
docker-compose up
```

#### b) 設定の外部化 (5点)
- 環境変数の活用
- 設定ファイルの分離
- シークレット管理

## 📊 スコアリング方法

### プロジェクトタイプ別の重み付け
```javascript
const weights = {
    "Webアプリ": {
        構造: 1.0,
        依存関係: 1.2,  // 重要
        可読性: 1.0,
        エラー: 0.9,
        テスト: 0.9,
        環境: 1.0
    },
    "ライブラリ": {
        構造: 1.1,
        依存関係: 0.8,  // 最小限でOK
        可読性: 1.3,    // 最重要
        エラー: 1.1,
        テスト: 1.2,    // 重要
        環境: 0.6
    },
    "データ分析": {
        構造: 0.9,
        依存関係: 0.7,
        可読性: 1.1,
        エラー: 0.8,
        テスト: 0.6,
        環境: 1.3      // 再現性重要
    }
};
```

## 🎯 診断実行コマンド集

### 汎用分析コマンド
```bash
# プロジェクト規模の把握
find . -type f -name "*.${ext}" | wc -l  # ファイル数
find . -type d | wc -l                    # ディレクトリ数
cloc .                                    # 言語別行数

# 複雑度の測定
find . -type f -name "*.${ext}" -exec wc -l {} + | sort -n | tail -10  # 大きいファイル

# TODO/FIXMEの検出
grep -r "TODO\|FIXME\|XXX\|HACK" . --include="*.${ext}" | wc -l

# 重複コード検出（言語非依存）
jscpd . --min-lines 5 --min-tokens 50
```

## 📈 改善優先度マトリクス

```
        影響度 高
         ↑
    [1] │ [2]
    ────┼────
    [3] │ [4]
         →
       労力 高

[1] Quick Wins: 構造整理、命名改善
[2] 大規模改善: アーキテクチャ再設計
[3] 継続改善: ドキュメント追加
[4] 将来課題: 完全な型付け
```

## 🚀 期待される効果

### スコア別のAI作業効率
| スコア | AI理解速度 | エラー率 | 必要な人間介入 |
|--------|-----------|---------|---------------|
| 90-100 | 即座に理解 | <5% | ほぼ不要 |
| 80-89 | 5分で理解 | <15% | 時々必要 |
| 70-79 | 15分で理解 | <30% | 頻繁に必要 |
| 60-69 | 30分以上 | >40% | 常に必要 |
| <60 | 困難 | >60% | AI利用困難 |

## 📝 診断レポートテンプレート

```markdown
# AI-Friendliness診断レポート

## プロジェクト概要
- **プロジェクト名**: [名前]
- **タイプ**: [Web/Mobile/API/etc]
- **主要技術**: [使用技術スタック]
- **規模**: [ファイル数/LOC]

## 診断結果サマリー
**総合スコア: XX/100点**

### カテゴリ別スコア
1. 構造の明確性: XX/25点
2. 依存関係の健全性: XX/20点
3. コードの可読性: XX/20点
4. エラーハンドリング: XX/15点
5. テストとドキュメント: XX/10点
6. 開発環境の再現性: XX/10点

## 改善提案TOP3
### 1. [最も効果的な改善] (+X点)
- **現状の問題**: 
- **改善方法**: 
- **期待効果**: AI作業時間をXX%短縮

### 2. [次に効果的な改善] (+X点)
...

## 実装ロードマップ
- Week 1: [Quick Wins実施]
- Week 2-3: [中規模改善]
- Month 2: [大規模改善]

## 成功指標
- AI理解成功率: 現在XX% → 目標XX%
- 平均デバッグ時間: 現在XX分 → 目標XX分
- エラー発生率: 現在XX% → 目標XX%
```

---

このユニバーサル診断プロンプトを使用することで、どんなプロジェクトでも客観的にAI-Friendlinessを評価し、具体的な改善策を導き出すことができます。
