# 📊 OpenHands監視システム 使用方法

## 🚀 簡単な使い方

### ステップ1: 2つのターミナルを開く

```bash
# ターミナル1（メイン）- いつも通りOpenHandsを実行
$ python bluelamp.py

# ターミナル2（監視）- 新しく開いて監視システムを実行
$ python3 openhands_monitor.py
```

### ステップ2: 監視開始

監視ターミナルで以下が表示されます：

```
┌─────────────────────────────────────────────────────────┐
│                🔍 OpenHands リアルタイム監視             │
├─────────────────────────────────────────────────────────┤
│ 📅 開始時刻: 14:23:10                                   │
│ ⏱️  経過時間: 00:01:23                                  │
│ 🕐 現在時刻: 14:24:33                                   │
│ 🎯 現在実行: npm start 実行中                           │
│ 📊 プロセス: 🟢 実行中                                  │
├─────────────────────────────────────────────────────────┤
│ 🖥️  CPU使用率: ████████░░ 15.2%                        │
│ 💾 メモリ使用: ██████░░░░ 234MB                         │
│ 🔢 プロセスID: 12345                                    │
├─────────────────────────────────────────────────────────┤
│ 📋 最新ログ:                                            │
│ [INFO] コマンド実行開始: npm start                      │
│ [DEBUG] サーバー初期化中...                             │
│ [INFO] ポート3000でリッスン開始                         │
├─────────────────────────────────────────────────────────┤
│ 🔄 自動更新: 20秒間隔 | Ctrl+C で終了                   │
└─────────────────────────────────────────────────────────┘
```

## ✨ 特徴

- **20秒ごと自動更新**: 進行状況が自動で更新されます
- **安全**: メインのOpenHandsに影響を与えません
- **リアルタイム**: 現在の実行状況がすぐわかります
- **簡単終了**: Ctrl+C でいつでも終了できます

## 🛠️ トラブルシューティング

### ログファイルが見つからない場合
```bash
# ログディレクトリを確認
$ ls -la logs/

# 今日の日付のログファイルがあるか確認
$ ls -la logs/bluelamp_*.log
```

### プロセスが検出されない場合
```bash
# OpenHandsが実行中か確認
$ ps aux | grep python | grep bluelamp
```

## 🎯 使用例

1. **長時間のサーバー起動監視**
   - メイン: `python bluelamp.py` でサーバー起動指示
   - 監視: `python3 openhands_monitor.py` で進行状況確認

2. **複雑なタスクの実行監視**
   - 20秒ごとに現在の実行内容が更新される
   - CPU・メモリ使用量も確認できる

3. **デバッグ時の状況把握**
   - 「止まっているのか実行中なのか」が明確にわかる
   - ログの最新情報もリアルタイム表示

## 🔧 カスタマイズ

更新間隔を変更したい場合は、`openhands_monitor.py` の以下の行を編集：

```python
time.sleep(20)  # 20秒 → 好きな秒数に変更
```