# -*- coding: utf-8 -*-
# Author: Yiping Liu
# Description: This script calculates the average of a list of numbers.
# Version: 1.0
# Last Modified: May 7, 2023

import pandas as pd

pd.set_option('display.precision', 11)
species = {
    ('psi', 'Cl-', 'Fe+2', 'Na+'): {
        'a1': -1.4e-2, # Marion et al. 2003
        # 'a1': -0.01605,
        # 'a1': -0.01, # Christov 2004
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'SO4-2', 'Fe+2', 'Na+'): {
        'a1': -1.207e-1,
        'a2': 5.235e-4,
        'a3': -5.39e-7,
        'a4': -4.39e-10,
        'a5': -1.723e1,
        'a6': 1.2645e-2,
        'a7': 0,
    },
    ('psi', 'Cl-', 'Fe+2', 'K+'): {
        'a1': 5.036223e-2,
        'a2': -8.750820e-6,
        'a3': 0,
        'a4': 0,
        'a5': -2.89909e1,
        'a6': 0,
        'a7': 0,
    },
    # ('psi', 'Cl-', 'Fe+2', 'K+'): {
    #     'a1': -0.02523,
    #     # 'a1': 0.003, # Christov 2004
    #     'a2': 0,
    #     'a3': 0,
    #     'a4': 0,
    #     'a5': 0,
    #     'a6': 0,
    #     'a7': 0,
    # },
    ('psi', 'SO4-2', 'Fe+2', 'K+'): {
        'a1': -1.18e-1,
        'a2': -4.78e-5,
        'a3': -3.27e-7,
        'a4': -9.37e-10,
        'a5': 3.344e1,
        'a6': -8.84e-3,
        'a7': 0,
    },
    ('psi', 'Cl-', 'Fe+2', 'H+'): {
        'a1': -1.4157e-1,
        'a2': 5.15e-4,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'SO4-2', 'Fe+2', 'H+'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'HSO4-', 'Fe+2', 'H+'): {
        'a1': 5.75716e1,
        'a2': -5.7767e-1,
        'a3': 1.924796e-3,
        'a4': -2.129138e-6,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'Cl-', 'Fe+2', 'Mg+2'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'SO4-2', 'Fe+2', 'Mg+2'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'Cl-', 'Fe+2', 'Mg+2'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'SO4-2', 'Fe+2', 'Mg+2'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'Cl-', 'Fe+2', 'Ca+2'): {
        'a1': 4.1579022e1,
        'a2': 1.30377312e-2,
        'a3': 0,
        'a4': 0,
        'a5': -9.81658526e2,
        'a6': -7.4061986e0,
        'a7': 0,
    },
    ('psi', 'SO4-2', 'Fe+2', 'Ca+2'): {
        'a1': 2.4e-2,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'SO4-2', 'Fe+2', 'Cl-'): {
        'a1': 5.869e-2,
        'a2': -8.97e-5,
        'a3': 4.7e-8,
        'a4': 6.5e-11,
        'a5': -2.413e1,
        'a6': 4.345e-3,
        'a7': 0,
    },
    ('psi', 'HCO3-', 'Fe+2', 'Cl-'): {
        'a1': -9.6e-2,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'SO4-2', 'Fe+2', 'HCO3-'): {
        'a1': -1.61e-1,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'SO4-2', 'Fe+2', 'HSO4-'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('psi', 'FeOH+', 'Fe+2', 'Cl-'): {
        'a1': 2.8e-2,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
    ('zeta', 'FeOH+', 'Fe+2', 'Cl-'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
    },
}

index = pd.MultiIndex.from_tuples([('pr1', 'pr2', 'pr3', 'pr4')],
                                  names=["parameter", "species1", "species2", "species3"])
df = pd.DataFrame(columns=['a1', 'a2', 'a3', 'a4', 'a5', 'a6', 'a7'], index=index)
for key, value in species.items():
    df.loc[key, :] = pd.Series(value)
df.sort_index()

marion_ternary = df
