# Code autogenerated by StandardBots
import json
from contextlib import contextmanager
from enum import Enum
from typing import Dict, Generic, TypeVar, Union

import urllib3

from . import models


class RobotKind(Enum):
    Live = "live"
    Simulated = "simulated"


GenericResponseType = TypeVar('GenericResponseType')
OkResponseType = TypeVar('OkResponseType')


class Response(Generic[GenericResponseType, OkResponseType]):
    data: GenericResponseType
    status: int
    response: urllib3.HTTPResponse

    def __init__(self, data: GenericResponseType, status: int, response: urllib3.HTTPResponse):
        self.data = data
        self.status = status
        self.response = response

    def ok(self) -> GenericResponseType:
        if self.status != 200:
            raise Exception("Request failed with status " + str(self.status) + ": " + str(self.data))
        return self.data

    def d(self) -> GenericResponseType:
        return self.data

    def isNotOk(self):
        return self.status != 200

    def assert_status(self, status: int):
        if self.status != status:
            raise Exception("Expecting status " + str(self.status) + ", but found " + str(self.status))

class RequestManager:
    token: str
    host: str
    robot_kind: RobotKind
    def __init__(
        self,
        http: urllib3.PoolManager,
        token: str,
        host: str,
        robot_kind: RobotKind
    ):
        self.http = http
        self.token = token
        self.host = host
        self.robot_kind = robot_kind

    def request(self, method: str, url: str, **kwargs):
        return self.http.request(method, self.host + url, **kwargs)

    def json_headers(self) -> Dict[str, str]:
        return {
            "Content-Type": "application/json",
            "Authorization": "Bearer " + self.token,
            # Include both for backwards-compatibility purposes.
            "robot_kind": self.robot_kind.value,
            "robot-kind": self.robot_kind.value,
        }

    def close(self):
        self.http.clear()

class Default:
    _request_manager: RequestManager
    class Equipment:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager

        def onrobot_2fg7_move(
          self,
          value: Union[int, float],
          direction: Union[str, models.LinearGripDirectionEnum] = models.LinearGripDirectionEnum.Inward,
          unit_kind: Union[str, models.LinearUnitKind] = models.LinearUnitKind.Millimeters
        ):
          """Move the robot to the onrobot_2fg7 position.
          """
          return self.control_gripper(
            models.GripperCommandRequest(
              kind=models.GripperKindEnum.Onrobot2Fg7,
              onrobot_2fg7=models.OnRobot2FG7GripperCommandRequest(
                control_kind=models.OnRobot2FG7ControlKindEnum.Move,
                target_grip_width=models.LinearUnit(
                  unit_kind=models.LinearUnitKind(unit_kind),
                  value=float(value),
                ),
                grip_direction=models.LinearGripDirectionEnum(direction),
              )
            )
          )
        
        def onrobot_2fg7_grip(
          self,
          value: Union[int, float],
          direction: Union[str, models.LinearGripDirectionEnum] = models.LinearGripDirectionEnum.Inward,
          unit_kind: Union[str, models.LinearUnitKind] = models.LinearUnitKind.Millimeters,
          force: Union[int, float] = 0.0,
          force_unit: Union[str, models.ForceUnitKind] = models.ForceUnitKind.Newtons
        ):
          """Move the robot to the onrobot_2fg7 position.
          """
          return self.control_gripper(
            models.GripperCommandRequest(
              kind=models.GripperKindEnum.Onrobot2Fg7,
              onrobot_2fg7=models.OnRobot2FG7GripperCommandRequest(
                control_kind=models.OnRobot2FG7ControlKindEnum.ForceGrip,
                target_grip_width=models.LinearUnit(
                  unit_kind=models.LinearUnitKind(unit_kind),
                  value=float(value),
                ),
                target_force=models.ForceUnit(
                  unit_kind=models.ForceUnitKind(force_unit),
                  value=float(force),
                ),
                grip_direction=models.LinearGripDirectionEnum(direction),
              )
            )
          )
        
        def dh_ag_grip(
            self,
            target_diameter: float,
            target_force: float | None,
            target_speed: float | None,
        ):
            """
            Control the DH AG gripper.
            Args:
            - target_diameter: 0.0 - 1.0
            - target_force: 0.2 - 1.0
            - target_speed: 0.01 - 1.0
            """
            return self.control_gripper(
                body=models.GripperCommandRequest(
                    kind=models.GripperKindEnum.DhAg,
                    dh_ag=models.DHAGGripperCommandRequest(
                        target_diameter, target_force, target_speed
                    ),
                ),
            )
        def dh_pgc_grip(
            self,
            target_diameter: float,
            target_force: float | None,
            target_speed: float | None,
        ):
            """
            Control the DH PGC gripper.
            Args:
            - target_diameter: 0.0 - 1.0
            - target_force: 0.2 - 1.0
            - target_speed: 0.01 - 1.0
            """
            return self.control_gripper(
                body=models.GripperCommandRequest(
                    kind=models.GripperKindEnum.DhPgc,
                    dh_pgc=models.DHPGCGripperCommandRequest(
                        target_diameter, target_force, target_speed
                    ),
                ),
            )
        def dh_cgi_grip(
            self,
            target_diameter: float,
            target_force: float | None,
            target_speed: float | None,
        ):
            """
            Control the DH CGI gripper.
            Args:
            - target_diameter: 0.0 - 1.0
            - target_force: 0.2 - 1.0
            - target_speed: 0.01 - 1.0
            """
            return self.control_gripper(
                body=models.GripperCommandRequest(
                    kind=models.GripperKindEnum.DhCgi,
                    dh_pgc=models.DHCGIGripperCommandRequest(
                        target_diameter, target_force, target_speed
                    ),
                ),
            )
        

        def control_gripper(
            self,
            body: models.GripperCommandRequest,
        ) -> Response[
            None,
            None
        ]:
            """
            Send commands to control the Gripper (End Effector) of the robot. The gripper can be any of Standard Bots supported grippers.

            """
            path = "/api/v1/equipment/end-effector/control"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_gripper_command_request(body)),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_gripper_configuration(
            self,
        ) -> Response[
            Union[
                models.GripperConfiguration,
                models.ErrorResponse,
                None
            ],
            models.GripperConfiguration
        ]:
            """
            Get the current gripper configuration

            """
            path = "/api/v1/equipment/end-effector/configuration"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_gripper_configuration(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Sensors:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def get_sensors(
            self,
        ) -> Response[
            Union[
                models.SensorsConfiguration,
                models.ErrorResponse,
                None
            ],
            models.SensorsConfiguration
        ]:
            """
            Get the current state of all sensors
            """
            path = "/api/v1/equipment/custom/sensors"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_sensors_configuration(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Space:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def list_planes(
            self,
            limit: int,
            offset: int,
        ) -> Response[
            Union[
                models.PlanesPaginatedResponse,
                models.ErrorResponse,
                None
            ],
            models.PlanesPaginatedResponse
        ]:
            """
            List Planes
            """
            path = "/api/v1/space/planes"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                    fields={
                        "limit": models.serialize_i_64(limit),
                        "offset": models.serialize_i_64(offset),
                    }
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_planes_paginated_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    equipment: Equipment
    sensors: Sensors
    space: Space

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.equipment = Default.Equipment(request_manager)
        self.sensors = Default.Sensors(request_manager)
        self.space = Default.Space(request_manager)

class Movement:
    _request_manager: RequestManager
    class Brakes:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager

        
        def brake(self):
            """Brake the robot
            """
            return self.set_brakes_state(
              models.BrakesState(
                state=models.BrakesStateEnum.Engaged,
              ),
            )
        
        def unbrake(self):
            """Unbrake the robot
            """
            return self.set_brakes_state(
              models.BrakesState(
                state=models.BrakesStateEnum.Disengaged,
              ),
            )
        

        def set_brakes_state(
            self,
            body: models.BrakesState,
        ) -> Response[
            Union[
                models.BrakesState,
                models.ErrorResponse,
                None
            ],
            models.BrakesState
        ]:
            """
            Control Joint Brakes in the robot

            """
            path = "/api/v1/movement/brakes"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_brakes_state(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_brakes_state(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_brakes_state(
            self,
        ) -> Response[
            Union[
                models.BrakesState,
                models.ErrorResponse,
                None
            ],
            models.BrakesState
        ]:
            """
            Get the current state of the robot brakes

            """
            path = "/api/v1/movement/brakes"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_brakes_state(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def engage_emergency_stop(
            self,
            body: models.EngageEmergencyStopRequest,
        ) -> Response[
            None,
            None
        ]:
            """
            Engage Emergency braking system.
&gt; **⚠️ Warning:** This will immediately stop the robot and may cause damage to the robot or surrounding environment.

            """
            path = "/api/v1/movement/brakes/emergency-stop"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_engage_emergency_stop_request(body)),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Position:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager

        def move(
          self,
          position: models.Position,
          orientation: models.Orientation,
          reference_frame: str = 'base',
          axis_alignment: str = 'base',
          local_accuracy_calibration: str | None = None,
          movement_kind: models.MovementKindEnum | None = models.MovementKindEnum.Joint,
          speed_profile: models.SpeedProfile | None = None,
        ):
          return self.move_tooltip(
            position=position,
            orientation=orientation,
            reference_frame=reference_frame,
            axis_alignment=axis_alignment,
            local_accuracy_calibration=local_accuracy_calibration,
            movement_kind=movement_kind,
            speed_profile=speed_profile
          )
        
        def move_tooltip(
          self,
          position: models.Position,
          orientation: models.Orientation,
          reference_frame: str = 'base',
          axis_alignment: str = 'base',
          local_accuracy_calibration: str | None = None,
          movement_kind: models.MovementKindEnum | None = models.MovementKindEnum.Joint,
          speed_profile: models.SpeedProfile | None = None,
        ):
          """Move tooltip of robot to specified position
          """
          request = models.ArmPositionUpdateRequest(
            kind=models.ArmPositionUpdateRequestKindEnum.TooltipPosition,
            tooltip_position=models.PositionAndOrientation(
              position=position,
              orientation=orientation,
              reference_frame=reference_frame,
              local_accuracy_calibration=local_accuracy_calibration,
              axis_alignment=axis_alignment,
            ),
            movement_kind=movement_kind,
            speed_profile=speed_profile
          )
          return self.set_arm_position(request)
        

        def get_arm_position(
            self,
        ) -> Response[
            Union[
                models.CombinedArmPosition,
                models.ErrorResponse,
                None
            ],
            models.CombinedArmPosition
        ]:
            """
            Get the current position of the robot arm
            """
            path = "/api/v1/movement/position/arm"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_combined_arm_position(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def set_arm_position(
            self,
            body: models.ArmPositionUpdateRequest,
        ) -> Response[
            Union[
                models.ArmPositionUpdateEvent,
                models.ErrorResponse,
                None
            ],
            models.ArmPositionUpdateEvent
        ]:
            """
            Control the position of the RO1 Robot arm.

            """
            path = "/api/v1/movement/position/arm"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_arm_position_update_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_arm_position_update_event(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    brakes: Brakes
    position: Position

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.brakes = Movement.Brakes(request_manager)
        self.position = Movement.Position(request_manager)

class Camera:
    _request_manager: RequestManager
    class Data:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def get_color_frame(
            self,
            body: models.CameraFrameRequest,
        ) -> Response[
            None,
            None
        ]:
            """
            Retrieve the latest RGB frame from the camera.
            """
            path = "/api/v1/camera/frame/rgb"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_camera_frame_request(body)),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_camera_intrinsics_color(
            self,
        ) -> Response[
            None,
            None
        ]:
            """
            Retrieve the intrinsic parameters for the color camera.
            """
            path = "/api/v1/camera/intrinsics/rgb"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_camera_stream(
            self,
        ) -> Response[
            None,
            None
        ]:
            """
            Retrieve the latest RGB frame from the camera.
            """
            path = "/api/v1/camera/stream/rgb"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                    preload_content=False,
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Settings:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def set_camera_settings(
            self,
            body: models.CameraSettings,
        ) -> Response[
            None,
            None
        ]:
            """
            Set the camera settings.
            """
            path = "/api/v1/camera/settings"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_camera_settings(body)),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    data: Data
    settings: Settings

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.data = Camera.Data(request_manager)
        self.settings = Camera.Settings(request_manager)

class Faults:
    _request_manager: RequestManager
    class UserFaults:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def trigger_user_fault(
            self,
            body: models.TriggerFaultRequest,
        ) -> Response[
            Union[
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            None
        ]:
            """
            Trigger user faults for routine

            """
            path = "/api/v1/faults/user-fault"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_trigger_fault_request(body)),
                )
                parsed = None
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    user_faults: UserFaults

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.user_faults = Faults.UserFaults(request_manager)

class General:
    _request_manager: RequestManager
    class BotIdentity:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def bot_identity(
            self,
        ) -> Response[
            Union[
                models.BotIdentityData,
                models.ErrorResponse,
                None
            ],
            models.BotIdentityData
        ]:
            """
            Get information about the robot&#x27;s identity.
            """
            path = "/api/v1/identity/bot_identity"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_bot_identity_data(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Joints:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def get_joints_state(
            self,
        ) -> Response[
            Union[
                models.JointsStateResponse,
                models.ErrorResponse,
                None
            ],
            models.JointsStateResponse
        ]:
            """
            Retrieves information about the state of each joint
            """
            path = "/api/v1/joints"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_joints_state_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    bot_identity: BotIdentity
    joints: Joints

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.bot_identity = General.BotIdentity(request_manager)
        self.joints = General.Joints(request_manager)

class ChatGPT:
    _request_manager: RequestManager
    class Data:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def speech_to_text(
            self,
            body: models.SpeechToTextRequest,
        ) -> Response[
            None,
            None
        ]:
            """
            Convert speech to text.
            """
            path = "/api/v1/internal-only/speech-to-text"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_speech_to_text_request(body)),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def text_to_skill(
            self,
            body: models.TextToSkillRequest,
        ) -> Response[
            None,
            None
        ]:
            """
            Convert text to a skill.
            """
            path = "/api/v1/internal-only/text-to-skill"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_text_to_skill_request(body)),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    data: Data

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.data = ChatGPT.Data(request_manager)

class IO:
    _request_manager: RequestManager
    class Control:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def update_io_state(
            self,
            body: models.IOStateUpdateRequest,
        ) -> Response[
            Union[
                models.IOStateResponse,
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            models.IOStateResponse
        ]:
            """
            Updates the state of I/O based on the provided action (&#x27;high&#x27; or &#x27;low&#x27;).
            """
            path = "/api/v1/io"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_io_state_update_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_io_state_response(json.loads(response.data))
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Status:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def get_io_state(
            self,
        ) -> Response[
            Union[
                models.IOStateResponse,
                models.ErrorResponse,
                None
            ],
            models.IOStateResponse
        ]:
            """
            Retrieves the current state of I/O.
            """
            path = "/api/v1/io"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_io_state_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    control: Control
    status: Status

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.control = IO.Control(request_manager)
        self.status = IO.Status(request_manager)

class Poses:
    _request_manager: RequestManager
    class ConstructPose:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def cartesian_pose(
            self,
            body: models.CartesianPoseRequest,
        ) -> Response[
            Union[
                models.CartesianPoseResponse,
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            models.CartesianPoseResponse
        ]:
            """
            Retrieve the cartesian pose based on euler angles

            """
            path = "/api/v1/poses/cartesian-pose"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_cartesian_pose_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_cartesian_pose_response(json.loads(response.data))
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def joint_pose(
            self,
            body: models.JointPoseRequest,
        ) -> Response[
            Union[
                models.JointPoseResponse,
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            models.JointPoseResponse
        ]:
            """
            Retrieve the cartesian pose based on joint angles

            """
            path = "/api/v1/poses/joint-pose"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_joint_pose_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_joint_pose_response(json.loads(response.data))
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class CartesianDistance:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def pose_distance(
            self,
            body: models.PoseDistanceRequest,
        ) -> Response[
            Union[
                models.PoseDistanceResponse,
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            models.PoseDistanceResponse
        ]:
            """
            Calculate the distance between two cartesian poses

            """
            path = "/api/v1/poses/pose-distance"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_pose_distance_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_pose_distance_response(json.loads(response.data))
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class PoseOperations:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def poses_addition(
            self,
            body: models.PoseOperationsRequest,
        ) -> Response[
            Union[
                models.PoseOperationsResponse,
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            models.PoseOperationsResponse
        ]:
            """
            Calculate the addition between two cartesian poses

            """
            path = "/api/v1/poses/add"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_pose_operations_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_pose_operations_response(json.loads(response.data))
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def poses_subtraction(
            self,
            body: models.PoseOperationsRequest,
        ) -> Response[
            Union[
                models.PoseOperationsResponse,
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            models.PoseOperationsResponse
        ]:
            """
            Calculate the subtraction between two cartesian poses

            """
            path = "/api/v1/poses/subtract"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_pose_operations_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_pose_operations_response(json.loads(response.data))
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def cartesian_offset(
            self,
            body: models.CartesianOffsetRequest,
        ) -> Response[
            Union[
                models.CartesianOffsetResponse,
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            models.CartesianOffsetResponse
        ]:
            """
            Determine the robot pose after applying the offset transformation

            """
            path = "/api/v1/poses/cartesian-offset"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_cartesian_offset_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_cartesian_offset_response(json.loads(response.data))
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class PoseRetrieval:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def get_joints_position(
            self,
        ) -> Response[
            Union[
                models.JointsPositionResponse,
                models.ErrorResponse,
                None
            ],
            models.JointsPositionResponse
        ]:
            """
            Get the joints position of the robot
            """
            path = "/api/v1/poses/joints-position"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_joints_position_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_tooltip_position(
            self,
        ) -> Response[
            Union[
                models.TooltipPositionResponse,
                models.ErrorResponse,
                None
            ],
            models.TooltipPositionResponse
        ]:
            """
            Get the tooltip position of the robot
            """
            path = "/api/v1/poses/tooltip-position"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_tooltip_position_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_flange_position(
            self,
        ) -> Response[
            Union[
                models.FlangePositionResponse,
                models.ErrorResponse,
                None
            ],
            models.FlangePositionResponse
        ]:
            """
            Get the flange position of the robot
            """
            path = "/api/v1/poses/flange-position"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_flange_position_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    construct_pose: ConstructPose
    cartesian_distance: CartesianDistance
    pose_operations: PoseOperations
    pose_retrieval: PoseRetrieval

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.construct_pose = Poses.ConstructPose(request_manager)
        self.cartesian_distance = Poses.CartesianDistance(request_manager)
        self.pose_operations = Poses.PoseOperations(request_manager)
        self.pose_retrieval = Poses.PoseRetrieval(request_manager)

class Recovery:
    _request_manager: RequestManager
    class Recover:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def recover(
            self,
        ) -> Response[
            Union[
                models.FailureStateResponse,
                models.ErrorResponse,
                models.ErrorResponse,
                None
            ],
            models.FailureStateResponse
        ]:
            """
            Attempts to recover the robot from a fault state. Inspect the response to determine if additional recovery actions are required.

            """
            path = "/api/v1/recovery/recover"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_failure_state_response(json.loads(response.data))
                if response.status == 400:
                    parsed = models.parse_error_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_status(
            self,
        ) -> Response[
            Union[
                models.FailureStateResponse,
                models.ErrorResponse,
                None
            ],
            models.FailureStateResponse
        ]:
            """
            Get the robot&#x27;s recovery status.

            """
            path = "/api/v1/recovery/status"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_failure_state_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    recover: Recover

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.recover = Recovery.Recover(request_manager)

class ROS:
    _request_manager: RequestManager
    class Control:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def update_ros_control_state(
            self,
            body: models.ROSControlUpdateRequest,
        ) -> Response[
            Union[
                models.ROSControlStateResponse,
                models.ErrorResponse,
                None
            ],
            models.ROSControlStateResponse
        ]:
            """
            Updates the state of ROS control based on the provided action (&#x27;enable&#x27; or &#x27;disable&#x27;).
            """
            path = "/api/v1/movement/ros/state"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_ros_control_update_request(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_ros_control_state_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Status:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def get_ros_control_state(
            self,
        ) -> Response[
            Union[
                models.ROSControlStateResponse,
                models.ErrorResponse,
                None
            ],
            models.ROSControlStateResponse
        ]:
            """
            Retrieves the current state of ROS control.
            """
            path = "/api/v1/movement/ros/state"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_ros_control_state_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    control: Control
    status: Status

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.control = ROS.Control(request_manager)
        self.status = ROS.Status(request_manager)

class RoutineEditor:
    _request_manager: RequestManager
    class Routines:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def play(
            self,
            body: models.PlayRoutineRequest,
            routine_id: str,
        ) -> Response[
            None,
            None
        ]:
            """
            Play a routine
            """
            path = "/api/v1/routine-editor/routines/{routine_id}/play"
            path = path.replace("{routine_id}", str(routine_id))
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_play_routine_request(body)),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def pause(
            self,
            routine_id: str,
        ) -> Response[
            None,
            None
        ]:
            """
            Pause a routine
            """
            path = "/api/v1/routine-editor/routines/{routine_id}/pause"
            path = path.replace("{routine_id}", str(routine_id))
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def stop(
            self,
        ) -> Response[
            None,
            None
        ]:
            """
            Stop running routine and all ongoing motions
            """
            path = "/api/v1/routine-editor/stop"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def list(
            self,
            limit: int,
            offset: int,
        ) -> Response[
            Union[
                models.RoutinesPaginatedResponse,
                models.ErrorResponse,
                None
            ],
            models.RoutinesPaginatedResponse
        ]:
            """
            List routines defined in Routine Editor UI
            """
            path = "/api/v1/routine-editor/routines"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                    fields={
                        "limit": models.serialize_i_64(limit),
                        "offset": models.serialize_i_64(offset),
                    }
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_routines_paginated_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def load(
            self,
            routine_id: str,
        ) -> Response[
            Union[
                models.Routine,
                models.ErrorResponse,
                None
            ],
            models.Routine
        ]:
            """
            Get routine data by ID
            """
            path = "/api/v1/routine-editor/routines/{routine_id}"
            path = path.replace("{routine_id}", str(routine_id))
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_routine(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def list_spaces(
            self,
            routine_id: str,
            exclude_global_spaces: bool,
        ) -> Response[
            Union[
                models.SpacesPaginatedResponse,
                models.ErrorResponse,
                None
            ],
            models.SpacesPaginatedResponse
        ]:
            """
            List spaces from routine
            """
            path = "/api/v1/routine-editor/routines/{routine_id}/spaces"
            path = path.replace("{routine_id}", str(routine_id))
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                    fields={
                        "exclude_global_spaces": models.serialize_bool(exclude_global_spaces),
                    }
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_spaces_paginated_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_step_variables(
            self,
            routine_id: str,
            step_id_map: bool,
        ) -> Response[
            Union[
                models.RoutineStepVariablesResponse,
                models.ErrorResponse,
                None
            ],
            models.RoutineStepVariablesResponse
        ]:
            """
            Get all step variables from a running routine.
            """
            path = "/api/v1/routine-editor/routines/{routine_id}/step-variables"
            path = path.replace("{routine_id}", str(routine_id))
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                    fields={
                        "step_id_map": models.serialize_bool(step_id_map),
                    }
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_routine_step_variables_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_state(
            self,
            routine_id: str,
        ) -> Response[
            Union[
                models.RoutineStateResponse,
                models.ErrorResponse,
                None
            ],
            models.RoutineStateResponse
        ]:
            """
            Get the state from a running routine.
            """
            path = "/api/v1/routine-editor/routines/{routine_id}/state"
            path = path.replace("{routine_id}", str(routine_id))
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_routine_state_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Variables:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def load(
            self,
            variable_name: str,
        ) -> Response[
            Union[
                models.RuntimeVariable,
                models.ErrorResponse,
                None
            ],
            models.RuntimeVariable
        ]:
            """
            Returns current state of a variable
            """
            path = "/api/v1/routine-editor/variables/{variable_name}"
            path = path.replace("{variable_name}", str(variable_name))
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_runtime_variable(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def update(
            self,
            body: models.RuntimeVariable,
            variable_name: str,
        ) -> Response[
            Union[
                models.RuntimeVariable,
                models.ErrorResponse,
                None
            ],
            models.RuntimeVariable
        ]:
            """
            Update the value of a variable
            """
            path = "/api/v1/routine-editor/variables/{variable_name}"
            path = path.replace("{variable_name}", str(variable_name))
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_runtime_variable(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_runtime_variable(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    routines: Routines
    variables: Variables

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.routines = RoutineEditor.Routines(request_manager)
        self.variables = RoutineEditor.Variables(request_manager)

class Status:
    _request_manager: RequestManager
    class Control:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def set_configuration_control_state(
            self,
            body: models.RobotControlMode,
        ) -> Response[
            Union[
                models.RobotControlMode,
                models.ErrorResponse,
                None
            ],
            models.RobotControlMode
        ]:
            """
            Set the system which is controlling the robot
            """
            path = "/api/v1/status/control-mode"
            try:
                response = self._request_manager.request(
                    "POST",
                    path,
                    headers=self._request_manager.json_headers(),
                    body=json.dumps(models.serialize_robot_control_mode(body)),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_robot_control_mode(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
        def get_configuration_state_control(
            self,
        ) -> Response[
            Union[
                models.RobotControlMode,
                models.ErrorResponse,
                None
            ],
            models.RobotControlMode
        ]:
            """
            Get the system which is controlling the robot
            """
            path = "/api/v1/status/control-mode"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_robot_control_mode(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )
    class Health:
        def __init__(self, request_manager: RequestManager):
            self._request_manager = request_manager


        def get_health(
            self,
        ) -> Response[
            Union[
                models.StatusHealthResponse,
                models.ErrorResponse,
                None
            ],
            models.StatusHealthResponse
        ]:
            """
            Get the current health of the robot
            """
            path = "/api/v1/status/health"
            try:
                response = self._request_manager.request(
                    "GET",
                    path,
                    headers=self._request_manager.json_headers(),
                )
                parsed = None
                if response.status == 200:
                    parsed = models.parse_status_health_response(json.loads(response.data))

                is_user_error = response.status >= 400 and response.status <= 500
                is_unavailable = response.status == 503
                if parsed is None and (is_user_error or is_unavailable):
                    parsed = models.parse_error_response(json.loads(response.data))

                return Response(
                    parsed,
                    response.status,
                    response
                )
            except urllib3.exceptions.MaxRetryError:
                return Response(
                    models.ErrorResponse(
                        error=models.ErrorEnum.InternalServerError,
                        message="Connection Refused"
                    ),
                    503,
                    None
                )

    control: Control
    health: Health

    def __init__(self, request_manager: RequestManager):
        self._request_manager = request_manager
        self.control = Status.Control(request_manager)
        self.health = Status.Health(request_manager)




class StandardBotsRobot(Default):
    RobotKind = RobotKind

    movement: Movement
    camera: Camera
    faults: Faults
    general: General
    chat_gpt: ChatGPT
    io: IO
    poses: Poses
    recovery: Recovery
    ros: ROS
    routine_editor: RoutineEditor
    status: Status
    def __init__(
        self,
        url: str,
        token: str,
        robot_kind: Union[RobotKind, str] = RobotKind.Live,
        pools: int = 10
    ):
        super().__init__(RequestManager(
            urllib3.PoolManager(num_pools=2),
            token=token,
            host=url,
            robot_kind=RobotKind(robot_kind),
        ))
        self.movement = Movement(self._request_manager)
        self.camera = Camera(self._request_manager)
        self.faults = Faults(self._request_manager)
        self.general = General(self._request_manager)
        self.chat_gpt = ChatGPT(self._request_manager)
        self.io = IO(self._request_manager)
        self.poses = Poses(self._request_manager)
        self.recovery = Recovery(self._request_manager)
        self.ros = ROS(self._request_manager)
        self.routine_editor = RoutineEditor(self._request_manager)
        self.status = Status(self._request_manager)

    @contextmanager
    def connection(self):
        yield
        self._request_manager.close()
