# Code autogenerated by StandardBots

from dataclasses import dataclass
from typing import List, Tuple, Union, Dict, Any
from enum import Enum

def parse_i_8(data: object) -> int:
  return int(data)

def serialize_i_8(data: int) -> object:
  return data

def parse_i_16(data: object) -> int:
  return int(data)

def serialize_i_16(data: int) -> object:
  return data

def parse_i_32(data: object) -> int:
  return int(data)

def serialize_i_32(data: int) -> object:
  return data

def parse_i_64(data: object) -> int:
  return int(data)

def serialize_i_64(data: int) -> object:
  return data

def parse_i_128(data: object) -> int:
  return int(data)

def serialize_i_128(data: int) -> object:
  return data

def parse_u_8(data: object) -> int:
  return int(data)

def serialize_u_8(data: int) -> object:
  return data

def parse_u_16(data: object) -> int:
  return int(data)

def serialize_u_16(data: int) -> object:
  return data

def parse_u_32(data: object) -> int:
  return int(data)

def serialize_u_32(data: int) -> object:
  return data

def parse_u_63(data: object) -> int:
  return int(data)

def serialize_u_63(data: int) -> object:
  return data

def parse_u_128(data: object) -> int:
  return int(data)

def serialize_u_128(data: int) -> object:
  return data

def parse_object_object(data: object) -> int:
  return int(data)

def serialize_object_object(data: int) -> object:
  return data

def parse_f_32(data: object) -> float:
  return float(data)

def serialize_f_32(data: float) -> object:
  return data

def parse_f_64(data: object) -> float:
  return float(data)

def serialize_f_64(data: float) -> object:
  return data

def parse_object_object(data: object) -> float:
  return float(data)

def serialize_object_object(data: float) -> object:
  return data


def parse_bool(data: object) -> bool:
  return bool(data)

def serialize_bool(data: bool) -> object:
  return data

def parse_str(data: object) -> str:
  return str(data)

def serialize_str(data: str) -> object:
  return data

def serialize_float(data: float) -> object:
  return data

def serialize_int(data: int) -> object:
  return data

@dataclass
class ArmPositionUpdateCanceledEvent:
  """Move robot event when motion is canceled"""
  kind: Union[str, None] = None
  reason: Union[str, None] = None

  def validate_kind(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "kind must be of type str for ArmPositionUpdateCanceledEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "reason must be of type str for ArmPositionUpdateCanceledEvent, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_reason(self.reason)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_canceled_event(data: object):
  return ArmPositionUpdateCanceledEvent(
    kind=parse_str(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    reason=parse_str(data["reason"]) if "reason" in data and data.get("reason") is not None else None,
  )

def serialize_arm_position_update_canceled_event(data: ArmPositionUpdateCanceledEvent) -> object:
  return {
    "kind": None if data.kind is None else serialize_str(data.kind),
    "reason": None if data.reason is None else serialize_str(data.reason),
  }

class ArmPositionUpdateFailureEventKind(Enum):
  MotionFailedUnknownReason = "motion_failed_unknown_reason"
  """Enum MotionFailedUnknownReason = `motion_failed_unknown_reason`"""
  MotionFailedCollision = "motion_failed_collision"
  """Enum MotionFailedCollision = `motion_failed_collision`"""

def parse_arm_position_update_failure_event_kind(data: object) -> ArmPositionUpdateFailureEventKind:
  return ArmPositionUpdateFailureEventKind(data)

def serialize_arm_position_update_failure_event_kind(data: Union[ArmPositionUpdateFailureEventKind, str]) -> object:
  return ArmPositionUpdateFailureEventKind(data).value

class ArmPositionUpdateKindEnum(Enum):
  Success = "success"
  """Enum Success = `success`"""
  Failure = "failure"
  """Enum Failure = `failure`"""
  Canceled = "canceled"
  """Enum Canceled = `canceled`"""
  Position = "position"
  """Enum Position = `position`"""
  Planning = "planning"
  """Enum Planning = `planning`"""

def parse_arm_position_update_kind_enum(data: object) -> ArmPositionUpdateKindEnum:
  return ArmPositionUpdateKindEnum(data)

def serialize_arm_position_update_kind_enum(data: Union[ArmPositionUpdateKindEnum, str]) -> object:
  return ArmPositionUpdateKindEnum(data).value

class ArmPositionUpdateRequestKindEnum(Enum):
  TooltipPositions = "tooltip_positions"
  """Enum TooltipPositions = `tooltip_positions`"""
  TooltipPosition = "tooltip_position"
  """Enum TooltipPosition = `tooltip_position`"""
  JointRotations = "joint_rotations"
  """Enum JointRotations = `joint_rotations`"""
  JointRotation = "joint_rotation"
  """Enum JointRotation = `joint_rotation`"""

def parse_arm_position_update_request_kind_enum(data: object) -> ArmPositionUpdateRequestKindEnum:
  return ArmPositionUpdateRequestKindEnum(data)

def serialize_arm_position_update_request_kind_enum(data: Union[ArmPositionUpdateRequestKindEnum, str]) -> object:
  return ArmPositionUpdateRequestKindEnum(data).value

class ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum(Enum):
  All = "all"
  """Receive all events as the robot moves to the target position."""
  Events = "events"
  """Receive only events as the robot moves to the target position."""
  Positions = "positions"
  """Receive only position events as the robot moves to the target position."""

def parse_arm_position_update_request_response_event_stream_subscription_kind_enum(data: object) -> ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum:
  return ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum(data)

def serialize_arm_position_update_request_response_event_stream_subscription_kind_enum(data: Union[ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum, str]) -> object:
  return ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum(data).value

class ArmPositionUpdateRequestResponseKindEnum(Enum):
  Sync = "sync"
  """Receive a single response once the robot has reached the target position."""
  EventStream = "event_stream"
  """Receive a stream of events as the robot moves to the target position. The &#x60;subscriptions&#x60; property can be used to specify which events should be sent. By default, all events are sent."""

def parse_arm_position_update_request_response_kind_enum(data: object) -> ArmPositionUpdateRequestResponseKindEnum:
  return ArmPositionUpdateRequestResponseKindEnum(data)

def serialize_arm_position_update_request_response_kind_enum(data: Union[ArmPositionUpdateRequestResponseKindEnum, str]) -> object:
  return ArmPositionUpdateRequestResponseKindEnum(data).value

@dataclass
class BotIdentityData:
  """Data about the robot&#x27;s identity"""
  robotId: Union[str, None] = None
  alias: Union[str, None] = None
  robotOperationMode: Union[str, None] = None
  applicationUrl: Union[str, None] = None

  def validate_robotId(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "robotId must be of type str for BotIdentityData, got " + type(value).__name__]

    return [True, ""]

  def validate_alias(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "alias must be of type str for BotIdentityData, got " + type(value).__name__]

    return [True, ""]

  def validate_robotOperationMode(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "robotOperationMode must be of type str for BotIdentityData, got " + type(value).__name__]

    return [True, ""]

  def validate_applicationUrl(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "applicationUrl must be of type str for BotIdentityData, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_robotId(self.robotId)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_alias(self.alias)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_robotOperationMode(self.robotOperationMode)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_applicationUrl(self.applicationUrl)
    if not is_valid:
      raise TypeError(error_str)

def parse_bot_identity_data(data: object):
  return BotIdentityData(
    robotId=parse_str(data["robotId"]) if "robotId" in data and data.get("robotId") is not None else None,
    alias=parse_str(data["alias"]) if "alias" in data and data.get("alias") is not None else None,
    robotOperationMode=parse_str(data["robotOperationMode"]) if "robotOperationMode" in data and data.get("robotOperationMode") is not None else None,
    applicationUrl=parse_str(data["applicationUrl"]) if "applicationUrl" in data and data.get("applicationUrl") is not None else None,
  )

def serialize_bot_identity_data(data: BotIdentityData) -> object:
  return {
    "robotId": None if data.robotId is None else serialize_str(data.robotId),
    "alias": None if data.alias is None else serialize_str(data.alias),
    "robotOperationMode": None if data.robotOperationMode is None else serialize_str(data.robotOperationMode),
    "applicationUrl": None if data.applicationUrl is None else serialize_str(data.applicationUrl),
  }

class BrakesStateEnum(Enum):
  Engaged = "engaged"
  """Robot Brakes are engaged, robot is not able to move"""
  Disengaged = "disengaged"
  """Robot Brakes are disengaged, robot can move freely"""

def parse_brakes_state_enum(data: object) -> BrakesStateEnum:
  return BrakesStateEnum(data)

def serialize_brakes_state_enum(data: Union[BrakesStateEnum, str]) -> object:
  return BrakesStateEnum(data).value

@dataclass
class CameraIntrinsics:
  """Intrinsic parameters of the camera."""
  width: Union[float, None] = None
  height: Union[float, None] = None
  fx: Union[float, None] = None
  fy: Union[float, None] = None
  ppx: Union[float, None] = None
  ppy: Union[float, None] = None
  error: Union[int, None] = None

  def validate_width(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "width must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_height(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "height must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_fx(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "fx must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_fy(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "fy must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_ppx(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "ppx must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_ppy(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "ppy must be of type float for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def validate_error(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "error must be of type int for CameraIntrinsics, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_width(self.width)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_height(self.height)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_fx(self.fx)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_fy(self.fy)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_ppx(self.ppx)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_ppy(self.ppy)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_error(self.error)
    if not is_valid:
      raise TypeError(error_str)

def parse_camera_intrinsics(data: object):
  return CameraIntrinsics(
    width=parse_f_64(data["width"]) if "width" in data and data.get("width") is not None else None,
    height=parse_f_64(data["height"]) if "height" in data and data.get("height") is not None else None,
    fx=parse_f_64(data["fx"]) if "fx" in data and data.get("fx") is not None else None,
    fy=parse_f_64(data["fy"]) if "fy" in data and data.get("fy") is not None else None,
    ppx=parse_f_64(data["ppx"]) if "ppx" in data and data.get("ppx") is not None else None,
    ppy=parse_f_64(data["ppy"]) if "ppy" in data and data.get("ppy") is not None else None,
    error=parse_i_8(data["error"]) if "error" in data and data.get("error") is not None else None,
  )

def serialize_camera_intrinsics(data: CameraIntrinsics) -> object:
  return {
    "width": None if data.width is None else serialize_f_64(data.width),
    "height": None if data.height is None else serialize_f_64(data.height),
    "fx": None if data.fx is None else serialize_f_64(data.fx),
    "fy": None if data.fy is None else serialize_f_64(data.fy),
    "ppx": None if data.ppx is None else serialize_f_64(data.ppx),
    "ppy": None if data.ppy is None else serialize_f_64(data.ppy),
    "error": None if data.error is None else serialize_i_8(data.error),
  }

@dataclass
class CameraSettings:
  """Settings for the camera."""
  brightness: Union[int, None] = None
  contrast: Union[int, None] = None
  exposure: Union[int, None] = None
  sharpness: Union[int, None] = None
  hue: Union[int, None] = None
  whiteBalance: Union[int, None] = None
  autoWhiteBalance: Union[bool, None] = None

  def validate_brightness(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "brightness must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_contrast(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "contrast must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_exposure(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "exposure must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_sharpness(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "sharpness must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_hue(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "hue must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_whiteBalance(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "whiteBalance must be of type int for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def validate_autoWhiteBalance(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "autoWhiteBalance must be of type bool for CameraSettings, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_brightness(self.brightness)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_contrast(self.contrast)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_exposure(self.exposure)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_sharpness(self.sharpness)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_hue(self.hue)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_whiteBalance(self.whiteBalance)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_autoWhiteBalance(self.autoWhiteBalance)
    if not is_valid:
      raise TypeError(error_str)

def parse_camera_settings(data: object):
  return CameraSettings(
    brightness=parse_i_16(data["brightness"]) if "brightness" in data and data.get("brightness") is not None else None,
    contrast=parse_i_16(data["contrast"]) if "contrast" in data and data.get("contrast") is not None else None,
    exposure=parse_i_16(data["exposure"]) if "exposure" in data and data.get("exposure") is not None else None,
    sharpness=parse_i_16(data["sharpness"]) if "sharpness" in data and data.get("sharpness") is not None else None,
    hue=parse_i_16(data["hue"]) if "hue" in data and data.get("hue") is not None else None,
    whiteBalance=parse_i_16(data["whiteBalance"]) if "whiteBalance" in data and data.get("whiteBalance") is not None else None,
    autoWhiteBalance=parse_bool(data["autoWhiteBalance"]) if "autoWhiteBalance" in data and data.get("autoWhiteBalance") is not None else None,
  )

def serialize_camera_settings(data: CameraSettings) -> object:
  return {
    "brightness": None if data.brightness is None else serialize_i_16(data.brightness),
    "contrast": None if data.contrast is None else serialize_i_16(data.contrast),
    "exposure": None if data.exposure is None else serialize_i_16(data.exposure),
    "sharpness": None if data.sharpness is None else serialize_i_16(data.sharpness),
    "hue": None if data.hue is None else serialize_i_16(data.hue),
    "whiteBalance": None if data.whiteBalance is None else serialize_i_16(data.whiteBalance),
    "autoWhiteBalance": None if data.autoWhiteBalance is None else serialize_bool(data.autoWhiteBalance),
  }

@dataclass
class CartesianPose:
  """Cartesian pose
"""
  x: Union[float, None] = None
  y: Union[float, None] = None
  z: Union[float, None] = None
  i: Union[float, None] = None
  j: Union[float, None] = None
  k: Union[float, None] = None
  w: Union[float, None] = None

  def validate_x(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "x is required for CartesianPose"]

    if not isinstance(value, float):
      return [False, "x must be of type float for CartesianPose, got " + type(value).__name__]

    return [True, ""]

  def validate_y(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "y is required for CartesianPose"]

    if not isinstance(value, float):
      return [False, "y must be of type float for CartesianPose, got " + type(value).__name__]

    return [True, ""]

  def validate_z(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "z is required for CartesianPose"]

    if not isinstance(value, float):
      return [False, "z must be of type float for CartesianPose, got " + type(value).__name__]

    return [True, ""]

  def validate_i(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "i is required for CartesianPose"]

    if not isinstance(value, float):
      return [False, "i must be of type float for CartesianPose, got " + type(value).__name__]

    return [True, ""]

  def validate_j(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "j is required for CartesianPose"]

    if not isinstance(value, float):
      return [False, "j must be of type float for CartesianPose, got " + type(value).__name__]

    return [True, ""]

  def validate_k(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "k is required for CartesianPose"]

    if not isinstance(value, float):
      return [False, "k must be of type float for CartesianPose, got " + type(value).__name__]

    return [True, ""]

  def validate_w(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "w is required for CartesianPose"]

    if not isinstance(value, float):
      return [False, "w must be of type float for CartesianPose, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_x(self.x)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_y(self.y)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_z(self.z)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_i(self.i)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_j(self.j)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_k(self.k)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_w(self.w)
    if not is_valid:
      raise TypeError(error_str)

def parse_cartesian_pose(data: object):
  return CartesianPose(
    x=parse_f_64(data["x"]) if "x" in data and data.get("x") is not None else None,
    y=parse_f_64(data["y"]) if "y" in data and data.get("y") is not None else None,
    z=parse_f_64(data["z"]) if "z" in data and data.get("z") is not None else None,
    i=parse_f_64(data["i"]) if "i" in data and data.get("i") is not None else None,
    j=parse_f_64(data["j"]) if "j" in data and data.get("j") is not None else None,
    k=parse_f_64(data["k"]) if "k" in data and data.get("k") is not None else None,
    w=parse_f_64(data["w"]) if "w" in data and data.get("w") is not None else None,
  )

def serialize_cartesian_pose(data: CartesianPose) -> object:
  return {
    "x": serialize_f_64(data.x),
    "y": serialize_f_64(data.y),
    "z": serialize_f_64(data.z),
    "i": serialize_f_64(data.i),
    "j": serialize_f_64(data.j),
    "k": serialize_f_64(data.k),
    "w": serialize_f_64(data.w),
  }

class ConnectionStatus(Enum):
  Connected = "connected"
  """Enum Connected = `connected`"""
  Disconnected = "disconnected"
  """Enum Disconnected = `disconnected`"""
  Ready = "ready"
  """Enum Ready = `ready`"""

def parse_connection_status(data: object) -> ConnectionStatus:
  return ConnectionStatus(data)

def serialize_connection_status(data: Union[ConnectionStatus, str]) -> object:
  return ConnectionStatus(data).value

@dataclass
class DHAGGripperCommandRequest:
  """Control the DH AG gripper (end effector) of the robot
"""
  target_diameter: Union[float, None] = None
  target_force: Union[float, None] = None
  target_speed: Union[float, None] = None

  def validate_target_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "target_diameter is required for DHAGGripperCommandRequest"]

    if not isinstance(value, float):
      return [False, "target_diameter must be of type float for DHAGGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_force must be of type float for DHAGGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_speed(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_speed must be of type float for DHAGGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_target_diameter(self.target_diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_speed(self.target_speed)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhag_gripper_command_request(data: object):
  return DHAGGripperCommandRequest(
    target_diameter=parse_f_64(data["target_diameter"]) if "target_diameter" in data and data.get("target_diameter") is not None else None,
    target_force=parse_f_64(data["target_force"]) if "target_force" in data and data.get("target_force") is not None else None,
    target_speed=parse_f_64(data["target_speed"]) if "target_speed" in data and data.get("target_speed") is not None else None,
  )

def serialize_dhag_gripper_command_request(data: DHAGGripperCommandRequest) -> object:
  return {
    "target_diameter": serialize_f_64(data.target_diameter),
    "target_force": None if data.target_force is None else serialize_f_64(data.target_force),
    "target_speed": None if data.target_speed is None else serialize_f_64(data.target_speed),
  }

@dataclass
class DHAGGripperConfiguration:
  """Configuration for DH AG Gripper"""
  diameter: Union[float, None] = None

  def validate_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "diameter is required for DHAGGripperConfiguration"]

    if not isinstance(value, float):
      return [False, "diameter must be of type float for DHAGGripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_diameter(self.diameter)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhag_gripper_configuration(data: object):
  return DHAGGripperConfiguration(
    diameter=parse_f_64(data["diameter"]) if "diameter" in data and data.get("diameter") is not None else None,
  )

def serialize_dhag_gripper_configuration(data: DHAGGripperConfiguration) -> object:
  return {
    "diameter": serialize_f_64(data.diameter),
  }

@dataclass
class DHCGIGripperCommandRequest:
  """Control the DH CGI gripper (end effector) of the robot
"""
  target_diameter: Union[float, None] = None
  target_force: Union[float, None] = None
  target_speed: Union[float, None] = None

  def validate_target_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "target_diameter is required for DHCGIGripperCommandRequest"]

    if not isinstance(value, float):
      return [False, "target_diameter must be of type float for DHCGIGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_force must be of type float for DHCGIGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_speed(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_speed must be of type float for DHCGIGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_target_diameter(self.target_diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_speed(self.target_speed)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhcgi_gripper_command_request(data: object):
  return DHCGIGripperCommandRequest(
    target_diameter=parse_f_64(data["target_diameter"]) if "target_diameter" in data and data.get("target_diameter") is not None else None,
    target_force=parse_f_64(data["target_force"]) if "target_force" in data and data.get("target_force") is not None else None,
    target_speed=parse_f_64(data["target_speed"]) if "target_speed" in data and data.get("target_speed") is not None else None,
  )

def serialize_dhcgi_gripper_command_request(data: DHCGIGripperCommandRequest) -> object:
  return {
    "target_diameter": serialize_f_64(data.target_diameter),
    "target_force": None if data.target_force is None else serialize_f_64(data.target_force),
    "target_speed": None if data.target_speed is None else serialize_f_64(data.target_speed),
  }

@dataclass
class DHCGIGripperConfiguration:
  """Configuration for DH CGI Gripper"""
  diameter: Union[float, None] = None

  def validate_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "diameter is required for DHCGIGripperConfiguration"]

    if not isinstance(value, float):
      return [False, "diameter must be of type float for DHCGIGripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_diameter(self.diameter)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhcgi_gripper_configuration(data: object):
  return DHCGIGripperConfiguration(
    diameter=parse_f_64(data["diameter"]) if "diameter" in data and data.get("diameter") is not None else None,
  )

def serialize_dhcgi_gripper_configuration(data: DHCGIGripperConfiguration) -> object:
  return {
    "diameter": serialize_f_64(data.diameter),
  }

@dataclass
class DHPGCGripperCommandRequest:
  """Control the DH PGC gripper (end effector) of the robot
"""
  target_diameter: Union[float, None] = None
  target_force: Union[float, None] = None
  target_speed: Union[float, None] = None

  def validate_target_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "target_diameter is required for DHPGCGripperCommandRequest"]

    if not isinstance(value, float):
      return [False, "target_diameter must be of type float for DHPGCGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_force must be of type float for DHPGCGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_speed(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_speed must be of type float for DHPGCGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_target_diameter(self.target_diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_speed(self.target_speed)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhpgc_gripper_command_request(data: object):
  return DHPGCGripperCommandRequest(
    target_diameter=parse_f_64(data["target_diameter"]) if "target_diameter" in data and data.get("target_diameter") is not None else None,
    target_force=parse_f_64(data["target_force"]) if "target_force" in data and data.get("target_force") is not None else None,
    target_speed=parse_f_64(data["target_speed"]) if "target_speed" in data and data.get("target_speed") is not None else None,
  )

def serialize_dhpgc_gripper_command_request(data: DHPGCGripperCommandRequest) -> object:
  return {
    "target_diameter": serialize_f_64(data.target_diameter),
    "target_force": None if data.target_force is None else serialize_f_64(data.target_force),
    "target_speed": None if data.target_speed is None else serialize_f_64(data.target_speed),
  }

@dataclass
class DHPGCGripperConfiguration:
  """Configuration for DH PGC Gripper"""
  diameter: Union[float, None] = None

  def validate_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "diameter is required for DHPGCGripperConfiguration"]

    if not isinstance(value, float):
      return [False, "diameter must be of type float for DHPGCGripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_diameter(self.diameter)
    if not is_valid:
      raise TypeError(error_str)

def parse_dhpgc_gripper_configuration(data: object):
  return DHPGCGripperConfiguration(
    diameter=parse_f_64(data["diameter"]) if "diameter" in data and data.get("diameter") is not None else None,
  )

def serialize_dhpgc_gripper_configuration(data: DHPGCGripperConfiguration) -> object:
  return {
    "diameter": serialize_f_64(data.diameter),
  }

@dataclass
class EngageEmergencyStopRequest:
  """Engage Emergency Stop. This will immediately stop the robot and prevent it from moving until the robot is unbraked.
"""
  reason: Union[str, None] = None

  def validate_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "reason must be of type str for EngageEmergencyStopRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_reason(self.reason)
    if not is_valid:
      raise TypeError(error_str)

def parse_engage_emergency_stop_request(data: object):
  return EngageEmergencyStopRequest(
    reason=parse_str(data["reason"]) if "reason" in data and data.get("reason") is not None else None,
  )

def serialize_engage_emergency_stop_request(data: EngageEmergencyStopRequest) -> object:
  return {
    "reason": None if data.reason is None else serialize_str(data.reason),
  }

@dataclass
class EnvironmentVariable:
  """Environment variables for a routine"""
  id: Union[str, None] = None
  name: Union[str, None] = None
  value: Union[str, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [False, "id is required for EnvironmentVariable"]

    if not isinstance(value, str):
      return [False, "id must be of type str for EnvironmentVariable, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for EnvironmentVariable, got " + type(value).__name__]

    return [True, ""]

  def validate_value(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "value must be of type str for EnvironmentVariable, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_value(self.value)
    if not is_valid:
      raise TypeError(error_str)

def parse_environment_variable(data: object):
  return EnvironmentVariable(
    id=parse_str(data["id"]) if "id" in data and data.get("id") is not None else None,
    name=parse_str(data["name"]) if "name" in data and data.get("name") is not None else None,
    value=parse_str(data["value"]) if "value" in data and data.get("value") is not None else None,
  )

def serialize_environment_variable(data: EnvironmentVariable) -> object:
  return {
    "id": serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
    "value": None if data.value is None else serialize_str(data.value),
  }

class ErrorEnum(Enum):
  AuthorizationRequired = "authorization_required"
  """Authorization required to access this resource"""
  RoutineMustBeRunning = "routine_must_be_running"
  """Routine must be running"""
  ApiControlRequired = "api_control_required"
  """API control required"""
  RobotBrakesDisengageFailed = "robot_brakes_disengage_failed"
  """Robot brakes disengage failed"""
  RobotBrakesEngageFailed = "robot_brakes_engage_failed"
  """Robot brakes engage failed"""
  RequestFailedValidation = "request_failed_validation"
  """Request failed validation"""
  RobotNotIdle = "robot_not_idle"
  """Robot must be idle"""
  BrakesMustBeEngaged = "brakes_must_be_engaged"
  """Brakes must be_engaged"""
  BrakesMustBeDisengaged = "brakes_must_be_disengaged"
  """Brakes must be disengaged"""
  EquipmentNoMatching = "equipment_no_matching"
  """No matching equipment found"""
  ServiceInitializing = "service_initializing"
  """The service is unavailable while initializing"""
  CameraDisconnected = "camera_disconnected"
  """Camera service running, but no camera is connected"""
  SettingsValidationError = "settings_validation_error"
  """Camera settings validation failed"""
  SettingsTimeout = "settings_timeout"
  """Camera settings timed out"""
  InternalServerError = "internal_server_error"
  """Internal server error occurred"""
  RecoveryError = "recovery_error"
  """Recovery error occurred"""
  NotFound = "not_found"
  """Requested resource not found"""
  InvalidSpaceSpecified = "invalid_space_specified"
  """Space specified was invalid or not found"""

def parse_error_enum(data: object) -> ErrorEnum:
  return ErrorEnum(data)

def serialize_error_enum(data: Union[ErrorEnum, str]) -> object:
  return ErrorEnum(data).value

@dataclass
class EulerPose:
  """Euler pose
"""
  x: Union[float, None] = None
  y: Union[float, None] = None
  z: Union[float, None] = None
  rx: Union[float, None] = None
  ry: Union[float, None] = None
  rz: Union[float, None] = None

  def validate_x(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "x must be of type float for EulerPose, got " + type(value).__name__]

    return [True, ""]

  def validate_y(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "y must be of type float for EulerPose, got " + type(value).__name__]

    return [True, ""]

  def validate_z(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "z must be of type float for EulerPose, got " + type(value).__name__]

    return [True, ""]

  def validate_rx(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "rx must be of type float for EulerPose, got " + type(value).__name__]

    return [True, ""]

  def validate_ry(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "ry must be of type float for EulerPose, got " + type(value).__name__]

    return [True, ""]

  def validate_rz(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "rz must be of type float for EulerPose, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_x(self.x)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_y(self.y)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_z(self.z)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_rx(self.rx)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_ry(self.ry)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_rz(self.rz)
    if not is_valid:
      raise TypeError(error_str)

def parse_euler_pose(data: object):
  return EulerPose(
    x=parse_f_64(data["x"]) if "x" in data and data.get("x") is not None else None,
    y=parse_f_64(data["y"]) if "y" in data and data.get("y") is not None else None,
    z=parse_f_64(data["z"]) if "z" in data and data.get("z") is not None else None,
    rx=parse_f_64(data["rx"]) if "rx" in data and data.get("rx") is not None else None,
    ry=parse_f_64(data["ry"]) if "ry" in data and data.get("ry") is not None else None,
    rz=parse_f_64(data["rz"]) if "rz" in data and data.get("rz") is not None else None,
  )

def serialize_euler_pose(data: EulerPose) -> object:
  return {
    "x": None if data.x is None else serialize_f_64(data.x),
    "y": None if data.y is None else serialize_f_64(data.y),
    "z": None if data.z is None else serialize_f_64(data.z),
    "rx": None if data.rx is None else serialize_f_64(data.rx),
    "ry": None if data.ry is None else serialize_f_64(data.ry),
    "rz": None if data.rz is None else serialize_f_64(data.rz),
  }

class ForceUnitKind(Enum):
  Newtons = "newtons"
  """Enum Newtons = `newtons`"""
  Pounds = "pounds"
  """Enum Pounds = `pounds`"""

def parse_force_unit_kind(data: object) -> ForceUnitKind:
  return ForceUnitKind(data)

def serialize_force_unit_kind(data: Union[ForceUnitKind, str]) -> object:
  return ForceUnitKind(data).value

class GripperKindEnum(Enum):
  Onrobot2Fg7 = "onrobot_2fg7"
  """An OnRobot 2FG7 Gripper is connected"""
  Onrobot2Fg14 = "onrobot_2fg14"
  """An OnRobot 2FG14 Gripper is connected"""
  Onrobot3Fg15 = "onrobot_3fg15"
  """An OnRobot 3FG15 Gripper is connected"""
  OnrobotScrewdriver = "onrobot_screwdriver"
  """An OnRobot Screwdriver is connected"""
  DhAg = "dh_ag"
  """A DH AG Gripper is connected"""
  DhPgc = "dh_pgc"
  """A DH PGC Gripper is connected"""
  DhCgi = "dh_cgi"
  """A DH CGI Gripper is connected"""
  SchunkEgx = "schunk_egx"
  """A Schunk EGU / EGK Gripper is connected"""
  NoneConnected = "none_connected"
  """No gripper is connected"""

def parse_gripper_kind_enum(data: object) -> GripperKindEnum:
  return GripperKindEnum(data)

def serialize_gripper_kind_enum(data: Union[GripperKindEnum, str]) -> object:
  return GripperKindEnum(data).value

IOStateMap = Dict[str, str]

def parse_io_state_map(data: object) -> IOStateMap:
  return {
    parse_str(key): parse_str(value) for key, value in data.items()
  }

def serialize_io_state_map(data: IOStateMap) -> object:
  return {
    serialize_str(key): serialize_str(value) for key, value in data.items()
  }

@dataclass
class JointAngles:
  """Joint angles
"""
  j0: Union[float, None] = None
  j1: Union[float, None] = None
  j2: Union[float, None] = None
  j3: Union[float, None] = None
  j4: Union[float, None] = None
  j5: Union[float, None] = None

  def validate_j0(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "j0 must be of type float for JointAngles, got " + type(value).__name__]

    return [True, ""]

  def validate_j1(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "j1 must be of type float for JointAngles, got " + type(value).__name__]

    return [True, ""]

  def validate_j2(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "j2 must be of type float for JointAngles, got " + type(value).__name__]

    return [True, ""]

  def validate_j3(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "j3 must be of type float for JointAngles, got " + type(value).__name__]

    return [True, ""]

  def validate_j4(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "j4 must be of type float for JointAngles, got " + type(value).__name__]

    return [True, ""]

  def validate_j5(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "j5 must be of type float for JointAngles, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_j0(self.j0)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_j1(self.j1)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_j2(self.j2)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_j3(self.j3)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_j4(self.j4)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_j5(self.j5)
    if not is_valid:
      raise TypeError(error_str)

def parse_joint_angles(data: object):
  return JointAngles(
    j0=parse_f_64(data["j0"]) if "j0" in data and data.get("j0") is not None else None,
    j1=parse_f_64(data["j1"]) if "j1" in data and data.get("j1") is not None else None,
    j2=parse_f_64(data["j2"]) if "j2" in data and data.get("j2") is not None else None,
    j3=parse_f_64(data["j3"]) if "j3" in data and data.get("j3") is not None else None,
    j4=parse_f_64(data["j4"]) if "j4" in data and data.get("j4") is not None else None,
    j5=parse_f_64(data["j5"]) if "j5" in data and data.get("j5") is not None else None,
  )

def serialize_joint_angles(data: JointAngles) -> object:
  return {
    "j0": None if data.j0 is None else serialize_f_64(data.j0),
    "j1": None if data.j1 is None else serialize_f_64(data.j1),
    "j2": None if data.j2 is None else serialize_f_64(data.j2),
    "j3": None if data.j3 is None else serialize_f_64(data.j3),
    "j4": None if data.j4 is None else serialize_f_64(data.j4),
    "j5": None if data.j5 is None else serialize_f_64(data.j5),
  }

JointAnglesArray = List[float]

def parse_joint_angles_array(data: object) -> JointAnglesArray:
  return [parse_f_64(item) for item in data]

def serialize_joint_angles_array(data: JointAnglesArray) -> List[object]:
  return [serialize_f_64(item) for item in data]

JointRotations = Tuple[float,float,float,float,float,float,]

def parse_joint_rotations(data: object) -> JointRotations:
  return (parse_f_64(data[0]),parse_f_64(data[1]),parse_f_64(data[2]),parse_f_64(data[3]),parse_f_64(data[4]),parse_f_64(data[5]),)

def serialize_joint_rotations(data: JointRotations) -> object:
  return [serialize_f_64(data[0]),serialize_f_64(data[1]),serialize_f_64(data[2]),serialize_f_64(data[3]),serialize_f_64(data[4]),serialize_f_64(data[5]),]

class LinearGripDirectionEnum(Enum):
  Inward = "inward"
  """Move gripper inward to grip. Measure grip position based on interior of gripper fingers and exterior of object"""
  Outward = "outward"
  """Grip gripper outward to grip. Measure grip position based on exterior of gripper fingers and interior of object"""

def parse_linear_grip_direction_enum(data: object) -> LinearGripDirectionEnum:
  return LinearGripDirectionEnum(data)

def serialize_linear_grip_direction_enum(data: Union[LinearGripDirectionEnum, str]) -> object:
  return LinearGripDirectionEnum(data).value

class LinearUnitKind(Enum):
  Millimeters = "millimeters"
  """Enum Millimeters = `millimeters`"""
  Centimeters = "centimeters"
  """Enum Centimeters = `centimeters`"""
  Meters = "meters"
  """Enum Meters = `meters`"""
  Inches = "inches"
  """Enum Inches = `inches`"""
  Feet = "feet"
  """Enum Feet = `feet`"""

def parse_linear_unit_kind(data: object) -> LinearUnitKind:
  return LinearUnitKind(data)

def serialize_linear_unit_kind(data: Union[LinearUnitKind, str]) -> object:
  return LinearUnitKind(data).value

MaxJointAcclerations = Tuple[float,float,float,float,float,float,]

def parse_max_joint_acclerations(data: object) -> MaxJointAcclerations:
  return (parse_f_64(data[0]),parse_f_64(data[1]),parse_f_64(data[2]),parse_f_64(data[3]),parse_f_64(data[4]),parse_f_64(data[5]),)

def serialize_max_joint_acclerations(data: MaxJointAcclerations) -> object:
  return [serialize_f_64(data[0]),serialize_f_64(data[1]),serialize_f_64(data[2]),serialize_f_64(data[3]),serialize_f_64(data[4]),serialize_f_64(data[5]),]

MaxJointSpeeds = Tuple[float,float,float,float,float,float,]

def parse_max_joint_speeds(data: object) -> MaxJointSpeeds:
  return (parse_f_64(data[0]),parse_f_64(data[1]),parse_f_64(data[2]),parse_f_64(data[3]),parse_f_64(data[4]),parse_f_64(data[5]),)

def serialize_max_joint_speeds(data: MaxJointSpeeds) -> object:
  return [serialize_f_64(data[0]),serialize_f_64(data[1]),serialize_f_64(data[2]),serialize_f_64(data[3]),serialize_f_64(data[4]),serialize_f_64(data[5]),]

class MovementKindEnum(Enum):
  Joint = "joint"
  """Enum Joint = `joint`"""
  Line = "line"
  """Enum Line = `line`"""

def parse_movement_kind_enum(data: object) -> MovementKindEnum:
  return MovementKindEnum(data)

def serialize_movement_kind_enum(data: Union[MovementKindEnum, str]) -> object:
  return MovementKindEnum(data).value

class OnRobot2FG14ControlKindEnum(Enum):
  Move = "move"
  """Move gripper to target grip width"""
  ForceGrip = "force_grip"
  """Grip with target force"""

def parse_on_robot_2_fg_14_control_kind_enum(data: object) -> OnRobot2FG14ControlKindEnum:
  return OnRobot2FG14ControlKindEnum(data)

def serialize_on_robot_2_fg_14_control_kind_enum(data: Union[OnRobot2FG14ControlKindEnum, str]) -> object:
  return OnRobot2FG14ControlKindEnum(data).value

class OnRobot2FG7ControlKindEnum(Enum):
  Move = "move"
  """Move gripper to target grip width"""
  ForceGrip = "force_grip"
  """Grip with target force"""

def parse_on_robot_2_fg_7_control_kind_enum(data: object) -> OnRobot2FG7ControlKindEnum:
  return OnRobot2FG7ControlKindEnum(data)

def serialize_on_robot_2_fg_7_control_kind_enum(data: Union[OnRobot2FG7ControlKindEnum, str]) -> object:
  return OnRobot2FG7ControlKindEnum(data).value

class OnRobot3FG15ControlKindEnum(Enum):
  Move = "move"
  """Move gripper to target grip diameter"""
  ForceGrip = "force_grip"
  """Grip with target force"""
  FlexibleForceGrip = "flexible_force_grip"
  """Grip with target force"""

def parse_on_robot_3_fg_15_control_kind_enum(data: object) -> OnRobot3FG15ControlKindEnum:
  return OnRobot3FG15ControlKindEnum(data)

def serialize_on_robot_3_fg_15_control_kind_enum(data: Union[OnRobot3FG15ControlKindEnum, str]) -> object:
  return OnRobot3FG15ControlKindEnum(data).value

class OnRobotGripKindEnum(Enum):
  Inward = "inward"
  """Enum Inward = `inward`"""
  Outward = "outward"
  """Enum Outward = `outward`"""

def parse_on_robot_grip_kind_enum(data: object) -> OnRobotGripKindEnum:
  return OnRobotGripKindEnum(data)

def serialize_on_robot_grip_kind_enum(data: Union[OnRobotGripKindEnum, str]) -> object:
  return OnRobotGripKindEnum(data).value

@dataclass
class OnRobotScrewdriverConfiguration:
  """Configuration for OnRobot Screwdriver"""
  status: Union[int, None] = None
  error: Union[str, None] = None
  busy: Union[bool, None] = None
  additional_results: Union[int, None] = None
  current_torque: Union[float, None] = None
  shank_position: Union[float, None] = None
  torque_angle_gradient: Union[float, None] = None
  achieved_torque: Union[float, None] = None
  target_force: Union[float, None] = None
  target_torque: Union[float, None] = None
  quick_changer_version: Union[int, None] = None
  uncalibrated_error: Union[bool, None] = None

  def validate_status(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "status must be of type int for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_error(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "error must be of type str for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_busy(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "busy must be of type bool for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_additional_results(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "additional_results must be of type int for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_current_torque(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "current_torque must be of type float for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_shank_position(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "shank_position must be of type float for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_torque_angle_gradient(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "torque_angle_gradient must be of type float for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_achieved_torque(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "achieved_torque must be of type float for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_force must be of type float for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_target_torque(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_torque must be of type float for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_quick_changer_version(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "quick_changer_version must be of type int for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_uncalibrated_error(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "uncalibrated_error must be of type bool for OnRobotScrewdriverConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_status(self.status)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_error(self.error)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_busy(self.busy)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_additional_results(self.additional_results)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_current_torque(self.current_torque)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_shank_position(self.shank_position)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_torque_angle_gradient(self.torque_angle_gradient)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_achieved_torque(self.achieved_torque)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_torque(self.target_torque)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_quick_changer_version(self.quick_changer_version)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_uncalibrated_error(self.uncalibrated_error)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_screwdriver_configuration(data: object):
  return OnRobotScrewdriverConfiguration(
    status=parse_i_32(data["status"]) if "status" in data and data.get("status") is not None else None,
    error=parse_str(data["error"]) if "error" in data and data.get("error") is not None else None,
    busy=parse_bool(data["busy"]) if "busy" in data and data.get("busy") is not None else None,
    additional_results=parse_i_32(data["additional_results"]) if "additional_results" in data and data.get("additional_results") is not None else None,
    current_torque=parse_f_64(data["current_torque"]) if "current_torque" in data and data.get("current_torque") is not None else None,
    shank_position=parse_f_64(data["shank_position"]) if "shank_position" in data and data.get("shank_position") is not None else None,
    torque_angle_gradient=parse_f_64(data["torque_angle_gradient"]) if "torque_angle_gradient" in data and data.get("torque_angle_gradient") is not None else None,
    achieved_torque=parse_f_64(data["achieved_torque"]) if "achieved_torque" in data and data.get("achieved_torque") is not None else None,
    target_force=parse_f_64(data["target_force"]) if "target_force" in data and data.get("target_force") is not None else None,
    target_torque=parse_f_64(data["target_torque"]) if "target_torque" in data and data.get("target_torque") is not None else None,
    quick_changer_version=parse_i_32(data["quick_changer_version"]) if "quick_changer_version" in data and data.get("quick_changer_version") is not None else None,
    uncalibrated_error=parse_bool(data["uncalibrated_error"]) if "uncalibrated_error" in data and data.get("uncalibrated_error") is not None else None,
  )

def serialize_on_robot_screwdriver_configuration(data: OnRobotScrewdriverConfiguration) -> object:
  return {
    "status": None if data.status is None else serialize_i_32(data.status),
    "error": None if data.error is None else serialize_str(data.error),
    "busy": None if data.busy is None else serialize_bool(data.busy),
    "additional_results": None if data.additional_results is None else serialize_i_32(data.additional_results),
    "current_torque": None if data.current_torque is None else serialize_f_64(data.current_torque),
    "shank_position": None if data.shank_position is None else serialize_f_64(data.shank_position),
    "torque_angle_gradient": None if data.torque_angle_gradient is None else serialize_f_64(data.torque_angle_gradient),
    "achieved_torque": None if data.achieved_torque is None else serialize_f_64(data.achieved_torque),
    "target_force": None if data.target_force is None else serialize_f_64(data.target_force),
    "target_torque": None if data.target_torque is None else serialize_f_64(data.target_torque),
    "quick_changer_version": None if data.quick_changer_version is None else serialize_i_32(data.quick_changer_version),
    "uncalibrated_error": None if data.uncalibrated_error is None else serialize_bool(data.uncalibrated_error),
  }

class OrientationKindEnum(Enum):
  Quaternion = "quaternion"
  """Enum Quaternion = `quaternion`"""

def parse_orientation_kind_enum(data: object) -> OrientationKindEnum:
  return OrientationKindEnum(data)

def serialize_orientation_kind_enum(data: Union[OrientationKindEnum, str]) -> object:
  return OrientationKindEnum(data).value

@dataclass
class Pagination:
  """Common Pagination Metadata"""
  total: Union[int, None] = None
  limit: Union[int, None] = None
  offset: Union[int, None] = None

  def validate_total(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "total must be of type int for Pagination, got " + type(value).__name__]

    return [True, ""]

  def validate_limit(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "limit must be of type int for Pagination, got " + type(value).__name__]

    return [True, ""]

  def validate_offset(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "offset must be of type int for Pagination, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_total(self.total)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_limit(self.limit)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_offset(self.offset)
    if not is_valid:
      raise TypeError(error_str)

def parse_pagination(data: object):
  return Pagination(
    total=parse_i_64(data["total"]) if "total" in data and data.get("total") is not None else None,
    limit=parse_i_64(data["limit"]) if "limit" in data and data.get("limit") is not None else None,
    offset=parse_i_64(data["offset"]) if "offset" in data and data.get("offset") is not None else None,
  )

def serialize_pagination(data: Pagination) -> object:
  return {
    "total": None if data.total is None else serialize_i_64(data.total),
    "limit": None if data.limit is None else serialize_i_64(data.limit),
    "offset": None if data.offset is None else serialize_i_64(data.offset),
  }

@dataclass
class Plane:
  """Plane in 3D space"""
  id: Union[str, None] = None
  name: Union[str, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "id must be of type str for Plane, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for Plane, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)

def parse_plane(data: object):
  return Plane(
    id=parse_str(data["id"]) if "id" in data and data.get("id") is not None else None,
    name=parse_str(data["name"]) if "name" in data and data.get("name") is not None else None,
  )

def serialize_plane(data: Plane) -> object:
  return {
    "id": None if data.id is None else serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
  }

@dataclass
class PoseDistanceResponse:
  """Response: Distance between two cartesian poses
"""
  distance: Union[float, None] = None

  def validate_distance(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "distance must be of type float for PoseDistanceResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_distance(self.distance)
    if not is_valid:
      raise TypeError(error_str)

def parse_pose_distance_response(data: object):
  return PoseDistanceResponse(
    distance=parse_f_64(data["distance"]) if "distance" in data and data.get("distance") is not None else None,
  )

def serialize_pose_distance_response(data: PoseDistanceResponse) -> object:
  return {
    "distance": None if data.distance is None else serialize_f_64(data.distance),
  }

@dataclass
class PositionPose:
  """The full 3D position with rotation"""
  x: Union[float, None] = None
  y: Union[float, None] = None
  z: Union[float, None] = None
  w: Union[float, None] = None
  i: Union[float, None] = None
  j: Union[float, None] = None
  k: Union[float, None] = None

  def validate_x(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "x must be of type float for PositionPose, got " + type(value).__name__]

    return [True, ""]

  def validate_y(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "y must be of type float for PositionPose, got " + type(value).__name__]

    return [True, ""]

  def validate_z(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "z must be of type float for PositionPose, got " + type(value).__name__]

    return [True, ""]

  def validate_w(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "w must be of type float for PositionPose, got " + type(value).__name__]

    return [True, ""]

  def validate_i(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "i must be of type float for PositionPose, got " + type(value).__name__]

    return [True, ""]

  def validate_j(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "j must be of type float for PositionPose, got " + type(value).__name__]

    return [True, ""]

  def validate_k(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "k must be of type float for PositionPose, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_x(self.x)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_y(self.y)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_z(self.z)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_w(self.w)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_i(self.i)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_j(self.j)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_k(self.k)
    if not is_valid:
      raise TypeError(error_str)

def parse_position_pose(data: object):
  return PositionPose(
    x=parse_f_64(data["x"]) if "x" in data and data.get("x") is not None else None,
    y=parse_f_64(data["y"]) if "y" in data and data.get("y") is not None else None,
    z=parse_f_64(data["z"]) if "z" in data and data.get("z") is not None else None,
    w=parse_f_64(data["w"]) if "w" in data and data.get("w") is not None else None,
    i=parse_f_64(data["i"]) if "i" in data and data.get("i") is not None else None,
    j=parse_f_64(data["j"]) if "j" in data and data.get("j") is not None else None,
    k=parse_f_64(data["k"]) if "k" in data and data.get("k") is not None else None,
  )

def serialize_position_pose(data: PositionPose) -> object:
  return {
    "x": None if data.x is None else serialize_f_64(data.x),
    "y": None if data.y is None else serialize_f_64(data.y),
    "z": None if data.z is None else serialize_f_64(data.z),
    "w": None if data.w is None else serialize_f_64(data.w),
    "i": None if data.i is None else serialize_f_64(data.i),
    "j": None if data.j is None else serialize_f_64(data.j),
    "k": None if data.k is None else serialize_f_64(data.k),
  }

@dataclass
class Quaternion:
  """Quaternion orientation"""
  x: Union[float, None] = None
  y: Union[float, None] = None
  z: Union[float, None] = None
  w: Union[float, None] = None

  def validate_x(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "x must be of type float for Quaternion, got " + type(value).__name__]

    return [True, ""]

  def validate_y(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "y must be of type float for Quaternion, got " + type(value).__name__]

    return [True, ""]

  def validate_z(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "z must be of type float for Quaternion, got " + type(value).__name__]

    return [True, ""]

  def validate_w(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "w must be of type float for Quaternion, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_x(self.x)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_y(self.y)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_z(self.z)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_w(self.w)
    if not is_valid:
      raise TypeError(error_str)

def parse_quaternion(data: object):
  return Quaternion(
    x=parse_f_64(data["x"]) if "x" in data and data.get("x") is not None else None,
    y=parse_f_64(data["y"]) if "y" in data and data.get("y") is not None else None,
    z=parse_f_64(data["z"]) if "z" in data and data.get("z") is not None else None,
    w=parse_f_64(data["w"]) if "w" in data and data.get("w") is not None else None,
  )

def serialize_quaternion(data: Quaternion) -> object:
  return {
    "x": None if data.x is None else serialize_f_64(data.x),
    "y": None if data.y is None else serialize_f_64(data.y),
    "z": None if data.z is None else serialize_f_64(data.z),
    "w": None if data.w is None else serialize_f_64(data.w),
  }

class RecoveryTypeEnum(Enum):
  Recoverable = "Recoverable"
  """Enum Recoverable = `Recoverable`"""
  NotRecoverable = "NotRecoverable"
  """Enum NotRecoverable = `NotRecoverable`"""
  Restart = "Restart"
  """Enum Restart = `Restart`"""
  GuidedMode = "GuidedMode"
  """Enum GuidedMode = `GuidedMode`"""
  ManualRecoveryMode = "ManualRecoveryMode"
  """Enum ManualRecoveryMode = `ManualRecoveryMode`"""

def parse_recovery_type_enum(data: object) -> RecoveryTypeEnum:
  return RecoveryTypeEnum(data)

def serialize_recovery_type_enum(data: Union[RecoveryTypeEnum, str]) -> object:
  return RecoveryTypeEnum(data).value

class RobotControlModeEnum(Enum):
  Api = "api"
  """The robot is controlled via the Standard Bots Robot API (this API)"""
  RoutineEditor = "routine_editor"
  """The robot is controlled via the Routine Editor UI"""

def parse_robot_control_mode_enum(data: object) -> RobotControlModeEnum:
  return RobotControlModeEnum(data)

def serialize_robot_control_mode_enum(data: Union[RobotControlModeEnum, str]) -> object:
  return RobotControlModeEnum(data).value

class RobotStatusEnum(Enum):
  Idle = "Idle"
  """Enum Idle = `Idle`"""
  RunningAdHocCommand = "RunningAdHocCommand"
  """Enum RunningAdHocCommand = `RunningAdHocCommand`"""
  RoutineRunning = "RoutineRunning"
  """Enum RoutineRunning = `RoutineRunning`"""
  Antigravity = "Antigravity"
  """Enum Antigravity = `Antigravity`"""
  AntigravitySlow = "AntigravitySlow"
  """Enum AntigravitySlow = `AntigravitySlow`"""
  Failure = "Failure"
  """Enum Failure = `Failure`"""
  Recovering = "Recovering"
  """Enum Recovering = `Recovering`"""

def parse_robot_status_enum(data: object) -> RobotStatusEnum:
  return RobotStatusEnum(data)

def serialize_robot_status_enum(data: Union[RobotStatusEnum, str]) -> object:
  return RobotStatusEnum(data).value

class ROSControlStateEnum(Enum):
  Enabled = "enabled"
  """ROS control is enabled."""
  Disabled = "disabled"
  """ROS control is disabled."""

def parse_ros_control_state_enum(data: object) -> ROSControlStateEnum:
  return ROSControlStateEnum(data)

def serialize_ros_control_state_enum(data: Union[ROSControlStateEnum, str]) -> object:
  return ROSControlStateEnum(data).value

@dataclass
class RoutineStateResponse:
  """State of the routine."""
  is_paused: Union[bool, None] = None
  current_step_id: Union[str, None] = None
  start_time: Union[str, None] = None
  run_time_seconds: Union[float, None] = None
  cycle_count: Union[int, None] = None
  total_expected_cycles: Union[int, None] = None
  should_next_arm_move_be_guided_mode: Union[bool, None] = None
  is_preflight_test_run: Union[bool, None] = None

  def validate_is_paused(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [False, "is_paused is required for RoutineStateResponse"]

    if not isinstance(value, bool):
      return [False, "is_paused must be of type bool for RoutineStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_current_step_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [False, "current_step_id is required for RoutineStateResponse"]

    if not isinstance(value, str):
      return [False, "current_step_id must be of type str for RoutineStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_start_time(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [False, "start_time is required for RoutineStateResponse"]

    if not isinstance(value, str):
      return [False, "start_time must be of type str for RoutineStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_run_time_seconds(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [False, "run_time_seconds is required for RoutineStateResponse"]

    if not isinstance(value, float):
      return [False, "run_time_seconds must be of type float for RoutineStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_cycle_count(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "cycle_count must be of type int for RoutineStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_total_expected_cycles(self, value: int) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, int):
      return [False, "total_expected_cycles must be of type int for RoutineStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_should_next_arm_move_be_guided_mode(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "should_next_arm_move_be_guided_mode must be of type bool for RoutineStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_is_preflight_test_run(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [False, "is_preflight_test_run is required for RoutineStateResponse"]

    if not isinstance(value, bool):
      return [False, "is_preflight_test_run must be of type bool for RoutineStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_is_paused(self.is_paused)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_current_step_id(self.current_step_id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_start_time(self.start_time)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_run_time_seconds(self.run_time_seconds)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_cycle_count(self.cycle_count)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_total_expected_cycles(self.total_expected_cycles)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_should_next_arm_move_be_guided_mode(self.should_next_arm_move_be_guided_mode)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_is_preflight_test_run(self.is_preflight_test_run)
    if not is_valid:
      raise TypeError(error_str)

def parse_routine_state_response(data: object):
  return RoutineStateResponse(
    is_paused=parse_bool(data["is_paused"]) if "is_paused" in data and data.get("is_paused") is not None else None,
    current_step_id=parse_str(data["current_step_id"]) if "current_step_id" in data and data.get("current_step_id") is not None else None,
    start_time=parse_str(data["start_time"]) if "start_time" in data and data.get("start_time") is not None else None,
    run_time_seconds=parse_f_64(data["run_time_seconds"]) if "run_time_seconds" in data and data.get("run_time_seconds") is not None else None,
    cycle_count=parse_i_64(data["cycle_count"]) if "cycle_count" in data and data.get("cycle_count") is not None else None,
    total_expected_cycles=parse_i_64(data["total_expected_cycles"]) if "total_expected_cycles" in data and data.get("total_expected_cycles") is not None else None,
    should_next_arm_move_be_guided_mode=parse_bool(data["should_next_arm_move_be_guided_mode"]) if "should_next_arm_move_be_guided_mode" in data and data.get("should_next_arm_move_be_guided_mode") is not None else None,
    is_preflight_test_run=parse_bool(data["is_preflight_test_run"]) if "is_preflight_test_run" in data and data.get("is_preflight_test_run") is not None else None,
  )

def serialize_routine_state_response(data: RoutineStateResponse) -> object:
  return {
    "is_paused": serialize_bool(data.is_paused),
    "current_step_id": serialize_str(data.current_step_id),
    "start_time": serialize_str(data.start_time),
    "run_time_seconds": serialize_f_64(data.run_time_seconds),
    "cycle_count": None if data.cycle_count is None else serialize_i_64(data.cycle_count),
    "total_expected_cycles": None if data.total_expected_cycles is None else serialize_i_64(data.total_expected_cycles),
    "should_next_arm_move_be_guided_mode": None if data.should_next_arm_move_be_guided_mode is None else serialize_bool(data.should_next_arm_move_be_guided_mode),
    "is_preflight_test_run": serialize_bool(data.is_preflight_test_run),
  }

RoutineStepVariablesData = Dict[str, str]

def parse_routine_step_variables_data(data: object) -> RoutineStepVariablesData:
  return {
    parse_str(key): parse_str(value) for key, value in data.items()
  }

def serialize_routine_step_variables_data(data: RoutineStepVariablesData) -> object:
  return {
    serialize_str(key): serialize_str(value) for key, value in data.items()
  }

RoutineStepVariablesIdMap = Dict[str, str]

def parse_routine_step_variables_id_map(data: object) -> RoutineStepVariablesIdMap:
  return {
    parse_str(key): parse_str(value) for key, value in data.items()
  }

def serialize_routine_step_variables_id_map(data: RoutineStepVariablesIdMap) -> object:
  return {
    serialize_str(key): serialize_str(value) for key, value in data.items()
  }

RoutineVariablesStateMap = Dict[str, str]

def parse_routine_variables_state_map(data: object) -> RoutineVariablesStateMap:
  return {
    parse_str(key): parse_str(value) for key, value in data.items()
  }

def serialize_routine_variables_state_map(data: RoutineVariablesStateMap) -> object:
  return {
    serialize_str(key): serialize_str(value) for key, value in data.items()
  }

@dataclass
class RuntimeVariable:
  """Runtime Variable state"""
  value: Union[str, None] = None

  def validate_value(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "value must be of type str for RuntimeVariable, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_value(self.value)
    if not is_valid:
      raise TypeError(error_str)

def parse_runtime_variable(data: object):
  return RuntimeVariable(
    value=parse_str(data["value"]) if "value" in data and data.get("value") is not None else None,
  )

def serialize_runtime_variable(data: RuntimeVariable) -> object:
  return {
    "value": None if data.value is None else serialize_str(data.value),
  }

class SchunkEGxControlKindEnum(Enum):
  Move = "move"
  """Move gripper to target grip diameter"""

def parse_schunk_e_gx_control_kind_enum(data: object) -> SchunkEGxControlKindEnum:
  return SchunkEGxControlKindEnum(data)

def serialize_schunk_e_gx_control_kind_enum(data: Union[SchunkEGxControlKindEnum, str]) -> object:
  return SchunkEGxControlKindEnum(data).value

@dataclass
class Sensor:
  """Individual sensor information"""
  id: Union[str, None] = None
  name: Union[str, None] = None
  kind: Union[str, None] = None
  sensorValue: Union[str, None] = None
  equipmentId: Union[str, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "id must be of type str for Sensor, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for Sensor, got " + type(value).__name__]

    return [True, ""]

  def validate_kind(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "kind must be of type str for Sensor, got " + type(value).__name__]

    return [True, ""]

  def validate_sensorValue(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "sensorValue must be of type str for Sensor, got " + type(value).__name__]

    return [True, ""]

  def validate_equipmentId(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "equipmentId must be of type str for Sensor, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_sensorValue(self.sensorValue)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_equipmentId(self.equipmentId)
    if not is_valid:
      raise TypeError(error_str)

def parse_sensor(data: object):
  return Sensor(
    id=parse_str(data["id"]) if "id" in data and data.get("id") is not None else None,
    name=parse_str(data["name"]) if "name" in data and data.get("name") is not None else None,
    kind=parse_str(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    sensorValue=parse_str(data["sensorValue"]) if "sensorValue" in data and data.get("sensorValue") is not None else None,
    equipmentId=parse_str(data["equipmentId"]) if "equipmentId" in data and data.get("equipmentId") is not None else None,
  )

def serialize_sensor(data: Sensor) -> object:
  return {
    "id": None if data.id is None else serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
    "kind": None if data.kind is None else serialize_str(data.kind),
    "sensorValue": None if data.sensorValue is None else serialize_str(data.sensorValue),
    "equipmentId": None if data.equipmentId is None else serialize_str(data.equipmentId),
  }

SkillsList = List[str]

def parse_skills_list(data: object) -> SkillsList:
  return [parse_str(item) for item in data]

def serialize_skills_list(data: SkillsList) -> List[object]:
  return [serialize_str(item) for item in data]

@dataclass
class SpeechToTextRequest:
  """Request to convert speech to text."""
  encoded_audio_data: Union[str, None] = None

  def validate_encoded_audio_data(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "encoded_audio_data must be of type str for SpeechToTextRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_encoded_audio_data(self.encoded_audio_data)
    if not is_valid:
      raise TypeError(error_str)

def parse_speech_to_text_request(data: object):
  return SpeechToTextRequest(
    encoded_audio_data=parse_str(data["encoded_audio_data"]) if "encoded_audio_data" in data and data.get("encoded_audio_data") is not None else None,
  )

def serialize_speech_to_text_request(data: SpeechToTextRequest) -> object:
  return {
    "encoded_audio_data": None if data.encoded_audio_data is None else serialize_str(data.encoded_audio_data),
  }

class StatusHealthEnum(Enum):
  Ok = "ok"
  """Enum Ok = `ok`"""
  Warning = "warning"
  """Enum Warning = `warning`"""
  Error = "error"
  """Enum Error = `error`"""

def parse_status_health_enum(data: object) -> StatusHealthEnum:
  return StatusHealthEnum(data)

def serialize_status_health_enum(data: Union[StatusHealthEnum, str]) -> object:
  return StatusHealthEnum(data).value

@dataclass
class StatusVersionData:
  """Version Data"""
  id: Union[str, None] = None
  name: Union[str, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "id must be of type str for StatusVersionData, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for StatusVersionData, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)

def parse_status_version_data(data: object):
  return StatusVersionData(
    id=parse_str(data["id"]) if "id" in data and data.get("id") is not None else None,
    name=parse_str(data["name"]) if "name" in data and data.get("name") is not None else None,
  )

def serialize_status_version_data(data: StatusVersionData) -> object:
  return {
    "id": None if data.id is None else serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
  }

@dataclass
class TriggerFaultRequest:
  """Request to trigger an user fault for routine.
"""
  message: Union[str, None] = None
  isRecoverable: Union[bool, None] = None

  def validate_message(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "message must be of type str for TriggerFaultRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_isRecoverable(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "isRecoverable must be of type bool for TriggerFaultRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_message(self.message)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_isRecoverable(self.isRecoverable)
    if not is_valid:
      raise TypeError(error_str)

def parse_trigger_fault_request(data: object):
  return TriggerFaultRequest(
    message=parse_str(data["message"]) if "message" in data and data.get("message") is not None else None,
    isRecoverable=parse_bool(data["isRecoverable"]) if "isRecoverable" in data and data.get("isRecoverable") is not None else None,
  )

def serialize_trigger_fault_request(data: TriggerFaultRequest) -> object:
  return {
    "message": None if data.message is None else serialize_str(data.message),
    "isRecoverable": None if data.isRecoverable is None else serialize_bool(data.isRecoverable),
  }

@dataclass
class ArmPositionUpdateFailureEvent:
  """Move robot event when movement failed"""
  kind: Union[ArmPositionUpdateFailureEventKind, None] = None
  reason: Union[str, None] = None
  internal_reason: Union[str, None] = None

  def validate_kind(self, value: ArmPositionUpdateFailureEventKind) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for ArmPositionUpdateFailureEvent"]

    if not ((isinstance(value, str) and ArmPositionUpdateFailureEventKind in ['motion_failed_unknown_reason', 'motion_failed_collision']) or isinstance(value, ArmPositionUpdateFailureEventKind)):
      return [False, "kind must be of type ArmPositionUpdateFailureEventKind for ArmPositionUpdateFailureEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [False, "reason is required for ArmPositionUpdateFailureEvent"]

    if not isinstance(value, str):
      return [False, "reason must be of type str for ArmPositionUpdateFailureEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_internal_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "internal_reason must be of type str for ArmPositionUpdateFailureEvent, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_reason(self.reason)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_internal_reason(self.internal_reason)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_failure_event(data: object):
  return ArmPositionUpdateFailureEvent(
    kind=parse_arm_position_update_failure_event_kind(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    reason=parse_str(data["reason"]) if "reason" in data and data.get("reason") is not None else None,
    internal_reason=parse_str(data["internal_reason"]) if "internal_reason" in data and data.get("internal_reason") is not None else None,
  )

def serialize_arm_position_update_failure_event(data: ArmPositionUpdateFailureEvent) -> object:
  return {
    "kind": serialize_arm_position_update_failure_event_kind(data.kind),
    "reason": serialize_str(data.reason),
    "internal_reason": None if data.internal_reason is None else serialize_str(data.internal_reason),
  }

ArmPositionUpdateRequestResponseEventStreamSubscriptionsList = List[ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum]

def parse_arm_position_update_request_response_event_stream_subscriptions_list(data: object) -> ArmPositionUpdateRequestResponseEventStreamSubscriptionsList:
  return [parse_arm_position_update_request_response_event_stream_subscription_kind_enum(item) for item in data]

def serialize_arm_position_update_request_response_event_stream_subscriptions_list(data: ArmPositionUpdateRequestResponseEventStreamSubscriptionsList) -> List[object]:
  return [serialize_arm_position_update_request_response_event_stream_subscription_kind_enum(item) for item in data]

@dataclass
class BrakesState:
  """State of the robot joint brakes. Each joint contains a brake which can be engaged when the robot is at a standstill to prevent the robot from moving.
"""
  state: Union[BrakesStateEnum, None] = None

  def validate_state(self, value: BrakesStateEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "state is required for BrakesState"]

    if not ((isinstance(value, str) and BrakesStateEnum in ['engaged', 'disengaged']) or isinstance(value, BrakesStateEnum)):
      return [False, "state must be of type BrakesStateEnum for BrakesState, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_brakes_state(data: object):
  return BrakesState(
    state=parse_brakes_state_enum(data["state"]) if "state" in data and data.get("state") is not None else None,
  )

def serialize_brakes_state(data: BrakesState) -> object:
  return {
    "state": serialize_brakes_state_enum(data.state),
  }

@dataclass
class CameraIntrinsicsResponse:
  """Response with intrinsic parameters of the camera."""
  intrinsics: Union[CameraIntrinsics, None] = None

  def validate_intrinsics(self, value: CameraIntrinsics) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, CameraIntrinsics):
      return [False, "intrinsics must be of type CameraIntrinsics for CameraIntrinsicsResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_intrinsics(self.intrinsics)
    if not is_valid:
      raise TypeError(error_str)

def parse_camera_intrinsics_response(data: object):
  return CameraIntrinsicsResponse(
    intrinsics=parse_camera_intrinsics(data["intrinsics"]) if "intrinsics" in data and data.get("intrinsics") is not None else None,
  )

def serialize_camera_intrinsics_response(data: CameraIntrinsicsResponse) -> object:
  return {
    "intrinsics": None if data.intrinsics is None else serialize_camera_intrinsics(data.intrinsics),
  }

@dataclass
class CameraFrameRequest:
  """Request for a single camera frame."""
  camera_settings: Union[CameraSettings, None] = None

  def validate_camera_settings(self, value: CameraSettings) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, CameraSettings):
      return [False, "camera_settings must be of type CameraSettings for CameraFrameRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_camera_settings(self.camera_settings)
    if not is_valid:
      raise TypeError(error_str)

def parse_camera_frame_request(data: object):
  return CameraFrameRequest(
    camera_settings=parse_camera_settings(data["camera_settings"]) if "camera_settings" in data and data.get("camera_settings") is not None else None,
  )

def serialize_camera_frame_request(data: CameraFrameRequest) -> object:
  return {
    "camera_settings": None if data.camera_settings is None else serialize_camera_settings(data.camera_settings),
  }

@dataclass
class CartesianOffsetResponse:
  """Response with the cartesian offset value
"""
  pose: Union[CartesianPose, None] = None

  def validate_pose(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose is required for CartesianOffsetResponse"]

    if not isinstance(value, CartesianPose):
      return [False, "pose must be of type CartesianPose for CartesianOffsetResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_cartesian_offset_response(data: object):
  return CartesianOffsetResponse(
    pose=parse_cartesian_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_cartesian_offset_response(data: CartesianOffsetResponse) -> object:
  return {
    "pose": serialize_cartesian_pose(data.pose),
  }

@dataclass
class CartesianPoseResponse:
  """Response with cartesian pose based on euler pose"""
  pose: Union[CartesianPose, None] = None

  def validate_pose(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose is required for CartesianPoseResponse"]

    if not isinstance(value, CartesianPose):
      return [False, "pose must be of type CartesianPose for CartesianPoseResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_cartesian_pose_response(data: object):
  return CartesianPoseResponse(
    pose=parse_cartesian_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_cartesian_pose_response(data: CartesianPoseResponse) -> object:
  return {
    "pose": serialize_cartesian_pose(data.pose),
  }

@dataclass
class FlangePositionResponse:
  """Response with robot flange position
"""
  pose: Union[CartesianPose, None] = None

  def validate_pose(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, CartesianPose):
      return [False, "pose must be of type CartesianPose for FlangePositionResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_flange_position_response(data: object):
  return FlangePositionResponse(
    pose=parse_cartesian_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_flange_position_response(data: FlangePositionResponse) -> object:
  return {
    "pose": None if data.pose is None else serialize_cartesian_pose(data.pose),
  }

@dataclass
class JointPoseResponse:
  """Response with cartesian pose based on joint angles"""
  pose: Union[CartesianPose, None] = None

  def validate_pose(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose is required for JointPoseResponse"]

    if not isinstance(value, CartesianPose):
      return [False, "pose must be of type CartesianPose for JointPoseResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_joint_pose_response(data: object):
  return JointPoseResponse(
    pose=parse_cartesian_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_joint_pose_response(data: JointPoseResponse) -> object:
  return {
    "pose": serialize_cartesian_pose(data.pose),
  }

@dataclass
class PoseDistanceRequest:
  """Request: Calculate the distance between two cartesian poses
"""
  pose1: Union[CartesianPose, None] = None
  pose2: Union[CartesianPose, None] = None

  def validate_pose1(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose1 is required for PoseDistanceRequest"]

    if not isinstance(value, CartesianPose):
      return [False, "pose1 must be of type CartesianPose for PoseDistanceRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_pose2(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose2 is required for PoseDistanceRequest"]

    if not isinstance(value, CartesianPose):
      return [False, "pose2 must be of type CartesianPose for PoseDistanceRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose1(self.pose1)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_pose2(self.pose2)
    if not is_valid:
      raise TypeError(error_str)

def parse_pose_distance_request(data: object):
  return PoseDistanceRequest(
    pose1=parse_cartesian_pose(data["pose1"]) if "pose1" in data and data.get("pose1") is not None else None,
    pose2=parse_cartesian_pose(data["pose2"]) if "pose2" in data and data.get("pose2") is not None else None,
  )

def serialize_pose_distance_request(data: PoseDistanceRequest) -> object:
  return {
    "pose1": serialize_cartesian_pose(data.pose1),
    "pose2": serialize_cartesian_pose(data.pose2),
  }

@dataclass
class PoseOperationsRequest:
  """Request: Calculate add or substract operations between two cartesian poses
"""
  pose1: Union[CartesianPose, None] = None
  pose2: Union[CartesianPose, None] = None

  def validate_pose1(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose1 is required for PoseOperationsRequest"]

    if not isinstance(value, CartesianPose):
      return [False, "pose1 must be of type CartesianPose for PoseOperationsRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_pose2(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose2 is required for PoseOperationsRequest"]

    if not isinstance(value, CartesianPose):
      return [False, "pose2 must be of type CartesianPose for PoseOperationsRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose1(self.pose1)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_pose2(self.pose2)
    if not is_valid:
      raise TypeError(error_str)

def parse_pose_operations_request(data: object):
  return PoseOperationsRequest(
    pose1=parse_cartesian_pose(data["pose1"]) if "pose1" in data and data.get("pose1") is not None else None,
    pose2=parse_cartesian_pose(data["pose2"]) if "pose2" in data and data.get("pose2") is not None else None,
  )

def serialize_pose_operations_request(data: PoseOperationsRequest) -> object:
  return {
    "pose1": serialize_cartesian_pose(data.pose1),
    "pose2": serialize_cartesian_pose(data.pose2),
  }

@dataclass
class PoseOperationsResponse:
  """Response: Operation result between two cartesian poses
"""
  pose: Union[CartesianPose, None] = None

  def validate_pose(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose is required for PoseOperationsResponse"]

    if not isinstance(value, CartesianPose):
      return [False, "pose must be of type CartesianPose for PoseOperationsResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_pose_operations_response(data: object):
  return PoseOperationsResponse(
    pose=parse_cartesian_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_pose_operations_response(data: PoseOperationsResponse) -> object:
  return {
    "pose": serialize_cartesian_pose(data.pose),
  }

@dataclass
class TooltipPositionResponse:
  """Response with robot tooltip position
"""
  pose: Union[CartesianPose, None] = None

  def validate_pose(self, value: CartesianPose) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, CartesianPose):
      return [False, "pose must be of type CartesianPose for TooltipPositionResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_tooltip_position_response(data: object):
  return TooltipPositionResponse(
    pose=parse_cartesian_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_tooltip_position_response(data: TooltipPositionResponse) -> object:
  return {
    "pose": None if data.pose is None else serialize_cartesian_pose(data.pose),
  }

@dataclass
class JointState:
  """State of a joint"""
  braked: Union[bool, None] = None
  connectionStatus: Union[ConnectionStatus, None] = None
  inCollision: Union[bool, None] = None
  disturbance: Union[float, None] = None

  def validate_braked(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "braked must be of type bool for JointState, got " + type(value).__name__]

    return [True, ""]

  def validate_connectionStatus(self, value: ConnectionStatus) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ConnectionStatus in ['connected', 'disconnected', 'ready']) or isinstance(value, ConnectionStatus)):
      return [False, "connectionStatus must be of type ConnectionStatus for JointState, got " + type(value).__name__]

    return [True, ""]

  def validate_inCollision(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "inCollision must be of type bool for JointState, got " + type(value).__name__]

    return [True, ""]

  def validate_disturbance(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "disturbance must be of type float for JointState, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_braked(self.braked)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_connectionStatus(self.connectionStatus)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_inCollision(self.inCollision)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_disturbance(self.disturbance)
    if not is_valid:
      raise TypeError(error_str)

def parse_joint_state(data: object):
  return JointState(
    braked=parse_bool(data["braked"]) if "braked" in data and data.get("braked") is not None else None,
    connectionStatus=parse_connection_status(data["connectionStatus"]) if "connectionStatus" in data and data.get("connectionStatus") is not None else None,
    inCollision=parse_bool(data["inCollision"]) if "inCollision" in data and data.get("inCollision") is not None else None,
    disturbance=parse_f_64(data["disturbance"]) if "disturbance" in data and data.get("disturbance") is not None else None,
  )

def serialize_joint_state(data: JointState) -> object:
  return {
    "braked": None if data.braked is None else serialize_bool(data.braked),
    "connectionStatus": None if data.connectionStatus is None else serialize_connection_status(data.connectionStatus),
    "inCollision": None if data.inCollision is None else serialize_bool(data.inCollision),
    "disturbance": None if data.disturbance is None else serialize_f_64(data.disturbance),
  }

EnvironmentVariablesList = List[EnvironmentVariable]

def parse_environment_variables_list(data: object) -> EnvironmentVariablesList:
  return [parse_environment_variable(item) for item in data]

def serialize_environment_variables_list(data: EnvironmentVariablesList) -> List[object]:
  return [serialize_environment_variable(item) for item in data]

@dataclass
class ErrorResponse:
  """Error Response"""
  error: Union[ErrorEnum, None] = None
  message: Union[str, None] = None

  def validate_error(self, value: ErrorEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "error is required for ErrorResponse"]

    if not ((isinstance(value, str) and ErrorEnum in ['authorization_required', 'routine_must_be_running', 'api_control_required', 'robot_brakes_disengage_failed', 'robot_brakes_engage_failed', 'request_failed_validation', 'robot_not_idle', 'brakes_must_be_engaged', 'brakes_must_be_disengaged', 'equipment_no_matching', 'service_initializing', 'camera_disconnected', 'settings_validation_error', 'settings_timeout', 'internal_server_error', 'recovery_error', 'not_found', 'invalid_space_specified']) or isinstance(value, ErrorEnum)):
      return [False, "error must be of type ErrorEnum for ErrorResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_message(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [False, "message is required for ErrorResponse"]

    if not isinstance(value, str):
      return [False, "message must be of type str for ErrorResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_error(self.error)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_message(self.message)
    if not is_valid:
      raise TypeError(error_str)

def parse_error_response(data: object):
  return ErrorResponse(
    error=parse_error_enum(data["error"]) if "error" in data and data.get("error") is not None else None,
    message=parse_str(data["message"]) if "message" in data and data.get("message") is not None else None,
  )

def serialize_error_response(data: ErrorResponse) -> object:
  return {
    "error": serialize_error_enum(data.error),
    "message": serialize_str(data.message),
  }

@dataclass
class CartesianOffsetRequest:
  """Request to retrieve the cartesian offset based on robot position
"""
  pose: Union[EulerPose, None] = None

  def validate_pose(self, value: EulerPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose is required for CartesianOffsetRequest"]

    if not isinstance(value, EulerPose):
      return [False, "pose must be of type EulerPose for CartesianOffsetRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_cartesian_offset_request(data: object):
  return CartesianOffsetRequest(
    pose=parse_euler_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_cartesian_offset_request(data: CartesianOffsetRequest) -> object:
  return {
    "pose": serialize_euler_pose(data.pose),
  }

@dataclass
class CartesianPoseRequest:
  """Request to transform the euler pose to cartesian pose"""
  pose: Union[EulerPose, None] = None

  def validate_pose(self, value: EulerPose) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose is required for CartesianPoseRequest"]

    if not isinstance(value, EulerPose):
      return [False, "pose must be of type EulerPose for CartesianPoseRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_cartesian_pose_request(data: object):
  return CartesianPoseRequest(
    pose=parse_euler_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_cartesian_pose_request(data: CartesianPoseRequest) -> object:
  return {
    "pose": serialize_euler_pose(data.pose),
  }

@dataclass
class ForceUnit:
  """Reusable Abstraction for force units (eg force, torque)
"""
  unit_kind: Union[ForceUnitKind, None] = None
  value: Union[float, None] = None

  def validate_unit_kind(self, value: ForceUnitKind) -> Tuple[bool, str]:
    if value is None:
      return [False, "unit_kind is required for ForceUnit"]

    if not ((isinstance(value, str) and ForceUnitKind in ['newtons', 'pounds']) or isinstance(value, ForceUnitKind)):
      return [False, "unit_kind must be of type ForceUnitKind for ForceUnit, got " + type(value).__name__]

    return [True, ""]

  def validate_value(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "value must be of type float for ForceUnit, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_unit_kind(self.unit_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_value(self.value)
    if not is_valid:
      raise TypeError(error_str)

def parse_force_unit(data: object):
  return ForceUnit(
    unit_kind=parse_force_unit_kind(data["unit_kind"]) if "unit_kind" in data and data.get("unit_kind") is not None else None,
    value=parse_f_64(data["value"]) if "value" in data and data.get("value") is not None else None,
  )

def serialize_force_unit(data: ForceUnit) -> object:
  return {
    "unit_kind": serialize_force_unit_kind(data.unit_kind),
    "value": None if data.value is None else serialize_f_64(data.value),
  }

@dataclass
class IOStateResponse:
  """Response to a query for the current state of I/O."""
  state: Union[IOStateMap, None] = None

  def validate_state(self, value: IOStateMap) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, dict) and all((isinstance(k, str) and isinstance(val, str)) for k, val in value.items())):
      return [False, "state must be of type IOStateMap for IOStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_io_state_response(data: object):
  return IOStateResponse(
    state=parse_io_state_map(data["state"]) if "state" in data and data.get("state") is not None else None,
  )

def serialize_io_state_response(data: IOStateResponse) -> object:
  return {
    "state": None if data.state is None else serialize_io_state_map(data.state),
  }

@dataclass
class IOStateUpdateRequest:
  """Request to update the state of I/O for multiple ports."""
  state: Union[IOStateMap, None] = None

  def validate_state(self, value: IOStateMap) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, dict) and all((isinstance(k, str) and isinstance(val, str)) for k, val in value.items())):
      return [False, "state must be of type IOStateMap for IOStateUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_io_state_update_request(data: object):
  return IOStateUpdateRequest(
    state=parse_io_state_map(data["state"]) if "state" in data and data.get("state") is not None else None,
  )

def serialize_io_state_update_request(data: IOStateUpdateRequest) -> object:
  return {
    "state": None if data.state is None else serialize_io_state_map(data.state),
  }

@dataclass
class JointPoseRequest:
  """Request to transform the joint angles to cartesian pose"""
  pose: Union[JointAngles, None] = None

  def validate_pose(self, value: JointAngles) -> Tuple[bool, str]:
    if value is None:
      return [False, "pose is required for JointPoseRequest"]

    if not isinstance(value, JointAngles):
      return [False, "pose must be of type JointAngles for JointPoseRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_joint_pose_request(data: object):
  return JointPoseRequest(
    pose=parse_joint_angles(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_joint_pose_request(data: JointPoseRequest) -> object:
  return {
    "pose": serialize_joint_angles(data.pose),
  }

@dataclass
class JointsPositionResponse:
  """Response with robot joints position
"""
  pose: Union[JointAngles, None] = None

  def validate_pose(self, value: JointAngles) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointAngles):
      return [False, "pose must be of type JointAngles for JointsPositionResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_joints_position_response(data: object):
  return JointsPositionResponse(
    pose=parse_joint_angles(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_joints_position_response(data: JointsPositionResponse) -> object:
  return {
    "pose": None if data.pose is None else serialize_joint_angles(data.pose),
  }

@dataclass
class ArmJointRotations:
  """Rotational positions of arm joints"""
  joints: Union[JointRotations, None] = None

  def validate_joints(self, value: JointRotations) -> Tuple[bool, str]:
    if value is None:
      return [False, "joints is required for ArmJointRotations"]

    if not (isinstance(value, tuple) and len(value) == 6):
      return [False, "joints must be of type JointRotations for ArmJointRotations, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_joints(self.joints)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_joint_rotations(data: object):
  return ArmJointRotations(
    joints=parse_joint_rotations(data["joints"]) if "joints" in data and data.get("joints") is not None else None,
  )

def serialize_arm_joint_rotations(data: ArmJointRotations) -> object:
  return {
    "joints": serialize_joint_rotations(data.joints),
  }

@dataclass
class LinearUnit:
  """Reusable Abstraction for linear units (eg distance, position, offset)
"""
  unit_kind: Union[LinearUnitKind, None] = None
  value: Union[float, None] = None

  def validate_unit_kind(self, value: LinearUnitKind) -> Tuple[bool, str]:
    if value is None:
      return [False, "unit_kind is required for LinearUnit"]

    if not ((isinstance(value, str) and LinearUnitKind in ['millimeters', 'centimeters', 'meters', 'inches', 'feet']) or isinstance(value, LinearUnitKind)):
      return [False, "unit_kind must be of type LinearUnitKind for LinearUnit, got " + type(value).__name__]

    return [True, ""]

  def validate_value(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "value must be of type float for LinearUnit, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_unit_kind(self.unit_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_value(self.value)
    if not is_valid:
      raise TypeError(error_str)

def parse_linear_unit(data: object):
  return LinearUnit(
    unit_kind=parse_linear_unit_kind(data["unit_kind"]) if "unit_kind" in data and data.get("unit_kind") is not None else None,
    value=parse_f_64(data["value"]) if "value" in data and data.get("value") is not None else None,
  )

def serialize_linear_unit(data: LinearUnit) -> object:
  return {
    "unit_kind": serialize_linear_unit_kind(data.unit_kind),
    "value": None if data.value is None else serialize_f_64(data.value),
  }

@dataclass
class Position:
  """Position of an object in 3D space. All empty values default to 0"""
  unit_kind: Union[LinearUnitKind, None] = None
  x: Union[float, None] = None
  y: Union[float, None] = None
  z: Union[float, None] = None

  def validate_unit_kind(self, value: LinearUnitKind) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and LinearUnitKind in ['millimeters', 'centimeters', 'meters', 'inches', 'feet']) or isinstance(value, LinearUnitKind)):
      return [False, "unit_kind must be of type LinearUnitKind for Position, got " + type(value).__name__]

    return [True, ""]

  def validate_x(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "x must be of type float for Position, got " + type(value).__name__]

    return [True, ""]

  def validate_y(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "y must be of type float for Position, got " + type(value).__name__]

    return [True, ""]

  def validate_z(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "z must be of type float for Position, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_unit_kind(self.unit_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_x(self.x)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_y(self.y)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_z(self.z)
    if not is_valid:
      raise TypeError(error_str)

def parse_position(data: object):
  return Position(
    unit_kind=parse_linear_unit_kind(data["unit_kind"]) if "unit_kind" in data and data.get("unit_kind") is not None else None,
    x=parse_f_64(data["x"]) if "x" in data and data.get("x") is not None else None,
    y=parse_f_64(data["y"]) if "y" in data and data.get("y") is not None else None,
    z=parse_f_64(data["z"]) if "z" in data and data.get("z") is not None else None,
  )

def serialize_position(data: Position) -> object:
  return {
    "unit_kind": None if data.unit_kind is None else serialize_linear_unit_kind(data.unit_kind),
    "x": None if data.x is None else serialize_f_64(data.x),
    "y": None if data.y is None else serialize_f_64(data.y),
    "z": None if data.z is None else serialize_f_64(data.z),
  }

@dataclass
class SpeedProfile:
  """Speed profile/limits for arm movements"""
  max_joint_speeds: Union[MaxJointSpeeds, None] = None
  max_joint_accelerations: Union[MaxJointAcclerations, None] = None
  max_tooltip_speed: Union[float, None] = None
  base_acceleration_scaling: Union[float, None] = None
  base_velocity_scaling: Union[float, None] = None
  scaling_factor: Union[float, None] = None

  def validate_max_joint_speeds(self, value: MaxJointSpeeds) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, tuple) and len(value) == 6):
      return [False, "max_joint_speeds must be of type MaxJointSpeeds for SpeedProfile, got " + type(value).__name__]

    return [True, ""]

  def validate_max_joint_accelerations(self, value: MaxJointAcclerations) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, tuple) and len(value) == 6):
      return [False, "max_joint_accelerations must be of type MaxJointAcclerations for SpeedProfile, got " + type(value).__name__]

    return [True, ""]

  def validate_max_tooltip_speed(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "max_tooltip_speed must be of type float for SpeedProfile, got " + type(value).__name__]

    return [True, ""]

  def validate_base_acceleration_scaling(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "base_acceleration_scaling must be of type float for SpeedProfile, got " + type(value).__name__]

    return [True, ""]

  def validate_base_velocity_scaling(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "base_velocity_scaling must be of type float for SpeedProfile, got " + type(value).__name__]

    return [True, ""]

  def validate_scaling_factor(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "scaling_factor must be of type float for SpeedProfile, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_max_joint_speeds(self.max_joint_speeds)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_max_joint_accelerations(self.max_joint_accelerations)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_max_tooltip_speed(self.max_tooltip_speed)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_base_acceleration_scaling(self.base_acceleration_scaling)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_base_velocity_scaling(self.base_velocity_scaling)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_scaling_factor(self.scaling_factor)
    if not is_valid:
      raise TypeError(error_str)

def parse_speed_profile(data: object):
  return SpeedProfile(
    max_joint_speeds=parse_max_joint_speeds(data["max_joint_speeds"]) if "max_joint_speeds" in data and data.get("max_joint_speeds") is not None else None,
    max_joint_accelerations=parse_max_joint_acclerations(data["max_joint_accelerations"]) if "max_joint_accelerations" in data and data.get("max_joint_accelerations") is not None else None,
    max_tooltip_speed=parse_f_64(data["max_tooltip_speed"]) if "max_tooltip_speed" in data and data.get("max_tooltip_speed") is not None else None,
    base_acceleration_scaling=parse_f_64(data["base_acceleration_scaling"]) if "base_acceleration_scaling" in data and data.get("base_acceleration_scaling") is not None else None,
    base_velocity_scaling=parse_f_64(data["base_velocity_scaling"]) if "base_velocity_scaling" in data and data.get("base_velocity_scaling") is not None else None,
    scaling_factor=parse_f_64(data["scaling_factor"]) if "scaling_factor" in data and data.get("scaling_factor") is not None else None,
  )

def serialize_speed_profile(data: SpeedProfile) -> object:
  return {
    "max_joint_speeds": None if data.max_joint_speeds is None else serialize_max_joint_speeds(data.max_joint_speeds),
    "max_joint_accelerations": None if data.max_joint_accelerations is None else serialize_max_joint_acclerations(data.max_joint_accelerations),
    "max_tooltip_speed": None if data.max_tooltip_speed is None else serialize_f_64(data.max_tooltip_speed),
    "base_acceleration_scaling": None if data.base_acceleration_scaling is None else serialize_f_64(data.base_acceleration_scaling),
    "base_velocity_scaling": None if data.base_velocity_scaling is None else serialize_f_64(data.base_velocity_scaling),
    "scaling_factor": None if data.scaling_factor is None else serialize_f_64(data.scaling_factor),
  }

@dataclass
class OnRobot2FG14GripperConfiguration:
  """Configuration for OnRobot 2FG14 Gripper"""
  grip_kind: Union[OnRobotGripKindEnum, None] = None
  grip_detected: Union[bool, None] = None
  normalized_width_inner: Union[float, None] = None
  normalized_width_outer: Union[float, None] = None
  width_inner: Union[float, None] = None
  min_width_inner: Union[float, None] = None
  max_width_inner: Union[float, None] = None
  width_outer: Union[float, None] = None
  min_width_outer: Union[float, None] = None
  max_width_outer: Union[float, None] = None
  force: Union[float, None] = None
  max_force: Union[float, None] = None
  finger_mounting_position: Union[str, None] = None
  finger_offset: Union[float, None] = None
  finger_angle: Union[float, None] = None
  finger_length: Union[float, None] = None
  finger_height: Union[float, None] = None
  linear_sensor_error: Union[bool, None] = None
  uncalibrated_error: Union[bool, None] = None

  def validate_grip_kind(self, value: OnRobotGripKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and OnRobotGripKindEnum in ['inward', 'outward']) or isinstance(value, OnRobotGripKindEnum)):
      return [False, "grip_kind must be of type OnRobotGripKindEnum for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_grip_detected(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "grip_detected must be of type bool for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_normalized_width_inner(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "normalized_width_inner must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_normalized_width_outer(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "normalized_width_outer must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_width_inner(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "width_inner must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_min_width_inner(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "min_width_inner must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_max_width_inner(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "max_width_inner must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_width_outer(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "width_outer must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_min_width_outer(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "min_width_outer must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_max_width_outer(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "max_width_outer must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "force must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_max_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "max_force must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_mounting_position(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "finger_mounting_position must be of type str for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_offset(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_offset must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_angle(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_angle must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_length(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_length must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_height(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_height must be of type float for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_linear_sensor_error(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "linear_sensor_error must be of type bool for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_uncalibrated_error(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "uncalibrated_error must be of type bool for OnRobot2FG14GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_grip_kind(self.grip_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_grip_detected(self.grip_detected)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_normalized_width_inner(self.normalized_width_inner)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_normalized_width_outer(self.normalized_width_outer)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_width_inner(self.width_inner)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_min_width_inner(self.min_width_inner)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_max_width_inner(self.max_width_inner)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_width_outer(self.width_outer)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_min_width_outer(self.min_width_outer)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_max_width_outer(self.max_width_outer)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_force(self.force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_max_force(self.max_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_mounting_position(self.finger_mounting_position)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_offset(self.finger_offset)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_angle(self.finger_angle)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_length(self.finger_length)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_height(self.finger_height)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_linear_sensor_error(self.linear_sensor_error)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_uncalibrated_error(self.uncalibrated_error)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_2_fg_14_gripper_configuration(data: object):
  return OnRobot2FG14GripperConfiguration(
    grip_kind=parse_on_robot_grip_kind_enum(data["grip_kind"]) if "grip_kind" in data and data.get("grip_kind") is not None else None,
    grip_detected=parse_bool(data["grip_detected"]) if "grip_detected" in data and data.get("grip_detected") is not None else None,
    normalized_width_inner=parse_f_64(data["normalized_width_inner"]) if "normalized_width_inner" in data and data.get("normalized_width_inner") is not None else None,
    normalized_width_outer=parse_f_64(data["normalized_width_outer"]) if "normalized_width_outer" in data and data.get("normalized_width_outer") is not None else None,
    width_inner=parse_f_64(data["width_inner"]) if "width_inner" in data and data.get("width_inner") is not None else None,
    min_width_inner=parse_f_64(data["min_width_inner"]) if "min_width_inner" in data and data.get("min_width_inner") is not None else None,
    max_width_inner=parse_f_64(data["max_width_inner"]) if "max_width_inner" in data and data.get("max_width_inner") is not None else None,
    width_outer=parse_f_64(data["width_outer"]) if "width_outer" in data and data.get("width_outer") is not None else None,
    min_width_outer=parse_f_64(data["min_width_outer"]) if "min_width_outer" in data and data.get("min_width_outer") is not None else None,
    max_width_outer=parse_f_64(data["max_width_outer"]) if "max_width_outer" in data and data.get("max_width_outer") is not None else None,
    force=parse_f_64(data["force"]) if "force" in data and data.get("force") is not None else None,
    max_force=parse_f_64(data["max_force"]) if "max_force" in data and data.get("max_force") is not None else None,
    finger_mounting_position=parse_str(data["finger_mounting_position"]) if "finger_mounting_position" in data and data.get("finger_mounting_position") is not None else None,
    finger_offset=parse_f_64(data["finger_offset"]) if "finger_offset" in data and data.get("finger_offset") is not None else None,
    finger_angle=parse_f_64(data["finger_angle"]) if "finger_angle" in data and data.get("finger_angle") is not None else None,
    finger_length=parse_f_64(data["finger_length"]) if "finger_length" in data and data.get("finger_length") is not None else None,
    finger_height=parse_f_64(data["finger_height"]) if "finger_height" in data and data.get("finger_height") is not None else None,
    linear_sensor_error=parse_bool(data["linear_sensor_error"]) if "linear_sensor_error" in data and data.get("linear_sensor_error") is not None else None,
    uncalibrated_error=parse_bool(data["uncalibrated_error"]) if "uncalibrated_error" in data and data.get("uncalibrated_error") is not None else None,
  )

def serialize_on_robot_2_fg_14_gripper_configuration(data: OnRobot2FG14GripperConfiguration) -> object:
  return {
    "grip_kind": None if data.grip_kind is None else serialize_on_robot_grip_kind_enum(data.grip_kind),
    "grip_detected": None if data.grip_detected is None else serialize_bool(data.grip_detected),
    "normalized_width_inner": None if data.normalized_width_inner is None else serialize_f_64(data.normalized_width_inner),
    "normalized_width_outer": None if data.normalized_width_outer is None else serialize_f_64(data.normalized_width_outer),
    "width_inner": None if data.width_inner is None else serialize_f_64(data.width_inner),
    "min_width_inner": None if data.min_width_inner is None else serialize_f_64(data.min_width_inner),
    "max_width_inner": None if data.max_width_inner is None else serialize_f_64(data.max_width_inner),
    "width_outer": None if data.width_outer is None else serialize_f_64(data.width_outer),
    "min_width_outer": None if data.min_width_outer is None else serialize_f_64(data.min_width_outer),
    "max_width_outer": None if data.max_width_outer is None else serialize_f_64(data.max_width_outer),
    "force": None if data.force is None else serialize_f_64(data.force),
    "max_force": None if data.max_force is None else serialize_f_64(data.max_force),
    "finger_mounting_position": None if data.finger_mounting_position is None else serialize_str(data.finger_mounting_position),
    "finger_offset": None if data.finger_offset is None else serialize_f_64(data.finger_offset),
    "finger_angle": None if data.finger_angle is None else serialize_f_64(data.finger_angle),
    "finger_length": None if data.finger_length is None else serialize_f_64(data.finger_length),
    "finger_height": None if data.finger_height is None else serialize_f_64(data.finger_height),
    "linear_sensor_error": None if data.linear_sensor_error is None else serialize_bool(data.linear_sensor_error),
    "uncalibrated_error": None if data.uncalibrated_error is None else serialize_bool(data.uncalibrated_error),
  }

@dataclass
class OnRobot2FG7GripperConfiguration:
  """Configuration for OnRobot 2FG7 Gripper"""
  grip_kind: Union[OnRobotGripKindEnum, None] = None
  grip_detected: Union[bool, None] = None
  normalized_width_inner: Union[float, None] = None
  normalized_width_outer: Union[float, None] = None
  width_inner: Union[float, None] = None
  min_width_inner: Union[float, None] = None
  max_width_inner: Union[float, None] = None
  width_outer: Union[float, None] = None
  min_width_outer: Union[float, None] = None
  max_width_outer: Union[float, None] = None
  force: Union[float, None] = None
  max_force: Union[float, None] = None
  finger_mounting_position: Union[str, None] = None
  finger_offset: Union[float, None] = None
  finger_angle: Union[float, None] = None
  finger_length: Union[float, None] = None
  finger_height: Union[float, None] = None
  linear_sensor_error: Union[bool, None] = None
  uncalibrated_error: Union[bool, None] = None

  def validate_grip_kind(self, value: OnRobotGripKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and OnRobotGripKindEnum in ['inward', 'outward']) or isinstance(value, OnRobotGripKindEnum)):
      return [False, "grip_kind must be of type OnRobotGripKindEnum for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_grip_detected(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "grip_detected must be of type bool for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_normalized_width_inner(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "normalized_width_inner must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_normalized_width_outer(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "normalized_width_outer must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_width_inner(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "width_inner must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_min_width_inner(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "min_width_inner must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_max_width_inner(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "max_width_inner must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_width_outer(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "width_outer must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_min_width_outer(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "min_width_outer must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_max_width_outer(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "max_width_outer must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "force must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_max_force(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "max_force must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_mounting_position(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "finger_mounting_position must be of type str for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_offset(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_offset must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_angle(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_angle must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_length(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_length must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_height(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_height must be of type float for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_linear_sensor_error(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "linear_sensor_error must be of type bool for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_uncalibrated_error(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "uncalibrated_error must be of type bool for OnRobot2FG7GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_grip_kind(self.grip_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_grip_detected(self.grip_detected)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_normalized_width_inner(self.normalized_width_inner)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_normalized_width_outer(self.normalized_width_outer)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_width_inner(self.width_inner)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_min_width_inner(self.min_width_inner)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_max_width_inner(self.max_width_inner)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_width_outer(self.width_outer)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_min_width_outer(self.min_width_outer)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_max_width_outer(self.max_width_outer)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_force(self.force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_max_force(self.max_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_mounting_position(self.finger_mounting_position)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_offset(self.finger_offset)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_angle(self.finger_angle)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_length(self.finger_length)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_height(self.finger_height)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_linear_sensor_error(self.linear_sensor_error)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_uncalibrated_error(self.uncalibrated_error)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_2_fg_7_gripper_configuration(data: object):
  return OnRobot2FG7GripperConfiguration(
    grip_kind=parse_on_robot_grip_kind_enum(data["grip_kind"]) if "grip_kind" in data and data.get("grip_kind") is not None else None,
    grip_detected=parse_bool(data["grip_detected"]) if "grip_detected" in data and data.get("grip_detected") is not None else None,
    normalized_width_inner=parse_f_64(data["normalized_width_inner"]) if "normalized_width_inner" in data and data.get("normalized_width_inner") is not None else None,
    normalized_width_outer=parse_f_64(data["normalized_width_outer"]) if "normalized_width_outer" in data and data.get("normalized_width_outer") is not None else None,
    width_inner=parse_f_64(data["width_inner"]) if "width_inner" in data and data.get("width_inner") is not None else None,
    min_width_inner=parse_f_64(data["min_width_inner"]) if "min_width_inner" in data and data.get("min_width_inner") is not None else None,
    max_width_inner=parse_f_64(data["max_width_inner"]) if "max_width_inner" in data and data.get("max_width_inner") is not None else None,
    width_outer=parse_f_64(data["width_outer"]) if "width_outer" in data and data.get("width_outer") is not None else None,
    min_width_outer=parse_f_64(data["min_width_outer"]) if "min_width_outer" in data and data.get("min_width_outer") is not None else None,
    max_width_outer=parse_f_64(data["max_width_outer"]) if "max_width_outer" in data and data.get("max_width_outer") is not None else None,
    force=parse_f_64(data["force"]) if "force" in data and data.get("force") is not None else None,
    max_force=parse_f_64(data["max_force"]) if "max_force" in data and data.get("max_force") is not None else None,
    finger_mounting_position=parse_str(data["finger_mounting_position"]) if "finger_mounting_position" in data and data.get("finger_mounting_position") is not None else None,
    finger_offset=parse_f_64(data["finger_offset"]) if "finger_offset" in data and data.get("finger_offset") is not None else None,
    finger_angle=parse_f_64(data["finger_angle"]) if "finger_angle" in data and data.get("finger_angle") is not None else None,
    finger_length=parse_f_64(data["finger_length"]) if "finger_length" in data and data.get("finger_length") is not None else None,
    finger_height=parse_f_64(data["finger_height"]) if "finger_height" in data and data.get("finger_height") is not None else None,
    linear_sensor_error=parse_bool(data["linear_sensor_error"]) if "linear_sensor_error" in data and data.get("linear_sensor_error") is not None else None,
    uncalibrated_error=parse_bool(data["uncalibrated_error"]) if "uncalibrated_error" in data and data.get("uncalibrated_error") is not None else None,
  )

def serialize_on_robot_2_fg_7_gripper_configuration(data: OnRobot2FG7GripperConfiguration) -> object:
  return {
    "grip_kind": None if data.grip_kind is None else serialize_on_robot_grip_kind_enum(data.grip_kind),
    "grip_detected": None if data.grip_detected is None else serialize_bool(data.grip_detected),
    "normalized_width_inner": None if data.normalized_width_inner is None else serialize_f_64(data.normalized_width_inner),
    "normalized_width_outer": None if data.normalized_width_outer is None else serialize_f_64(data.normalized_width_outer),
    "width_inner": None if data.width_inner is None else serialize_f_64(data.width_inner),
    "min_width_inner": None if data.min_width_inner is None else serialize_f_64(data.min_width_inner),
    "max_width_inner": None if data.max_width_inner is None else serialize_f_64(data.max_width_inner),
    "width_outer": None if data.width_outer is None else serialize_f_64(data.width_outer),
    "min_width_outer": None if data.min_width_outer is None else serialize_f_64(data.min_width_outer),
    "max_width_outer": None if data.max_width_outer is None else serialize_f_64(data.max_width_outer),
    "force": None if data.force is None else serialize_f_64(data.force),
    "max_force": None if data.max_force is None else serialize_f_64(data.max_force),
    "finger_mounting_position": None if data.finger_mounting_position is None else serialize_str(data.finger_mounting_position),
    "finger_offset": None if data.finger_offset is None else serialize_f_64(data.finger_offset),
    "finger_angle": None if data.finger_angle is None else serialize_f_64(data.finger_angle),
    "finger_length": None if data.finger_length is None else serialize_f_64(data.finger_length),
    "finger_height": None if data.finger_height is None else serialize_f_64(data.finger_height),
    "linear_sensor_error": None if data.linear_sensor_error is None else serialize_bool(data.linear_sensor_error),
    "uncalibrated_error": None if data.uncalibrated_error is None else serialize_bool(data.uncalibrated_error),
  }

@dataclass
class OnRobot3FG15GripperConfiguration:
  """Configuration for OnRobot 3FG15 Gripper"""
  grip_detected: Union[bool, None] = None
  force_grip_detected: Union[bool, None] = None
  calibration_ok: Union[bool, None] = None
  diameter: Union[float, None] = None
  grip_kind: Union[OnRobotGripKindEnum, None] = None
  finger_angle: Union[float, None] = None
  force_applied_fraction: Union[float, None] = None
  force_applied_newtons: Union[float, None] = None
  target_force_newtons: Union[float, None] = None
  finger_length: Union[float, None] = None
  finger_mounting_position: Union[float, None] = None
  finger_offset: Union[float, None] = None

  def validate_grip_detected(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "grip_detected must be of type bool for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_force_grip_detected(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "force_grip_detected must be of type bool for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_calibration_ok(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "calibration_ok must be of type bool for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_diameter(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "diameter must be of type float for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_grip_kind(self, value: OnRobotGripKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and OnRobotGripKindEnum in ['inward', 'outward']) or isinstance(value, OnRobotGripKindEnum)):
      return [False, "grip_kind must be of type OnRobotGripKindEnum for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_angle(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_angle must be of type float for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_force_applied_fraction(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "force_applied_fraction must be of type float for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_force_applied_newtons(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "force_applied_newtons must be of type float for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force_newtons(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "target_force_newtons must be of type float for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_length(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_length must be of type float for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_mounting_position(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_mounting_position must be of type float for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_finger_offset(self, value: float) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, float):
      return [False, "finger_offset must be of type float for OnRobot3FG15GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_grip_detected(self.grip_detected)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_force_grip_detected(self.force_grip_detected)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_calibration_ok(self.calibration_ok)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_diameter(self.diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_grip_kind(self.grip_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_angle(self.finger_angle)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_force_applied_fraction(self.force_applied_fraction)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_force_applied_newtons(self.force_applied_newtons)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force_newtons(self.target_force_newtons)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_length(self.finger_length)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_mounting_position(self.finger_mounting_position)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_finger_offset(self.finger_offset)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_3_fg_15_gripper_configuration(data: object):
  return OnRobot3FG15GripperConfiguration(
    grip_detected=parse_bool(data["grip_detected"]) if "grip_detected" in data and data.get("grip_detected") is not None else None,
    force_grip_detected=parse_bool(data["force_grip_detected"]) if "force_grip_detected" in data and data.get("force_grip_detected") is not None else None,
    calibration_ok=parse_bool(data["calibration_ok"]) if "calibration_ok" in data and data.get("calibration_ok") is not None else None,
    diameter=parse_f_64(data["diameter"]) if "diameter" in data and data.get("diameter") is not None else None,
    grip_kind=parse_on_robot_grip_kind_enum(data["grip_kind"]) if "grip_kind" in data and data.get("grip_kind") is not None else None,
    finger_angle=parse_f_64(data["finger_angle"]) if "finger_angle" in data and data.get("finger_angle") is not None else None,
    force_applied_fraction=parse_f_64(data["force_applied_fraction"]) if "force_applied_fraction" in data and data.get("force_applied_fraction") is not None else None,
    force_applied_newtons=parse_f_64(data["force_applied_newtons"]) if "force_applied_newtons" in data and data.get("force_applied_newtons") is not None else None,
    target_force_newtons=parse_f_64(data["target_force_newtons"]) if "target_force_newtons" in data and data.get("target_force_newtons") is not None else None,
    finger_length=parse_f_64(data["finger_length"]) if "finger_length" in data and data.get("finger_length") is not None else None,
    finger_mounting_position=parse_f_64(data["finger_mounting_position"]) if "finger_mounting_position" in data and data.get("finger_mounting_position") is not None else None,
    finger_offset=parse_f_64(data["finger_offset"]) if "finger_offset" in data and data.get("finger_offset") is not None else None,
  )

def serialize_on_robot_3_fg_15_gripper_configuration(data: OnRobot3FG15GripperConfiguration) -> object:
  return {
    "grip_detected": None if data.grip_detected is None else serialize_bool(data.grip_detected),
    "force_grip_detected": None if data.force_grip_detected is None else serialize_bool(data.force_grip_detected),
    "calibration_ok": None if data.calibration_ok is None else serialize_bool(data.calibration_ok),
    "diameter": None if data.diameter is None else serialize_f_64(data.diameter),
    "grip_kind": None if data.grip_kind is None else serialize_on_robot_grip_kind_enum(data.grip_kind),
    "finger_angle": None if data.finger_angle is None else serialize_f_64(data.finger_angle),
    "force_applied_fraction": None if data.force_applied_fraction is None else serialize_f_64(data.force_applied_fraction),
    "force_applied_newtons": None if data.force_applied_newtons is None else serialize_f_64(data.force_applied_newtons),
    "target_force_newtons": None if data.target_force_newtons is None else serialize_f_64(data.target_force_newtons),
    "finger_length": None if data.finger_length is None else serialize_f_64(data.finger_length),
    "finger_mounting_position": None if data.finger_mounting_position is None else serialize_f_64(data.finger_mounting_position),
    "finger_offset": None if data.finger_offset is None else serialize_f_64(data.finger_offset),
  }

PlanesList = List[Plane]

def parse_planes_list(data: object) -> PlanesList:
  return [parse_plane(item) for item in data]

def serialize_planes_list(data: PlanesList) -> List[object]:
  return [serialize_plane(item) for item in data]

@dataclass
class PositionMap:
  """The position in 3D space"""
  jointAngles: Union[JointAnglesArray, None] = None
  pose: Union[PositionPose, None] = None

  def validate_jointAngles(self, value: JointAnglesArray) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, float) for x in value)):
      return [False, "jointAngles must be of type JointAnglesArray for PositionMap, got " + type(value).__name__]

    return [True, ""]

  def validate_pose(self, value: PositionPose) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, PositionPose):
      return [False, "pose must be of type PositionPose for PositionMap, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_jointAngles(self.jointAngles)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_pose(self.pose)
    if not is_valid:
      raise TypeError(error_str)

def parse_position_map(data: object):
  return PositionMap(
    jointAngles=parse_joint_angles_array(data["jointAngles"]) if "jointAngles" in data and data.get("jointAngles") is not None else None,
    pose=parse_position_pose(data["pose"]) if "pose" in data and data.get("pose") is not None else None,
  )

def serialize_position_map(data: PositionMap) -> object:
  return {
    "jointAngles": None if data.jointAngles is None else serialize_joint_angles_array(data.jointAngles),
    "pose": None if data.pose is None else serialize_position_pose(data.pose),
  }

@dataclass
class Orientation:
  """Orientation of an object in 3D space"""
  kind: Union[OrientationKindEnum, None] = None
  quaternion: Union[Quaternion, None] = None

  def validate_kind(self, value: OrientationKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for Orientation"]

    if not ((isinstance(value, str) and OrientationKindEnum in ['quaternion']) or isinstance(value, OrientationKindEnum)):
      return [False, "kind must be of type OrientationKindEnum for Orientation, got " + type(value).__name__]

    return [True, ""]

  def validate_quaternion(self, value: Quaternion) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, Quaternion):
      return [False, "quaternion must be of type Quaternion for Orientation, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_quaternion(self.quaternion)
    if not is_valid:
      raise TypeError(error_str)

def parse_orientation(data: object):
  return Orientation(
    kind=parse_orientation_kind_enum(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    quaternion=parse_quaternion(data["quaternion"]) if "quaternion" in data and data.get("quaternion") is not None else None,
  )

def serialize_orientation(data: Orientation) -> object:
  return {
    "kind": serialize_orientation_kind_enum(data.kind),
    "quaternion": None if data.quaternion is None else serialize_quaternion(data.quaternion),
  }

@dataclass
class FailureStateDetails:
  """Failure state details."""
  failure_trace_id: Union[str, None] = None
  kind: Union[str, None] = None
  failed_step: Union[str, None] = None
  reason: Union[str, None] = None
  recovery_type: Union[RecoveryTypeEnum, None] = None
  is_recoverable_with_wrist_button: Union[bool, None] = None

  def validate_failure_trace_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "failure_trace_id must be of type str for FailureStateDetails, got " + type(value).__name__]

    return [True, ""]

  def validate_kind(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "kind must be of type str for FailureStateDetails, got " + type(value).__name__]

    return [True, ""]

  def validate_failed_step(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "failed_step must be of type str for FailureStateDetails, got " + type(value).__name__]

    return [True, ""]

  def validate_reason(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "reason must be of type str for FailureStateDetails, got " + type(value).__name__]

    return [True, ""]

  def validate_recovery_type(self, value: RecoveryTypeEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and RecoveryTypeEnum in ['Recoverable', 'NotRecoverable', 'Restart', 'GuidedMode', 'ManualRecoveryMode']) or isinstance(value, RecoveryTypeEnum)):
      return [False, "recovery_type must be of type RecoveryTypeEnum for FailureStateDetails, got " + type(value).__name__]

    return [True, ""]

  def validate_is_recoverable_with_wrist_button(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "is_recoverable_with_wrist_button must be of type bool for FailureStateDetails, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_failure_trace_id(self.failure_trace_id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_failed_step(self.failed_step)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_reason(self.reason)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_recovery_type(self.recovery_type)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_is_recoverable_with_wrist_button(self.is_recoverable_with_wrist_button)
    if not is_valid:
      raise TypeError(error_str)

def parse_failure_state_details(data: object):
  return FailureStateDetails(
    failure_trace_id=parse_str(data["failure_trace_id"]) if "failure_trace_id" in data and data.get("failure_trace_id") is not None else None,
    kind=parse_str(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    failed_step=parse_str(data["failed_step"]) if "failed_step" in data and data.get("failed_step") is not None else None,
    reason=parse_str(data["reason"]) if "reason" in data and data.get("reason") is not None else None,
    recovery_type=parse_recovery_type_enum(data["recovery_type"]) if "recovery_type" in data and data.get("recovery_type") is not None else None,
    is_recoverable_with_wrist_button=parse_bool(data["is_recoverable_with_wrist_button"]) if "is_recoverable_with_wrist_button" in data and data.get("is_recoverable_with_wrist_button") is not None else None,
  )

def serialize_failure_state_details(data: FailureStateDetails) -> object:
  return {
    "failure_trace_id": None if data.failure_trace_id is None else serialize_str(data.failure_trace_id),
    "kind": None if data.kind is None else serialize_str(data.kind),
    "failed_step": None if data.failed_step is None else serialize_str(data.failed_step),
    "reason": None if data.reason is None else serialize_str(data.reason),
    "recovery_type": None if data.recovery_type is None else serialize_recovery_type_enum(data.recovery_type),
    "is_recoverable_with_wrist_button": None if data.is_recoverable_with_wrist_button is None else serialize_bool(data.is_recoverable_with_wrist_button),
  }

@dataclass
class RobotControlMode:
  """Definition of Robot Control State, which tells you which service or system is controlling the Robot"""
  kind: Union[RobotControlModeEnum, None] = None

  def validate_kind(self, value: RobotControlModeEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and RobotControlModeEnum in ['api', 'routine_editor']) or isinstance(value, RobotControlModeEnum)):
      return [False, "kind must be of type RobotControlModeEnum for RobotControlMode, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)

def parse_robot_control_mode(data: object):
  return RobotControlMode(
    kind=parse_robot_control_mode_enum(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
  )

def serialize_robot_control_mode(data: RobotControlMode) -> object:
  return {
    "kind": None if data.kind is None else serialize_robot_control_mode_enum(data.kind),
  }

@dataclass
class ROSControlStateResponse:
  """Response to a query for the current state of ROS control."""
  state: Union[ROSControlStateEnum, None] = None

  def validate_state(self, value: ROSControlStateEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ROSControlStateEnum in ['enabled', 'disabled']) or isinstance(value, ROSControlStateEnum)):
      return [False, "state must be of type ROSControlStateEnum for ROSControlStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_state(self.state)
    if not is_valid:
      raise TypeError(error_str)

def parse_ros_control_state_response(data: object):
  return ROSControlStateResponse(
    state=parse_ros_control_state_enum(data["state"]) if "state" in data and data.get("state") is not None else None,
  )

def serialize_ros_control_state_response(data: ROSControlStateResponse) -> object:
  return {
    "state": None if data.state is None else serialize_ros_control_state_enum(data.state),
  }

@dataclass
class ROSControlUpdateRequest:
  """Request to update the state of direct ROS control."""
  action: Union[ROSControlStateEnum, None] = None

  def validate_action(self, value: ROSControlStateEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ROSControlStateEnum in ['enabled', 'disabled']) or isinstance(value, ROSControlStateEnum)):
      return [False, "action must be of type ROSControlStateEnum for ROSControlUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_action(self.action)
    if not is_valid:
      raise TypeError(error_str)

def parse_ros_control_update_request(data: object):
  return ROSControlUpdateRequest(
    action=parse_ros_control_state_enum(data["action"]) if "action" in data and data.get("action") is not None else None,
  )

def serialize_ros_control_update_request(data: ROSControlUpdateRequest) -> object:
  return {
    "action": None if data.action is None else serialize_ros_control_state_enum(data.action),
  }

@dataclass
class RoutineStepVariablesResponse:
  """Step variables from the routine."""
  variables: Union[RoutineStepVariablesData, None] = None
  step_id_map: Union[RoutineStepVariablesIdMap, None] = None

  def validate_variables(self, value: RoutineStepVariablesData) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, dict) and all((isinstance(k, str) and isinstance(val, str)) for k, val in value.items())):
      return [False, "variables must be of type RoutineStepVariablesData for RoutineStepVariablesResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_step_id_map(self, value: RoutineStepVariablesIdMap) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, dict) and all((isinstance(k, str) and isinstance(val, str)) for k, val in value.items())):
      return [False, "step_id_map must be of type RoutineStepVariablesIdMap for RoutineStepVariablesResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_variables(self.variables)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_step_id_map(self.step_id_map)
    if not is_valid:
      raise TypeError(error_str)

def parse_routine_step_variables_response(data: object):
  return RoutineStepVariablesResponse(
    variables=parse_routine_step_variables_data(data["variables"]) if "variables" in data and data.get("variables") is not None else None,
    step_id_map=parse_routine_step_variables_id_map(data["step_id_map"]) if "step_id_map" in data and data.get("step_id_map") is not None else None,
  )

def serialize_routine_step_variables_response(data: RoutineStepVariablesResponse) -> object:
  return {
    "variables": None if data.variables is None else serialize_routine_step_variables_data(data.variables),
    "step_id_map": None if data.step_id_map is None else serialize_routine_step_variables_id_map(data.step_id_map),
  }

@dataclass
class PlayRoutineRequest:
  """Request to play a routine"""
  variables: Union[RoutineVariablesStateMap, None] = None

  def validate_variables(self, value: RoutineVariablesStateMap) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, dict) and all((isinstance(k, str) and isinstance(val, str)) for k, val in value.items())):
      return [False, "variables must be of type RoutineVariablesStateMap for PlayRoutineRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_variables(self.variables)
    if not is_valid:
      raise TypeError(error_str)

def parse_play_routine_request(data: object):
  return PlayRoutineRequest(
    variables=parse_routine_variables_state_map(data["variables"]) if "variables" in data and data.get("variables") is not None else None,
  )

def serialize_play_routine_request(data: PlayRoutineRequest) -> object:
  return {
    "variables": None if data.variables is None else serialize_routine_variables_state_map(data.variables),
  }

SensorsList = List[Sensor]

def parse_sensors_list(data: object) -> SensorsList:
  return [parse_sensor(item) for item in data]

def serialize_sensors_list(data: SensorsList) -> List[object]:
  return [serialize_sensor(item) for item in data]

@dataclass
class TextToSkillRequest:
  """Request to convert text to a skill."""
  text: Union[str, None] = None
  skills: Union[SkillsList, None] = None

  def validate_text(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "text must be of type str for TextToSkillRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_skills(self, value: SkillsList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, str) for x in value)):
      return [False, "skills must be of type SkillsList for TextToSkillRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_text(self.text)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_skills(self.skills)
    if not is_valid:
      raise TypeError(error_str)

def parse_text_to_skill_request(data: object):
  return TextToSkillRequest(
    text=parse_str(data["text"]) if "text" in data and data.get("text") is not None else None,
    skills=parse_skills_list(data["skills"]) if "skills" in data and data.get("skills") is not None else None,
  )

def serialize_text_to_skill_request(data: TextToSkillRequest) -> object:
  return {
    "text": None if data.text is None else serialize_str(data.text),
    "skills": None if data.skills is None else serialize_skills_list(data.skills),
  }

@dataclass
class StatusHealthResponse:
  """Status Health Response"""
  health: Union[StatusHealthEnum, None] = None
  build: Union[StatusVersionData, None] = None

  def validate_health(self, value: StatusHealthEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and StatusHealthEnum in ['ok', 'warning', 'error']) or isinstance(value, StatusHealthEnum)):
      return [False, "health must be of type StatusHealthEnum for StatusHealthResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_build(self, value: StatusVersionData) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, StatusVersionData):
      return [False, "build must be of type StatusVersionData for StatusHealthResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_health(self.health)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_build(self.build)
    if not is_valid:
      raise TypeError(error_str)

def parse_status_health_response(data: object):
  return StatusHealthResponse(
    health=parse_status_health_enum(data["health"]) if "health" in data and data.get("health") is not None else None,
    build=parse_status_version_data(data["build"]) if "build" in data and data.get("build") is not None else None,
  )

def serialize_status_health_response(data: StatusHealthResponse) -> object:
  return {
    "health": None if data.health is None else serialize_status_health_enum(data.health),
    "build": None if data.build is None else serialize_status_version_data(data.build),
  }

@dataclass
class ArmPositionUpdateRequestResponseEventStreamDetails:
  """Specify how the response should be sent
"""
  subscriptions: Union[ArmPositionUpdateRequestResponseEventStreamSubscriptionsList, None] = None

  def validate_subscriptions(self, value: ArmPositionUpdateRequestResponseEventStreamSubscriptionsList) -> Tuple[bool, str]:
    if value is None:
      return [False, "subscriptions is required for ArmPositionUpdateRequestResponseEventStreamDetails"]

    if not (isinstance(value, list) and all(((isinstance(x, str) and ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum in ['all', 'events', 'positions']) or isinstance(x, ArmPositionUpdateRequestResponseEventStreamSubscriptionKindEnum)) for x in value)):
      return [False, "subscriptions must be of type ArmPositionUpdateRequestResponseEventStreamSubscriptionsList for ArmPositionUpdateRequestResponseEventStreamDetails, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_subscriptions(self.subscriptions)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_request_response_event_stream_details(data: object):
  return ArmPositionUpdateRequestResponseEventStreamDetails(
    subscriptions=parse_arm_position_update_request_response_event_stream_subscriptions_list(data["subscriptions"]) if "subscriptions" in data and data.get("subscriptions") is not None else None,
  )

def serialize_arm_position_update_request_response_event_stream_details(data: ArmPositionUpdateRequestResponseEventStreamDetails) -> object:
  return {
    "subscriptions": serialize_arm_position_update_request_response_event_stream_subscriptions_list(data.subscriptions),
  }

@dataclass
class JointsStateResponse:
  """Response to a query for the current state of the joints"""
  J0: Union[JointState, None] = None
  J1: Union[JointState, None] = None
  J2: Union[JointState, None] = None
  J3: Union[JointState, None] = None
  J4: Union[JointState, None] = None
  J5: Union[JointState, None] = None

  def validate_J0(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J0 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J1(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J1 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J2(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J2 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J3(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J3 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J4(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J4 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_J5(self, value: JointState) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, JointState):
      return [False, "J5 must be of type JointState for JointsStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_J0(self.J0)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J1(self.J1)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J2(self.J2)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J3(self.J3)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J4(self.J4)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_J5(self.J5)
    if not is_valid:
      raise TypeError(error_str)

def parse_joints_state_response(data: object):
  return JointsStateResponse(
    J0=parse_joint_state(data["J0"]) if "J0" in data and data.get("J0") is not None else None,
    J1=parse_joint_state(data["J1"]) if "J1" in data and data.get("J1") is not None else None,
    J2=parse_joint_state(data["J2"]) if "J2" in data and data.get("J2") is not None else None,
    J3=parse_joint_state(data["J3"]) if "J3" in data and data.get("J3") is not None else None,
    J4=parse_joint_state(data["J4"]) if "J4" in data and data.get("J4") is not None else None,
    J5=parse_joint_state(data["J5"]) if "J5" in data and data.get("J5") is not None else None,
  )

def serialize_joints_state_response(data: JointsStateResponse) -> object:
  return {
    "J0": None if data.J0 is None else serialize_joint_state(data.J0),
    "J1": None if data.J1 is None else serialize_joint_state(data.J1),
    "J2": None if data.J2 is None else serialize_joint_state(data.J2),
    "J3": None if data.J3 is None else serialize_joint_state(data.J3),
    "J4": None if data.J4 is None else serialize_joint_state(data.J4),
    "J5": None if data.J5 is None else serialize_joint_state(data.J5),
  }

@dataclass
class Routine:
  """Robot Routine containing steps to automate robot movement and operations"""
  id: Union[str, None] = None
  name: Union[str, None] = None
  environment_variables: Union[EnvironmentVariablesList, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "id must be of type str for Routine, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for Routine, got " + type(value).__name__]

    return [True, ""]

  def validate_environment_variables(self, value: EnvironmentVariablesList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, EnvironmentVariable) for x in value)):
      return [False, "environment_variables must be of type EnvironmentVariablesList for Routine, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_environment_variables(self.environment_variables)
    if not is_valid:
      raise TypeError(error_str)

def parse_routine(data: object):
  return Routine(
    id=parse_str(data["id"]) if "id" in data and data.get("id") is not None else None,
    name=parse_str(data["name"]) if "name" in data and data.get("name") is not None else None,
    environment_variables=parse_environment_variables_list(data["environment_variables"]) if "environment_variables" in data and data.get("environment_variables") is not None else None,
  )

def serialize_routine(data: Routine) -> object:
  return {
    "id": None if data.id is None else serialize_str(data.id),
    "name": None if data.name is None else serialize_str(data.name),
    "environment_variables": None if data.environment_variables is None else serialize_environment_variables_list(data.environment_variables),
  }

ArmJointRotationsList = List[ArmJointRotations]

def parse_arm_joint_rotations_list(data: object) -> ArmJointRotationsList:
  return [parse_arm_joint_rotations(item) for item in data]

def serialize_arm_joint_rotations_list(data: ArmJointRotationsList) -> List[object]:
  return [serialize_arm_joint_rotations(item) for item in data]

@dataclass
class OnRobot2FG14GripperCommandRequest:
  """Control the OnRobot 2FG14 gripper (end effector) of the robot
"""
  grip_direction: Union[LinearGripDirectionEnum, None] = None
  target_force: Union[ForceUnit, None] = None
  target_grip_width: Union[LinearUnit, None] = None
  control_kind: Union[OnRobot2FG14ControlKindEnum, None] = None

  def validate_grip_direction(self, value: LinearGripDirectionEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "grip_direction is required for OnRobot2FG14GripperCommandRequest"]

    if not ((isinstance(value, str) and LinearGripDirectionEnum in ['inward', 'outward']) or isinstance(value, LinearGripDirectionEnum)):
      return [False, "grip_direction must be of type LinearGripDirectionEnum for OnRobot2FG14GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: ForceUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ForceUnit):
      return [False, "target_force must be of type ForceUnit for OnRobot2FG14GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_grip_width(self, value: LinearUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, LinearUnit):
      return [False, "target_grip_width must be of type LinearUnit for OnRobot2FG14GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_control_kind(self, value: OnRobot2FG14ControlKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "control_kind is required for OnRobot2FG14GripperCommandRequest"]

    if not ((isinstance(value, str) and OnRobot2FG14ControlKindEnum in ['move', 'force_grip']) or isinstance(value, OnRobot2FG14ControlKindEnum)):
      return [False, "control_kind must be of type OnRobot2FG14ControlKindEnum for OnRobot2FG14GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_grip_direction(self.grip_direction)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_grip_width(self.target_grip_width)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_control_kind(self.control_kind)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_2_fg_14_gripper_command_request(data: object):
  return OnRobot2FG14GripperCommandRequest(
    grip_direction=parse_linear_grip_direction_enum(data["grip_direction"]) if "grip_direction" in data and data.get("grip_direction") is not None else None,
    target_force=parse_force_unit(data["target_force"]) if "target_force" in data and data.get("target_force") is not None else None,
    target_grip_width=parse_linear_unit(data["target_grip_width"]) if "target_grip_width" in data and data.get("target_grip_width") is not None else None,
    control_kind=parse_on_robot_2_fg_14_control_kind_enum(data["control_kind"]) if "control_kind" in data and data.get("control_kind") is not None else None,
  )

def serialize_on_robot_2_fg_14_gripper_command_request(data: OnRobot2FG14GripperCommandRequest) -> object:
  return {
    "grip_direction": serialize_linear_grip_direction_enum(data.grip_direction),
    "target_force": None if data.target_force is None else serialize_force_unit(data.target_force),
    "target_grip_width": None if data.target_grip_width is None else serialize_linear_unit(data.target_grip_width),
    "control_kind": serialize_on_robot_2_fg_14_control_kind_enum(data.control_kind),
  }

@dataclass
class OnRobot2FG7GripperCommandRequest:
  """Control the OnRobot 2FG7 gripper (end effector) of the robot
"""
  grip_direction: Union[LinearGripDirectionEnum, None] = None
  target_force: Union[ForceUnit, None] = None
  target_grip_width: Union[LinearUnit, None] = None
  control_kind: Union[OnRobot2FG7ControlKindEnum, None] = None

  def validate_grip_direction(self, value: LinearGripDirectionEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "grip_direction is required for OnRobot2FG7GripperCommandRequest"]

    if not ((isinstance(value, str) and LinearGripDirectionEnum in ['inward', 'outward']) or isinstance(value, LinearGripDirectionEnum)):
      return [False, "grip_direction must be of type LinearGripDirectionEnum for OnRobot2FG7GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: ForceUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ForceUnit):
      return [False, "target_force must be of type ForceUnit for OnRobot2FG7GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_grip_width(self, value: LinearUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, LinearUnit):
      return [False, "target_grip_width must be of type LinearUnit for OnRobot2FG7GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_control_kind(self, value: OnRobot2FG7ControlKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "control_kind is required for OnRobot2FG7GripperCommandRequest"]

    if not ((isinstance(value, str) and OnRobot2FG7ControlKindEnum in ['move', 'force_grip']) or isinstance(value, OnRobot2FG7ControlKindEnum)):
      return [False, "control_kind must be of type OnRobot2FG7ControlKindEnum for OnRobot2FG7GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_grip_direction(self.grip_direction)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_grip_width(self.target_grip_width)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_control_kind(self.control_kind)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_2_fg_7_gripper_command_request(data: object):
  return OnRobot2FG7GripperCommandRequest(
    grip_direction=parse_linear_grip_direction_enum(data["grip_direction"]) if "grip_direction" in data and data.get("grip_direction") is not None else None,
    target_force=parse_force_unit(data["target_force"]) if "target_force" in data and data.get("target_force") is not None else None,
    target_grip_width=parse_linear_unit(data["target_grip_width"]) if "target_grip_width" in data and data.get("target_grip_width") is not None else None,
    control_kind=parse_on_robot_2_fg_7_control_kind_enum(data["control_kind"]) if "control_kind" in data and data.get("control_kind") is not None else None,
  )

def serialize_on_robot_2_fg_7_gripper_command_request(data: OnRobot2FG7GripperCommandRequest) -> object:
  return {
    "grip_direction": serialize_linear_grip_direction_enum(data.grip_direction),
    "target_force": None if data.target_force is None else serialize_force_unit(data.target_force),
    "target_grip_width": None if data.target_grip_width is None else serialize_linear_unit(data.target_grip_width),
    "control_kind": serialize_on_robot_2_fg_7_control_kind_enum(data.control_kind),
  }

@dataclass
class OnRobot3FG15GripperCommandRequest:
  """Control the OnRobot 3FG15 gripper (end effector) of the robot
"""
  grip_direction: Union[LinearGripDirectionEnum, None] = None
  target_force: Union[ForceUnit, None] = None
  target_grip_diameter: Union[LinearUnit, None] = None
  control_kind: Union[OnRobot3FG15ControlKindEnum, None] = None

  def validate_grip_direction(self, value: LinearGripDirectionEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "grip_direction is required for OnRobot3FG15GripperCommandRequest"]

    if not ((isinstance(value, str) and LinearGripDirectionEnum in ['inward', 'outward']) or isinstance(value, LinearGripDirectionEnum)):
      return [False, "grip_direction must be of type LinearGripDirectionEnum for OnRobot3FG15GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_force(self, value: ForceUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ForceUnit):
      return [False, "target_force must be of type ForceUnit for OnRobot3FG15GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_target_grip_diameter(self, value: LinearUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, LinearUnit):
      return [False, "target_grip_diameter must be of type LinearUnit for OnRobot3FG15GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_control_kind(self, value: OnRobot3FG15ControlKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "control_kind is required for OnRobot3FG15GripperCommandRequest"]

    if not ((isinstance(value, str) and OnRobot3FG15ControlKindEnum in ['move', 'force_grip', 'flexible_force_grip']) or isinstance(value, OnRobot3FG15ControlKindEnum)):
      return [False, "control_kind must be of type OnRobot3FG15ControlKindEnum for OnRobot3FG15GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_grip_direction(self.grip_direction)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_force(self.target_force)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_target_grip_diameter(self.target_grip_diameter)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_control_kind(self.control_kind)
    if not is_valid:
      raise TypeError(error_str)

def parse_on_robot_3_fg_15_gripper_command_request(data: object):
  return OnRobot3FG15GripperCommandRequest(
    grip_direction=parse_linear_grip_direction_enum(data["grip_direction"]) if "grip_direction" in data and data.get("grip_direction") is not None else None,
    target_force=parse_force_unit(data["target_force"]) if "target_force" in data and data.get("target_force") is not None else None,
    target_grip_diameter=parse_linear_unit(data["target_grip_diameter"]) if "target_grip_diameter" in data and data.get("target_grip_diameter") is not None else None,
    control_kind=parse_on_robot_3_fg_15_control_kind_enum(data["control_kind"]) if "control_kind" in data and data.get("control_kind") is not None else None,
  )

def serialize_on_robot_3_fg_15_gripper_command_request(data: OnRobot3FG15GripperCommandRequest) -> object:
  return {
    "grip_direction": serialize_linear_grip_direction_enum(data.grip_direction),
    "target_force": None if data.target_force is None else serialize_force_unit(data.target_force),
    "target_grip_diameter": None if data.target_grip_diameter is None else serialize_linear_unit(data.target_grip_diameter),
    "control_kind": serialize_on_robot_3_fg_15_control_kind_enum(data.control_kind),
  }

@dataclass
class SchunkEGxGripperCommandRequest:
  """Control the Schunk EGU / EGK  gripper (end effector) of the robot
"""
  target_grip_width: Union[LinearUnit, None] = None
  control_kind: Union[SchunkEGxControlKindEnum, None] = None

  def validate_target_grip_width(self, value: LinearUnit) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, LinearUnit):
      return [False, "target_grip_width must be of type LinearUnit for SchunkEGxGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_control_kind(self, value: SchunkEGxControlKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "control_kind is required for SchunkEGxGripperCommandRequest"]

    if not ((isinstance(value, str) and SchunkEGxControlKindEnum in ['move']) or isinstance(value, SchunkEGxControlKindEnum)):
      return [False, "control_kind must be of type SchunkEGxControlKindEnum for SchunkEGxGripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_target_grip_width(self.target_grip_width)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_control_kind(self.control_kind)
    if not is_valid:
      raise TypeError(error_str)

def parse_schunk_e_gx_gripper_command_request(data: object):
  return SchunkEGxGripperCommandRequest(
    target_grip_width=parse_linear_unit(data["target_grip_width"]) if "target_grip_width" in data and data.get("target_grip_width") is not None else None,
    control_kind=parse_schunk_e_gx_control_kind_enum(data["control_kind"]) if "control_kind" in data and data.get("control_kind") is not None else None,
  )

def serialize_schunk_e_gx_gripper_command_request(data: SchunkEGxGripperCommandRequest) -> object:
  return {
    "target_grip_width": None if data.target_grip_width is None else serialize_linear_unit(data.target_grip_width),
    "control_kind": serialize_schunk_e_gx_control_kind_enum(data.control_kind),
  }

@dataclass
class GripperConfiguration:
  """Configuration of gripper, also known as End Effector"""
  kind: Union[GripperKindEnum, None] = None
  onrobot_2fg7: Union[OnRobot2FG7GripperConfiguration, None] = None
  onrobot_2fg14: Union[OnRobot2FG14GripperConfiguration, None] = None
  onrobot_3fg15: Union[OnRobot3FG15GripperConfiguration, None] = None
  onrobot_screwdriver: Union[OnRobotScrewdriverConfiguration, None] = None
  dh_ag: Union[DHAGGripperConfiguration, None] = None
  dh_pgc: Union[DHPGCGripperConfiguration, None] = None
  dh_cgi: Union[DHCGIGripperConfiguration, None] = None

  def validate_kind(self, value: GripperKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for GripperConfiguration"]

    if not ((isinstance(value, str) and GripperKindEnum in ['onrobot_2fg7', 'onrobot_2fg14', 'onrobot_3fg15', 'onrobot_screwdriver', 'dh_ag', 'dh_pgc', 'dh_cgi', 'schunk_egx', 'none_connected']) or isinstance(value, GripperKindEnum)):
      return [False, "kind must be of type GripperKindEnum for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_2fg7(self, value: OnRobot2FG7GripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobot2FG7GripperConfiguration):
      return [False, "onrobot_2fg7 must be of type OnRobot2FG7GripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_2fg14(self, value: OnRobot2FG14GripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobot2FG14GripperConfiguration):
      return [False, "onrobot_2fg14 must be of type OnRobot2FG14GripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_3fg15(self, value: OnRobot3FG15GripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobot3FG15GripperConfiguration):
      return [False, "onrobot_3fg15 must be of type OnRobot3FG15GripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_screwdriver(self, value: OnRobotScrewdriverConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobotScrewdriverConfiguration):
      return [False, "onrobot_screwdriver must be of type OnRobotScrewdriverConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_ag(self, value: DHAGGripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHAGGripperConfiguration):
      return [False, "dh_ag must be of type DHAGGripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_pgc(self, value: DHPGCGripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHPGCGripperConfiguration):
      return [False, "dh_pgc must be of type DHPGCGripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_cgi(self, value: DHCGIGripperConfiguration) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHCGIGripperConfiguration):
      return [False, "dh_cgi must be of type DHCGIGripperConfiguration for GripperConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_2fg7(self.onrobot_2fg7)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_2fg14(self.onrobot_2fg14)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_3fg15(self.onrobot_3fg15)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_screwdriver(self.onrobot_screwdriver)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_ag(self.dh_ag)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_pgc(self.dh_pgc)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_cgi(self.dh_cgi)
    if not is_valid:
      raise TypeError(error_str)

def parse_gripper_configuration(data: object):
  return GripperConfiguration(
    kind=parse_gripper_kind_enum(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    onrobot_2fg7=parse_on_robot_2_fg_7_gripper_configuration(data["onrobot_2fg7"]) if "onrobot_2fg7" in data and data.get("onrobot_2fg7") is not None else None,
    onrobot_2fg14=parse_on_robot_2_fg_14_gripper_configuration(data["onrobot_2fg14"]) if "onrobot_2fg14" in data and data.get("onrobot_2fg14") is not None else None,
    onrobot_3fg15=parse_on_robot_3_fg_15_gripper_configuration(data["onrobot_3fg15"]) if "onrobot_3fg15" in data and data.get("onrobot_3fg15") is not None else None,
    onrobot_screwdriver=parse_on_robot_screwdriver_configuration(data["onrobot_screwdriver"]) if "onrobot_screwdriver" in data and data.get("onrobot_screwdriver") is not None else None,
    dh_ag=parse_dhag_gripper_configuration(data["dh_ag"]) if "dh_ag" in data and data.get("dh_ag") is not None else None,
    dh_pgc=parse_dhpgc_gripper_configuration(data["dh_pgc"]) if "dh_pgc" in data and data.get("dh_pgc") is not None else None,
    dh_cgi=parse_dhcgi_gripper_configuration(data["dh_cgi"]) if "dh_cgi" in data and data.get("dh_cgi") is not None else None,
  )

def serialize_gripper_configuration(data: GripperConfiguration) -> object:
  return {
    "kind": serialize_gripper_kind_enum(data.kind),
    "onrobot_2fg7": None if data.onrobot_2fg7 is None else serialize_on_robot_2_fg_7_gripper_configuration(data.onrobot_2fg7),
    "onrobot_2fg14": None if data.onrobot_2fg14 is None else serialize_on_robot_2_fg_14_gripper_configuration(data.onrobot_2fg14),
    "onrobot_3fg15": None if data.onrobot_3fg15 is None else serialize_on_robot_3_fg_15_gripper_configuration(data.onrobot_3fg15),
    "onrobot_screwdriver": None if data.onrobot_screwdriver is None else serialize_on_robot_screwdriver_configuration(data.onrobot_screwdriver),
    "dh_ag": None if data.dh_ag is None else serialize_dhag_gripper_configuration(data.dh_ag),
    "dh_pgc": None if data.dh_pgc is None else serialize_dhpgc_gripper_configuration(data.dh_pgc),
    "dh_cgi": None if data.dh_cgi is None else serialize_dhcgi_gripper_configuration(data.dh_cgi),
  }

@dataclass
class PlanesPaginatedResponse:
  """Paginated response containing plane data"""
  items: Union[PlanesList, None] = None
  pagination: Union[Pagination, None] = None

  def validate_items(self, value: PlanesList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, Plane) for x in value)):
      return [False, "items must be of type PlanesList for PlanesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_pagination(self, value: Pagination) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, Pagination):
      return [False, "pagination must be of type Pagination for PlanesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_items(self.items)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_pagination(self.pagination)
    if not is_valid:
      raise TypeError(error_str)

def parse_planes_paginated_response(data: object):
  return PlanesPaginatedResponse(
    items=parse_planes_list(data["items"]) if "items" in data and data.get("items") is not None else None,
    pagination=parse_pagination(data["pagination"]) if "pagination" in data and data.get("pagination") is not None else None,
  )

def serialize_planes_paginated_response(data: PlanesPaginatedResponse) -> object:
  return {
    "items": None if data.items is None else serialize_planes_list(data.items),
    "pagination": None if data.pagination is None else serialize_pagination(data.pagination),
  }

SpacePositionsMap = List[PositionMap]

def parse_space_positions_map(data: object) -> SpacePositionsMap:
  return [parse_position_map(item) for item in data]

def serialize_space_positions_map(data: SpacePositionsMap) -> List[object]:
  return [serialize_position_map(item) for item in data]

@dataclass
class PositionAndOrientation:
  """Position of the arm tooltip"""
  axis_alignment: Union[str, None] = None
  reference_frame: Union[str, None] = None
  local_accuracy_calibration: Union[str, None] = None
  position: Union[Position, None] = None
  orientation: Union[Orientation, None] = None

  def validate_axis_alignment(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "axis_alignment must be of type str for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def validate_reference_frame(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "reference_frame must be of type str for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def validate_local_accuracy_calibration(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "local_accuracy_calibration must be of type str for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def validate_position(self, value: Position) -> Tuple[bool, str]:
    if value is None:
      return [False, "position is required for PositionAndOrientation"]

    if not isinstance(value, Position):
      return [False, "position must be of type Position for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def validate_orientation(self, value: Orientation) -> Tuple[bool, str]:
    if value is None:
      return [False, "orientation is required for PositionAndOrientation"]

    if not isinstance(value, Orientation):
      return [False, "orientation must be of type Orientation for PositionAndOrientation, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_axis_alignment(self.axis_alignment)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_reference_frame(self.reference_frame)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_local_accuracy_calibration(self.local_accuracy_calibration)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_position(self.position)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_orientation(self.orientation)
    if not is_valid:
      raise TypeError(error_str)

def parse_position_and_orientation(data: object):
  return PositionAndOrientation(
    axis_alignment=parse_str(data["axis_alignment"]) if "axis_alignment" in data and data.get("axis_alignment") is not None else None,
    reference_frame=parse_str(data["reference_frame"]) if "reference_frame" in data and data.get("reference_frame") is not None else None,
    local_accuracy_calibration=parse_str(data["local_accuracy_calibration"]) if "local_accuracy_calibration" in data and data.get("local_accuracy_calibration") is not None else None,
    position=parse_position(data["position"]) if "position" in data and data.get("position") is not None else None,
    orientation=parse_orientation(data["orientation"]) if "orientation" in data and data.get("orientation") is not None else None,
  )

def serialize_position_and_orientation(data: PositionAndOrientation) -> object:
  return {
    "axis_alignment": None if data.axis_alignment is None else serialize_str(data.axis_alignment),
    "reference_frame": None if data.reference_frame is None else serialize_str(data.reference_frame),
    "local_accuracy_calibration": None if data.local_accuracy_calibration is None else serialize_str(data.local_accuracy_calibration),
    "position": serialize_position(data.position),
    "orientation": serialize_orientation(data.orientation),
  }

@dataclass
class FailureStateResponse:
  """Failure state response informs user of how and whether the robot may be recovered."""
  status: Union[RobotStatusEnum, None] = None
  failed: Union[bool, None] = None
  failure: Union[FailureStateDetails, None] = None

  def validate_status(self, value: RobotStatusEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and RobotStatusEnum in ['Idle', 'RunningAdHocCommand', 'RoutineRunning', 'Antigravity', 'AntigravitySlow', 'Failure', 'Recovering']) or isinstance(value, RobotStatusEnum)):
      return [False, "status must be of type RobotStatusEnum for FailureStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_failed(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "failed must be of type bool for FailureStateResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_failure(self, value: FailureStateDetails) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, FailureStateDetails):
      return [False, "failure must be of type FailureStateDetails for FailureStateResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_status(self.status)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_failed(self.failed)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_failure(self.failure)
    if not is_valid:
      raise TypeError(error_str)

def parse_failure_state_response(data: object):
  return FailureStateResponse(
    status=parse_robot_status_enum(data["status"]) if "status" in data and data.get("status") is not None else None,
    failed=parse_bool(data["failed"]) if "failed" in data and data.get("failed") is not None else None,
    failure=parse_failure_state_details(data["failure"]) if "failure" in data and data.get("failure") is not None else None,
  )

def serialize_failure_state_response(data: FailureStateResponse) -> object:
  return {
    "status": None if data.status is None else serialize_robot_status_enum(data.status),
    "failed": None if data.failed is None else serialize_bool(data.failed),
    "failure": None if data.failure is None else serialize_failure_state_details(data.failure),
  }

@dataclass
class SensorsConfiguration:
  """Configuration of all sensors defined in custom equipment"""
  sensors: Union[SensorsList, None] = None

  def validate_sensors(self, value: SensorsList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, Sensor) for x in value)):
      return [False, "sensors must be of type SensorsList for SensorsConfiguration, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_sensors(self.sensors)
    if not is_valid:
      raise TypeError(error_str)

def parse_sensors_configuration(data: object):
  return SensorsConfiguration(
    sensors=parse_sensors_list(data["sensors"]) if "sensors" in data and data.get("sensors") is not None else None,
  )

def serialize_sensors_configuration(data: SensorsConfiguration) -> object:
  return {
    "sensors": None if data.sensors is None else serialize_sensors_list(data.sensors),
  }

@dataclass
class ArmPositionUpdateRequestResponseFormat:
  """Specify how the response should be sent
"""
  kind: Union[ArmPositionUpdateRequestResponseKindEnum, None] = None
  event_stream: Union[ArmPositionUpdateRequestResponseEventStreamDetails, None] = None

  def validate_kind(self, value: ArmPositionUpdateRequestResponseKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ArmPositionUpdateRequestResponseKindEnum in ['sync', 'event_stream']) or isinstance(value, ArmPositionUpdateRequestResponseKindEnum)):
      return [False, "kind must be of type ArmPositionUpdateRequestResponseKindEnum for ArmPositionUpdateRequestResponseFormat, got " + type(value).__name__]

    return [True, ""]

  def validate_event_stream(self, value: ArmPositionUpdateRequestResponseEventStreamDetails) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmPositionUpdateRequestResponseEventStreamDetails):
      return [False, "event_stream must be of type ArmPositionUpdateRequestResponseEventStreamDetails for ArmPositionUpdateRequestResponseFormat, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_event_stream(self.event_stream)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_request_response_format(data: object):
  return ArmPositionUpdateRequestResponseFormat(
    kind=parse_arm_position_update_request_response_kind_enum(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    event_stream=parse_arm_position_update_request_response_event_stream_details(data["event_stream"]) if "event_stream" in data and data.get("event_stream") is not None else None,
  )

def serialize_arm_position_update_request_response_format(data: ArmPositionUpdateRequestResponseFormat) -> object:
  return {
    "kind": None if data.kind is None else serialize_arm_position_update_request_response_kind_enum(data.kind),
    "event_stream": None if data.event_stream is None else serialize_arm_position_update_request_response_event_stream_details(data.event_stream),
  }

RoutinesList = List[Routine]

def parse_routines_list(data: object) -> RoutinesList:
  return [parse_routine(item) for item in data]

def serialize_routines_list(data: RoutinesList) -> List[object]:
  return [serialize_routine(item) for item in data]

@dataclass
class GripperCommandRequest:
  """Control the gripper (end effector) of the robot
"""
  kind: Union[GripperKindEnum, None] = None
  onrobot_2fg7: Union[OnRobot2FG7GripperCommandRequest, None] = None
  onrobot_2fg14: Union[OnRobot2FG14GripperCommandRequest, None] = None
  onrobot_3fg15: Union[OnRobot3FG15GripperCommandRequest, None] = None
  dh_ag: Union[DHAGGripperCommandRequest, None] = None
  dh_pgc: Union[DHPGCGripperCommandRequest, None] = None
  dh_cgi: Union[DHCGIGripperCommandRequest, None] = None
  schunk_egx: Union[SchunkEGxGripperCommandRequest, None] = None

  def validate_kind(self, value: GripperKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for GripperCommandRequest"]

    if not ((isinstance(value, str) and GripperKindEnum in ['onrobot_2fg7', 'onrobot_2fg14', 'onrobot_3fg15', 'onrobot_screwdriver', 'dh_ag', 'dh_pgc', 'dh_cgi', 'schunk_egx', 'none_connected']) or isinstance(value, GripperKindEnum)):
      return [False, "kind must be of type GripperKindEnum for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_2fg7(self, value: OnRobot2FG7GripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobot2FG7GripperCommandRequest):
      return [False, "onrobot_2fg7 must be of type OnRobot2FG7GripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_2fg14(self, value: OnRobot2FG14GripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobot2FG14GripperCommandRequest):
      return [False, "onrobot_2fg14 must be of type OnRobot2FG14GripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_onrobot_3fg15(self, value: OnRobot3FG15GripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, OnRobot3FG15GripperCommandRequest):
      return [False, "onrobot_3fg15 must be of type OnRobot3FG15GripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_ag(self, value: DHAGGripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHAGGripperCommandRequest):
      return [False, "dh_ag must be of type DHAGGripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_pgc(self, value: DHPGCGripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHPGCGripperCommandRequest):
      return [False, "dh_pgc must be of type DHPGCGripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_dh_cgi(self, value: DHCGIGripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, DHCGIGripperCommandRequest):
      return [False, "dh_cgi must be of type DHCGIGripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_schunk_egx(self, value: SchunkEGxGripperCommandRequest) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, SchunkEGxGripperCommandRequest):
      return [False, "schunk_egx must be of type SchunkEGxGripperCommandRequest for GripperCommandRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_2fg7(self.onrobot_2fg7)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_2fg14(self.onrobot_2fg14)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_onrobot_3fg15(self.onrobot_3fg15)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_ag(self.dh_ag)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_pgc(self.dh_pgc)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_dh_cgi(self.dh_cgi)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_schunk_egx(self.schunk_egx)
    if not is_valid:
      raise TypeError(error_str)

def parse_gripper_command_request(data: object):
  return GripperCommandRequest(
    kind=parse_gripper_kind_enum(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    onrobot_2fg7=parse_on_robot_2_fg_7_gripper_command_request(data["onrobot_2fg7"]) if "onrobot_2fg7" in data and data.get("onrobot_2fg7") is not None else None,
    onrobot_2fg14=parse_on_robot_2_fg_14_gripper_command_request(data["onrobot_2fg14"]) if "onrobot_2fg14" in data and data.get("onrobot_2fg14") is not None else None,
    onrobot_3fg15=parse_on_robot_3_fg_15_gripper_command_request(data["onrobot_3fg15"]) if "onrobot_3fg15" in data and data.get("onrobot_3fg15") is not None else None,
    dh_ag=parse_dhag_gripper_command_request(data["dh_ag"]) if "dh_ag" in data and data.get("dh_ag") is not None else None,
    dh_pgc=parse_dhpgc_gripper_command_request(data["dh_pgc"]) if "dh_pgc" in data and data.get("dh_pgc") is not None else None,
    dh_cgi=parse_dhcgi_gripper_command_request(data["dh_cgi"]) if "dh_cgi" in data and data.get("dh_cgi") is not None else None,
    schunk_egx=parse_schunk_e_gx_gripper_command_request(data["schunk_egx"]) if "schunk_egx" in data and data.get("schunk_egx") is not None else None,
  )

def serialize_gripper_command_request(data: GripperCommandRequest) -> object:
  return {
    "kind": serialize_gripper_kind_enum(data.kind),
    "onrobot_2fg7": None if data.onrobot_2fg7 is None else serialize_on_robot_2_fg_7_gripper_command_request(data.onrobot_2fg7),
    "onrobot_2fg14": None if data.onrobot_2fg14 is None else serialize_on_robot_2_fg_14_gripper_command_request(data.onrobot_2fg14),
    "onrobot_3fg15": None if data.onrobot_3fg15 is None else serialize_on_robot_3_fg_15_gripper_command_request(data.onrobot_3fg15),
    "dh_ag": None if data.dh_ag is None else serialize_dhag_gripper_command_request(data.dh_ag),
    "dh_pgc": None if data.dh_pgc is None else serialize_dhpgc_gripper_command_request(data.dh_pgc),
    "dh_cgi": None if data.dh_cgi is None else serialize_dhcgi_gripper_command_request(data.dh_cgi),
    "schunk_egx": None if data.schunk_egx is None else serialize_schunk_e_gx_gripper_command_request(data.schunk_egx),
  }

@dataclass
class Space:
  """Space in 3D space"""
  id: Union[str, None] = None
  kind: Union[str, None] = None
  name: Union[str, None] = None
  description: Union[str, None] = None
  isGlobal: Union[bool, None] = None
  positions: Union[SpacePositionsMap, None] = None

  def validate_id(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "id must be of type str for Space, got " + type(value).__name__]

    return [True, ""]

  def validate_kind(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "kind must be of type str for Space, got " + type(value).__name__]

    return [True, ""]

  def validate_name(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "name must be of type str for Space, got " + type(value).__name__]

    return [True, ""]

  def validate_description(self, value: str) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, str):
      return [False, "description must be of type str for Space, got " + type(value).__name__]

    return [True, ""]

  def validate_isGlobal(self, value: bool) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, bool):
      return [False, "isGlobal must be of type bool for Space, got " + type(value).__name__]

    return [True, ""]

  def validate_positions(self, value: SpacePositionsMap) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, PositionMap) for x in value)):
      return [False, "positions must be of type SpacePositionsMap for Space, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_id(self.id)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_name(self.name)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_description(self.description)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_isGlobal(self.isGlobal)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_positions(self.positions)
    if not is_valid:
      raise TypeError(error_str)

def parse_space(data: object):
  return Space(
    id=parse_str(data["id"]) if "id" in data and data.get("id") is not None else None,
    kind=parse_str(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    name=parse_str(data["name"]) if "name" in data and data.get("name") is not None else None,
    description=parse_str(data["description"]) if "description" in data and data.get("description") is not None else None,
    isGlobal=parse_bool(data["isGlobal"]) if "isGlobal" in data and data.get("isGlobal") is not None else None,
    positions=parse_space_positions_map(data["positions"]) if "positions" in data and data.get("positions") is not None else None,
  )

def serialize_space(data: Space) -> object:
  return {
    "id": None if data.id is None else serialize_str(data.id),
    "kind": None if data.kind is None else serialize_str(data.kind),
    "name": None if data.name is None else serialize_str(data.name),
    "description": None if data.description is None else serialize_str(data.description),
    "isGlobal": None if data.isGlobal is None else serialize_bool(data.isGlobal),
    "positions": None if data.positions is None else serialize_space_positions_map(data.positions),
  }

@dataclass
class CombinedArmPosition:
  """Combined tooltip position and joint rotations defining the arm&#x27;s position"""
  joint_rotations: Union[JointRotations, None] = None
  tooltip_position: Union[PositionAndOrientation, None] = None

  def validate_joint_rotations(self, value: JointRotations) -> Tuple[bool, str]:
    if value is None:
      return [False, "joint_rotations is required for CombinedArmPosition"]

    if not (isinstance(value, tuple) and len(value) == 6):
      return [False, "joint_rotations must be of type JointRotations for CombinedArmPosition, got " + type(value).__name__]

    return [True, ""]

  def validate_tooltip_position(self, value: PositionAndOrientation) -> Tuple[bool, str]:
    if value is None:
      return [False, "tooltip_position is required for CombinedArmPosition"]

    if not isinstance(value, PositionAndOrientation):
      return [False, "tooltip_position must be of type PositionAndOrientation for CombinedArmPosition, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_joint_rotations(self.joint_rotations)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_tooltip_position(self.tooltip_position)
    if not is_valid:
      raise TypeError(error_str)

def parse_combined_arm_position(data: object):
  return CombinedArmPosition(
    joint_rotations=parse_joint_rotations(data["joint_rotations"]) if "joint_rotations" in data and data.get("joint_rotations") is not None else None,
    tooltip_position=parse_position_and_orientation(data["tooltip_position"]) if "tooltip_position" in data and data.get("tooltip_position") is not None else None,
  )

def serialize_combined_arm_position(data: CombinedArmPosition) -> object:
  return {
    "joint_rotations": serialize_joint_rotations(data.joint_rotations),
    "tooltip_position": serialize_position_and_orientation(data.tooltip_position),
  }

PositionAndOrientationList = List[PositionAndOrientation]

def parse_position_and_orientation_list(data: object) -> PositionAndOrientationList:
  return [parse_position_and_orientation(item) for item in data]

def serialize_position_and_orientation_list(data: PositionAndOrientationList) -> List[object]:
  return [serialize_position_and_orientation(item) for item in data]

@dataclass
class RoutinesPaginatedResponse:
  """Paginated response containing routine data"""
  items: Union[RoutinesList, None] = None
  pagination: Union[Pagination, None] = None

  def validate_items(self, value: RoutinesList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, Routine) for x in value)):
      return [False, "items must be of type RoutinesList for RoutinesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def validate_pagination(self, value: Pagination) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, Pagination):
      return [False, "pagination must be of type Pagination for RoutinesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_items(self.items)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_pagination(self.pagination)
    if not is_valid:
      raise TypeError(error_str)

def parse_routines_paginated_response(data: object):
  return RoutinesPaginatedResponse(
    items=parse_routines_list(data["items"]) if "items" in data and data.get("items") is not None else None,
    pagination=parse_pagination(data["pagination"]) if "pagination" in data and data.get("pagination") is not None else None,
  )

def serialize_routines_paginated_response(data: RoutinesPaginatedResponse) -> object:
  return {
    "items": None if data.items is None else serialize_routines_list(data.items),
    "pagination": None if data.pagination is None else serialize_pagination(data.pagination),
  }

SpacesList = List[Space]

def parse_spaces_list(data: object) -> SpacesList:
  return [parse_space(item) for item in data]

def serialize_spaces_list(data: SpacesList) -> List[object]:
  return [serialize_space(item) for item in data]

@dataclass
class ArmPositionUpdateEvent:
  """Event emitted by the move robot API"""
  kind: Union[ArmPositionUpdateKindEnum, None] = None
  failure: Union[ArmPositionUpdateFailureEvent, None] = None
  canceled: Union[ArmPositionUpdateCanceledEvent, None] = None
  position: Union[CombinedArmPosition, None] = None

  def validate_kind(self, value: ArmPositionUpdateKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and ArmPositionUpdateKindEnum in ['success', 'failure', 'canceled', 'position', 'planning']) or isinstance(value, ArmPositionUpdateKindEnum)):
      return [False, "kind must be of type ArmPositionUpdateKindEnum for ArmPositionUpdateEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_failure(self, value: ArmPositionUpdateFailureEvent) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmPositionUpdateFailureEvent):
      return [False, "failure must be of type ArmPositionUpdateFailureEvent for ArmPositionUpdateEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_canceled(self, value: ArmPositionUpdateCanceledEvent) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmPositionUpdateCanceledEvent):
      return [False, "canceled must be of type ArmPositionUpdateCanceledEvent for ArmPositionUpdateEvent, got " + type(value).__name__]

    return [True, ""]

  def validate_position(self, value: CombinedArmPosition) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, CombinedArmPosition):
      return [False, "position must be of type CombinedArmPosition for ArmPositionUpdateEvent, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_failure(self.failure)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_canceled(self.canceled)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_position(self.position)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_event(data: object):
  return ArmPositionUpdateEvent(
    kind=parse_arm_position_update_kind_enum(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    failure=parse_arm_position_update_failure_event(data["failure"]) if "failure" in data and data.get("failure") is not None else None,
    canceled=parse_arm_position_update_canceled_event(data["canceled"]) if "canceled" in data and data.get("canceled") is not None else None,
    position=parse_combined_arm_position(data["position"]) if "position" in data and data.get("position") is not None else None,
  )

def serialize_arm_position_update_event(data: ArmPositionUpdateEvent) -> object:
  return {
    "kind": None if data.kind is None else serialize_arm_position_update_kind_enum(data.kind),
    "failure": None if data.failure is None else serialize_arm_position_update_failure_event(data.failure),
    "canceled": None if data.canceled is None else serialize_arm_position_update_canceled_event(data.canceled),
    "position": None if data.position is None else serialize_combined_arm_position(data.position),
  }

@dataclass
class ArmPositionUpdateRequest:
  """Move the robot"""
  kind: Union[ArmPositionUpdateRequestKindEnum, None] = None
  tooltip_positions: Union[PositionAndOrientationList, None] = None
  tooltip_position: Union[PositionAndOrientation, None] = None
  joint_rotations: Union[ArmJointRotationsList, None] = None
  joint_rotation: Union[ArmJointRotations, None] = None
  movement_kind: Union[MovementKindEnum, None] = None
  speed_profile: Union[SpeedProfile, None] = None
  response: Union[ArmPositionUpdateRequestResponseFormat, None] = None

  def validate_kind(self, value: ArmPositionUpdateRequestKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [False, "kind is required for ArmPositionUpdateRequest"]

    if not ((isinstance(value, str) and ArmPositionUpdateRequestKindEnum in ['tooltip_positions', 'tooltip_position', 'joint_rotations', 'joint_rotation']) or isinstance(value, ArmPositionUpdateRequestKindEnum)):
      return [False, "kind must be of type ArmPositionUpdateRequestKindEnum for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_tooltip_positions(self, value: PositionAndOrientationList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, PositionAndOrientation) for x in value)):
      return [False, "tooltip_positions must be of type PositionAndOrientationList for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_tooltip_position(self, value: PositionAndOrientation) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, PositionAndOrientation):
      return [False, "tooltip_position must be of type PositionAndOrientation for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_joint_rotations(self, value: ArmJointRotationsList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, ArmJointRotations) for x in value)):
      return [False, "joint_rotations must be of type ArmJointRotationsList for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_joint_rotation(self, value: ArmJointRotations) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmJointRotations):
      return [False, "joint_rotation must be of type ArmJointRotations for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_movement_kind(self, value: MovementKindEnum) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not ((isinstance(value, str) and MovementKindEnum in ['joint', 'line']) or isinstance(value, MovementKindEnum)):
      return [False, "movement_kind must be of type MovementKindEnum for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_speed_profile(self, value: SpeedProfile) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, SpeedProfile):
      return [False, "speed_profile must be of type SpeedProfile for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def validate_response(self, value: ArmPositionUpdateRequestResponseFormat) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not isinstance(value, ArmPositionUpdateRequestResponseFormat):
      return [False, "response must be of type ArmPositionUpdateRequestResponseFormat for ArmPositionUpdateRequest, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_kind(self.kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_tooltip_positions(self.tooltip_positions)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_tooltip_position(self.tooltip_position)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_joint_rotations(self.joint_rotations)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_joint_rotation(self.joint_rotation)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_movement_kind(self.movement_kind)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_speed_profile(self.speed_profile)
    if not is_valid:
      raise TypeError(error_str)
    is_valid, error_str = self.validate_response(self.response)
    if not is_valid:
      raise TypeError(error_str)

def parse_arm_position_update_request(data: object):
  return ArmPositionUpdateRequest(
    kind=parse_arm_position_update_request_kind_enum(data["kind"]) if "kind" in data and data.get("kind") is not None else None,
    tooltip_positions=parse_position_and_orientation_list(data["tooltip_positions"]) if "tooltip_positions" in data and data.get("tooltip_positions") is not None else None,
    tooltip_position=parse_position_and_orientation(data["tooltip_position"]) if "tooltip_position" in data and data.get("tooltip_position") is not None else None,
    joint_rotations=parse_arm_joint_rotations_list(data["joint_rotations"]) if "joint_rotations" in data and data.get("joint_rotations") is not None else None,
    joint_rotation=parse_arm_joint_rotations(data["joint_rotation"]) if "joint_rotation" in data and data.get("joint_rotation") is not None else None,
    movement_kind=parse_movement_kind_enum(data["movement_kind"]) if "movement_kind" in data and data.get("movement_kind") is not None else None,
    speed_profile=parse_speed_profile(data["speed_profile"]) if "speed_profile" in data and data.get("speed_profile") is not None else None,
    response=parse_arm_position_update_request_response_format(data["response"]) if "response" in data and data.get("response") is not None else None,
  )

def serialize_arm_position_update_request(data: ArmPositionUpdateRequest) -> object:
  return {
    "kind": serialize_arm_position_update_request_kind_enum(data.kind),
    "tooltip_positions": None if data.tooltip_positions is None else serialize_position_and_orientation_list(data.tooltip_positions),
    "tooltip_position": None if data.tooltip_position is None else serialize_position_and_orientation(data.tooltip_position),
    "joint_rotations": None if data.joint_rotations is None else serialize_arm_joint_rotations_list(data.joint_rotations),
    "joint_rotation": None if data.joint_rotation is None else serialize_arm_joint_rotations(data.joint_rotation),
    "movement_kind": None if data.movement_kind is None else serialize_movement_kind_enum(data.movement_kind),
    "speed_profile": None if data.speed_profile is None else serialize_speed_profile(data.speed_profile),
    "response": None if data.response is None else serialize_arm_position_update_request_response_format(data.response),
  }

@dataclass
class SpacesPaginatedResponse:
  """Paginated response containing space data"""
  items: Union[SpacesList, None] = None

  def validate_items(self, value: SpacesList) -> Tuple[bool, str]:
    if value is None:
      return [True, ""]

    if not (isinstance(value, list) and all(isinstance(x, Space) for x in value)):
      return [False, "items must be of type SpacesList for SpacesPaginatedResponse, got " + type(value).__name__]

    return [True, ""]

  def __post_init__(self):
    # Type check incoming model - raise error if invalid (required or wrong type)
    is_valid, error_str = self.validate_items(self.items)
    if not is_valid:
      raise TypeError(error_str)

def parse_spaces_paginated_response(data: object):
  return SpacesPaginatedResponse(
    items=parse_spaces_list(data["items"]) if "items" in data and data.get("items") is not None else None,
  )

def serialize_spaces_paginated_response(data: SpacesPaginatedResponse) -> object:
  return {
    "items": None if data.items is None else serialize_spaces_list(data.items),
  }

ArmPositionUpdateEventStream = List[ArmPositionUpdateEvent]

def parse_arm_position_update_event_stream(data: object) -> ArmPositionUpdateEventStream:
  return [parse_arm_position_update_event(item) for item in data]

def serialize_arm_position_update_event_stream(data: ArmPositionUpdateEventStream) -> List[object]:
  return [serialize_arm_position_update_event(item) for item in data]

