
# Sample .XCompose file

> Link: https://github.com/Udzu/xcompose/blob/master/Compose

This repo also hosts my personal .XCompose file, which contains over 42 000 memorable compose key sequences. To use them, copy all or parts of the config into your ~/.XCompose file. You can browse the sequences either directly in the config or using the [xcompose](https://github.com/Udzu/xcompose/) utility.  Note that the shortcuts for Hangul syllables and logograms are in separate files.

The file aims for memorability and consistency. As a result, a small number of the rules here conflict with the default system rules, with workarounds given in the comments (e.g. \<underscore>'s usefulness for subscripting often interferes with its system use for macrons, for which \<minus> works equally well as an alternative).

## Table of contents and examples

### Common script characters (587)
* **Spaces** (15): NBSP MMSP ZWSP etc
* **Dashes** (12): – — ⁓ ⸻ etc
* **Brackets** (24): ⟨ ⟦ ⸨ ⌈ ⫽ etc
* **Bullets** (11): • ‣ ⁃ ◉ etc
* **General punctuation** (60): ⁁ ⁂ ⸎ etc
* **Currency symbols** (20): ₱ ₿ ₪ etc
* **Combining diacritics** (174): ń n̊ n̫ m͡n Zǎ̺̣͆̚l⃪ğ̶̍ö̱̰̥̂̃ etc
* **Control characters** (271): RLI PDI ZWJ VS16 etc

### Latin script characters (2734)
* **International Phonetic Alphabet** (128): ⫽ˈɹɛ.dɪt⫽ [aɪ̯ pʰiː eɪ̯] etc
* **Latin script letters** (513): Ƿ Ȝ ␢ ȵ etc
* **Mathematical alphanumerics** (792): 𝐀 𝐴 𝑨 A 𝗔 𝘈 𝘼 𝒜 𝓐 𝔄 𝕬 𝙰 𝔸 𜳖 etc
* **Enclosed alphanumerics** (288): ⓼ 🅛 🆛 ⒜ ⒓ etc
* **Superscripts and subscripts** (309): ᵃ ᴬ ₐ ᴀ ◌ͣ etc
* **Multigraphs and ligatures** (389): ʣ ㏈ etc
* **Letter games** (315): ʇᴉppǝɹ ɟibbɘר டωᓀᓀ·–⟝ etc

### Non-Latin script characters (32716)
* **Arabic**, Old North Arabian, Old South Arabian, Avestan, Chorasmian, Hatran, Mandaic, Manichaean, Nabatean, Old Persian, Osmanya, Inscriptional Pahlavi, Psalter Pahlavi, Inscriptional Parthian, Hanifi Rohingya, Old Sogdian, Sogdian, Syriac, Neo-Tifinagh, Thaana, Old Uyghur & Yezidi (1989): ⁧رِيدِتْ⁩, ⁧𐪇𐪕𐪉⁩, ⁧𐬭𐬈𐬛𐬌𐬙⁩, ⁧𐩧𐩵𐩩⁩, ⁧𐿂𐾴𐾺𐿄⁩, ⁧𐣣𐣣𐣩𐣵⁩, ⁧ࡓࡏࡃࡉࡕ⁩, ⁧𐫡𐫅𐫏𐫤⁩, ⁧𐢛𐢅𐢍𐢞⁩, 𐎼𐎡𐎮𐎡𐎫, 𐒇𐒗𐒆𐒘𐒂, ⁧𐭥𐭣𐭩𐭲⁩, ⁧𐮅𐮃𐮈𐮑⁩, ⁧𐴌𐴠𐴊𐴞𐴃⁩, ⁧𐭓𐭃𐭉𐭕⁩, ⁧𐼘𐼘𐼊𐼚⁩, ⁧𐽀𐼲𐼷𐽂⁩, ⁧ܪܕ݁ܝܬ݁⁩, ⵔⴻⴷⴷⵉⵜ, ⁧ރެދިތް⁩, ⁧𐽾𐽲𐽶𐾀⁩, ⁧𐺎𐺩𐺋𐺨𐺕⁩ etc
* **Armenian** (95): Րեդդիտ etc
* **Brahmic scripts**: Ahom, Bengali, Bhaiksuki, Brahmi, Burmese, Chakma, Devanagari, Dives Akuru, Dogra, Grantha, Gujala Gondi, Gujarati, Gurmukhi, Gurung Khema, Kaithi, Kannada, Kawi, Kharoshthi, Khojki, Khudawadi, Kirat Rai, Lepcha, Limbu, Mahajani, Makasar, Malayalam, Marchen, Masaram Gondi, Meitei, Modi, Multani, Nandinagari, Newa, Odia, Rejang, Saurashtra, Sharada, Siddham, Sinhala, Sylheti Nagri, Takri, Tamil, Telugu, Tigalari, Tirhuta (3092): 𑜍𑜦𑜔𑜢𑜌𑜫, রেডিট, 𑰨𑰸𑰠𑰰𑰞, 𑀭𑁂𑀟𑀺𑀝, ရေဍိဋ္, 𑄢𑄬𑄘𑄨𑄖𑄳, रेडिट, 𑤧𑤵𑤞𑤱𑤜𑤽, 𑠤𑠳𑠜𑠭𑠚, 𑌰𑍇𑌧𑌿𑌥, 𑶈𑶐𑵹𑶋𑵴𑶗, રેડિટ, ਰੇਡਿਟ, 𖄛𖄣𖄓𖄟𖄑, 𑂩𑂵𑂡𑂱𑂟, ರೆಡಿತ್, ⁧𐨪𐨅𐨢𐨁𐨠⁩, 𑈦𑈰𑈝𑈭𑈚, 𑋙𑋥𑋐𑋡𑋎, 𖵝𖵧𖵕𖵤𖵓, ᰛᰬᰌᰧᰳ, ᤖᤧᤍᤡᤳ, 𑅭𑅓𑅦𑅑𑅟, രെഡിട്, 𑲊𑲳𑱼𑲱𑱻, 𑴦𑴺𑴞𑴲𑴜, ꯔꯦꯗꯤꯠ, 𑘨𑘹𑘠𑘱𑘞, 𑊢𑊃𑊙𑊁𑊗, 𑧈𑧚𑧀𑧒𑦾, 𑐬𑐾𑐢𑐶𑐠, ରେଡିଟ, ꢬꢾꢞꢶꢜ, 𑆫𑆼𑆣𑆴𑆡, 𑖨𑖸𑖠𑖰𑖞, රෙඩිට්, ꠞꠦꠗꠤꠕ, 𑚤𑚲𑚜𑚮𑚚, ரெடிட், రెడిట్, 𑎬𑏂𑎤𑎹𑎢, 𑒩𑒺𑒡𑒱𑒟 etc
* **Braille**, UEB (272): ⠗⠫⠙⠊⠞ etc
* **ConScripts**: Cherokee, Cree, Deseret, Inuktitut, Kayah Li, Mefeidrin, Mundari Bani, Mru, Nyiakeng Puachue Hmong, Ol Chiki, Old Onal, Osage, Pahawh Hmong, Pau Cin Hau, Shavian, Sloan-Duployan, Sora Sompeng, Sunuwar, Tangsa, Toto, Wancho & Warang Citi (1787): ᎴᏗᏛ, ᕃᑎᑦ, 𐐡𐐇𐐔𐐆𐐓, ᕃᑎᑦ, ꤚꤢꤧꤘꤤꤒ, 𖹜𖹯𖹹𖹹𖹫𖹨, 𞓣𞓤𞓡𞓚𞓝, 𖩓𖩘𖩅𖩊𖩀, 𞄣𞄪𞄏𞄦𞄃, ᱨᱮᱫᱫᱤᱛ, 𞗧𞗨𞗠𞗜𞗝, 𐒴𐓟𐓵𐓣𐓰, 𖬡𖬉𖬰𖬞𖬰𖬃𖬰𖬧𖬵, 𑫒𑫖𑫄𑫗𑫎, 𐑮𐑧𐑛𐑦𐑑, 𛰋𛱌𛰍, 𑃝𑃣𑃔𑃤𑃑, 𑯄𑯂𑯀𑯃𑯁, 𖪲𖪔𖪱𖪏𖪰, 𞊟𞊦𞊓𞊡𞊒, 𞋗𞋛𞋄𞋜𞋋, 𑢼𑣈𑣔𑣂𑣕 etc
* **Cyrillic**, Glagolitic & Old Permic (565): Ре́ддит, Ⱃⰵδδιτ, 𐍠𐍔𐍓𐍓𐍙𐍢 etc
* **Geʽez**, Adlam, Bamum, Bassa Vah, Garay, Mende Kikakui, Meroitic Cursive & Hieroglyphic, NKo & Vai (1308): ሬዲተ, ⁧𞤈𞤫𞤣𞤭𞤼⁩, ꚥꛤꛤ꛱, 𖫦𖫬𖫗𖫭𖫡, ⁧𐵞𐵩𐵺𐵋𐵽⁩, ⁧𞠺𞠾𞡊⁩, ⁧𐦫𐦪𐦷𐦢𐦴⁩, ⁧𐦎𐦁𐦝𐦂𐦘⁩, ⁧ߙߍߘߘߌߕ⁩, ꗸꔹꗋ etc
* **Georgian** & Caucasian Albanian (207): რედდიტ, ႰႤႣႣႨႲ, 𐕙𐔴𐔳𐔳𐔼𐔸 etc
* **Greek**, Coptic, Cypriot, Elbasan, Gothic, Linear B, Lycian, Todhri & Vithkuqi (1132): Ρέντιτ, Ⲣⲉⲇⲇⲓⲧ, ⁧𐠤𐠯𐠮⁩, 𐔙𐔇𐔄𐔍𐔝, 𐍂𐌴𐌳𐌳𐌹𐍄, 𐀩𐀇𐀵, 𐊕𐊁𐊅𐊅𐊆𐊗, 𐗝𐗉𐗆𐗒𐗢, 𐖊𐖞𐖜𐖜𐖥𐖵 etc
* **Hebrew**, Aramaic, Elymaic, Lydian, Palmyrene, Phoenician, Samaritan & Ugaritic (350): ⁧רֶדִיט⁩, ⁧𐡓𐡃𐡉𐡕⁩, ⁧𐿳𐿣𐿵⁩, ⁧𐤭𐤤𐤣𐤣𐤦𐤯⁩, ⁧𐡴𐡣𐡩𐡶⁩, ⁧𐤓𐤃𐤕⁩, ⁧ࠓࠝࠃࠪࠕ⁩, 𐎗𐎄𐎚 etc
* **Japanese** (mostly kana) (866): 「レディット」 etc
* **Kawi Scripts**: Balinese, Batak, Baybayin, Buginese, Buhid, Hanunoo, Javanese, Old Kawi, Makasar, Rejang, Sundanese & Tagbanwa (485): ᬭᬾᬤᬶᬢ᭄, ᯒᯧᯑᯪᯖ᯲, ᜍᜒᜇᜒᜆ᜔, ᨑᨙᨉᨗ, ᝍᝒᝇᝒ, ᜭᜲᜧᜲᜦ᜴, ꦫꦺꦢꦶꦠ, 𑼬𑼾𑼤𑼶𑼢, 𑻭𑻵𑻧𑻳, ꤽꥉꤴꥇꤳ, ᮛᮨᮓᮤᮒ᮪, ᝮᝲᝧᝲ, etc
* **Korean** (11736): 레딧 etc
* **International Morse Code** (76): ·-· · -·· -·· ·· - etc
* **Old Italic**, Carian, Ogham, Old Hungarian, Runic & Old Turkic (382): 𐌓𐌄𐌃𐌃𐌉𐌕, 𐊥𐊺𐊢𐊢𐊹𐊭, ᚏᚓᚇᚔᚈ, ⁧𐲢𐳉𐳇𐳇𐳐𐳦⁩, ᚱᛖᛞᛞᛁᛏ, ⁧𐰺𐰅𐰑𐰃𐱃⁩ etc
* **Sutton SignWriting** (667): 𝧿𝨾𝡇𝪜𝪡𝦈𝪪 etc
* **Thai**, Cham, Khmer, Lao, Tai Tham & Tai Viet (502): เรดดิต, ꨣꨮꨖꨪꩅ, រេទិត, ເຣັດິຕ, ᩁᩮᨯᩥᨲ, ꪧꪵꪒꪲꪒ etc
* **Zhuyin**, Fraser, Mongolian, New Tai Lue, ʼPhags-pa, Pollard, Soyombo, Tai LeTibetan, Yi, Zanabazar Square (2420): ㄏㄨㄥˊㄉㄧˊ, ꓡꓯꓓꓲꓔ, ᠷᠡᠳᠢᠲ, ᦜᦵᦡᦲᧆ, ꡘꡠꡊꡞꡈ, 𖼖𖽝𖼋𖽡𖼊, 𑩼𑩔𑩩𑩑𑪍, ᥘᥦᥖᥤᥖ, རེཌིཊ྄, ꏒꄶ, 𑨫𑨄𑨜𑨁𑨚𑨴 etc
* **Logograms/undeciphered**: Anatolian Hieroglyphs, Cuneiform, Cypro-Minoan, Egyptian Hieroglyphs, Linear A&B (4635): 𔐅 𒆛 𒿌 𓀁 𐙞 etc
* Language names (150): 🇯🇵 日本語 🇮🇷 ⁧فارس⁩ 🇻🇳 Tiếng Việt etc

### Symbols (4983)
* **Emoji** (1515): 😉 👌🏾 🇳🇿 🫡 👉🏼 💔 🤣 🤦🏽‍♀️ 🏳️‍⚧️ ✨ etc
* **Sprites** (147): 🗫 🯅 ㋡ etc
* **Math and science** (384): ρ(∂v⃗/∂t + (v⃗·∇)v) ∫πeⁱᶿ dθ etc.
* **APL** (107): ⍟ ⍫ ⍉ etc
* **Technical** (106): ⏻ ⎙ ⌘ etc
* **Numerals** (404): 𝍸𝍷 𝍵 Ⅻ ↁ etc
* **Music** (137): 𝄞 𝅗𝅨𝅥 𝅃𝅥𝅮 𝆍𝆑𝆎 etc
* **Games** (358): ♞c6 🩡 🂽 🁖 🀄︎ etc
* **Astrology** (81): ♈ 🐉 🌒 ☿ ♇ etc
* **I Ching** (166): ䷇ ☰☷☲☵ etc
* **Hieroglyphs** (361): 𓁖 𓁹 𓃠 etc
* **Arrows** (312): ↦ ↺ ⇄ ⇼ ⏎ ⇬ etc
* **Geometric shapes** (240): ⬛ ⬚ 🟣 ◐ ◭ ◈ ✶ etc
* **Box drawing** (665): ╞╦╕ etc
