# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._enums import *

__all__ = [
    'AWSOIDCConfigurationArgs',
    'AWSOIDCConfigurationArgsDict',
    'ApprovalRuleConfigArgs',
    'ApprovalRuleConfigArgsDict',
    'AuthPolicyDefinitionArgs',
    'AuthPolicyDefinitionArgsDict',
    'AzureOIDCConfigurationArgs',
    'AzureOIDCConfigurationArgsDict',
    'DeploymentSettingsCacheOptionsArgs',
    'DeploymentSettingsCacheOptionsArgsDict',
    'DeploymentSettingsExecutorContextArgs',
    'DeploymentSettingsExecutorContextArgsDict',
    'DeploymentSettingsGitAuthBasicAuthArgs',
    'DeploymentSettingsGitAuthBasicAuthArgsDict',
    'DeploymentSettingsGitAuthSSHAuthArgs',
    'DeploymentSettingsGitAuthSSHAuthArgsDict',
    'DeploymentSettingsGitSourceGitAuthArgs',
    'DeploymentSettingsGitSourceGitAuthArgsDict',
    'DeploymentSettingsGitSourceArgs',
    'DeploymentSettingsGitSourceArgsDict',
    'DeploymentSettingsGithubArgs',
    'DeploymentSettingsGithubArgsDict',
    'DeploymentSettingsOperationContextArgs',
    'DeploymentSettingsOperationContextArgsDict',
    'DeploymentSettingsSourceContextArgs',
    'DeploymentSettingsSourceContextArgsDict',
    'EligibleApproverArgs',
    'EligibleApproverArgsDict',
    'EnvironmentIdentifierArgs',
    'EnvironmentIdentifierArgsDict',
    'GCPOIDCConfigurationArgs',
    'GCPOIDCConfigurationArgsDict',
    'OperationContextOIDCArgs',
    'OperationContextOIDCArgsDict',
    'OperationContextOptionsArgs',
    'OperationContextOptionsArgsDict',
    'PolicyGroupPolicyPackReferenceArgs',
    'PolicyGroupPolicyPackReferenceArgsDict',
    'PolicyGroupStackReferenceArgs',
    'PolicyGroupStackReferenceArgsDict',
    'TemplateSourceDestinationArgs',
    'TemplateSourceDestinationArgsDict',
]

MYPY = False

if not MYPY:
    class AWSOIDCConfigurationArgsDict(TypedDict):
        role_arn: pulumi.Input[_builtins.str]
        """
        The ARN of the role to assume using the OIDC token.
        """
        session_name: pulumi.Input[_builtins.str]
        """
        The name of the assume-role session.
        """
        duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        Duration of the assume-role session in “XhYmZs” format
        """
        policy_arns: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Optional set of IAM policy ARNs that further restrict the assume-role session
        """
elif False:
    AWSOIDCConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AWSOIDCConfigurationArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[_builtins.str],
                 session_name: pulumi.Input[_builtins.str],
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the role to assume using the OIDC token.
        :param pulumi.Input[_builtins.str] session_name: The name of the assume-role session.
        :param pulumi.Input[_builtins.str] duration: Duration of the assume-role session in “XhYmZs” format
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_arns: Optional set of IAM policy ARNs that further restrict the assume-role session
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "session_name", session_name)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)

    @_builtins.property
    @pulumi.getter(name="roleARN")
    def role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the role to assume using the OIDC token.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the assume-role session.
        """
        return pulumi.get(self, "session_name")

    @session_name.setter
    def session_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "session_name", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration of the assume-role session in “XhYmZs” format
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="policyARNs")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional set of IAM policy ARNs that further restrict the assume-role session
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_arns", value)


if not MYPY:
    class ApprovalRuleConfigArgsDict(TypedDict):
        allow_self_approval: pulumi.Input[_builtins.bool]
        """
        Whether self-approval is allowed.
        """
        eligible_approvers: pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgsDict']]]
        """
        List of eligible approvers.
        """
        num_approvals_required: pulumi.Input[_builtins.int]
        """
        Number of approvals required.
        """
        require_reapproval_on_change: pulumi.Input[_builtins.bool]
        """
        Whether reapproval is required on changes.
        """
elif False:
    ApprovalRuleConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApprovalRuleConfigArgs:
    def __init__(__self__, *,
                 allow_self_approval: pulumi.Input[_builtins.bool],
                 eligible_approvers: pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgs']]],
                 num_approvals_required: pulumi.Input[_builtins.int],
                 require_reapproval_on_change: pulumi.Input[_builtins.bool]):
        """
        :param pulumi.Input[_builtins.bool] allow_self_approval: Whether self-approval is allowed.
        :param pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgs']]] eligible_approvers: List of eligible approvers.
        :param pulumi.Input[_builtins.int] num_approvals_required: Number of approvals required.
        :param pulumi.Input[_builtins.bool] require_reapproval_on_change: Whether reapproval is required on changes.
        """
        pulumi.set(__self__, "allow_self_approval", allow_self_approval)
        pulumi.set(__self__, "eligible_approvers", eligible_approvers)
        pulumi.set(__self__, "num_approvals_required", num_approvals_required)
        pulumi.set(__self__, "require_reapproval_on_change", require_reapproval_on_change)

    @_builtins.property
    @pulumi.getter(name="allowSelfApproval")
    def allow_self_approval(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether self-approval is allowed.
        """
        return pulumi.get(self, "allow_self_approval")

    @allow_self_approval.setter
    def allow_self_approval(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "allow_self_approval", value)

    @_builtins.property
    @pulumi.getter(name="eligibleApprovers")
    def eligible_approvers(self) -> pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgs']]]:
        """
        List of eligible approvers.
        """
        return pulumi.get(self, "eligible_approvers")

    @eligible_approvers.setter
    def eligible_approvers(self, value: pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgs']]]):
        pulumi.set(self, "eligible_approvers", value)

    @_builtins.property
    @pulumi.getter(name="numApprovalsRequired")
    def num_approvals_required(self) -> pulumi.Input[_builtins.int]:
        """
        Number of approvals required.
        """
        return pulumi.get(self, "num_approvals_required")

    @num_approvals_required.setter
    def num_approvals_required(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num_approvals_required", value)

    @_builtins.property
    @pulumi.getter(name="requireReapprovalOnChange")
    def require_reapproval_on_change(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether reapproval is required on changes.
        """
        return pulumi.get(self, "require_reapproval_on_change")

    @require_reapproval_on_change.setter
    def require_reapproval_on_change(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "require_reapproval_on_change", value)


if not MYPY:
    class AuthPolicyDefinitionArgsDict(TypedDict):
        decision: pulumi.Input['AuthPolicyDecision']
        """
        The rule type of this policy definition
        """
        rules: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]
        """
        OIDC rules to set for this policy.
        """
        token_type: pulumi.Input['AuthPolicyTokenType']
        """
        The token type for this policy definition
        """
        authorized_permissions: NotRequired[pulumi.Input[Sequence[pulumi.Input['AuthPolicyPermissionLevel']]]]
        """
        The permission level for organization tokens.
        """
        runner_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The runner ID for deployment runner tokens.
        """
        team_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The team name for team tokens.
        """
        user_login: NotRequired[pulumi.Input[_builtins.str]]
        """
        The user login for personal tokens.
        """
elif False:
    AuthPolicyDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthPolicyDefinitionArgs:
    def __init__(__self__, *,
                 decision: pulumi.Input['AuthPolicyDecision'],
                 rules: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 token_type: pulumi.Input['AuthPolicyTokenType'],
                 authorized_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['AuthPolicyPermissionLevel']]]] = None,
                 runner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 team_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_login: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input['AuthPolicyDecision'] decision: The rule type of this policy definition
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rules: OIDC rules to set for this policy.
        :param pulumi.Input['AuthPolicyTokenType'] token_type: The token type for this policy definition
        :param pulumi.Input[Sequence[pulumi.Input['AuthPolicyPermissionLevel']]] authorized_permissions: The permission level for organization tokens.
        :param pulumi.Input[_builtins.str] runner_id: The runner ID for deployment runner tokens.
        :param pulumi.Input[_builtins.str] team_name: The team name for team tokens.
        :param pulumi.Input[_builtins.str] user_login: The user login for personal tokens.
        """
        pulumi.set(__self__, "decision", decision)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "token_type", token_type)
        if authorized_permissions is not None:
            pulumi.set(__self__, "authorized_permissions", authorized_permissions)
        if runner_id is not None:
            pulumi.set(__self__, "runner_id", runner_id)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)
        if user_login is not None:
            pulumi.set(__self__, "user_login", user_login)

    @_builtins.property
    @pulumi.getter
    def decision(self) -> pulumi.Input['AuthPolicyDecision']:
        """
        The rule type of this policy definition
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: pulumi.Input['AuthPolicyDecision']):
        pulumi.set(self, "decision", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        OIDC rules to set for this policy.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Input['AuthPolicyTokenType']:
        """
        The token type for this policy definition
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: pulumi.Input['AuthPolicyTokenType']):
        pulumi.set(self, "token_type", value)

    @_builtins.property
    @pulumi.getter(name="authorizedPermissions")
    def authorized_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthPolicyPermissionLevel']]]]:
        """
        The permission level for organization tokens.
        """
        return pulumi.get(self, "authorized_permissions")

    @authorized_permissions.setter
    def authorized_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthPolicyPermissionLevel']]]]):
        pulumi.set(self, "authorized_permissions", value)

    @_builtins.property
    @pulumi.getter(name="runnerID")
    def runner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runner ID for deployment runner tokens.
        """
        return pulumi.get(self, "runner_id")

    @runner_id.setter
    def runner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runner_id", value)

    @_builtins.property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The team name for team tokens.
        """
        return pulumi.get(self, "team_name")

    @team_name.setter
    def team_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_name", value)

    @_builtins.property
    @pulumi.getter(name="userLogin")
    def user_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user login for personal tokens.
        """
        return pulumi.get(self, "user_login")

    @user_login.setter
    def user_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_login", value)


if not MYPY:
    class AzureOIDCConfigurationArgsDict(TypedDict):
        client_id: pulumi.Input[_builtins.str]
        """
        The client ID of the federated workload identity.
        """
        subscription_id: pulumi.Input[_builtins.str]
        """
        The subscription ID of the federated workload identity.
        """
        tenant_id: pulumi.Input[_builtins.str]
        """
        The tenant ID of the federated workload identity.
        """
elif False:
    AzureOIDCConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AzureOIDCConfigurationArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 subscription_id: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] client_id: The client ID of the federated workload identity.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID of the federated workload identity.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the federated workload identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client ID of the federated workload identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[_builtins.str]:
        """
        The subscription ID of the federated workload identity.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The tenant ID of the federated workload identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class DeploymentSettingsCacheOptionsArgsDict(TypedDict):
        """
        Dependency cache settings for the deployment
        """
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable dependency caching
        """
elif False:
    DeploymentSettingsCacheOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsCacheOptionsArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Dependency cache settings for the deployment
        :param pulumi.Input[_builtins.bool] enable: Enable dependency caching
        """
        if enable is None:
            enable = False
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable dependency caching
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)


if not MYPY:
    class DeploymentSettingsExecutorContextArgsDict(TypedDict):
        """
        The executor context defines information about the executor where the deployment is executed. If unspecified, the default 'pulumi/pulumi' image is used.
        """
        executor_image: pulumi.Input[_builtins.str]
        """
        Allows overriding the default executor image with a custom image. E.g. 'pulumi/pulumi-nodejs:latest'
        """
elif False:
    DeploymentSettingsExecutorContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsExecutorContextArgs:
    def __init__(__self__, *,
                 executor_image: pulumi.Input[_builtins.str]):
        """
        The executor context defines information about the executor where the deployment is executed. If unspecified, the default 'pulumi/pulumi' image is used.
        :param pulumi.Input[_builtins.str] executor_image: Allows overriding the default executor image with a custom image. E.g. 'pulumi/pulumi-nodejs:latest'
        """
        pulumi.set(__self__, "executor_image", executor_image)

    @_builtins.property
    @pulumi.getter(name="executorImage")
    def executor_image(self) -> pulumi.Input[_builtins.str]:
        """
        Allows overriding the default executor image with a custom image. E.g. 'pulumi/pulumi-nodejs:latest'
        """
        return pulumi.get(self, "executor_image")

    @executor_image.setter
    def executor_image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "executor_image", value)


if not MYPY:
    class DeploymentSettingsGitAuthBasicAuthArgsDict(TypedDict):
        """
        Git source settings for a deployment.
        """
        password: pulumi.Input[_builtins.str]
        """
        Password for git basic authentication.
        """
        username: pulumi.Input[_builtins.str]
        """
        User name for git basic authentication.
        """
elif False:
    DeploymentSettingsGitAuthBasicAuthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsGitAuthBasicAuthArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str]):
        """
        Git source settings for a deployment.
        :param pulumi.Input[_builtins.str] password: Password for git basic authentication.
        :param pulumi.Input[_builtins.str] username: User name for git basic authentication.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Password for git basic authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        User name for git basic authentication.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class DeploymentSettingsGitAuthSSHAuthArgsDict(TypedDict):
        """
        Git source settings for a deployment.
        """
        ssh_private_key: pulumi.Input[_builtins.str]
        """
        SSH private key.
        """
        password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional password for SSH authentication.
        """
elif False:
    DeploymentSettingsGitAuthSSHAuthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsGitAuthSSHAuthArgs:
    def __init__(__self__, *,
                 ssh_private_key: pulumi.Input[_builtins.str],
                 password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Git source settings for a deployment.
        :param pulumi.Input[_builtins.str] ssh_private_key: SSH private key.
        :param pulumi.Input[_builtins.str] password: Optional password for SSH authentication.
        """
        pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> pulumi.Input[_builtins.str]:
        """
        SSH private key.
        """
        return pulumi.get(self, "ssh_private_key")

    @ssh_private_key.setter
    def ssh_private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ssh_private_key", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional password for SSH authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)


if not MYPY:
    class DeploymentSettingsGitSourceGitAuthArgsDict(TypedDict):
        """
        Git source settings for a deployment.
        """
        basic_auth: NotRequired[pulumi.Input['DeploymentSettingsGitAuthBasicAuthArgsDict']]
        """
        Basic auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        ssh_auth: NotRequired[pulumi.Input['DeploymentSettingsGitAuthSSHAuthArgsDict']]
        """
        SSH auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
elif False:
    DeploymentSettingsGitSourceGitAuthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsGitSourceGitAuthArgs:
    def __init__(__self__, *,
                 basic_auth: Optional[pulumi.Input['DeploymentSettingsGitAuthBasicAuthArgs']] = None,
                 ssh_auth: Optional[pulumi.Input['DeploymentSettingsGitAuthSSHAuthArgs']] = None):
        """
        Git source settings for a deployment.
        :param pulumi.Input['DeploymentSettingsGitAuthBasicAuthArgs'] basic_auth: Basic auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        :param pulumi.Input['DeploymentSettingsGitAuthSSHAuthArgs'] ssh_auth: SSH auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if ssh_auth is not None:
            pulumi.set(__self__, "ssh_auth", ssh_auth)

    @_builtins.property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional[pulumi.Input['DeploymentSettingsGitAuthBasicAuthArgs']]:
        """
        Basic auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        return pulumi.get(self, "basic_auth")

    @basic_auth.setter
    def basic_auth(self, value: Optional[pulumi.Input['DeploymentSettingsGitAuthBasicAuthArgs']]):
        pulumi.set(self, "basic_auth", value)

    @_builtins.property
    @pulumi.getter(name="sshAuth")
    def ssh_auth(self) -> Optional[pulumi.Input['DeploymentSettingsGitAuthSSHAuthArgs']]:
        """
        SSH auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        return pulumi.get(self, "ssh_auth")

    @ssh_auth.setter
    def ssh_auth(self, value: Optional[pulumi.Input['DeploymentSettingsGitAuthSSHAuthArgs']]):
        pulumi.set(self, "ssh_auth", value)


if not MYPY:
    class DeploymentSettingsGitSourceArgsDict(TypedDict):
        """
        Git source settings for a deployment.
        """
        branch: NotRequired[pulumi.Input[_builtins.str]]
        """
        The branch to deploy. One of either `branch` or `commit` must be specified.
        """
        commit: NotRequired[pulumi.Input[_builtins.str]]
        """
        The commit to deploy. One of either `branch` or `commit` must be specified.
        """
        git_auth: NotRequired[pulumi.Input['DeploymentSettingsGitSourceGitAuthArgsDict']]
        """
        Git authentication configuration for this deployment. Should not be specified if there are `gitHub` settings for this deployment.
        """
        repo_dir: NotRequired[pulumi.Input[_builtins.str]]
        """
        The directory within the repository where the Pulumi.yaml is located.
        """
        repo_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The repository URL to use for git settings. Should not be specified if there are `gitHub` settings for this deployment.
        """
elif False:
    DeploymentSettingsGitSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsGitSourceArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit: Optional[pulumi.Input[_builtins.str]] = None,
                 git_auth: Optional[pulumi.Input['DeploymentSettingsGitSourceGitAuthArgs']] = None,
                 repo_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Git source settings for a deployment.
        :param pulumi.Input[_builtins.str] branch: The branch to deploy. One of either `branch` or `commit` must be specified.
        :param pulumi.Input[_builtins.str] commit: The commit to deploy. One of either `branch` or `commit` must be specified.
        :param pulumi.Input['DeploymentSettingsGitSourceGitAuthArgs'] git_auth: Git authentication configuration for this deployment. Should not be specified if there are `gitHub` settings for this deployment.
        :param pulumi.Input[_builtins.str] repo_dir: The directory within the repository where the Pulumi.yaml is located.
        :param pulumi.Input[_builtins.str] repo_url: The repository URL to use for git settings. Should not be specified if there are `gitHub` settings for this deployment.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if git_auth is not None:
            pulumi.set(__self__, "git_auth", git_auth)
        if repo_dir is not None:
            pulumi.set(__self__, "repo_dir", repo_dir)
        if repo_url is not None:
            pulumi.set(__self__, "repo_url", repo_url)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The branch to deploy. One of either `branch` or `commit` must be specified.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch", value)

    @_builtins.property
    @pulumi.getter
    def commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The commit to deploy. One of either `branch` or `commit` must be specified.
        """
        return pulumi.get(self, "commit")

    @commit.setter
    def commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit", value)

    @_builtins.property
    @pulumi.getter(name="gitAuth")
    def git_auth(self) -> Optional[pulumi.Input['DeploymentSettingsGitSourceGitAuthArgs']]:
        """
        Git authentication configuration for this deployment. Should not be specified if there are `gitHub` settings for this deployment.
        """
        return pulumi.get(self, "git_auth")

    @git_auth.setter
    def git_auth(self, value: Optional[pulumi.Input['DeploymentSettingsGitSourceGitAuthArgs']]):
        pulumi.set(self, "git_auth", value)

    @_builtins.property
    @pulumi.getter(name="repoDir")
    def repo_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The directory within the repository where the Pulumi.yaml is located.
        """
        return pulumi.get(self, "repo_dir")

    @repo_dir.setter
    def repo_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_dir", value)

    @_builtins.property
    @pulumi.getter(name="repoUrl")
    def repo_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The repository URL to use for git settings. Should not be specified if there are `gitHub` settings for this deployment.
        """
        return pulumi.get(self, "repo_url")

    @repo_url.setter
    def repo_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_url", value)


if not MYPY:
    class DeploymentSettingsGithubArgsDict(TypedDict):
        """
        GitHub settings for the deployment.
        """
        deploy_commits: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Trigger a deployment running `pulumi up` on commit.
        """
        paths: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The paths within the repo that deployments should be filtered to.
        """
        preview_pull_requests: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Trigger a deployment running `pulumi preview` when a PR is opened.
        """
        pull_request_template: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Use this stack as a template for pull request review stacks.
        """
        repository: NotRequired[pulumi.Input[_builtins.str]]
        """
        The GitHub repository in the format org/repo.
        """
elif False:
    DeploymentSettingsGithubArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsGithubArgs:
    def __init__(__self__, *,
                 deploy_commits: Optional[pulumi.Input[_builtins.bool]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preview_pull_requests: Optional[pulumi.Input[_builtins.bool]] = None,
                 pull_request_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None):
        """
        GitHub settings for the deployment.
        :param pulumi.Input[_builtins.bool] deploy_commits: Trigger a deployment running `pulumi up` on commit.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: The paths within the repo that deployments should be filtered to.
        :param pulumi.Input[_builtins.bool] preview_pull_requests: Trigger a deployment running `pulumi preview` when a PR is opened.
        :param pulumi.Input[_builtins.bool] pull_request_template: Use this stack as a template for pull request review stacks.
        :param pulumi.Input[_builtins.str] repository: The GitHub repository in the format org/repo.
        """
        if deploy_commits is None:
            deploy_commits = True
        if deploy_commits is not None:
            pulumi.set(__self__, "deploy_commits", deploy_commits)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if preview_pull_requests is None:
            preview_pull_requests = True
        if preview_pull_requests is not None:
            pulumi.set(__self__, "preview_pull_requests", preview_pull_requests)
        if pull_request_template is None:
            pull_request_template = False
        if pull_request_template is not None:
            pulumi.set(__self__, "pull_request_template", pull_request_template)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter(name="deployCommits")
    def deploy_commits(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Trigger a deployment running `pulumi up` on commit.
        """
        return pulumi.get(self, "deploy_commits")

    @deploy_commits.setter
    def deploy_commits(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deploy_commits", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The paths within the repo that deployments should be filtered to.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @_builtins.property
    @pulumi.getter(name="previewPullRequests")
    def preview_pull_requests(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Trigger a deployment running `pulumi preview` when a PR is opened.
        """
        return pulumi.get(self, "preview_pull_requests")

    @preview_pull_requests.setter
    def preview_pull_requests(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preview_pull_requests", value)

    @_builtins.property
    @pulumi.getter(name="pullRequestTemplate")
    def pull_request_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use this stack as a template for pull request review stacks.
        """
        return pulumi.get(self, "pull_request_template")

    @pull_request_template.setter
    def pull_request_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pull_request_template", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GitHub repository in the format org/repo.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)


if not MYPY:
    class DeploymentSettingsOperationContextArgsDict(TypedDict):
        """
        Settings related to the Pulumi operation environment during the deployment.
        """
        environment_variables: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Environment variables to set for the deployment.
        """
        oidc: NotRequired[pulumi.Input['OperationContextOIDCArgsDict']]
        """
        OIDC configuration to use during the deployment.
        """
        options: NotRequired[pulumi.Input['OperationContextOptionsArgsDict']]
        """
        Options to override default behavior during the deployment.
        """
        pre_run_commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Shell commands to run before the Pulumi operation executes.
        """
elif False:
    DeploymentSettingsOperationContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsOperationContextArgs:
    def __init__(__self__, *,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 oidc: Optional[pulumi.Input['OperationContextOIDCArgs']] = None,
                 options: Optional[pulumi.Input['OperationContextOptionsArgs']] = None,
                 pre_run_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Settings related to the Pulumi operation environment during the deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Environment variables to set for the deployment.
        :param pulumi.Input['OperationContextOIDCArgs'] oidc: OIDC configuration to use during the deployment.
        :param pulumi.Input['OperationContextOptionsArgs'] options: Options to override default behavior during the deployment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pre_run_commands: Shell commands to run before the Pulumi operation executes.
        """
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if oidc is not None:
            pulumi.set(__self__, "oidc", oidc)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if pre_run_commands is not None:
            pulumi.set(__self__, "pre_run_commands", pre_run_commands)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Environment variables to set for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def oidc(self) -> Optional[pulumi.Input['OperationContextOIDCArgs']]:
        """
        OIDC configuration to use during the deployment.
        """
        return pulumi.get(self, "oidc")

    @oidc.setter
    def oidc(self, value: Optional[pulumi.Input['OperationContextOIDCArgs']]):
        pulumi.set(self, "oidc", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['OperationContextOptionsArgs']]:
        """
        Options to override default behavior during the deployment.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['OperationContextOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="preRunCommands")
    def pre_run_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Shell commands to run before the Pulumi operation executes.
        """
        return pulumi.get(self, "pre_run_commands")

    @pre_run_commands.setter
    def pre_run_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pre_run_commands", value)


if not MYPY:
    class DeploymentSettingsSourceContextArgsDict(TypedDict):
        """
        Settings related to the source of the deployment.
        """
        git: NotRequired[pulumi.Input['DeploymentSettingsGitSourceArgsDict']]
        """
        Git source settings for a deployment.
        """
elif False:
    DeploymentSettingsSourceContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSettingsSourceContextArgs:
    def __init__(__self__, *,
                 git: Optional[pulumi.Input['DeploymentSettingsGitSourceArgs']] = None):
        """
        Settings related to the source of the deployment.
        :param pulumi.Input['DeploymentSettingsGitSourceArgs'] git: Git source settings for a deployment.
        """
        if git is not None:
            pulumi.set(__self__, "git", git)

    @_builtins.property
    @pulumi.getter
    def git(self) -> Optional[pulumi.Input['DeploymentSettingsGitSourceArgs']]:
        """
        Git source settings for a deployment.
        """
        return pulumi.get(self, "git")

    @git.setter
    def git(self, value: Optional[pulumi.Input['DeploymentSettingsGitSourceArgs']]):
        pulumi.set(self, "git", value)


if not MYPY:
    class EligibleApproverArgsDict(TypedDict):
        rbac_permission: NotRequired[pulumi.Input['RbacPermission']]
        """
        RBAC permission that gives right to approve.
        """
        team_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the team that can approve.
        """
        user: NotRequired[pulumi.Input[_builtins.str]]
        """
        Login of the user that can approve.
        """
elif False:
    EligibleApproverArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EligibleApproverArgs:
    def __init__(__self__, *,
                 rbac_permission: Optional[pulumi.Input['RbacPermission']] = None,
                 team_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input['RbacPermission'] rbac_permission: RBAC permission that gives right to approve.
        :param pulumi.Input[_builtins.str] team_name: Name of the team that can approve.
        :param pulumi.Input[_builtins.str] user: Login of the user that can approve.
        """
        if rbac_permission is not None:
            pulumi.set(__self__, "rbac_permission", rbac_permission)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="rbacPermission")
    def rbac_permission(self) -> Optional[pulumi.Input['RbacPermission']]:
        """
        RBAC permission that gives right to approve.
        """
        return pulumi.get(self, "rbac_permission")

    @rbac_permission.setter
    def rbac_permission(self, value: Optional[pulumi.Input['RbacPermission']]):
        pulumi.set(self, "rbac_permission", value)

    @_builtins.property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the team that can approve.
        """
        return pulumi.get(self, "team_name")

    @team_name.setter
    def team_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_name", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login of the user that can approve.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


if not MYPY:
    class EnvironmentIdentifierArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The environment name.
        """
        organization: pulumi.Input[_builtins.str]
        """
        The organization name.
        """
        project: pulumi.Input[_builtins.str]
        """
        The project name.
        """
elif False:
    EnvironmentIdentifierArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentIdentifierArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 organization: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The environment name.
        :param pulumi.Input[_builtins.str] organization: The organization name.
        :param pulumi.Input[_builtins.str] project: The project name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The environment name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        The organization name.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The project name.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)


if not MYPY:
    class GCPOIDCConfigurationArgsDict(TypedDict):
        project_id: pulumi.Input[_builtins.str]
        """
        The numerical ID of the GCP project.
        """
        provider_id: pulumi.Input[_builtins.str]
        """
        The ID of the identity provider associated with the workload pool.
        """
        service_account: pulumi.Input[_builtins.str]
        """
        The email address of the service account to use.
        """
        workload_pool_id: pulumi.Input[_builtins.str]
        """
        The ID of the workload pool to use.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region of the GCP project.
        """
        token_lifetime: NotRequired[pulumi.Input[_builtins.str]]
        """
        The lifetime of the temporary credentials in “XhYmZs” format.
        """
elif False:
    GCPOIDCConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GCPOIDCConfigurationArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 provider_id: pulumi.Input[_builtins.str],
                 service_account: pulumi.Input[_builtins.str],
                 workload_pool_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 token_lifetime: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] project_id: The numerical ID of the GCP project.
        :param pulumi.Input[_builtins.str] provider_id: The ID of the identity provider associated with the workload pool.
        :param pulumi.Input[_builtins.str] service_account: The email address of the service account to use.
        :param pulumi.Input[_builtins.str] workload_pool_id: The ID of the workload pool to use.
        :param pulumi.Input[_builtins.str] region: The region of the GCP project.
        :param pulumi.Input[_builtins.str] token_lifetime: The lifetime of the temporary credentials in “XhYmZs” format.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_id", provider_id)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "workload_pool_id", workload_pool_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token_lifetime is not None:
            pulumi.set(__self__, "token_lifetime", token_lifetime)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The numerical ID of the GCP project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the identity provider associated with the workload pool.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[_builtins.str]:
        """
        The email address of the service account to use.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="workloadPoolId")
    def workload_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workload pool to use.
        """
        return pulumi.get(self, "workload_pool_id")

    @workload_pool_id.setter
    def workload_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workload_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the GCP project.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifetime of the temporary credentials in “XhYmZs” format.
        """
        return pulumi.get(self, "token_lifetime")

    @token_lifetime.setter
    def token_lifetime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_lifetime", value)


if not MYPY:
    class OperationContextOIDCArgsDict(TypedDict):
        aws: NotRequired[pulumi.Input['AWSOIDCConfigurationArgsDict']]
        """
        AWS-specific OIDC configuration.
        """
        azure: NotRequired[pulumi.Input['AzureOIDCConfigurationArgsDict']]
        """
        Azure-specific OIDC configuration.
        """
        gcp: NotRequired[pulumi.Input['GCPOIDCConfigurationArgsDict']]
        """
        GCP-specific OIDC configuration.
        """
elif False:
    OperationContextOIDCArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OperationContextOIDCArgs:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['AWSOIDCConfigurationArgs']] = None,
                 azure: Optional[pulumi.Input['AzureOIDCConfigurationArgs']] = None,
                 gcp: Optional[pulumi.Input['GCPOIDCConfigurationArgs']] = None):
        """
        :param pulumi.Input['AWSOIDCConfigurationArgs'] aws: AWS-specific OIDC configuration.
        :param pulumi.Input['AzureOIDCConfigurationArgs'] azure: Azure-specific OIDC configuration.
        :param pulumi.Input['GCPOIDCConfigurationArgs'] gcp: GCP-specific OIDC configuration.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['AWSOIDCConfigurationArgs']]:
        """
        AWS-specific OIDC configuration.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['AWSOIDCConfigurationArgs']]):
        pulumi.set(self, "aws", value)

    @_builtins.property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['AzureOIDCConfigurationArgs']]:
        """
        Azure-specific OIDC configuration.
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['AzureOIDCConfigurationArgs']]):
        pulumi.set(self, "azure", value)

    @_builtins.property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['GCPOIDCConfigurationArgs']]:
        """
        GCP-specific OIDC configuration.
        """
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['GCPOIDCConfigurationArgs']]):
        pulumi.set(self, "gcp", value)


if not MYPY:
    class OperationContextOptionsArgsDict(TypedDict):
        delete_after_destroy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the stack should be deleted after it is destroyed.
        """
        shell: NotRequired[pulumi.Input[_builtins.str]]
        """
        The shell to use to run commands during the deployment. Defaults to 'bash'.
        """
        skip_install_dependencies: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Skip the default dependency installation step - use this to customize the dependency installation (e.g. if using yarn or poetry)
        """
        skip_intermediate_deployments: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Skip intermediate deployments (Consolidate multiple deployments of the same type into one deployment)
        """
elif False:
    OperationContextOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OperationContextOptionsArgs:
    def __init__(__self__, *,
                 delete_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 shell: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_install_dependencies: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_intermediate_deployments: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] delete_after_destroy: Whether the stack should be deleted after it is destroyed.
        :param pulumi.Input[_builtins.str] shell: The shell to use to run commands during the deployment. Defaults to 'bash'.
        :param pulumi.Input[_builtins.bool] skip_install_dependencies: Skip the default dependency installation step - use this to customize the dependency installation (e.g. if using yarn or poetry)
        :param pulumi.Input[_builtins.bool] skip_intermediate_deployments: Skip intermediate deployments (Consolidate multiple deployments of the same type into one deployment)
        """
        if delete_after_destroy is not None:
            pulumi.set(__self__, "delete_after_destroy", delete_after_destroy)
        if shell is not None:
            pulumi.set(__self__, "shell", shell)
        if skip_install_dependencies is not None:
            pulumi.set(__self__, "skip_install_dependencies", skip_install_dependencies)
        if skip_intermediate_deployments is not None:
            pulumi.set(__self__, "skip_intermediate_deployments", skip_intermediate_deployments)

    @_builtins.property
    @pulumi.getter(name="deleteAfterDestroy")
    def delete_after_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the stack should be deleted after it is destroyed.
        """
        return pulumi.get(self, "delete_after_destroy")

    @delete_after_destroy.setter
    def delete_after_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_after_destroy", value)

    @_builtins.property
    @pulumi.getter
    def shell(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shell to use to run commands during the deployment. Defaults to 'bash'.
        """
        return pulumi.get(self, "shell")

    @shell.setter
    def shell(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shell", value)

    @_builtins.property
    @pulumi.getter(name="skipInstallDependencies")
    def skip_install_dependencies(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip the default dependency installation step - use this to customize the dependency installation (e.g. if using yarn or poetry)
        """
        return pulumi.get(self, "skip_install_dependencies")

    @skip_install_dependencies.setter
    def skip_install_dependencies(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_install_dependencies", value)

    @_builtins.property
    @pulumi.getter(name="skipIntermediateDeployments")
    def skip_intermediate_deployments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip intermediate deployments (Consolidate multiple deployments of the same type into one deployment)
        """
        return pulumi.get(self, "skip_intermediate_deployments")

    @skip_intermediate_deployments.setter
    def skip_intermediate_deployments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_intermediate_deployments", value)


if not MYPY:
    class PolicyGroupPolicyPackReferenceArgsDict(TypedDict):
        """
        A reference to a policy pack within a policy group.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the policy pack.
        """
        config: NotRequired[pulumi.Input[Mapping[str, Any]]]
        """
        Optional configuration for the policy pack.
        """
        display_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The display name of the policy pack.
        """
        version: NotRequired[pulumi.Input[_builtins.float]]
        """
        The version of the policy pack.
        """
        version_tag: NotRequired[pulumi.Input[_builtins.str]]
        """
        The version tag of the policy pack.
        """
elif False:
    PolicyGroupPolicyPackReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyGroupPolicyPackReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.float]] = None,
                 version_tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        A reference to a policy pack within a policy group.
        :param pulumi.Input[_builtins.str] name: The name of the policy pack.
        :param pulumi.Input[Mapping[str, Any]] config: Optional configuration for the policy pack.
        :param pulumi.Input[_builtins.str] display_name: The display name of the policy pack.
        :param pulumi.Input[_builtins.float] version: The version of the policy pack.
        :param pulumi.Input[_builtins.str] version_tag: The version tag of the policy pack.
        """
        pulumi.set(__self__, "name", name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_tag is not None:
            pulumi.set(__self__, "version_tag", version_tag)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the policy pack.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Optional configuration for the policy pack.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the policy pack.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The version of the policy pack.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="versionTag")
    def version_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version tag of the policy pack.
        """
        return pulumi.get(self, "version_tag")

    @version_tag.setter
    def version_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_tag", value)


if not MYPY:
    class PolicyGroupStackReferenceArgsDict(TypedDict):
        """
        A reference to a stack within a policy group.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the stack.
        """
        routing_project: pulumi.Input[_builtins.str]
        """
        The routing project name (also known as project name).
        """
elif False:
    PolicyGroupStackReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyGroupStackReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 routing_project: pulumi.Input[_builtins.str]):
        """
        A reference to a stack within a policy group.
        :param pulumi.Input[_builtins.str] name: The name of the stack.
        :param pulumi.Input[_builtins.str] routing_project: The routing project name (also known as project name).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routing_project", routing_project)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the stack.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="routingProject")
    def routing_project(self) -> pulumi.Input[_builtins.str]:
        """
        The routing project name (also known as project name).
        """
        return pulumi.get(self, "routing_project")

    @routing_project.setter
    def routing_project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "routing_project", value)


if not MYPY:
    class TemplateSourceDestinationArgsDict(TypedDict):
        url: NotRequired[pulumi.Input[_builtins.str]]
        """
        Destination URL that gets filled in on new project creation.
        """
elif False:
    TemplateSourceDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TemplateSourceDestinationArgs:
    def __init__(__self__, *,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] url: Destination URL that gets filled in on new project creation.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination URL that gets filled in on new project creation.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


