# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentSettingsArgs', 'DeploymentSettings']

@pulumi.input_type
class DeploymentSettingsArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 stack: pulumi.Input[_builtins.str],
                 agent_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_options: Optional[pulumi.Input['DeploymentSettingsCacheOptionsArgs']] = None,
                 executor_context: Optional[pulumi.Input['DeploymentSettingsExecutorContextArgs']] = None,
                 github: Optional[pulumi.Input['DeploymentSettingsGithubArgs']] = None,
                 operation_context: Optional[pulumi.Input['DeploymentSettingsOperationContextArgs']] = None,
                 source_context: Optional[pulumi.Input['DeploymentSettingsSourceContextArgs']] = None):
        """
        The set of arguments for constructing a DeploymentSettings resource.
        :param pulumi.Input[_builtins.str] organization: Organization name.
        :param pulumi.Input[_builtins.str] project: Project name.
        :param pulumi.Input[_builtins.str] stack: Stack name.
        :param pulumi.Input[_builtins.str] agent_pool_id: The agent pool identifier to use for the deployment.
        :param pulumi.Input['DeploymentSettingsCacheOptionsArgs'] cache_options: Dependency cache settings for the deployment
        :param pulumi.Input['DeploymentSettingsExecutorContextArgs'] executor_context: Settings related to the deployment executor.
        :param pulumi.Input['DeploymentSettingsGithubArgs'] github: GitHub settings for the deployment.
        :param pulumi.Input['DeploymentSettingsOperationContextArgs'] operation_context: Settings related to the Pulumi operation environment during the deployment.
        :param pulumi.Input['DeploymentSettingsSourceContextArgs'] source_context: Settings related to the source of the deployment.
        """
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "stack", stack)
        if agent_pool_id is not None:
            pulumi.set(__self__, "agent_pool_id", agent_pool_id)
        if cache_options is not None:
            pulumi.set(__self__, "cache_options", cache_options)
        if executor_context is not None:
            pulumi.set(__self__, "executor_context", executor_context)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if operation_context is not None:
            pulumi.set(__self__, "operation_context", operation_context)
        if source_context is not None:
            pulumi.set(__self__, "source_context", source_context)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        Organization name.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        Project name.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def stack(self) -> pulumi.Input[_builtins.str]:
        """
        Stack name.
        """
        return pulumi.get(self, "stack")

    @stack.setter
    def stack(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack", value)

    @_builtins.property
    @pulumi.getter(name="agentPoolId")
    def agent_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent pool identifier to use for the deployment.
        """
        return pulumi.get(self, "agent_pool_id")

    @agent_pool_id.setter
    def agent_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="cacheOptions")
    def cache_options(self) -> Optional[pulumi.Input['DeploymentSettingsCacheOptionsArgs']]:
        """
        Dependency cache settings for the deployment
        """
        return pulumi.get(self, "cache_options")

    @cache_options.setter
    def cache_options(self, value: Optional[pulumi.Input['DeploymentSettingsCacheOptionsArgs']]):
        pulumi.set(self, "cache_options", value)

    @_builtins.property
    @pulumi.getter(name="executorContext")
    def executor_context(self) -> Optional[pulumi.Input['DeploymentSettingsExecutorContextArgs']]:
        """
        Settings related to the deployment executor.
        """
        return pulumi.get(self, "executor_context")

    @executor_context.setter
    def executor_context(self, value: Optional[pulumi.Input['DeploymentSettingsExecutorContextArgs']]):
        pulumi.set(self, "executor_context", value)

    @_builtins.property
    @pulumi.getter
    def github(self) -> Optional[pulumi.Input['DeploymentSettingsGithubArgs']]:
        """
        GitHub settings for the deployment.
        """
        return pulumi.get(self, "github")

    @github.setter
    def github(self, value: Optional[pulumi.Input['DeploymentSettingsGithubArgs']]):
        pulumi.set(self, "github", value)

    @_builtins.property
    @pulumi.getter(name="operationContext")
    def operation_context(self) -> Optional[pulumi.Input['DeploymentSettingsOperationContextArgs']]:
        """
        Settings related to the Pulumi operation environment during the deployment.
        """
        return pulumi.get(self, "operation_context")

    @operation_context.setter
    def operation_context(self, value: Optional[pulumi.Input['DeploymentSettingsOperationContextArgs']]):
        pulumi.set(self, "operation_context", value)

    @_builtins.property
    @pulumi.getter(name="sourceContext")
    def source_context(self) -> Optional[pulumi.Input['DeploymentSettingsSourceContextArgs']]:
        """
        Settings related to the source of the deployment.
        """
        return pulumi.get(self, "source_context")

    @source_context.setter
    def source_context(self, value: Optional[pulumi.Input['DeploymentSettingsSourceContextArgs']]):
        pulumi.set(self, "source_context", value)


@pulumi.type_token("pulumiservice:index:DeploymentSettings")
class DeploymentSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_options: Optional[pulumi.Input[Union['DeploymentSettingsCacheOptionsArgs', 'DeploymentSettingsCacheOptionsArgsDict']]] = None,
                 executor_context: Optional[pulumi.Input[Union['DeploymentSettingsExecutorContextArgs', 'DeploymentSettingsExecutorContextArgsDict']]] = None,
                 github: Optional[pulumi.Input[Union['DeploymentSettingsGithubArgs', 'DeploymentSettingsGithubArgsDict']]] = None,
                 operation_context: Optional[pulumi.Input[Union['DeploymentSettingsOperationContextArgs', 'DeploymentSettingsOperationContextArgsDict']]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 source_context: Optional[pulumi.Input[Union['DeploymentSettingsSourceContextArgs', 'DeploymentSettingsSourceContextArgsDict']]] = None,
                 stack: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Deployment settings configure Pulumi Deployments for a stack.

        ### Import

        Deployment settings can be imported using the `id`, which for deployment settings is `{org}/{project}/{stack}` e.g.,

        ```sh
         $ pulumi import pulumiservice:index:DeploymentSettings my_settings my-org/my-project/my-stack
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_pool_id: The agent pool identifier to use for the deployment.
        :param pulumi.Input[Union['DeploymentSettingsCacheOptionsArgs', 'DeploymentSettingsCacheOptionsArgsDict']] cache_options: Dependency cache settings for the deployment
        :param pulumi.Input[Union['DeploymentSettingsExecutorContextArgs', 'DeploymentSettingsExecutorContextArgsDict']] executor_context: Settings related to the deployment executor.
        :param pulumi.Input[Union['DeploymentSettingsGithubArgs', 'DeploymentSettingsGithubArgsDict']] github: GitHub settings for the deployment.
        :param pulumi.Input[Union['DeploymentSettingsOperationContextArgs', 'DeploymentSettingsOperationContextArgsDict']] operation_context: Settings related to the Pulumi operation environment during the deployment.
        :param pulumi.Input[_builtins.str] organization: Organization name.
        :param pulumi.Input[_builtins.str] project: Project name.
        :param pulumi.Input[Union['DeploymentSettingsSourceContextArgs', 'DeploymentSettingsSourceContextArgsDict']] source_context: Settings related to the source of the deployment.
        :param pulumi.Input[_builtins.str] stack: Stack name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Deployment settings configure Pulumi Deployments for a stack.

        ### Import

        Deployment settings can be imported using the `id`, which for deployment settings is `{org}/{project}/{stack}` e.g.,

        ```sh
         $ pulumi import pulumiservice:index:DeploymentSettings my_settings my-org/my-project/my-stack
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_options: Optional[pulumi.Input[Union['DeploymentSettingsCacheOptionsArgs', 'DeploymentSettingsCacheOptionsArgsDict']]] = None,
                 executor_context: Optional[pulumi.Input[Union['DeploymentSettingsExecutorContextArgs', 'DeploymentSettingsExecutorContextArgsDict']]] = None,
                 github: Optional[pulumi.Input[Union['DeploymentSettingsGithubArgs', 'DeploymentSettingsGithubArgsDict']]] = None,
                 operation_context: Optional[pulumi.Input[Union['DeploymentSettingsOperationContextArgs', 'DeploymentSettingsOperationContextArgsDict']]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 source_context: Optional[pulumi.Input[Union['DeploymentSettingsSourceContextArgs', 'DeploymentSettingsSourceContextArgsDict']]] = None,
                 stack: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentSettingsArgs.__new__(DeploymentSettingsArgs)

            __props__.__dict__["agent_pool_id"] = agent_pool_id
            __props__.__dict__["cache_options"] = cache_options
            __props__.__dict__["executor_context"] = executor_context
            __props__.__dict__["github"] = github
            __props__.__dict__["operation_context"] = operation_context
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["source_context"] = source_context
            if stack is None and not opts.urn:
                raise TypeError("Missing required property 'stack'")
            __props__.__dict__["stack"] = stack
        super(DeploymentSettings, __self__).__init__(
            'pulumiservice:index:DeploymentSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DeploymentSettings':
        """
        Get an existing DeploymentSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeploymentSettingsArgs.__new__(DeploymentSettingsArgs)

        __props__.__dict__["agent_pool_id"] = None
        __props__.__dict__["cache_options"] = None
        __props__.__dict__["executor_context"] = None
        __props__.__dict__["github"] = None
        __props__.__dict__["operation_context"] = None
        __props__.__dict__["organization"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["source_context"] = None
        __props__.__dict__["stack"] = None
        return DeploymentSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentPoolId")
    def agent_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The agent pool identifier to use for the deployment.
        """
        return pulumi.get(self, "agent_pool_id")

    @_builtins.property
    @pulumi.getter(name="cacheOptions")
    def cache_options(self) -> pulumi.Output[Optional['outputs.DeploymentSettingsCacheOptions']]:
        """
        Dependency cache settings for the deployment
        """
        return pulumi.get(self, "cache_options")

    @_builtins.property
    @pulumi.getter(name="executorContext")
    def executor_context(self) -> pulumi.Output[Optional['outputs.DeploymentSettingsExecutorContext']]:
        """
        Settings related to the deployment executor.
        """
        return pulumi.get(self, "executor_context")

    @_builtins.property
    @pulumi.getter
    def github(self) -> pulumi.Output[Optional['outputs.DeploymentSettingsGithub']]:
        """
        GitHub settings for the deployment.
        """
        return pulumi.get(self, "github")

    @_builtins.property
    @pulumi.getter(name="operationContext")
    def operation_context(self) -> pulumi.Output[Optional['outputs.DeploymentSettingsOperationContext']]:
        """
        Settings related to the Pulumi operation environment during the deployment.
        """
        return pulumi.get(self, "operation_context")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        Organization name.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="sourceContext")
    def source_context(self) -> pulumi.Output[Optional['outputs.DeploymentSettingsSourceContext']]:
        """
        Settings related to the source of the deployment.
        """
        return pulumi.get(self, "source_context")

    @_builtins.property
    @pulumi.getter
    def stack(self) -> pulumi.Output[_builtins.str]:
        """
        Stack name.
        """
        return pulumi.get(self, "stack")

