# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EnvironmentRotationScheduleArgs', 'EnvironmentRotationSchedule']

@pulumi.input_type
class EnvironmentRotationScheduleArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input[_builtins.str],
                 organization: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 schedule_cron: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EnvironmentRotationSchedule resource.
        :param pulumi.Input[_builtins.str] environment: Environment name.
        :param pulumi.Input[_builtins.str] organization: Organization name.
        :param pulumi.Input[_builtins.str] project: Project name.
        :param pulumi.Input[_builtins.str] schedule_cron: Cron expression for recurring scheduled rotations. If you are supplying this, do not supply timestamp.
        :param pulumi.Input[_builtins.str] timestamp: The time at which the rotation should run, in ISO 8601 format. Eg: 2020-01-01T00:00:00Z. If you are supplying this, do not supply scheduleCron.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "project", project)
        if schedule_cron is not None:
            pulumi.set(__self__, "schedule_cron", schedule_cron)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Environment name.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        Organization name.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        Project name.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="scheduleCron")
    def schedule_cron(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cron expression for recurring scheduled rotations. If you are supplying this, do not supply timestamp.
        """
        return pulumi.get(self, "schedule_cron")

    @schedule_cron.setter
    def schedule_cron(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_cron", value)

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the rotation should run, in ISO 8601 format. Eg: 2020-01-01T00:00:00Z. If you are supplying this, do not supply scheduleCron.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp", value)


@pulumi.type_token("pulumiservice:index:EnvironmentRotationSchedule")
class EnvironmentRotationSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_cron: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A scheduled recurring or single time environment rotation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] environment: Environment name.
        :param pulumi.Input[_builtins.str] organization: Organization name.
        :param pulumi.Input[_builtins.str] project: Project name.
        :param pulumi.Input[_builtins.str] schedule_cron: Cron expression for recurring scheduled rotations. If you are supplying this, do not supply timestamp.
        :param pulumi.Input[_builtins.str] timestamp: The time at which the rotation should run, in ISO 8601 format. Eg: 2020-01-01T00:00:00Z. If you are supplying this, do not supply scheduleCron.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentRotationScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A scheduled recurring or single time environment rotation.

        :param str resource_name: The name of the resource.
        :param EnvironmentRotationScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentRotationScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_cron: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentRotationScheduleArgs.__new__(EnvironmentRotationScheduleArgs)

            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["schedule_cron"] = schedule_cron
            __props__.__dict__["timestamp"] = timestamp
            __props__.__dict__["schedule_id"] = None
        super(EnvironmentRotationSchedule, __self__).__init__(
            'pulumiservice:index:EnvironmentRotationSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EnvironmentRotationSchedule':
        """
        Get an existing EnvironmentRotationSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnvironmentRotationScheduleArgs.__new__(EnvironmentRotationScheduleArgs)

        __props__.__dict__["environment"] = None
        __props__.__dict__["organization"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["schedule_cron"] = None
        __props__.__dict__["schedule_id"] = None
        __props__.__dict__["timestamp"] = None
        return EnvironmentRotationSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Environment name.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        Organization name.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="scheduleCron")
    def schedule_cron(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cron expression for recurring scheduled rotations. If you are supplying this, do not supply timestamp.
        """
        return pulumi.get(self, "schedule_cron")

    @_builtins.property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> pulumi.Output[_builtins.str]:
        """
        Schedule ID of the created rotation schedule, assigned by Pulumi Cloud.
        """
        return pulumi.get(self, "schedule_id")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time at which the rotation should run, in ISO 8601 format. Eg: 2020-01-01T00:00:00Z. If you are supplying this, do not supply scheduleCron.
        """
        return pulumi.get(self, "timestamp")

