# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AWSOIDCConfiguration',
    'ApprovalRuleConfig',
    'AuthPolicyDefinition',
    'AzureOIDCConfiguration',
    'DeploymentSettingsCacheOptions',
    'DeploymentSettingsExecutorContext',
    'DeploymentSettingsGitAuthBasicAuth',
    'DeploymentSettingsGitAuthSSHAuth',
    'DeploymentSettingsGitSource',
    'DeploymentSettingsGitSourceGitAuth',
    'DeploymentSettingsGithub',
    'DeploymentSettingsOperationContext',
    'DeploymentSettingsSourceContext',
    'EligibleApprover',
    'EnvironmentIdentifier',
    'GCPOIDCConfiguration',
    'OperationContextOIDC',
    'OperationContextOptions',
    'PolicyGroupPolicyPackReference',
    'PolicyGroupStackReference',
    'TemplateSourceDestination',
]

@pulumi.output_type
class AWSOIDCConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleARN":
            suggest = "role_arn"
        elif key == "sessionName":
            suggest = "session_name"
        elif key == "policyARNs":
            suggest = "policy_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AWSOIDCConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AWSOIDCConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AWSOIDCConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: _builtins.str,
                 session_name: _builtins.str,
                 duration: Optional[_builtins.str] = None,
                 policy_arns: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str role_arn: The ARN of the role to assume using the OIDC token.
        :param _builtins.str session_name: The name of the assume-role session.
        :param _builtins.str duration: Duration of the assume-role session in “XhYmZs” format
        :param Sequence[_builtins.str] policy_arns: Optional set of IAM policy ARNs that further restrict the assume-role session
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "session_name", session_name)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)

    @_builtins.property
    @pulumi.getter(name="roleARN")
    def role_arn(self) -> _builtins.str:
        """
        The ARN of the role to assume using the OIDC token.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> _builtins.str:
        """
        The name of the assume-role session.
        """
        return pulumi.get(self, "session_name")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        Duration of the assume-role session in “XhYmZs” format
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="policyARNs")
    def policy_arns(self) -> Optional[Sequence[_builtins.str]]:
        """
        Optional set of IAM policy ARNs that further restrict the assume-role session
        """
        return pulumi.get(self, "policy_arns")


@pulumi.output_type
class ApprovalRuleConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSelfApproval":
            suggest = "allow_self_approval"
        elif key == "eligibleApprovers":
            suggest = "eligible_approvers"
        elif key == "numApprovalsRequired":
            suggest = "num_approvals_required"
        elif key == "requireReapprovalOnChange":
            suggest = "require_reapproval_on_change"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApprovalRuleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApprovalRuleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApprovalRuleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_self_approval: _builtins.bool,
                 eligible_approvers: Sequence['outputs.EligibleApprover'],
                 num_approvals_required: _builtins.int,
                 require_reapproval_on_change: _builtins.bool):
        """
        :param _builtins.bool allow_self_approval: Whether self-approval is allowed.
        :param Sequence['EligibleApprover'] eligible_approvers: List of eligible approvers.
        :param _builtins.int num_approvals_required: Number of approvals required.
        :param _builtins.bool require_reapproval_on_change: Whether reapproval is required on changes.
        """
        pulumi.set(__self__, "allow_self_approval", allow_self_approval)
        pulumi.set(__self__, "eligible_approvers", eligible_approvers)
        pulumi.set(__self__, "num_approvals_required", num_approvals_required)
        pulumi.set(__self__, "require_reapproval_on_change", require_reapproval_on_change)

    @_builtins.property
    @pulumi.getter(name="allowSelfApproval")
    def allow_self_approval(self) -> _builtins.bool:
        """
        Whether self-approval is allowed.
        """
        return pulumi.get(self, "allow_self_approval")

    @_builtins.property
    @pulumi.getter(name="eligibleApprovers")
    def eligible_approvers(self) -> Sequence['outputs.EligibleApprover']:
        """
        List of eligible approvers.
        """
        return pulumi.get(self, "eligible_approvers")

    @_builtins.property
    @pulumi.getter(name="numApprovalsRequired")
    def num_approvals_required(self) -> _builtins.int:
        """
        Number of approvals required.
        """
        return pulumi.get(self, "num_approvals_required")

    @_builtins.property
    @pulumi.getter(name="requireReapprovalOnChange")
    def require_reapproval_on_change(self) -> _builtins.bool:
        """
        Whether reapproval is required on changes.
        """
        return pulumi.get(self, "require_reapproval_on_change")


@pulumi.output_type
class AuthPolicyDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenType":
            suggest = "token_type"
        elif key == "authorizedPermissions":
            suggest = "authorized_permissions"
        elif key == "runnerID":
            suggest = "runner_id"
        elif key == "teamName":
            suggest = "team_name"
        elif key == "userLogin":
            suggest = "user_login"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthPolicyDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthPolicyDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthPolicyDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 decision: 'AuthPolicyDecision',
                 rules: Mapping[str, _builtins.str],
                 token_type: 'AuthPolicyTokenType',
                 authorized_permissions: Optional[Sequence['AuthPolicyPermissionLevel']] = None,
                 runner_id: Optional[_builtins.str] = None,
                 team_name: Optional[_builtins.str] = None,
                 user_login: Optional[_builtins.str] = None):
        """
        :param 'AuthPolicyDecision' decision: The rule type of this policy definition
        :param Mapping[str, _builtins.str] rules: OIDC rules to set for this policy.
        :param 'AuthPolicyTokenType' token_type: The token type for this policy definition
        :param Sequence['AuthPolicyPermissionLevel'] authorized_permissions: The permission level for organization tokens.
        :param _builtins.str runner_id: The runner ID for deployment runner tokens.
        :param _builtins.str team_name: The team name for team tokens.
        :param _builtins.str user_login: The user login for personal tokens.
        """
        pulumi.set(__self__, "decision", decision)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "token_type", token_type)
        if authorized_permissions is not None:
            pulumi.set(__self__, "authorized_permissions", authorized_permissions)
        if runner_id is not None:
            pulumi.set(__self__, "runner_id", runner_id)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)
        if user_login is not None:
            pulumi.set(__self__, "user_login", user_login)

    @_builtins.property
    @pulumi.getter
    def decision(self) -> 'AuthPolicyDecision':
        """
        The rule type of this policy definition
        """
        return pulumi.get(self, "decision")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Mapping[str, _builtins.str]:
        """
        OIDC rules to set for this policy.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> 'AuthPolicyTokenType':
        """
        The token type for this policy definition
        """
        return pulumi.get(self, "token_type")

    @_builtins.property
    @pulumi.getter(name="authorizedPermissions")
    def authorized_permissions(self) -> Optional[Sequence['AuthPolicyPermissionLevel']]:
        """
        The permission level for organization tokens.
        """
        return pulumi.get(self, "authorized_permissions")

    @_builtins.property
    @pulumi.getter(name="runnerID")
    def runner_id(self) -> Optional[_builtins.str]:
        """
        The runner ID for deployment runner tokens.
        """
        return pulumi.get(self, "runner_id")

    @_builtins.property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[_builtins.str]:
        """
        The team name for team tokens.
        """
        return pulumi.get(self, "team_name")

    @_builtins.property
    @pulumi.getter(name="userLogin")
    def user_login(self) -> Optional[_builtins.str]:
        """
        The user login for personal tokens.
        """
        return pulumi.get(self, "user_login")


@pulumi.output_type
class AzureOIDCConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureOIDCConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureOIDCConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureOIDCConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 subscription_id: _builtins.str,
                 tenant_id: _builtins.str):
        """
        :param _builtins.str client_id: The client ID of the federated workload identity.
        :param _builtins.str subscription_id: The subscription ID of the federated workload identity.
        :param _builtins.str tenant_id: The tenant ID of the federated workload identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client ID of the federated workload identity.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The subscription ID of the federated workload identity.
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The tenant ID of the federated workload identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class DeploymentSettingsCacheOptions(dict):
    """
    Dependency cache settings for the deployment
    """
    def __init__(__self__, *,
                 enable: Optional[_builtins.bool] = None):
        """
        Dependency cache settings for the deployment
        :param _builtins.bool enable: Enable dependency caching
        """
        if enable is None:
            enable = False
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Enable dependency caching
        """
        return pulumi.get(self, "enable")


@pulumi.output_type
class DeploymentSettingsExecutorContext(dict):
    """
    The executor context defines information about the executor where the deployment is executed. If unspecified, the default 'pulumi/pulumi' image is used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executorImage":
            suggest = "executor_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsExecutorContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsExecutorContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsExecutorContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 executor_image: _builtins.str):
        """
        The executor context defines information about the executor where the deployment is executed. If unspecified, the default 'pulumi/pulumi' image is used.
        :param _builtins.str executor_image: Allows overriding the default executor image with a custom image. E.g. 'pulumi/pulumi-nodejs:latest'
        """
        pulumi.set(__self__, "executor_image", executor_image)

    @_builtins.property
    @pulumi.getter(name="executorImage")
    def executor_image(self) -> _builtins.str:
        """
        Allows overriding the default executor image with a custom image. E.g. 'pulumi/pulumi-nodejs:latest'
        """
        return pulumi.get(self, "executor_image")


@pulumi.output_type
class DeploymentSettingsGitAuthBasicAuth(dict):
    """
    Git source settings for a deployment.
    """
    def __init__(__self__, *,
                 password: _builtins.str,
                 username: _builtins.str):
        """
        Git source settings for a deployment.
        :param _builtins.str password: Password for git basic authentication.
        :param _builtins.str username: User name for git basic authentication.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Password for git basic authentication.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        User name for git basic authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DeploymentSettingsGitAuthSSHAuth(dict):
    """
    Git source settings for a deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshPrivateKey":
            suggest = "ssh_private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsGitAuthSSHAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsGitAuthSSHAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsGitAuthSSHAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_private_key: _builtins.str,
                 password: Optional[_builtins.str] = None):
        """
        Git source settings for a deployment.
        :param _builtins.str ssh_private_key: SSH private key.
        :param _builtins.str password: Optional password for SSH authentication.
        """
        pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> _builtins.str:
        """
        SSH private key.
        """
        return pulumi.get(self, "ssh_private_key")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Optional password for SSH authentication.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class DeploymentSettingsGitSource(dict):
    """
    Git source settings for a deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gitAuth":
            suggest = "git_auth"
        elif key == "repoDir":
            suggest = "repo_dir"
        elif key == "repoUrl":
            suggest = "repo_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsGitSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsGitSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsGitSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[_builtins.str] = None,
                 commit: Optional[_builtins.str] = None,
                 git_auth: Optional['outputs.DeploymentSettingsGitSourceGitAuth'] = None,
                 repo_dir: Optional[_builtins.str] = None,
                 repo_url: Optional[_builtins.str] = None):
        """
        Git source settings for a deployment.
        :param _builtins.str branch: The branch to deploy. One of either `branch` or `commit` must be specified.
        :param _builtins.str commit: The commit to deploy. One of either `branch` or `commit` must be specified.
        :param 'DeploymentSettingsGitSourceGitAuth' git_auth: Git authentication configuration for this deployment. Should not be specified if there are `gitHub` settings for this deployment.
        :param _builtins.str repo_dir: The directory within the repository where the Pulumi.yaml is located.
        :param _builtins.str repo_url: The repository URL to use for git settings. Should not be specified if there are `gitHub` settings for this deployment.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if git_auth is not None:
            pulumi.set(__self__, "git_auth", git_auth)
        if repo_dir is not None:
            pulumi.set(__self__, "repo_dir", repo_dir)
        if repo_url is not None:
            pulumi.set(__self__, "repo_url", repo_url)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[_builtins.str]:
        """
        The branch to deploy. One of either `branch` or `commit` must be specified.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter
    def commit(self) -> Optional[_builtins.str]:
        """
        The commit to deploy. One of either `branch` or `commit` must be specified.
        """
        return pulumi.get(self, "commit")

    @_builtins.property
    @pulumi.getter(name="gitAuth")
    def git_auth(self) -> Optional['outputs.DeploymentSettingsGitSourceGitAuth']:
        """
        Git authentication configuration for this deployment. Should not be specified if there are `gitHub` settings for this deployment.
        """
        return pulumi.get(self, "git_auth")

    @_builtins.property
    @pulumi.getter(name="repoDir")
    def repo_dir(self) -> Optional[_builtins.str]:
        """
        The directory within the repository where the Pulumi.yaml is located.
        """
        return pulumi.get(self, "repo_dir")

    @_builtins.property
    @pulumi.getter(name="repoUrl")
    def repo_url(self) -> Optional[_builtins.str]:
        """
        The repository URL to use for git settings. Should not be specified if there are `gitHub` settings for this deployment.
        """
        return pulumi.get(self, "repo_url")


@pulumi.output_type
class DeploymentSettingsGitSourceGitAuth(dict):
    """
    Git source settings for a deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "sshAuth":
            suggest = "ssh_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsGitSourceGitAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsGitSourceGitAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsGitSourceGitAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: Optional['outputs.DeploymentSettingsGitAuthBasicAuth'] = None,
                 ssh_auth: Optional['outputs.DeploymentSettingsGitAuthSSHAuth'] = None):
        """
        Git source settings for a deployment.
        :param 'DeploymentSettingsGitAuthBasicAuth' basic_auth: Basic auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        :param 'DeploymentSettingsGitAuthSSHAuth' ssh_auth: SSH auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if ssh_auth is not None:
            pulumi.set(__self__, "ssh_auth", ssh_auth)

    @_builtins.property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional['outputs.DeploymentSettingsGitAuthBasicAuth']:
        """
        Basic auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        return pulumi.get(self, "basic_auth")

    @_builtins.property
    @pulumi.getter(name="sshAuth")
    def ssh_auth(self) -> Optional['outputs.DeploymentSettingsGitAuthSSHAuth']:
        """
        SSH auth for git authentication. Only one of `personalAccessToken`, `sshAuth`, or `basicAuth` must be defined.
        """
        return pulumi.get(self, "ssh_auth")


@pulumi.output_type
class DeploymentSettingsGithub(dict):
    """
    GitHub settings for the deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployCommits":
            suggest = "deploy_commits"
        elif key == "previewPullRequests":
            suggest = "preview_pull_requests"
        elif key == "pullRequestTemplate":
            suggest = "pull_request_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deploy_commits: Optional[_builtins.bool] = None,
                 paths: Optional[Sequence[_builtins.str]] = None,
                 preview_pull_requests: Optional[_builtins.bool] = None,
                 pull_request_template: Optional[_builtins.bool] = None,
                 repository: Optional[_builtins.str] = None):
        """
        GitHub settings for the deployment.
        :param _builtins.bool deploy_commits: Trigger a deployment running `pulumi up` on commit.
        :param Sequence[_builtins.str] paths: The paths within the repo that deployments should be filtered to.
        :param _builtins.bool preview_pull_requests: Trigger a deployment running `pulumi preview` when a PR is opened.
        :param _builtins.bool pull_request_template: Use this stack as a template for pull request review stacks.
        :param _builtins.str repository: The GitHub repository in the format org/repo.
        """
        if deploy_commits is None:
            deploy_commits = True
        if deploy_commits is not None:
            pulumi.set(__self__, "deploy_commits", deploy_commits)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if preview_pull_requests is None:
            preview_pull_requests = True
        if preview_pull_requests is not None:
            pulumi.set(__self__, "preview_pull_requests", preview_pull_requests)
        if pull_request_template is None:
            pull_request_template = False
        if pull_request_template is not None:
            pulumi.set(__self__, "pull_request_template", pull_request_template)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter(name="deployCommits")
    def deploy_commits(self) -> Optional[_builtins.bool]:
        """
        Trigger a deployment running `pulumi up` on commit.
        """
        return pulumi.get(self, "deploy_commits")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[_builtins.str]]:
        """
        The paths within the repo that deployments should be filtered to.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter(name="previewPullRequests")
    def preview_pull_requests(self) -> Optional[_builtins.bool]:
        """
        Trigger a deployment running `pulumi preview` when a PR is opened.
        """
        return pulumi.get(self, "preview_pull_requests")

    @_builtins.property
    @pulumi.getter(name="pullRequestTemplate")
    def pull_request_template(self) -> Optional[_builtins.bool]:
        """
        Use this stack as a template for pull request review stacks.
        """
        return pulumi.get(self, "pull_request_template")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        The GitHub repository in the format org/repo.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class DeploymentSettingsOperationContext(dict):
    """
    Settings related to the Pulumi operation environment during the deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "preRunCommands":
            suggest = "pre_run_commands"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSettingsOperationContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSettingsOperationContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSettingsOperationContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_variables: Optional[Mapping[str, _builtins.str]] = None,
                 oidc: Optional['outputs.OperationContextOIDC'] = None,
                 options: Optional['outputs.OperationContextOptions'] = None,
                 pre_run_commands: Optional[Sequence[_builtins.str]] = None):
        """
        Settings related to the Pulumi operation environment during the deployment.
        :param Mapping[str, _builtins.str] environment_variables: Environment variables to set for the deployment.
        :param 'OperationContextOIDC' oidc: OIDC configuration to use during the deployment.
        :param 'OperationContextOptions' options: Options to override default behavior during the deployment.
        :param Sequence[_builtins.str] pre_run_commands: Shell commands to run before the Pulumi operation executes.
        """
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if oidc is not None:
            pulumi.set(__self__, "oidc", oidc)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if pre_run_commands is not None:
            pulumi.set(__self__, "pre_run_commands", pre_run_commands)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Environment variables to set for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter
    def oidc(self) -> Optional['outputs.OperationContextOIDC']:
        """
        OIDC configuration to use during the deployment.
        """
        return pulumi.get(self, "oidc")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional['outputs.OperationContextOptions']:
        """
        Options to override default behavior during the deployment.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="preRunCommands")
    def pre_run_commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Shell commands to run before the Pulumi operation executes.
        """
        return pulumi.get(self, "pre_run_commands")


@pulumi.output_type
class DeploymentSettingsSourceContext(dict):
    """
    Settings related to the source of the deployment.
    """
    def __init__(__self__, *,
                 git: Optional['outputs.DeploymentSettingsGitSource'] = None):
        """
        Settings related to the source of the deployment.
        :param 'DeploymentSettingsGitSource' git: Git source settings for a deployment.
        """
        if git is not None:
            pulumi.set(__self__, "git", git)

    @_builtins.property
    @pulumi.getter
    def git(self) -> Optional['outputs.DeploymentSettingsGitSource']:
        """
        Git source settings for a deployment.
        """
        return pulumi.get(self, "git")


@pulumi.output_type
class EligibleApprover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rbacPermission":
            suggest = "rbac_permission"
        elif key == "teamName":
            suggest = "team_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EligibleApprover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EligibleApprover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EligibleApprover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rbac_permission: Optional['RbacPermission'] = None,
                 team_name: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param 'RbacPermission' rbac_permission: RBAC permission that gives right to approve.
        :param _builtins.str team_name: Name of the team that can approve.
        :param _builtins.str user: Login of the user that can approve.
        """
        if rbac_permission is not None:
            pulumi.set(__self__, "rbac_permission", rbac_permission)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="rbacPermission")
    def rbac_permission(self) -> Optional['RbacPermission']:
        """
        RBAC permission that gives right to approve.
        """
        return pulumi.get(self, "rbac_permission")

    @_builtins.property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[_builtins.str]:
        """
        Name of the team that can approve.
        """
        return pulumi.get(self, "team_name")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        Login of the user that can approve.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class EnvironmentIdentifier(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 organization: _builtins.str,
                 project: _builtins.str):
        """
        :param _builtins.str name: The environment name.
        :param _builtins.str organization: The organization name.
        :param _builtins.str project: The project name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The environment name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> _builtins.str:
        """
        The organization name.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The project name.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GCPOIDCConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "providerId":
            suggest = "provider_id"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "workloadPoolId":
            suggest = "workload_pool_id"
        elif key == "tokenLifetime":
            suggest = "token_lifetime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GCPOIDCConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GCPOIDCConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GCPOIDCConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: _builtins.str,
                 provider_id: _builtins.str,
                 service_account: _builtins.str,
                 workload_pool_id: _builtins.str,
                 region: Optional[_builtins.str] = None,
                 token_lifetime: Optional[_builtins.str] = None):
        """
        :param _builtins.str project_id: The numerical ID of the GCP project.
        :param _builtins.str provider_id: The ID of the identity provider associated with the workload pool.
        :param _builtins.str service_account: The email address of the service account to use.
        :param _builtins.str workload_pool_id: The ID of the workload pool to use.
        :param _builtins.str region: The region of the GCP project.
        :param _builtins.str token_lifetime: The lifetime of the temporary credentials in “XhYmZs” format.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_id", provider_id)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "workload_pool_id", workload_pool_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token_lifetime is not None:
            pulumi.set(__self__, "token_lifetime", token_lifetime)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The numerical ID of the GCP project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> _builtins.str:
        """
        The ID of the identity provider associated with the workload pool.
        """
        return pulumi.get(self, "provider_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        The email address of the service account to use.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="workloadPoolId")
    def workload_pool_id(self) -> _builtins.str:
        """
        The ID of the workload pool to use.
        """
        return pulumi.get(self, "workload_pool_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region of the GCP project.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> Optional[_builtins.str]:
        """
        The lifetime of the temporary credentials in “XhYmZs” format.
        """
        return pulumi.get(self, "token_lifetime")


@pulumi.output_type
class OperationContextOIDC(dict):
    def __init__(__self__, *,
                 aws: Optional['outputs.AWSOIDCConfiguration'] = None,
                 azure: Optional['outputs.AzureOIDCConfiguration'] = None,
                 gcp: Optional['outputs.GCPOIDCConfiguration'] = None):
        """
        :param 'AWSOIDCConfiguration' aws: AWS-specific OIDC configuration.
        :param 'AzureOIDCConfiguration' azure: Azure-specific OIDC configuration.
        :param 'GCPOIDCConfiguration' gcp: GCP-specific OIDC configuration.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> Optional['outputs.AWSOIDCConfiguration']:
        """
        AWS-specific OIDC configuration.
        """
        return pulumi.get(self, "aws")

    @_builtins.property
    @pulumi.getter
    def azure(self) -> Optional['outputs.AzureOIDCConfiguration']:
        """
        Azure-specific OIDC configuration.
        """
        return pulumi.get(self, "azure")

    @_builtins.property
    @pulumi.getter
    def gcp(self) -> Optional['outputs.GCPOIDCConfiguration']:
        """
        GCP-specific OIDC configuration.
        """
        return pulumi.get(self, "gcp")


@pulumi.output_type
class OperationContextOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteAfterDestroy":
            suggest = "delete_after_destroy"
        elif key == "skipInstallDependencies":
            suggest = "skip_install_dependencies"
        elif key == "skipIntermediateDeployments":
            suggest = "skip_intermediate_deployments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OperationContextOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OperationContextOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OperationContextOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_after_destroy: Optional[_builtins.bool] = None,
                 shell: Optional[_builtins.str] = None,
                 skip_install_dependencies: Optional[_builtins.bool] = None,
                 skip_intermediate_deployments: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool delete_after_destroy: Whether the stack should be deleted after it is destroyed.
        :param _builtins.str shell: The shell to use to run commands during the deployment. Defaults to 'bash'.
        :param _builtins.bool skip_install_dependencies: Skip the default dependency installation step - use this to customize the dependency installation (e.g. if using yarn or poetry)
        :param _builtins.bool skip_intermediate_deployments: Skip intermediate deployments (Consolidate multiple deployments of the same type into one deployment)
        """
        if delete_after_destroy is not None:
            pulumi.set(__self__, "delete_after_destroy", delete_after_destroy)
        if shell is not None:
            pulumi.set(__self__, "shell", shell)
        if skip_install_dependencies is not None:
            pulumi.set(__self__, "skip_install_dependencies", skip_install_dependencies)
        if skip_intermediate_deployments is not None:
            pulumi.set(__self__, "skip_intermediate_deployments", skip_intermediate_deployments)

    @_builtins.property
    @pulumi.getter(name="deleteAfterDestroy")
    def delete_after_destroy(self) -> Optional[_builtins.bool]:
        """
        Whether the stack should be deleted after it is destroyed.
        """
        return pulumi.get(self, "delete_after_destroy")

    @_builtins.property
    @pulumi.getter
    def shell(self) -> Optional[_builtins.str]:
        """
        The shell to use to run commands during the deployment. Defaults to 'bash'.
        """
        return pulumi.get(self, "shell")

    @_builtins.property
    @pulumi.getter(name="skipInstallDependencies")
    def skip_install_dependencies(self) -> Optional[_builtins.bool]:
        """
        Skip the default dependency installation step - use this to customize the dependency installation (e.g. if using yarn or poetry)
        """
        return pulumi.get(self, "skip_install_dependencies")

    @_builtins.property
    @pulumi.getter(name="skipIntermediateDeployments")
    def skip_intermediate_deployments(self) -> Optional[_builtins.bool]:
        """
        Skip intermediate deployments (Consolidate multiple deployments of the same type into one deployment)
        """
        return pulumi.get(self, "skip_intermediate_deployments")


@pulumi.output_type
class PolicyGroupPolicyPackReference(dict):
    """
    A reference to a policy pack within a policy group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "versionTag":
            suggest = "version_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyGroupPolicyPackReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyGroupPolicyPackReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyGroupPolicyPackReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 config: Optional[Mapping[str, Any]] = None,
                 display_name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.float] = None,
                 version_tag: Optional[_builtins.str] = None):
        """
        A reference to a policy pack within a policy group.
        :param _builtins.str name: The name of the policy pack.
        :param Mapping[str, Any] config: Optional configuration for the policy pack.
        :param _builtins.str display_name: The display name of the policy pack.
        :param _builtins.float version: The version of the policy pack.
        :param _builtins.str version_tag: The version tag of the policy pack.
        """
        pulumi.set(__self__, "name", name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_tag is not None:
            pulumi.set(__self__, "version_tag", version_tag)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the policy pack.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[Mapping[str, Any]]:
        """
        Optional configuration for the policy pack.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the policy pack.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.float]:
        """
        The version of the policy pack.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionTag")
    def version_tag(self) -> Optional[_builtins.str]:
        """
        The version tag of the policy pack.
        """
        return pulumi.get(self, "version_tag")


@pulumi.output_type
class PolicyGroupStackReference(dict):
    """
    A reference to a stack within a policy group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routingProject":
            suggest = "routing_project"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyGroupStackReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyGroupStackReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyGroupStackReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 routing_project: _builtins.str):
        """
        A reference to a stack within a policy group.
        :param _builtins.str name: The name of the stack.
        :param _builtins.str routing_project: The routing project name (also known as project name).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routing_project", routing_project)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the stack.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="routingProject")
    def routing_project(self) -> _builtins.str:
        """
        The routing project name (also known as project name).
        """
        return pulumi.get(self, "routing_project")


@pulumi.output_type
class TemplateSourceDestination(dict):
    def __init__(__self__, *,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str url: Destination URL that gets filled in on new project creation.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        Destination URL that gets filled in on new project creation.
        """
        return pulumi.get(self, "url")


