# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyGroupArgs', 'PolicyGroup']

@pulumi.input_type
class PolicyGroupArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 organization_name: pulumi.Input[_builtins.str],
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_packs: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupPolicyPackReferenceArgs']]]] = None,
                 stacks: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupStackReferenceArgs']]]] = None):
        """
        The set of arguments for constructing a PolicyGroup resource.
        :param pulumi.Input[_builtins.str] name: The name of the policy group.
        :param pulumi.Input[_builtins.str] organization_name: The name of the Pulumi organization the policy group belongs to.
        :param pulumi.Input[_builtins.str] entity_type: The entity type for the policy group. Valid values are 'stacks' or 'accounts'. Defaults to 'stacks'.
        :param pulumi.Input[_builtins.str] mode: The mode for the policy group. Valid values are 'audit' (reports violations) or 'preventative' (blocks operations). Defaults to 'audit'.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyGroupPolicyPackReferenceArgs']]] policy_packs: List of policy packs applied to this policy group.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyGroupStackReferenceArgs']]] stacks: List of stack references that belong to this policy group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_name", organization_name)
        if entity_type is None:
            entity_type = 'stacks'
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if mode is None:
            mode = 'audit'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if policy_packs is not None:
            pulumi.set(__self__, "policy_packs", policy_packs)
        if stacks is not None:
            pulumi.set(__self__, "stacks", stacks)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the policy group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Pulumi organization the policy group belongs to.
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_name", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The entity type for the policy group. Valid values are 'stacks' or 'accounts'. Defaults to 'stacks'.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode for the policy group. Valid values are 'audit' (reports violations) or 'preventative' (blocks operations). Defaults to 'audit'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="policyPacks")
    def policy_packs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupPolicyPackReferenceArgs']]]]:
        """
        List of policy packs applied to this policy group.
        """
        return pulumi.get(self, "policy_packs")

    @policy_packs.setter
    def policy_packs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupPolicyPackReferenceArgs']]]]):
        pulumi.set(self, "policy_packs", value)

    @_builtins.property
    @pulumi.getter
    def stacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupStackReferenceArgs']]]]:
        """
        List of stack references that belong to this policy group.
        """
        return pulumi.get(self, "stacks")

    @stacks.setter
    def stacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupStackReferenceArgs']]]]):
        pulumi.set(self, "stacks", value)


@pulumi.type_token("pulumiservice:index:PolicyGroup")
class PolicyGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_packs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupPolicyPackReferenceArgs', 'PolicyGroupPolicyPackReferenceArgsDict']]]]] = None,
                 stacks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupStackReferenceArgs', 'PolicyGroupStackReferenceArgsDict']]]]] = None,
                 __props__=None):
        """
        A Policy Group allows you to apply policy packs to a set of stacks in your organization.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entity_type: The entity type for the policy group. Valid values are 'stacks' or 'accounts'. Defaults to 'stacks'.
        :param pulumi.Input[_builtins.str] mode: The mode for the policy group. Valid values are 'audit' (reports violations) or 'preventative' (blocks operations). Defaults to 'audit'.
        :param pulumi.Input[_builtins.str] name: The name of the policy group.
        :param pulumi.Input[_builtins.str] organization_name: The name of the Pulumi organization the policy group belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupPolicyPackReferenceArgs', 'PolicyGroupPolicyPackReferenceArgsDict']]]] policy_packs: List of policy packs applied to this policy group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupStackReferenceArgs', 'PolicyGroupStackReferenceArgsDict']]]] stacks: List of stack references that belong to this policy group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Policy Group allows you to apply policy packs to a set of stacks in your organization.

        :param str resource_name: The name of the resource.
        :param PolicyGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_packs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupPolicyPackReferenceArgs', 'PolicyGroupPolicyPackReferenceArgsDict']]]]] = None,
                 stacks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupStackReferenceArgs', 'PolicyGroupStackReferenceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyGroupArgs.__new__(PolicyGroupArgs)

            if entity_type is None:
                entity_type = 'stacks'
            __props__.__dict__["entity_type"] = entity_type
            if mode is None:
                mode = 'audit'
            __props__.__dict__["mode"] = mode
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if organization_name is None and not opts.urn:
                raise TypeError("Missing required property 'organization_name'")
            __props__.__dict__["organization_name"] = organization_name
            __props__.__dict__["policy_packs"] = policy_packs
            __props__.__dict__["stacks"] = stacks
        super(PolicyGroup, __self__).__init__(
            'pulumiservice:index:PolicyGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PolicyGroup':
        """
        Get an existing PolicyGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PolicyGroupArgs.__new__(PolicyGroupArgs)

        __props__.__dict__["entity_type"] = None
        __props__.__dict__["mode"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["organization_name"] = None
        __props__.__dict__["policy_packs"] = None
        __props__.__dict__["stacks"] = None
        return PolicyGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[_builtins.str]:
        """
        The entity type for the policy group. Valid values are 'stacks' or 'accounts'. Defaults to 'stacks'.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        The mode for the policy group. Valid values are 'audit' (reports violations) or 'preventative' (blocks operations). Defaults to 'audit'.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the policy group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Pulumi organization the policy group belongs to.
        """
        return pulumi.get(self, "organization_name")

    @_builtins.property
    @pulumi.getter(name="policyPacks")
    def policy_packs(self) -> pulumi.Output[Optional[Sequence['outputs.PolicyGroupPolicyPackReference']]]:
        """
        List of policy packs applied to this policy group.
        """
        return pulumi.get(self, "policy_packs")

    @_builtins.property
    @pulumi.getter
    def stacks(self) -> pulumi.Output[Optional[Sequence['outputs.PolicyGroupStackReference']]]:
        """
        List of stack references that belong to this policy group.
        """
        return pulumi.get(self, "stacks")

