# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] access_token: Access Token to authenticate with Pulumi Cloud.
        :param pulumi.Input[_builtins.str] api_url: Optional override of Pulumi Cloud API endpoint.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if api_url is None:
            api_url = (_utilities.get_env('PULUMI_BACKEND_URL') or 'https://api.pulumi.com')
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access Token to authenticate with Pulumi Cloud.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional override of Pulumi Cloud API endpoint.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_url", value)


@pulumi.type_token("pulumi:providers:pulumiservice")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Pulumiservice resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: Access Token to authenticate with Pulumi Cloud.
        :param pulumi.Input[_builtins.str] api_url: Optional override of Pulumi Cloud API endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Pulumiservice resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["access_token"] = None if access_token is None else pulumi.Output.secret(access_token)
            if api_url is None:
                api_url = (_utilities.get_env('PULUMI_BACKEND_URL') or 'https://api.pulumi.com')
            __props__.__dict__["api_url"] = api_url
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'pulumiservice',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access Token to authenticate with Pulumi Cloud.
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional override of Pulumi Cloud API endpoint.
        """
        return pulumi.get(self, "api_url")

