# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TtlScheduleArgs', 'TtlSchedule']

@pulumi.input_type
class TtlScheduleArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 stack: pulumi.Input[_builtins.str],
                 timestamp: pulumi.Input[_builtins.str],
                 delete_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TtlSchedule resource.
        :param pulumi.Input[_builtins.str] organization: Organization name.
        :param pulumi.Input[_builtins.str] project: Project name.
        :param pulumi.Input[_builtins.str] stack: Stack name.
        :param pulumi.Input[_builtins.str] timestamp: The time at which the schedule should run, in ISO 8601 format. Eg: 2020-01-01T00:00:00Z.
        :param pulumi.Input[_builtins.bool] delete_after_destroy: True if the stack and all associated history and settings should be deleted.
        """
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "stack", stack)
        pulumi.set(__self__, "timestamp", timestamp)
        if delete_after_destroy is None:
            delete_after_destroy = False
        if delete_after_destroy is not None:
            pulumi.set(__self__, "delete_after_destroy", delete_after_destroy)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        Organization name.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        Project name.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def stack(self) -> pulumi.Input[_builtins.str]:
        """
        Stack name.
        """
        return pulumi.get(self, "stack")

    @stack.setter
    def stack(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack", value)

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> pulumi.Input[_builtins.str]:
        """
        The time at which the schedule should run, in ISO 8601 format. Eg: 2020-01-01T00:00:00Z.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "timestamp", value)

    @_builtins.property
    @pulumi.getter(name="deleteAfterDestroy")
    def delete_after_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the stack and all associated history and settings should be deleted.
        """
        return pulumi.get(self, "delete_after_destroy")

    @delete_after_destroy.setter
    def delete_after_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_after_destroy", value)


@pulumi.type_token("pulumiservice:index:TtlSchedule")
class TtlSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 stack: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A scheduled stack destroy run.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] delete_after_destroy: True if the stack and all associated history and settings should be deleted.
        :param pulumi.Input[_builtins.str] organization: Organization name.
        :param pulumi.Input[_builtins.str] project: Project name.
        :param pulumi.Input[_builtins.str] stack: Stack name.
        :param pulumi.Input[_builtins.str] timestamp: The time at which the schedule should run, in ISO 8601 format. Eg: 2020-01-01T00:00:00Z.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TtlScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A scheduled stack destroy run.

        :param str resource_name: The name of the resource.
        :param TtlScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TtlScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 stack: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TtlScheduleArgs.__new__(TtlScheduleArgs)

            if delete_after_destroy is None:
                delete_after_destroy = False
            __props__.__dict__["delete_after_destroy"] = delete_after_destroy
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if stack is None and not opts.urn:
                raise TypeError("Missing required property 'stack'")
            __props__.__dict__["stack"] = stack
            if timestamp is None and not opts.urn:
                raise TypeError("Missing required property 'timestamp'")
            __props__.__dict__["timestamp"] = timestamp
            __props__.__dict__["schedule_id"] = None
        super(TtlSchedule, __self__).__init__(
            'pulumiservice:index:TtlSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TtlSchedule':
        """
        Get an existing TtlSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TtlScheduleArgs.__new__(TtlScheduleArgs)

        __props__.__dict__["delete_after_destroy"] = None
        __props__.__dict__["organization"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["schedule_id"] = None
        __props__.__dict__["stack"] = None
        __props__.__dict__["timestamp"] = None
        return TtlSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deleteAfterDestroy")
    def delete_after_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        True if the stack and all associated history and settings should be deleted.
        """
        return pulumi.get(self, "delete_after_destroy")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        Organization name.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> pulumi.Output[_builtins.str]:
        """
        Schedule ID of the created schedule, assigned by Pulumi Cloud.
        """
        return pulumi.get(self, "schedule_id")

    @_builtins.property
    @pulumi.getter
    def stack(self) -> pulumi.Output[_builtins.str]:
        """
        Stack name.
        """
        return pulumi.get(self, "stack")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the schedule should run, in ISO 8601 format. Eg: 2020-01-01T00:00:00Z.
        """
        return pulumi.get(self, "timestamp")

