# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from datetime import datetime
from typing_extensions import Literal, TypeAlias

from .._models import BaseModel
from .chat_response import ChatResponse
from .log_prob_response import LogProbResponse
from .chosen_bash20241022 import ChosenBash20241022
from .chosen_function_call import ChosenFunctionCall
from .shared.doc_reference import DocReference
from .chosen_computer20241022 import ChosenComputer20241022
from .chosen_text_editor20241022 import ChosenTextEditor20241022

__all__ = [
    "SessionChatResponse",
    "ChunkChatResponse",
    "ChunkChatResponseChoice",
    "ChunkChatResponseChoiceDelta",
    "ChunkChatResponseChoiceDeltaContentUnionMember2",
    "ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel1",
    "ChunkChatResponseChoiceDeltaContentUnionMember2ContentModel7",
    "ChunkChatResponseChoiceDeltaContentUnionMember2ContentModel7ImageURL",
    "ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2",
    "ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember0",
    "ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember1",
    "ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember1Source",
    "ChunkChatResponseChoiceDeltaToolCall",
    "ChunkChatResponseChoiceToolCall",
    "ChunkChatResponseUsage",
]


class ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel1(BaseModel):
    text: str

    type: Optional[Literal["text"]] = None


class ChunkChatResponseChoiceDeltaContentUnionMember2ContentModel7ImageURL(BaseModel):
    url: str

    detail: Optional[Literal["low", "high", "auto"]] = None


class ChunkChatResponseChoiceDeltaContentUnionMember2ContentModel7(BaseModel):
    image_url: ChunkChatResponseChoiceDeltaContentUnionMember2ContentModel7ImageURL
    """The image URL"""

    type: Optional[Literal["image_url"]] = None


class ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember0(BaseModel):
    text: str

    type: Optional[Literal["text"]] = None


class ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember1Source(
    BaseModel
):
    data: str

    media_type: str

    type: Optional[Literal["base64"]] = None


class ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember1(BaseModel):
    source: ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember1Source

    type: Optional[Literal["image"]] = None


class ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2(BaseModel):
    content: Union[
        List[ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember0],
        List[ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2ContentUnionMember1],
    ]

    tool_use_id: str

    type: Optional[Literal["tool_result"]] = None


ChunkChatResponseChoiceDeltaContentUnionMember2: TypeAlias = Union[
    ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel1,
    ChunkChatResponseChoiceDeltaContentUnionMember2ContentModel7,
    ChunkChatResponseChoiceDeltaContentUnionMember2AgentsAPIAutogenChatContentModel2,
]

ChunkChatResponseChoiceDeltaToolCall: TypeAlias = Union[
    ChosenFunctionCall, ChosenComputer20241022, ChosenTextEditor20241022, ChosenBash20241022
]


class ChunkChatResponseChoiceDelta(BaseModel):
    role: Literal["user", "assistant", "system", "tool"]

    content: Union[str, List[str], List[ChunkChatResponseChoiceDeltaContentUnionMember2], None] = None

    name: Optional[str] = None

    tool_call_id: Optional[str] = None

    tool_calls: Optional[List[ChunkChatResponseChoiceDeltaToolCall]] = None


ChunkChatResponseChoiceToolCall: TypeAlias = Union[
    ChosenFunctionCall, ChosenComputer20241022, ChosenTextEditor20241022, ChosenBash20241022
]


class ChunkChatResponseChoice(BaseModel):
    delta: ChunkChatResponseChoiceDelta
    """The message generated by the model"""

    index: int

    finish_reason: Optional[Literal["stop", "length", "content_filter", "tool_calls"]] = None

    logprobs: Optional[LogProbResponse] = None

    tool_calls: Optional[List[ChunkChatResponseChoiceToolCall]] = None


class ChunkChatResponseUsage(BaseModel):
    completion_tokens: Optional[int] = None

    prompt_tokens: Optional[int] = None

    total_tokens: Optional[int] = None


class ChunkChatResponse(BaseModel):
    id: str

    choices: List[ChunkChatResponseChoice]

    created_at: datetime

    docs: Optional[List[DocReference]] = None

    jobs: Optional[List[str]] = None

    usage: Optional[ChunkChatResponseUsage] = None
    """Usage statistics for the completion request"""


SessionChatResponse: TypeAlias = Union[ChunkChatResponse, ChatResponse]
