# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationPolicyArgs', 'NotificationPolicy']

@pulumi.input_type
class NotificationPolicyArgs:
    def __init__(__self__, *,
                 contact_point: pulumi.Input[builtins.str],
                 group_bies: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 disable_provenance: Optional[pulumi.Input[builtins.bool]] = None,
                 group_interval: Optional[pulumi.Input[builtins.str]] = None,
                 group_wait: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyArgs']]]] = None,
                 repeat_interval: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NotificationPolicy resource.
        :param pulumi.Input[builtins.str] contact_point: The default contact point to route all unmatched notifications to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        :param pulumi.Input[builtins.str] group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param pulumi.Input[builtins.str] group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyArgs']]] policies: Routing rules for specific label sets.
        :param pulumi.Input[builtins.str] repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        pulumi.set(__self__, "contact_point", contact_point)
        pulumi.set(__self__, "group_bies", group_bies)
        if disable_provenance is not None:
            pulumi.set(__self__, "disable_provenance", disable_provenance)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> pulumi.Input[builtins.str]:
        """
        The default contact point to route all unmatched notifications to.
        """
        return pulumi.get(self, "contact_point")

    @contact_point.setter
    def contact_point(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "contact_point", value)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "group_bies", value)

    @property
    @pulumi.getter(name="disableProvenance")
    def disable_provenance(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "disable_provenance")

    @disable_provenance.setter
    def disable_provenance(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_provenance", value)

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @group_interval.setter
    def group_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_interval", value)

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @group_wait.setter
    def group_wait(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_wait", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyArgs']]]]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repeat_interval", value)


@pulumi.input_type
class _NotificationPolicyState:
    def __init__(__self__, *,
                 contact_point: Optional[pulumi.Input[builtins.str]] = None,
                 disable_provenance: Optional[pulumi.Input[builtins.bool]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 group_interval: Optional[pulumi.Input[builtins.str]] = None,
                 group_wait: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyArgs']]]] = None,
                 repeat_interval: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NotificationPolicy resources.
        :param pulumi.Input[builtins.str] contact_point: The default contact point to route all unmatched notifications to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        :param pulumi.Input[builtins.str] group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param pulumi.Input[builtins.str] group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyArgs']]] policies: Routing rules for specific label sets.
        :param pulumi.Input[builtins.str] repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        if contact_point is not None:
            pulumi.set(__self__, "contact_point", contact_point)
        if disable_provenance is not None:
            pulumi.set(__self__, "disable_provenance", disable_provenance)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default contact point to route all unmatched notifications to.
        """
        return pulumi.get(self, "contact_point")

    @contact_point.setter
    def contact_point(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_point", value)

    @property
    @pulumi.getter(name="disableProvenance")
    def disable_provenance(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "disable_provenance")

    @disable_provenance.setter
    def disable_provenance(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_provenance", value)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @group_interval.setter
    def group_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_interval", value)

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @group_wait.setter
    def group_wait(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_wait", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyArgs']]]]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repeat_interval", value)


@pulumi.type_token("grafana:alerting/notificationPolicy:NotificationPolicy")
class NotificationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_point: Optional[pulumi.Input[builtins.str]] = None,
                 disable_provenance: Optional[pulumi.Input[builtins.bool]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 group_interval: Optional[pulumi.Input[builtins.str]] = None,
                 group_wait: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationPolicyPolicyArgs', 'NotificationPolicyPolicyArgsDict']]]]] = None,
                 repeat_interval: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Sets the global notification policy for Grafana.

        !> This resource manages the entire notification policy tree and overwrites its policies. However, it does not overwrite internal policies created when alert rules directly set a contact point for notifications.

        * Official documentation
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/alerting_provisioning/#notification-policies)

        This resource requires Grafana 9.1.0 or later.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        a_contact_point = grafana.alerting.ContactPoint("a_contact_point",
            name="A Contact Point",
            emails=[{
                "addresses": [
                    "one@company.org",
                    "two@company.org",
                ],
                "message": "{{ len .Alerts.Firing }} firing.",
            }])
        a_mute_timing = grafana.alerting.MuteTiming("a_mute_timing",
            name="Some Mute Timing",
            intervals=[{
                "weekdays": ["monday"],
            }])
        my_notification_policy = grafana.alerting.NotificationPolicy("my_notification_policy",
            group_bies=["..."],
            contact_point=a_contact_point.name,
            group_wait="45s",
            group_interval="6m",
            repeat_interval="3h",
            policies=[
                {
                    "matchers": [
                        {
                            "label": "mylabel",
                            "match": "=",
                            "value": "myvalue",
                        },
                        {
                            "label": "alertname",
                            "match": "=",
                            "value": "CPU Usage",
                        },
                        {
                            "label": "Name",
                            "match": "=~",
                            "value": "host.*|host-b.*",
                        },
                    ],
                    "contact_point": a_contact_point.name,
                    "continue_": True,
                    "mute_timings": [a_mute_timing.name],
                    "group_wait": "45s",
                    "group_interval": "6m",
                    "repeat_interval": "3h",
                    "policies": [{
                        "matchers": [{
                            "label": "sublabel",
                            "match": "=",
                            "value": "subvalue",
                        }],
                        "contact_point": a_contact_point.name,
                        "group_bies": ["..."],
                    }],
                },
                {
                    "matchers": [{
                        "label": "anotherlabel",
                        "match": "=~",
                        "value": "another value.*",
                    }],
                    "contact_point": a_contact_point.name,
                    "group_bies": ["..."],
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:alerting/notificationPolicy:NotificationPolicy name "{{ anyString }}"
        ```

        ```sh
        $ pulumi import grafana:alerting/notificationPolicy:NotificationPolicy name "{{ orgID }}:{{ anyString }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] contact_point: The default contact point to route all unmatched notifications to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        :param pulumi.Input[builtins.str] group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param pulumi.Input[builtins.str] group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationPolicyPolicyArgs', 'NotificationPolicyPolicyArgsDict']]]] policies: Routing rules for specific label sets.
        :param pulumi.Input[builtins.str] repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Sets the global notification policy for Grafana.

        !> This resource manages the entire notification policy tree and overwrites its policies. However, it does not overwrite internal policies created when alert rules directly set a contact point for notifications.

        * Official documentation
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/alerting_provisioning/#notification-policies)

        This resource requires Grafana 9.1.0 or later.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        a_contact_point = grafana.alerting.ContactPoint("a_contact_point",
            name="A Contact Point",
            emails=[{
                "addresses": [
                    "one@company.org",
                    "two@company.org",
                ],
                "message": "{{ len .Alerts.Firing }} firing.",
            }])
        a_mute_timing = grafana.alerting.MuteTiming("a_mute_timing",
            name="Some Mute Timing",
            intervals=[{
                "weekdays": ["monday"],
            }])
        my_notification_policy = grafana.alerting.NotificationPolicy("my_notification_policy",
            group_bies=["..."],
            contact_point=a_contact_point.name,
            group_wait="45s",
            group_interval="6m",
            repeat_interval="3h",
            policies=[
                {
                    "matchers": [
                        {
                            "label": "mylabel",
                            "match": "=",
                            "value": "myvalue",
                        },
                        {
                            "label": "alertname",
                            "match": "=",
                            "value": "CPU Usage",
                        },
                        {
                            "label": "Name",
                            "match": "=~",
                            "value": "host.*|host-b.*",
                        },
                    ],
                    "contact_point": a_contact_point.name,
                    "continue_": True,
                    "mute_timings": [a_mute_timing.name],
                    "group_wait": "45s",
                    "group_interval": "6m",
                    "repeat_interval": "3h",
                    "policies": [{
                        "matchers": [{
                            "label": "sublabel",
                            "match": "=",
                            "value": "subvalue",
                        }],
                        "contact_point": a_contact_point.name,
                        "group_bies": ["..."],
                    }],
                },
                {
                    "matchers": [{
                        "label": "anotherlabel",
                        "match": "=~",
                        "value": "another value.*",
                    }],
                    "contact_point": a_contact_point.name,
                    "group_bies": ["..."],
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:alerting/notificationPolicy:NotificationPolicy name "{{ anyString }}"
        ```

        ```sh
        $ pulumi import grafana:alerting/notificationPolicy:NotificationPolicy name "{{ orgID }}:{{ anyString }}"
        ```

        :param str resource_name: The name of the resource.
        :param NotificationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_point: Optional[pulumi.Input[builtins.str]] = None,
                 disable_provenance: Optional[pulumi.Input[builtins.bool]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 group_interval: Optional[pulumi.Input[builtins.str]] = None,
                 group_wait: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationPolicyPolicyArgs', 'NotificationPolicyPolicyArgsDict']]]]] = None,
                 repeat_interval: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationPolicyArgs.__new__(NotificationPolicyArgs)

            if contact_point is None and not opts.urn:
                raise TypeError("Missing required property 'contact_point'")
            __props__.__dict__["contact_point"] = contact_point
            __props__.__dict__["disable_provenance"] = disable_provenance
            if group_bies is None and not opts.urn:
                raise TypeError("Missing required property 'group_bies'")
            __props__.__dict__["group_bies"] = group_bies
            __props__.__dict__["group_interval"] = group_interval
            __props__.__dict__["group_wait"] = group_wait
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["policies"] = policies
            __props__.__dict__["repeat_interval"] = repeat_interval
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/notificationPolicy:NotificationPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(NotificationPolicy, __self__).__init__(
            'grafana:alerting/notificationPolicy:NotificationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contact_point: Optional[pulumi.Input[builtins.str]] = None,
            disable_provenance: Optional[pulumi.Input[builtins.bool]] = None,
            group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            group_interval: Optional[pulumi.Input[builtins.str]] = None,
            group_wait: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationPolicyPolicyArgs', 'NotificationPolicyPolicyArgsDict']]]]] = None,
            repeat_interval: Optional[pulumi.Input[builtins.str]] = None) -> 'NotificationPolicy':
        """
        Get an existing NotificationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] contact_point: The default contact point to route all unmatched notifications to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        :param pulumi.Input[builtins.str] group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param pulumi.Input[builtins.str] group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationPolicyPolicyArgs', 'NotificationPolicyPolicyArgsDict']]]] policies: Routing rules for specific label sets.
        :param pulumi.Input[builtins.str] repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationPolicyState.__new__(_NotificationPolicyState)

        __props__.__dict__["contact_point"] = contact_point
        __props__.__dict__["disable_provenance"] = disable_provenance
        __props__.__dict__["group_bies"] = group_bies
        __props__.__dict__["group_interval"] = group_interval
        __props__.__dict__["group_wait"] = group_wait
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["policies"] = policies
        __props__.__dict__["repeat_interval"] = repeat_interval
        return NotificationPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> pulumi.Output[builtins.str]:
        """
        The default contact point to route all unmatched notifications to.
        """
        return pulumi.get(self, "contact_point")

    @property
    @pulumi.getter(name="disableProvenance")
    def disable_provenance(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "disable_provenance")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        """
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence['outputs.NotificationPolicyPolicy']]]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")

