# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ContactPointAlertmanager',
    'ContactPointDingding',
    'ContactPointDiscord',
    'ContactPointEmail',
    'ContactPointGooglechat',
    'ContactPointKafka',
    'ContactPointLine',
    'ContactPointOncall',
    'ContactPointOpsgeny',
    'ContactPointOpsgenyResponder',
    'ContactPointPagerduty',
    'ContactPointPushover',
    'ContactPointSensugo',
    'ContactPointSlack',
    'ContactPointSn',
    'ContactPointTeam',
    'ContactPointTelegram',
    'ContactPointThreema',
    'ContactPointVictorop',
    'ContactPointWebex',
    'ContactPointWebhook',
    'ContactPointWecom',
    'MuteTimingInterval',
    'MuteTimingIntervalTime',
    'NotificationPolicyPolicy',
    'NotificationPolicyPolicyMatcher',
    'NotificationPolicyPolicyPolicy',
    'NotificationPolicyPolicyPolicyMatcher',
    'NotificationPolicyPolicyPolicyPolicy',
    'NotificationPolicyPolicyPolicyPolicyMatcher',
    'NotificationPolicyPolicyPolicyPolicyPolicy',
    'NotificationPolicyPolicyPolicyPolicyPolicyMatcher',
    'RuleGroupRule',
    'RuleGroupRuleData',
    'RuleGroupRuleDataRelativeTimeRange',
    'RuleGroupRuleNotificationSettings',
    'RuleGroupRuleRecord',
]

@pulumi.output_type
class ContactPointAlertmanager(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuthPassword":
            suggest = "basic_auth_password"
        elif key == "basicAuthUser":
            suggest = "basic_auth_user"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointAlertmanager. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointAlertmanager.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointAlertmanager.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 basic_auth_password: Optional[builtins.str] = None,
                 basic_auth_user: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str url: The URL of the Alertmanager instance.
        :param builtins.str basic_auth_password: The password component of the basic auth credentials to use.
        :param builtins.str basic_auth_user: The username component of the basic auth credentials to use.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if basic_auth_password is not None:
            pulumi.set(__self__, "basic_auth_password", basic_auth_password)
        if basic_auth_user is not None:
            pulumi.set(__self__, "basic_auth_user", basic_auth_user)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL of the Alertmanager instance.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="basicAuthPassword")
    def basic_auth_password(self) -> Optional[builtins.str]:
        """
        The password component of the basic auth credentials to use.
        """
        return pulumi.get(self, "basic_auth_password")

    @property
    @pulumi.getter(name="basicAuthUser")
    def basic_auth_user(self) -> Optional[builtins.str]:
        """
        The username component of the basic auth credentials to use.
        """
        return pulumi.get(self, "basic_auth_user")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointDingding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "messageType":
            suggest = "message_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointDingding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointDingding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointDingding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 message_type: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str url: The DingDing webhook URL.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message: The templated content of the message.
        :param builtins.str message_type: The format of message to send - either 'link' or 'actionCard'
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: The templated title of the message.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The DingDing webhook URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated content of the message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        The format of message to send - either 'link' or 'actionCard'
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        The templated title of the message.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointDiscord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "avatarUrl":
            suggest = "avatar_url"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "useDiscordUsername":
            suggest = "use_discord_username"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointDiscord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointDiscord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointDiscord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 avatar_url: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None,
                 use_discord_username: Optional[builtins.bool] = None):
        """
        :param builtins.str url: The discord webhook URL.
        :param builtins.str avatar_url: The URL of a custom avatar image to use. Defaults to ``.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message: The templated content of the message. Defaults to ``.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: The templated content of the title.
        :param builtins.str uid: The UID of the contact point.
        :param builtins.bool use_discord_username: Whether to use the bot account's plain username instead of "Grafana." Defaults to `false`.
        """
        pulumi.set(__self__, "url", url)
        if avatar_url is not None:
            pulumi.set(__self__, "avatar_url", avatar_url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if use_discord_username is not None:
            pulumi.set(__self__, "use_discord_username", use_discord_username)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The discord webhook URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> Optional[builtins.str]:
        """
        The URL of a custom avatar image to use. Defaults to ``.
        """
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated content of the message. Defaults to ``.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        The templated content of the title.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="useDiscordUsername")
    def use_discord_username(self) -> Optional[builtins.bool]:
        """
        Whether to use the bot account's plain username instead of "Grafana." Defaults to `false`.
        """
        return pulumi.get(self, "use_discord_username")


@pulumi.output_type
class ContactPointEmail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "singleEmail":
            suggest = "single_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointEmail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointEmail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointEmail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Sequence[builtins.str],
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 single_email: Optional[builtins.bool] = None,
                 subject: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] addresses: The addresses to send emails to.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message: The templated content of the email. Defaults to ``.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.bool single_email: Whether to send a single email CC'ing all addresses, rather than a separate email to each address. Defaults to `false`.
        :param builtins.str subject: The templated subject line of the email. Defaults to ``.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "addresses", addresses)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if single_email is not None:
            pulumi.set(__self__, "single_email", single_email)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence[builtins.str]:
        """
        The addresses to send emails to.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated content of the email. Defaults to ``.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="singleEmail")
    def single_email(self) -> Optional[builtins.bool]:
        """
        Whether to send a single email CC'ing all addresses, rather than a separate email to each address. Defaults to `false`.
        """
        return pulumi.get(self, "single_email")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The templated subject line of the email. Defaults to ``.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointGooglechat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableResolveMessage":
            suggest = "disable_resolve_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointGooglechat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointGooglechat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointGooglechat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str url: The Google Chat webhook URL.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message: The templated content of the message.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: The templated content of the title.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The Google Chat webhook URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated content of the message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        The templated content of the title.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restProxyUrl":
            suggest = "rest_proxy_url"
        elif key == "apiVersion":
            suggest = "api_version"
        elif key == "clusterId":
            suggest = "cluster_id"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rest_proxy_url: builtins.str,
                 topic: builtins.str,
                 api_version: Optional[builtins.str] = None,
                 cluster_id: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 details: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 password: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 uid: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str rest_proxy_url: The URL of the Kafka REST proxy to send requests to.
        :param builtins.str topic: The name of the Kafka topic to publish to.
        :param builtins.str api_version: The API version to use when contacting the Kafka REST Server. Supported: v2 (default) and v3. Defaults to `v2`.
        :param builtins.str cluster_id: The Id of cluster to use when contacting the Kafka REST Server. Required api_version to be 'v3'
        :param builtins.str description: The templated description of the Kafka message.
        :param builtins.str details: The templated details to include with the message.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str password: The password to use when making a call to the Kafka REST Proxy
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str uid: The UID of the contact point.
        :param builtins.str username: The user name to use when making a call to the Kafka REST Proxy
        """
        pulumi.set(__self__, "rest_proxy_url", rest_proxy_url)
        pulumi.set(__self__, "topic", topic)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="restProxyUrl")
    def rest_proxy_url(self) -> builtins.str:
        """
        The URL of the Kafka REST proxy to send requests to.
        """
        return pulumi.get(self, "rest_proxy_url")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The name of the Kafka topic to publish to.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        The API version to use when contacting the Kafka REST Server. Supported: v2 (default) and v3. Defaults to `v2`.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[builtins.str]:
        """
        The Id of cluster to use when contacting the Kafka REST Server. Required api_version to be 'v3'
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The templated description of the Kafka message.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def details(self) -> Optional[builtins.str]:
        """
        The templated details to include with the message.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        The password to use when making a call to the Kafka REST Proxy
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        The user name to use when making a call to the Kafka REST Proxy
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ContactPointLine(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableResolveMessage":
            suggest = "disable_resolve_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointLine. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointLine.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointLine.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token: builtins.str,
                 description: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str token: The bearer token used to authorize the client.
        :param builtins.str description: The templated description of the message.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: The templated title of the message.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "token", token)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The bearer token used to authorize the client.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The templated description of the message.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        The templated title of the message.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointOncall(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationCredentials":
            suggest = "authorization_credentials"
        elif key == "authorizationScheme":
            suggest = "authorization_scheme"
        elif key == "basicAuthPassword":
            suggest = "basic_auth_password"
        elif key == "basicAuthUser":
            suggest = "basic_auth_user"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "maxAlerts":
            suggest = "max_alerts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointOncall. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointOncall.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointOncall.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 authorization_credentials: Optional[builtins.str] = None,
                 authorization_scheme: Optional[builtins.str] = None,
                 basic_auth_password: Optional[builtins.str] = None,
                 basic_auth_user: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 http_method: Optional[builtins.str] = None,
                 max_alerts: Optional[builtins.int] = None,
                 message: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str url: The URL to send webhook requests to.
        :param builtins.str authorization_credentials: Allows a custom authorization scheme - attaches an auth header with this value. Do not use in conjunction with basic auth parameters.
        :param builtins.str authorization_scheme: Allows a custom authorization scheme - attaches an auth header with this name. Do not use in conjunction with basic auth parameters.
        :param builtins.str basic_auth_password: The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        :param builtins.str basic_auth_user: The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str http_method: The HTTP method to use in the request. Defaults to `POST`.
        :param builtins.int max_alerts: The maximum number of alerts to send in a single request. This can be helpful in limiting the size of the request body. The default is 0, which indicates no limit.
        :param builtins.str message: Custom message. You can use template variables.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: Templated title of the message.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if authorization_credentials is not None:
            pulumi.set(__self__, "authorization_credentials", authorization_credentials)
        if authorization_scheme is not None:
            pulumi.set(__self__, "authorization_scheme", authorization_scheme)
        if basic_auth_password is not None:
            pulumi.set(__self__, "basic_auth_password", basic_auth_password)
        if basic_auth_user is not None:
            pulumi.set(__self__, "basic_auth_user", basic_auth_user)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if max_alerts is not None:
            pulumi.set(__self__, "max_alerts", max_alerts)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL to send webhook requests to.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="authorizationCredentials")
    def authorization_credentials(self) -> Optional[builtins.str]:
        """
        Allows a custom authorization scheme - attaches an auth header with this value. Do not use in conjunction with basic auth parameters.
        """
        return pulumi.get(self, "authorization_credentials")

    @property
    @pulumi.getter(name="authorizationScheme")
    def authorization_scheme(self) -> Optional[builtins.str]:
        """
        Allows a custom authorization scheme - attaches an auth header with this name. Do not use in conjunction with basic auth parameters.
        """
        return pulumi.get(self, "authorization_scheme")

    @property
    @pulumi.getter(name="basicAuthPassword")
    def basic_auth_password(self) -> Optional[builtins.str]:
        """
        The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        """
        return pulumi.get(self, "basic_auth_password")

    @property
    @pulumi.getter(name="basicAuthUser")
    def basic_auth_user(self) -> Optional[builtins.str]:
        """
        The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        """
        return pulumi.get(self, "basic_auth_user")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[builtins.str]:
        """
        The HTTP method to use in the request. Defaults to `POST`.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="maxAlerts")
    def max_alerts(self) -> Optional[builtins.int]:
        """
        The maximum number of alerts to send in a single request. This can be helpful in limiting the size of the request body. The default is 0, which indicates no limit.
        """
        return pulumi.get(self, "max_alerts")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Custom message. You can use template variables.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Templated title of the message.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointOpsgeny(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "autoClose":
            suggest = "auto_close"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "overridePriority":
            suggest = "override_priority"
        elif key == "sendTagsAs":
            suggest = "send_tags_as"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointOpsgeny. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointOpsgeny.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointOpsgeny.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: builtins.str,
                 auto_close: Optional[builtins.bool] = None,
                 description: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 override_priority: Optional[builtins.bool] = None,
                 responders: Optional[Sequence['outputs.ContactPointOpsgenyResponder']] = None,
                 send_tags_as: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 uid: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str api_key: The OpsGenie API key to use.
        :param builtins.bool auto_close: Whether to auto-close alerts in OpsGenie when they resolve in the Alertmanager.
        :param builtins.str description: A templated high-level description to use for the alert.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message: The templated content of the message.
        :param builtins.bool override_priority: Whether to allow the alert priority to be configured via the value of the `og_priority` annotation on the alert.
        :param Sequence['ContactPointOpsgenyResponderArgs'] responders: Teams, users, escalations and schedules that the alert will be routed to send notifications. If the API Key belongs to a team integration, this field will be overwritten with the owner team. This feature is available from Grafana 10.3+.
        :param builtins.str send_tags_as: Whether to send annotations to OpsGenie as Tags, Details, or both. Supported values are `tags`, `details`, `both`, or empty to use the default behavior of Tags.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str uid: The UID of the contact point.
        :param builtins.str url: Allows customization of the OpsGenie API URL.
        """
        pulumi.set(__self__, "api_key", api_key)
        if auto_close is not None:
            pulumi.set(__self__, "auto_close", auto_close)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if override_priority is not None:
            pulumi.set(__self__, "override_priority", override_priority)
        if responders is not None:
            pulumi.set(__self__, "responders", responders)
        if send_tags_as is not None:
            pulumi.set(__self__, "send_tags_as", send_tags_as)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> builtins.str:
        """
        The OpsGenie API key to use.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="autoClose")
    def auto_close(self) -> Optional[builtins.bool]:
        """
        Whether to auto-close alerts in OpsGenie when they resolve in the Alertmanager.
        """
        return pulumi.get(self, "auto_close")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A templated high-level description to use for the alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated content of the message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="overridePriority")
    def override_priority(self) -> Optional[builtins.bool]:
        """
        Whether to allow the alert priority to be configured via the value of the `og_priority` annotation on the alert.
        """
        return pulumi.get(self, "override_priority")

    @property
    @pulumi.getter
    def responders(self) -> Optional[Sequence['outputs.ContactPointOpsgenyResponder']]:
        """
        Teams, users, escalations and schedules that the alert will be routed to send notifications. If the API Key belongs to a team integration, this field will be overwritten with the owner team. This feature is available from Grafana 10.3+.
        """
        return pulumi.get(self, "responders")

    @property
    @pulumi.getter(name="sendTagsAs")
    def send_tags_as(self) -> Optional[builtins.str]:
        """
        Whether to send annotations to OpsGenie as Tags, Details, or both. Supported values are `tags`, `details`, `both`, or empty to use the default behavior of Tags.
        """
        return pulumi.get(self, "send_tags_as")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        Allows customization of the OpsGenie API URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ContactPointOpsgenyResponder(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of the responder. Supported: team, teams, user, escalation, schedule or a template that is expanded to one of these values.
        :param builtins.str id: ID of the responder. Must be specified if name and username are empty.
        :param builtins.str name: Name of the responder. Must be specified if username and id are empty.
        :param builtins.str username: User name of the responder. Must be specified if name and id are empty.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the responder. Supported: team, teams, user, escalation, schedule or a template that is expanded to one of these values.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        ID of the responder. Must be specified if name and username are empty.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the responder. Must be specified if username and id are empty.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        User name of the responder. Must be specified if name and id are empty.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ContactPointPagerduty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "integrationKey":
            suggest = "integration_key"
        elif key == "class":
            suggest = "class_"
        elif key == "clientUrl":
            suggest = "client_url"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointPagerduty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointPagerduty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointPagerduty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 integration_key: builtins.str,
                 class_: Optional[builtins.str] = None,
                 client: Optional[builtins.str] = None,
                 client_url: Optional[builtins.str] = None,
                 component: Optional[builtins.str] = None,
                 details: Optional[Mapping[str, builtins.str]] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 group: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 severity: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str integration_key: The PagerDuty API key.
        :param builtins.str class_: The class or type of event, for example `ping failure`.
        :param builtins.str client: The name of the monitoring client that is triggering this event.
        :param builtins.str client_url: The URL of the monitoring client that is triggering this event.
        :param builtins.str component: The component being affected by the event.
        :param Mapping[str, builtins.str] details: A set of arbitrary key/value pairs that provide further detail about the incident.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str group: The group to which the provided component belongs to.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str severity: The PagerDuty event severity level. Default is `critical`.
        :param builtins.str source: The unique location of the affected system.
        :param builtins.str summary: The templated summary message of the event.
        :param builtins.str uid: The UID of the contact point.
        :param builtins.str url: The URL to send API requests to
        """
        pulumi.set(__self__, "integration_key", integration_key)
        if class_ is not None:
            pulumi.set(__self__, "class_", class_)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_url is not None:
            pulumi.set(__self__, "client_url", client_url)
        if component is not None:
            pulumi.set(__self__, "component", component)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="integrationKey")
    def integration_key(self) -> builtins.str:
        """
        The PagerDuty API key.
        """
        return pulumi.get(self, "integration_key")

    @property
    @pulumi.getter(name="class")
    def class_(self) -> Optional[builtins.str]:
        """
        The class or type of event, for example `ping failure`.
        """
        return pulumi.get(self, "class_")

    @property
    @pulumi.getter
    def client(self) -> Optional[builtins.str]:
        """
        The name of the monitoring client that is triggering this event.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter(name="clientUrl")
    def client_url(self) -> Optional[builtins.str]:
        """
        The URL of the monitoring client that is triggering this event.
        """
        return pulumi.get(self, "client_url")

    @property
    @pulumi.getter
    def component(self) -> Optional[builtins.str]:
        """
        The component being affected by the event.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def details(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A set of arbitrary key/value pairs that provide further detail about the incident.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        """
        The group to which the provided component belongs to.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def severity(self) -> Optional[builtins.str]:
        """
        The PagerDuty event severity level. Default is `critical`.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        The unique location of the affected system.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        The templated summary message of the event.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        The URL to send API requests to
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ContactPointPushover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiToken":
            suggest = "api_token"
        elif key == "userKey":
            suggest = "user_key"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "okPriority":
            suggest = "ok_priority"
        elif key == "okSound":
            suggest = "ok_sound"
        elif key == "uploadImage":
            suggest = "upload_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointPushover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointPushover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointPushover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_token: builtins.str,
                 user_key: builtins.str,
                 device: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 expire: Optional[builtins.int] = None,
                 message: Optional[builtins.str] = None,
                 ok_priority: Optional[builtins.int] = None,
                 ok_sound: Optional[builtins.str] = None,
                 priority: Optional[builtins.int] = None,
                 retry: Optional[builtins.int] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 sound: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None,
                 upload_image: Optional[builtins.bool] = None):
        """
        :param builtins.str api_token: The Pushover API token.
        :param builtins.str user_key: The Pushover user key.
        :param builtins.str device: Comma-separated list of devices to which the event is associated.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.int expire: How many seconds for which the notification will continue to be retried by Pushover.
        :param builtins.str message: The templated notification message content.
        :param builtins.int ok_priority: The priority level of the resolved event.
        :param builtins.str ok_sound: The sound associated with the resolved notification.
        :param builtins.int priority: The priority level of the event.
        :param builtins.int retry: How often, in seconds, the Pushover servers will send the same notification to the user.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str sound: The sound associated with the notification.
        :param builtins.str title: The templated title of the message.
        :param builtins.str uid: The UID of the contact point.
        :param builtins.bool upload_image: Whether to send images in the notification or not. Default is true. Requires Grafana to be configured to send images in notifications.
        """
        pulumi.set(__self__, "api_token", api_token)
        pulumi.set(__self__, "user_key", user_key)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if expire is not None:
            pulumi.set(__self__, "expire", expire)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if ok_priority is not None:
            pulumi.set(__self__, "ok_priority", ok_priority)
        if ok_sound is not None:
            pulumi.set(__self__, "ok_sound", ok_sound)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if sound is not None:
            pulumi.set(__self__, "sound", sound)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if upload_image is not None:
            pulumi.set(__self__, "upload_image", upload_image)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> builtins.str:
        """
        The Pushover API token.
        """
        return pulumi.get(self, "api_token")

    @property
    @pulumi.getter(name="userKey")
    def user_key(self) -> builtins.str:
        """
        The Pushover user key.
        """
        return pulumi.get(self, "user_key")

    @property
    @pulumi.getter
    def device(self) -> Optional[builtins.str]:
        """
        Comma-separated list of devices to which the event is associated.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def expire(self) -> Optional[builtins.int]:
        """
        How many seconds for which the notification will continue to be retried by Pushover.
        """
        return pulumi.get(self, "expire")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated notification message content.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="okPriority")
    def ok_priority(self) -> Optional[builtins.int]:
        """
        The priority level of the resolved event.
        """
        return pulumi.get(self, "ok_priority")

    @property
    @pulumi.getter(name="okSound")
    def ok_sound(self) -> Optional[builtins.str]:
        """
        The sound associated with the resolved notification.
        """
        return pulumi.get(self, "ok_sound")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        The priority level of the event.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def retry(self) -> Optional[builtins.int]:
        """
        How often, in seconds, the Pushover servers will send the same notification to the user.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def sound(self) -> Optional[builtins.str]:
        """
        The sound associated with the notification.
        """
        return pulumi.get(self, "sound")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        The templated title of the message.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="uploadImage")
    def upload_image(self) -> Optional[builtins.bool]:
        """
        Whether to send images in the notification or not. Default is true. Requires Grafana to be configured to send images in notifications.
        """
        return pulumi.get(self, "upload_image")


@pulumi.output_type
class ContactPointSensugo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointSensugo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointSensugo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointSensugo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: builtins.str,
                 url: builtins.str,
                 check: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 entity: Optional[builtins.str] = None,
                 handler: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str api_key: The SensuGo API key.
        :param builtins.str url: The SensuGo URL to send requests to.
        :param builtins.str check: The SensuGo check to which the event should be routed.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str entity: The entity being monitored.
        :param builtins.str handler: A custom handler to execute in addition to the check.
        :param builtins.str message: Templated message content describing the alert.
        :param builtins.str namespace: The namespace in which the check resides.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "url", url)
        if check is not None:
            pulumi.set(__self__, "check", check)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> builtins.str:
        """
        The SensuGo API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The SensuGo URL to send requests to.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def check(self) -> Optional[builtins.str]:
        """
        The SensuGo check to which the event should be routed.
        """
        return pulumi.get(self, "check")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def entity(self) -> Optional[builtins.str]:
        """
        The entity being monitored.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter
    def handler(self) -> Optional[builtins.str]:
        """
        A custom handler to execute in addition to the check.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Templated message content describing the alert.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace in which the check resides.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointSlack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "endpointUrl":
            suggest = "endpoint_url"
        elif key == "iconEmoji":
            suggest = "icon_emoji"
        elif key == "iconUrl":
            suggest = "icon_url"
        elif key == "mentionChannel":
            suggest = "mention_channel"
        elif key == "mentionGroups":
            suggest = "mention_groups"
        elif key == "mentionUsers":
            suggest = "mention_users"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointSlack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointSlack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointSlack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 color: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 endpoint_url: Optional[builtins.str] = None,
                 icon_emoji: Optional[builtins.str] = None,
                 icon_url: Optional[builtins.str] = None,
                 mention_channel: Optional[builtins.str] = None,
                 mention_groups: Optional[builtins.str] = None,
                 mention_users: Optional[builtins.str] = None,
                 recipient: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 text: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None,
                 token: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str color: Templated color of the slack message.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str endpoint_url: Use this to override the Slack API endpoint URL to send requests to.
        :param builtins.str icon_emoji: The name of a Slack workspace emoji to use as the bot icon.
        :param builtins.str icon_url: A URL of an image to use as the bot icon.
        :param builtins.str mention_channel: Describes how to ping the slack channel that messages are being sent to. Options are `here` for an @here ping, `channel` for @channel, or empty for no ping.
        :param builtins.str mention_groups: Comma-separated list of groups to mention in the message.
        :param builtins.str mention_users: Comma-separated list of users to mention in the message.
        :param builtins.str recipient: Channel, private group, or IM channel (can be an encoded ID or a name) to send messages to.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str text: Templated content of the message.
        :param builtins.str title: Templated title of the message.
        :param builtins.str token: A Slack API token,for sending messages directly without the webhook method.
        :param builtins.str uid: The UID of the contact point.
        :param builtins.str url: A Slack webhook URL,for sending messages via the webhook method.
        :param builtins.str username: Username for the bot to use.
        """
        if color is not None:
            pulumi.set(__self__, "color", color)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if icon_emoji is not None:
            pulumi.set(__self__, "icon_emoji", icon_emoji)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if mention_channel is not None:
            pulumi.set(__self__, "mention_channel", mention_channel)
        if mention_groups is not None:
            pulumi.set(__self__, "mention_groups", mention_groups)
        if mention_users is not None:
            pulumi.set(__self__, "mention_users", mention_users)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def color(self) -> Optional[builtins.str]:
        """
        Templated color of the slack message.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[builtins.str]:
        """
        Use this to override the Slack API endpoint URL to send requests to.
        """
        return pulumi.get(self, "endpoint_url")

    @property
    @pulumi.getter(name="iconEmoji")
    def icon_emoji(self) -> Optional[builtins.str]:
        """
        The name of a Slack workspace emoji to use as the bot icon.
        """
        return pulumi.get(self, "icon_emoji")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[builtins.str]:
        """
        A URL of an image to use as the bot icon.
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="mentionChannel")
    def mention_channel(self) -> Optional[builtins.str]:
        """
        Describes how to ping the slack channel that messages are being sent to. Options are `here` for an @here ping, `channel` for @channel, or empty for no ping.
        """
        return pulumi.get(self, "mention_channel")

    @property
    @pulumi.getter(name="mentionGroups")
    def mention_groups(self) -> Optional[builtins.str]:
        """
        Comma-separated list of groups to mention in the message.
        """
        return pulumi.get(self, "mention_groups")

    @property
    @pulumi.getter(name="mentionUsers")
    def mention_users(self) -> Optional[builtins.str]:
        """
        Comma-separated list of users to mention in the message.
        """
        return pulumi.get(self, "mention_users")

    @property
    @pulumi.getter
    def recipient(self) -> Optional[builtins.str]:
        """
        Channel, private group, or IM channel (can be an encoded ID or a name) to send messages to.
        """
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def text(self) -> Optional[builtins.str]:
        """
        Templated content of the message.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Templated title of the message.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def token(self) -> Optional[builtins.str]:
        """
        A Slack API token,for sending messages directly without the webhook method.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        A Slack webhook URL,for sending messages via the webhook method.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Username for the bot to use.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ContactPointSn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "assumeRoleArn":
            suggest = "assume_role_arn"
        elif key == "authProvider":
            suggest = "auth_provider"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointSn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointSn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointSn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic: builtins.str,
                 access_key: Optional[builtins.str] = None,
                 assume_role_arn: Optional[builtins.str] = None,
                 auth_provider: Optional[builtins.str] = None,
                 body: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 external_id: Optional[builtins.str] = None,
                 message_format: Optional[builtins.str] = None,
                 secret_key: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 subject: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str topic: The Amazon SNS topic to send notifications to.
        :param builtins.str access_key: AWS access key ID used to authenticate with Amazon SNS.
        :param builtins.str assume_role_arn: The Amazon Resource Name (ARN) of the role to assume to send notifications to Amazon SNS.
        :param builtins.str auth_provider: The authentication provider to use. Valid values are `default`, `arn` and `keys`. Default is `default`. Defaults to `default`.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str external_id: The external ID to use when assuming the role.
        :param builtins.str message_format: The format of the message to send. Valid values are `text`, `body` and `json`. Default is `text`. Defaults to `text`.
        :param builtins.str secret_key: AWS secret access key used to authenticate with Amazon SNS.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if assume_role_arn is not None:
            pulumi.set(__self__, "assume_role_arn", assume_role_arn)
        if auth_provider is not None:
            pulumi.set(__self__, "auth_provider", auth_provider)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The Amazon SNS topic to send notifications to.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[builtins.str]:
        """
        AWS access key ID used to authenticate with Amazon SNS.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="assumeRoleArn")
    def assume_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the role to assume to send notifications to Amazon SNS.
        """
        return pulumi.get(self, "assume_role_arn")

    @property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> Optional[builtins.str]:
        """
        The authentication provider to use. Valid values are `default`, `arn` and `keys`. Default is `default`. Defaults to `default`.
        """
        return pulumi.get(self, "auth_provider")

    @property
    @pulumi.getter
    def body(self) -> Optional[builtins.str]:
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        The external ID to use when assuming the role.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[builtins.str]:
        """
        The format of the message to send. Valid values are `text`, `body` and `json`. Default is `text`. Defaults to `text`.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[builtins.str]:
        """
        AWS secret access key used to authenticate with Amazon SNS.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointTeam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "sectionTitle":
            suggest = "section_title"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointTeam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointTeam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointTeam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 section_title: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str url: A Teams webhook URL.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message: The templated message content to send.
        :param builtins.str section_title: The templated subtitle for each message section.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: The templated title of the message.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if section_title is not None:
            pulumi.set(__self__, "section_title", section_title)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        A Teams webhook URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated message content to send.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="sectionTitle")
    def section_title(self) -> Optional[builtins.str]:
        """
        The templated subtitle for each message section.
        """
        return pulumi.get(self, "section_title")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        The templated title of the message.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointTelegram(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chatId":
            suggest = "chat_id"
        elif key == "disableNotifications":
            suggest = "disable_notifications"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "disableWebPagePreview":
            suggest = "disable_web_page_preview"
        elif key == "messageThreadId":
            suggest = "message_thread_id"
        elif key == "parseMode":
            suggest = "parse_mode"
        elif key == "protectContent":
            suggest = "protect_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointTelegram. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointTelegram.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointTelegram.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chat_id: builtins.str,
                 token: builtins.str,
                 disable_notifications: Optional[builtins.bool] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 disable_web_page_preview: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 message_thread_id: Optional[builtins.str] = None,
                 parse_mode: Optional[builtins.str] = None,
                 protect_content: Optional[builtins.bool] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str chat_id: The chat ID to send messages to.
        :param builtins.str token: The Telegram bot token.
        :param builtins.bool disable_notifications: When set users will receive a notification with no sound.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.bool disable_web_page_preview: When set it disables link previews for links in the message.
        :param builtins.str message: The templated content of the message.
        :param builtins.str message_thread_id: The ID of the message thread to send the message to.
        :param builtins.str parse_mode: Mode for parsing entities in the message text. Supported: None, Markdown, MarkdownV2, and HTML. HTML is the default.
        :param builtins.bool protect_content: When set it protects the contents of the message from forwarding and saving.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "chat_id", chat_id)
        pulumi.set(__self__, "token", token)
        if disable_notifications is not None:
            pulumi.set(__self__, "disable_notifications", disable_notifications)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if disable_web_page_preview is not None:
            pulumi.set(__self__, "disable_web_page_preview", disable_web_page_preview)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_thread_id is not None:
            pulumi.set(__self__, "message_thread_id", message_thread_id)
        if parse_mode is not None:
            pulumi.set(__self__, "parse_mode", parse_mode)
        if protect_content is not None:
            pulumi.set(__self__, "protect_content", protect_content)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="chatId")
    def chat_id(self) -> builtins.str:
        """
        The chat ID to send messages to.
        """
        return pulumi.get(self, "chat_id")

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The Telegram bot token.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="disableNotifications")
    def disable_notifications(self) -> Optional[builtins.bool]:
        """
        When set users will receive a notification with no sound.
        """
        return pulumi.get(self, "disable_notifications")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter(name="disableWebPagePreview")
    def disable_web_page_preview(self) -> Optional[builtins.bool]:
        """
        When set it disables link previews for links in the message.
        """
        return pulumi.get(self, "disable_web_page_preview")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated content of the message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageThreadId")
    def message_thread_id(self) -> Optional[builtins.str]:
        """
        The ID of the message thread to send the message to.
        """
        return pulumi.get(self, "message_thread_id")

    @property
    @pulumi.getter(name="parseMode")
    def parse_mode(self) -> Optional[builtins.str]:
        """
        Mode for parsing entities in the message text. Supported: None, Markdown, MarkdownV2, and HTML. HTML is the default.
        """
        return pulumi.get(self, "parse_mode")

    @property
    @pulumi.getter(name="protectContent")
    def protect_content(self) -> Optional[builtins.bool]:
        """
        When set it protects the contents of the message from forwarding and saving.
        """
        return pulumi.get(self, "protect_content")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointThreema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiSecret":
            suggest = "api_secret"
        elif key == "gatewayId":
            suggest = "gateway_id"
        elif key == "recipientId":
            suggest = "recipient_id"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointThreema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointThreema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointThreema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_secret: builtins.str,
                 gateway_id: builtins.str,
                 recipient_id: builtins.str,
                 description: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str api_secret: The Threema API key.
        :param builtins.str gateway_id: The Threema gateway ID.
        :param builtins.str recipient_id: The ID of the recipient of the message.
        :param builtins.str description: The templated description of the message.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: The templated title of the message.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "api_secret", api_secret)
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "recipient_id", recipient_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiSecret")
    def api_secret(self) -> builtins.str:
        """
        The Threema API key.
        """
        return pulumi.get(self, "api_secret")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> builtins.str:
        """
        The Threema gateway ID.
        """
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter(name="recipientId")
    def recipient_id(self) -> builtins.str:
        """
        The ID of the recipient of the message.
        """
        return pulumi.get(self, "recipient_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The templated description of the message.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        The templated title of the message.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointVictorop(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "messageType":
            suggest = "message_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointVictorop. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointVictorop.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointVictorop.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 description: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message_type: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str url: The VictorOps webhook URL.
        :param builtins.str description: Templated description of the message.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message_type: The VictorOps alert state - typically either `CRITICAL` or `RECOVERY`.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: Templated title to display.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The VictorOps webhook URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Templated description of the message.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[builtins.str]:
        """
        The VictorOps alert state - typically either `CRITICAL` or `RECOVERY`.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Templated title to display.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointWebex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiUrl":
            suggest = "api_url"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "roomId":
            suggest = "room_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointWebex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointWebex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointWebex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_url: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 room_id: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 token: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str api_url: The URL to send webhook requests to.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message: The templated title of the message to send.
        :param builtins.str room_id: ID of the Webex Teams room where to send the messages.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str token: The bearer token used to authorize the client.
        :param builtins.str uid: The UID of the contact point.
        """
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if room_id is not None:
            pulumi.set(__self__, "room_id", room_id)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[builtins.str]:
        """
        The URL to send webhook requests to.
        """
        return pulumi.get(self, "api_url")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated title of the message to send.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="roomId")
    def room_id(self) -> Optional[builtins.str]:
        """
        ID of the Webex Teams room where to send the messages.
        """
        return pulumi.get(self, "room_id")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def token(self) -> Optional[builtins.str]:
        """
        The bearer token used to authorize the client.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointWebhook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationCredentials":
            suggest = "authorization_credentials"
        elif key == "authorizationScheme":
            suggest = "authorization_scheme"
        elif key == "basicAuthPassword":
            suggest = "basic_auth_password"
        elif key == "basicAuthUser":
            suggest = "basic_auth_user"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "maxAlerts":
            suggest = "max_alerts"
        elif key == "tlsConfig":
            suggest = "tls_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointWebhook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointWebhook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointWebhook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 authorization_credentials: Optional[builtins.str] = None,
                 authorization_scheme: Optional[builtins.str] = None,
                 basic_auth_password: Optional[builtins.str] = None,
                 basic_auth_user: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 http_method: Optional[builtins.str] = None,
                 max_alerts: Optional[builtins.int] = None,
                 message: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 tls_config: Optional[Mapping[str, builtins.str]] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str url: The URL to send webhook requests to.
        :param builtins.str authorization_credentials: Allows a custom authorization scheme - attaches an auth header with this value. Do not use in conjunction with basic auth parameters.
        :param builtins.str authorization_scheme: Allows a custom authorization scheme - attaches an auth header with this name. Do not use in conjunction with basic auth parameters.
        :param builtins.str basic_auth_password: The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        :param builtins.str basic_auth_user: The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str http_method: The HTTP method to use in the request. Defaults to `POST`.
        :param builtins.int max_alerts: The maximum number of alerts to send in a single request. This can be helpful in limiting the size of the request body. The default is 0, which indicates no limit.
        :param builtins.str message: Custom message. You can use template variables.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: Templated title of the message.
        :param Mapping[str, builtins.str] tls_config: Allows configuring TLS for the webhook notifier.
        :param builtins.str uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if authorization_credentials is not None:
            pulumi.set(__self__, "authorization_credentials", authorization_credentials)
        if authorization_scheme is not None:
            pulumi.set(__self__, "authorization_scheme", authorization_scheme)
        if basic_auth_password is not None:
            pulumi.set(__self__, "basic_auth_password", basic_auth_password)
        if basic_auth_user is not None:
            pulumi.set(__self__, "basic_auth_user", basic_auth_user)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if max_alerts is not None:
            pulumi.set(__self__, "max_alerts", max_alerts)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL to send webhook requests to.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="authorizationCredentials")
    def authorization_credentials(self) -> Optional[builtins.str]:
        """
        Allows a custom authorization scheme - attaches an auth header with this value. Do not use in conjunction with basic auth parameters.
        """
        return pulumi.get(self, "authorization_credentials")

    @property
    @pulumi.getter(name="authorizationScheme")
    def authorization_scheme(self) -> Optional[builtins.str]:
        """
        Allows a custom authorization scheme - attaches an auth header with this name. Do not use in conjunction with basic auth parameters.
        """
        return pulumi.get(self, "authorization_scheme")

    @property
    @pulumi.getter(name="basicAuthPassword")
    def basic_auth_password(self) -> Optional[builtins.str]:
        """
        The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        """
        return pulumi.get(self, "basic_auth_password")

    @property
    @pulumi.getter(name="basicAuthUser")
    def basic_auth_user(self) -> Optional[builtins.str]:
        """
        The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        """
        return pulumi.get(self, "basic_auth_user")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[builtins.str]:
        """
        The HTTP method to use in the request. Defaults to `POST`.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="maxAlerts")
    def max_alerts(self) -> Optional[builtins.int]:
        """
        The maximum number of alerts to send in a single request. This can be helpful in limiting the size of the request body. The default is 0, which indicates no limit.
        """
        return pulumi.get(self, "max_alerts")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Custom message. You can use template variables.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Templated title of the message.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Allows configuring TLS for the webhook notifier.
        """
        return pulumi.get(self, "tls_config")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ContactPointWecom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentId":
            suggest = "agent_id"
        elif key == "corpId":
            suggest = "corp_id"
        elif key == "disableResolveMessage":
            suggest = "disable_resolve_message"
        elif key == "msgType":
            suggest = "msg_type"
        elif key == "toUser":
            suggest = "to_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactPointWecom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactPointWecom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactPointWecom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_id: Optional[builtins.str] = None,
                 corp_id: Optional[builtins.str] = None,
                 disable_resolve_message: Optional[builtins.bool] = None,
                 message: Optional[builtins.str] = None,
                 msg_type: Optional[builtins.str] = None,
                 secret: Optional[builtins.str] = None,
                 settings: Optional[Mapping[str, builtins.str]] = None,
                 title: Optional[builtins.str] = None,
                 to_user: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str agent_id: Agent ID added to the request payload when using APIAPP.
        :param builtins.str corp_id: Corp ID used to get token when using APIAPP.
        :param builtins.bool disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param builtins.str message: The templated content of the message to send.
        :param builtins.str msg_type: The type of them message. Supported: markdown, text. Default: text.
        :param builtins.str secret: The secret key required to obtain access token when using APIAPP. See https://work.weixin.qq.com/wework_admin/frame#apps to create APIAPP.
        :param Mapping[str, builtins.str] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param builtins.str title: The templated title of the message to send.
        :param builtins.str to_user: The ID of user that should receive the message. Multiple entries should be separated by '|'. Default: @all.
        :param builtins.str uid: The UID of the contact point.
        :param builtins.str url: The WeCom webhook URL. Required if using GroupRobot.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if corp_id is not None:
            pulumi.set(__self__, "corp_id", corp_id)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if msg_type is not None:
            pulumi.set(__self__, "msg_type", msg_type)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if to_user is not None:
            pulumi.set(__self__, "to_user", to_user)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[builtins.str]:
        """
        Agent ID added to the request payload when using APIAPP.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="corpId")
    def corp_id(self) -> Optional[builtins.str]:
        """
        Corp ID used to get token when using APIAPP.
        """
        return pulumi.get(self, "corp_id")

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[builtins.bool]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The templated content of the message to send.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="msgType")
    def msg_type(self) -> Optional[builtins.str]:
        """
        The type of them message. Supported: markdown, text. Default: text.
        """
        return pulumi.get(self, "msg_type")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.str]:
        """
        The secret key required to obtain access token when using APIAPP. See https://work.weixin.qq.com/wework_admin/frame#apps to create APIAPP.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        The templated title of the message to send.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="toUser")
    def to_user(self) -> Optional[builtins.str]:
        """
        The ID of user that should receive the message. Multiple entries should be separated by '|'. Default: @all.
        """
        return pulumi.get(self, "to_user")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        The WeCom webhook URL. Required if using GroupRobot.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class MuteTimingInterval(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfMonths":
            suggest = "days_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MuteTimingInterval. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MuteTimingInterval.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MuteTimingInterval.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_months: Optional[Sequence[builtins.str]] = None,
                 location: Optional[builtins.str] = None,
                 months: Optional[Sequence[builtins.str]] = None,
                 times: Optional[Sequence['outputs.MuteTimingIntervalTime']] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None,
                 years: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] days_of_months: An inclusive range of days, 1-31, within a month, e.g. "1" or "14:16". Negative values can be used to represent days counting from the end of a month, e.g. "-1".
        :param builtins.str location: Provides the time zone for the time interval. Must be a location in the IANA time zone database, e.g "America/New_York"
        :param Sequence[builtins.str] months: An inclusive range of months, either numerical or full calendar month, e.g. "1:3", "december", or "may:august".
        :param Sequence['MuteTimingIntervalTimeArgs'] times: The time ranges, represented in minutes, during which to mute in a given day.
        :param Sequence[builtins.str] weekdays: An inclusive range of weekdays, e.g. "monday" or "tuesday:thursday".
        :param Sequence[builtins.str] years: A positive inclusive range of years, e.g. "2030" or "2025:2026".
        """
        if days_of_months is not None:
            pulumi.set(__self__, "days_of_months", days_of_months)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if months is not None:
            pulumi.set(__self__, "months", months)
        if times is not None:
            pulumi.set(__self__, "times", times)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter(name="daysOfMonths")
    def days_of_months(self) -> Optional[Sequence[builtins.str]]:
        """
        An inclusive range of days, 1-31, within a month, e.g. "1" or "14:16". Negative values can be used to represent days counting from the end of a month, e.g. "-1".
        """
        return pulumi.get(self, "days_of_months")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        Provides the time zone for the time interval. Must be a location in the IANA time zone database, e.g "America/New_York"
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def months(self) -> Optional[Sequence[builtins.str]]:
        """
        An inclusive range of months, either numerical or full calendar month, e.g. "1:3", "december", or "may:august".
        """
        return pulumi.get(self, "months")

    @property
    @pulumi.getter
    def times(self) -> Optional[Sequence['outputs.MuteTimingIntervalTime']]:
        """
        The time ranges, represented in minutes, during which to mute in a given day.
        """
        return pulumi.get(self, "times")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        An inclusive range of weekdays, e.g. "monday" or "tuesday:thursday".
        """
        return pulumi.get(self, "weekdays")

    @property
    @pulumi.getter
    def years(self) -> Optional[Sequence[builtins.str]]:
        """
        A positive inclusive range of years, e.g. "2030" or "2025:2026".
        """
        return pulumi.get(self, "years")


@pulumi.output_type
class MuteTimingIntervalTime(dict):
    def __init__(__self__, *,
                 end: builtins.str,
                 start: builtins.str):
        """
        :param builtins.str end: The time, in hh:mm format, of when the interval should end exclusively.
        :param builtins.str start: The time, in hh:mm format, of when the interval should begin inclusively.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> builtins.str:
        """
        The time, in hh:mm format, of when the interval should end exclusively.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> builtins.str:
        """
        The time, in hh:mm format, of when the interval should begin inclusively.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class NotificationPolicyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactPoint":
            suggest = "contact_point"
        elif key == "continue":
            suggest = "continue_"
        elif key == "groupBies":
            suggest = "group_bies"
        elif key == "groupInterval":
            suggest = "group_interval"
        elif key == "groupWait":
            suggest = "group_wait"
        elif key == "muteTimings":
            suggest = "mute_timings"
        elif key == "repeatInterval":
            suggest = "repeat_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_point: Optional[builtins.str] = None,
                 continue_: Optional[builtins.bool] = None,
                 group_bies: Optional[Sequence[builtins.str]] = None,
                 group_interval: Optional[builtins.str] = None,
                 group_wait: Optional[builtins.str] = None,
                 matchers: Optional[Sequence['outputs.NotificationPolicyPolicyMatcher']] = None,
                 mute_timings: Optional[Sequence[builtins.str]] = None,
                 policies: Optional[Sequence['outputs.NotificationPolicyPolicyPolicy']] = None,
                 repeat_interval: Optional[builtins.str] = None):
        """
        :param builtins.str contact_point: The contact point to route notifications that match this rule to.
        :param builtins.bool continue_: Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        :param Sequence[builtins.str] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. Required for root policy only. If empty, the parent grouping is used.
        :param builtins.str group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param builtins.str group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param Sequence['NotificationPolicyPolicyMatcherArgs'] matchers: Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        :param Sequence[builtins.str] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param Sequence['NotificationPolicyPolicyPolicyArgs'] policies: Routing rules for specific label sets.
        :param builtins.str repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        if contact_point is not None:
            pulumi.set(__self__, "contact_point", contact_point)
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> Optional[builtins.str]:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[builtins.bool]:
        """
        Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        """
        return pulumi.get(self, "continue_")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. Required for root policy only. If empty, the parent grouping is used.
        """
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[builtins.str]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @property
    @pulumi.getter
    def matchers(self) -> Optional[Sequence['outputs.NotificationPolicyPolicyMatcher']]:
        """
        Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        """
        return pulumi.get(self, "matchers")

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.NotificationPolicyPolicyPolicy']]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class NotificationPolicyPolicyMatcher(dict):
    def __init__(__self__, *,
                 label: builtins.str,
                 match: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str label: The name of the label to match against.
        :param builtins.str match: The operator to apply when matching values of the given label. Allowed operators are `=` for equality, `!=` for negated equality, `=~` for regex equality, and `!~` for negated regex equality.
        :param builtins.str value: The label value to match against.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        The name of the label to match against.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def match(self) -> builtins.str:
        """
        The operator to apply when matching values of the given label. Allowed operators are `=` for equality, `!=` for negated equality, `=~` for regex equality, and `!~` for negated regex equality.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The label value to match against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NotificationPolicyPolicyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactPoint":
            suggest = "contact_point"
        elif key == "continue":
            suggest = "continue_"
        elif key == "groupBies":
            suggest = "group_bies"
        elif key == "groupInterval":
            suggest = "group_interval"
        elif key == "groupWait":
            suggest = "group_wait"
        elif key == "muteTimings":
            suggest = "mute_timings"
        elif key == "repeatInterval":
            suggest = "repeat_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyPolicyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyPolicyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyPolicyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_point: Optional[builtins.str] = None,
                 continue_: Optional[builtins.bool] = None,
                 group_bies: Optional[Sequence[builtins.str]] = None,
                 group_interval: Optional[builtins.str] = None,
                 group_wait: Optional[builtins.str] = None,
                 matchers: Optional[Sequence['outputs.NotificationPolicyPolicyPolicyMatcher']] = None,
                 mute_timings: Optional[Sequence[builtins.str]] = None,
                 policies: Optional[Sequence['outputs.NotificationPolicyPolicyPolicyPolicy']] = None,
                 repeat_interval: Optional[builtins.str] = None):
        """
        :param builtins.str contact_point: The contact point to route notifications that match this rule to.
        :param builtins.bool continue_: Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        :param Sequence[builtins.str] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. Required for root policy only. If empty, the parent grouping is used.
        :param builtins.str group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param builtins.str group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param Sequence['NotificationPolicyPolicyPolicyMatcherArgs'] matchers: Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        :param Sequence[builtins.str] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param Sequence['NotificationPolicyPolicyPolicyPolicyArgs'] policies: Routing rules for specific label sets.
        :param builtins.str repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        if contact_point is not None:
            pulumi.set(__self__, "contact_point", contact_point)
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> Optional[builtins.str]:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[builtins.bool]:
        """
        Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        """
        return pulumi.get(self, "continue_")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. Required for root policy only. If empty, the parent grouping is used.
        """
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[builtins.str]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @property
    @pulumi.getter
    def matchers(self) -> Optional[Sequence['outputs.NotificationPolicyPolicyPolicyMatcher']]:
        """
        Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        """
        return pulumi.get(self, "matchers")

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.NotificationPolicyPolicyPolicyPolicy']]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class NotificationPolicyPolicyPolicyMatcher(dict):
    def __init__(__self__, *,
                 label: builtins.str,
                 match: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str label: The name of the label to match against.
        :param builtins.str match: The operator to apply when matching values of the given label. Allowed operators are `=` for equality, `!=` for negated equality, `=~` for regex equality, and `!~` for negated regex equality.
        :param builtins.str value: The label value to match against.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        The name of the label to match against.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def match(self) -> builtins.str:
        """
        The operator to apply when matching values of the given label. Allowed operators are `=` for equality, `!=` for negated equality, `=~` for regex equality, and `!~` for negated regex equality.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The label value to match against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NotificationPolicyPolicyPolicyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactPoint":
            suggest = "contact_point"
        elif key == "continue":
            suggest = "continue_"
        elif key == "groupBies":
            suggest = "group_bies"
        elif key == "groupInterval":
            suggest = "group_interval"
        elif key == "groupWait":
            suggest = "group_wait"
        elif key == "muteTimings":
            suggest = "mute_timings"
        elif key == "repeatInterval":
            suggest = "repeat_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyPolicyPolicyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyPolicyPolicyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyPolicyPolicyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_point: Optional[builtins.str] = None,
                 continue_: Optional[builtins.bool] = None,
                 group_bies: Optional[Sequence[builtins.str]] = None,
                 group_interval: Optional[builtins.str] = None,
                 group_wait: Optional[builtins.str] = None,
                 matchers: Optional[Sequence['outputs.NotificationPolicyPolicyPolicyPolicyMatcher']] = None,
                 mute_timings: Optional[Sequence[builtins.str]] = None,
                 policies: Optional[Sequence['outputs.NotificationPolicyPolicyPolicyPolicyPolicy']] = None,
                 repeat_interval: Optional[builtins.str] = None):
        """
        :param builtins.str contact_point: The contact point to route notifications that match this rule to.
        :param builtins.bool continue_: Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        :param Sequence[builtins.str] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. Required for root policy only. If empty, the parent grouping is used.
        :param builtins.str group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param builtins.str group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param Sequence['NotificationPolicyPolicyPolicyPolicyMatcherArgs'] matchers: Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        :param Sequence[builtins.str] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param Sequence['NotificationPolicyPolicyPolicyPolicyPolicyArgs'] policies: Routing rules for specific label sets.
        :param builtins.str repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        if contact_point is not None:
            pulumi.set(__self__, "contact_point", contact_point)
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> Optional[builtins.str]:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[builtins.bool]:
        """
        Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        """
        return pulumi.get(self, "continue_")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. Required for root policy only. If empty, the parent grouping is used.
        """
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[builtins.str]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @property
    @pulumi.getter
    def matchers(self) -> Optional[Sequence['outputs.NotificationPolicyPolicyPolicyPolicyMatcher']]:
        """
        Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        """
        return pulumi.get(self, "matchers")

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.NotificationPolicyPolicyPolicyPolicyPolicy']]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class NotificationPolicyPolicyPolicyPolicyMatcher(dict):
    def __init__(__self__, *,
                 label: builtins.str,
                 match: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str label: The name of the label to match against.
        :param builtins.str match: The operator to apply when matching values of the given label. Allowed operators are `=` for equality, `!=` for negated equality, `=~` for regex equality, and `!~` for negated regex equality.
        :param builtins.str value: The label value to match against.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        The name of the label to match against.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def match(self) -> builtins.str:
        """
        The operator to apply when matching values of the given label. Allowed operators are `=` for equality, `!=` for negated equality, `=~` for regex equality, and `!~` for negated regex equality.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The label value to match against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NotificationPolicyPolicyPolicyPolicyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupBies":
            suggest = "group_bies"
        elif key == "contactPoint":
            suggest = "contact_point"
        elif key == "continue":
            suggest = "continue_"
        elif key == "groupInterval":
            suggest = "group_interval"
        elif key == "groupWait":
            suggest = "group_wait"
        elif key == "muteTimings":
            suggest = "mute_timings"
        elif key == "repeatInterval":
            suggest = "repeat_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyPolicyPolicyPolicyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyPolicyPolicyPolicyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyPolicyPolicyPolicyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_bies: Sequence[builtins.str],
                 contact_point: Optional[builtins.str] = None,
                 continue_: Optional[builtins.bool] = None,
                 group_interval: Optional[builtins.str] = None,
                 group_wait: Optional[builtins.str] = None,
                 matchers: Optional[Sequence['outputs.NotificationPolicyPolicyPolicyPolicyPolicyMatcher']] = None,
                 mute_timings: Optional[Sequence[builtins.str]] = None,
                 repeat_interval: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. Required for root policy only. If empty, the parent grouping is used.
        :param builtins.str contact_point: The contact point to route notifications that match this rule to.
        :param builtins.bool continue_: Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        :param builtins.str group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param builtins.str group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param Sequence['NotificationPolicyPolicyPolicyPolicyPolicyMatcherArgs'] matchers: Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        :param Sequence[builtins.str] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param builtins.str repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        pulumi.set(__self__, "group_bies", group_bies)
        if contact_point is not None:
            pulumi.set(__self__, "contact_point", contact_point)
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Sequence[builtins.str]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. Required for root policy only. If empty, the parent grouping is used.
        """
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> Optional[builtins.str]:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[builtins.bool]:
        """
        Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        """
        return pulumi.get(self, "continue_")

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[builtins.str]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @property
    @pulumi.getter
    def matchers(self) -> Optional[Sequence['outputs.NotificationPolicyPolicyPolicyPolicyPolicyMatcher']]:
        """
        Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        """
        return pulumi.get(self, "matchers")

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class NotificationPolicyPolicyPolicyPolicyPolicyMatcher(dict):
    def __init__(__self__, *,
                 label: builtins.str,
                 match: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str label: The name of the label to match against.
        :param builtins.str match: The operator to apply when matching values of the given label. Allowed operators are `=` for equality, `!=` for negated equality, `=~` for regex equality, and `!~` for negated regex equality.
        :param builtins.str value: The label value to match against.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        The name of the label to match against.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def match(self) -> builtins.str:
        """
        The operator to apply when matching values of the given label. Allowed operators are `=` for equality, `!=` for negated equality, `=~` for regex equality, and `!~` for negated regex equality.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The label value to match against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleGroupRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "execErrState":
            suggest = "exec_err_state"
        elif key == "for":
            suggest = "for_"
        elif key == "isPaused":
            suggest = "is_paused"
        elif key == "keepFiringFor":
            suggest = "keep_firing_for"
        elif key == "missingSeriesEvalsToResolve":
            suggest = "missing_series_evals_to_resolve"
        elif key == "noDataState":
            suggest = "no_data_state"
        elif key == "notificationSettings":
            suggest = "notification_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datas: Sequence['outputs.RuleGroupRuleData'],
                 name: builtins.str,
                 annotations: Optional[Mapping[str, builtins.str]] = None,
                 condition: Optional[builtins.str] = None,
                 exec_err_state: Optional[builtins.str] = None,
                 for_: Optional[builtins.str] = None,
                 is_paused: Optional[builtins.bool] = None,
                 keep_firing_for: Optional[builtins.str] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 missing_series_evals_to_resolve: Optional[builtins.int] = None,
                 no_data_state: Optional[builtins.str] = None,
                 notification_settings: Optional['outputs.RuleGroupRuleNotificationSettings'] = None,
                 record: Optional['outputs.RuleGroupRuleRecord'] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param Sequence['RuleGroupRuleDataArgs'] datas: A sequence of stages that describe the contents of the rule.
        :param builtins.str name: The name of the alert rule.
        :param Mapping[str, builtins.str] annotations: Key-value pairs of metadata to attach to the alert rule. They add additional information, such as a `summary` or `runbook_url`, to help identify and investigate alerts. The `__dashboardUid__` and `__panelId__` annotations, which link alerts to a panel, must be set together. Defaults to `map[]`.
        :param builtins.str condition: The `ref_id` of the query node in the `data` field to use as the alert condition.
        :param builtins.str exec_err_state: Describes what state to enter when the rule's query is invalid and the rule cannot be executed. Options are OK, Error, KeepLast, and Alerting.  Defaults to Alerting if not set.
        :param builtins.str for_: The amount of time for which the rule must be breached for the rule to be considered to be Firing. Before this time has elapsed, the rule is only considered to be Pending. Defaults to `0`.
        :param builtins.bool is_paused: Sets whether the alert should be paused or not. Defaults to `false`.
        :param builtins.str keep_firing_for: The amount of time for which the rule will considered to be Recovering after initially Firing. Before this time has elapsed, the rule will continue to fire once it's been triggered.
        :param Mapping[str, builtins.str] labels: Key-value pairs to attach to the alert rule that can be used in matching, grouping, and routing. Defaults to `map[]`.
        :param builtins.int missing_series_evals_to_resolve: The number of missing series evaluations that must occur before the rule is considered to be resolved.
        :param builtins.str no_data_state: Describes what state to enter when the rule's query returns No Data. Options are OK, NoData, KeepLast, and Alerting. Defaults to NoData if not set.
        :param 'RuleGroupRuleNotificationSettingsArgs' notification_settings: Notification settings for the rule. If specified, it overrides the notification policies. Available since Grafana 10.4, requires feature flag 'alertingSimplifiedRouting' to be enabled.
        :param 'RuleGroupRuleRecordArgs' record: Settings for a recording rule. Available since Grafana 11.2, requires feature flag 'grafanaManagedRecordingRules' to be enabled.
        :param builtins.str uid: The unique identifier of the alert rule.
        """
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "name", name)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if exec_err_state is not None:
            pulumi.set(__self__, "exec_err_state", exec_err_state)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if is_paused is not None:
            pulumi.set(__self__, "is_paused", is_paused)
        if keep_firing_for is not None:
            pulumi.set(__self__, "keep_firing_for", keep_firing_for)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if missing_series_evals_to_resolve is not None:
            pulumi.set(__self__, "missing_series_evals_to_resolve", missing_series_evals_to_resolve)
        if no_data_state is not None:
            pulumi.set(__self__, "no_data_state", no_data_state)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if record is not None:
            pulumi.set(__self__, "record", record)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.RuleGroupRuleData']:
        """
        A sequence of stages that describe the contents of the rule.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value pairs of metadata to attach to the alert rule. They add additional information, such as a `summary` or `runbook_url`, to help identify and investigate alerts. The `__dashboardUid__` and `__panelId__` annotations, which link alerts to a panel, must be set together. Defaults to `map[]`.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def condition(self) -> Optional[builtins.str]:
        """
        The `ref_id` of the query node in the `data` field to use as the alert condition.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="execErrState")
    def exec_err_state(self) -> Optional[builtins.str]:
        """
        Describes what state to enter when the rule's query is invalid and the rule cannot be executed. Options are OK, Error, KeepLast, and Alerting.  Defaults to Alerting if not set.
        """
        return pulumi.get(self, "exec_err_state")

    @property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[builtins.str]:
        """
        The amount of time for which the rule must be breached for the rule to be considered to be Firing. Before this time has elapsed, the rule is only considered to be Pending. Defaults to `0`.
        """
        return pulumi.get(self, "for_")

    @property
    @pulumi.getter(name="isPaused")
    def is_paused(self) -> Optional[builtins.bool]:
        """
        Sets whether the alert should be paused or not. Defaults to `false`.
        """
        return pulumi.get(self, "is_paused")

    @property
    @pulumi.getter(name="keepFiringFor")
    def keep_firing_for(self) -> Optional[builtins.str]:
        """
        The amount of time for which the rule will considered to be Recovering after initially Firing. Before this time has elapsed, the rule will continue to fire once it's been triggered.
        """
        return pulumi.get(self, "keep_firing_for")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value pairs to attach to the alert rule that can be used in matching, grouping, and routing. Defaults to `map[]`.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="missingSeriesEvalsToResolve")
    def missing_series_evals_to_resolve(self) -> Optional[builtins.int]:
        """
        The number of missing series evaluations that must occur before the rule is considered to be resolved.
        """
        return pulumi.get(self, "missing_series_evals_to_resolve")

    @property
    @pulumi.getter(name="noDataState")
    def no_data_state(self) -> Optional[builtins.str]:
        """
        Describes what state to enter when the rule's query returns No Data. Options are OK, NoData, KeepLast, and Alerting. Defaults to NoData if not set.
        """
        return pulumi.get(self, "no_data_state")

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional['outputs.RuleGroupRuleNotificationSettings']:
        """
        Notification settings for the rule. If specified, it overrides the notification policies. Available since Grafana 10.4, requires feature flag 'alertingSimplifiedRouting' to be enabled.
        """
        return pulumi.get(self, "notification_settings")

    @property
    @pulumi.getter
    def record(self) -> Optional['outputs.RuleGroupRuleRecord']:
        """
        Settings for a recording rule. Available since Grafana 11.2, requires feature flag 'grafanaManagedRecordingRules' to be enabled.
        """
        return pulumi.get(self, "record")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        The unique identifier of the alert rule.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class RuleGroupRuleData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasourceUid":
            suggest = "datasource_uid"
        elif key == "refId":
            suggest = "ref_id"
        elif key == "relativeTimeRange":
            suggest = "relative_time_range"
        elif key == "queryType":
            suggest = "query_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRuleData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRuleData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRuleData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datasource_uid: builtins.str,
                 model: builtins.str,
                 ref_id: builtins.str,
                 relative_time_range: 'outputs.RuleGroupRuleDataRelativeTimeRange',
                 query_type: Optional[builtins.str] = None):
        """
        :param builtins.str datasource_uid: The UID of the datasource being queried, or "-100" if this stage is an expression stage.
        :param builtins.str model: Custom JSON data to send to the specified datasource when querying.
        :param builtins.str ref_id: A unique string to identify this query stage within a rule.
        :param 'RuleGroupRuleDataRelativeTimeRangeArgs' relative_time_range: The time range, relative to when the query is executed, across which to query.
        :param builtins.str query_type: An optional identifier for the type of query being executed. Defaults to ``.
        """
        pulumi.set(__self__, "datasource_uid", datasource_uid)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "relative_time_range", relative_time_range)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)

    @property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> builtins.str:
        """
        The UID of the datasource being queried, or "-100" if this stage is an expression stage.
        """
        return pulumi.get(self, "datasource_uid")

    @property
    @pulumi.getter
    def model(self) -> builtins.str:
        """
        Custom JSON data to send to the specified datasource when querying.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        A unique string to identify this query stage within a rule.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter(name="relativeTimeRange")
    def relative_time_range(self) -> 'outputs.RuleGroupRuleDataRelativeTimeRange':
        """
        The time range, relative to when the query is executed, across which to query.
        """
        return pulumi.get(self, "relative_time_range")

    @property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[builtins.str]:
        """
        An optional identifier for the type of query being executed. Defaults to ``.
        """
        return pulumi.get(self, "query_type")


@pulumi.output_type
class RuleGroupRuleDataRelativeTimeRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRuleDataRelativeTimeRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRuleDataRelativeTimeRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRuleDataRelativeTimeRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: builtins.int,
                 to: builtins.int):
        """
        :param builtins.int from_: The number of seconds in the past, relative to when the rule is evaluated, at which the time range begins.
        :param builtins.int to: The number of seconds in the past, relative to when the rule is evaluated, at which the time range ends.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> builtins.int:
        """
        The number of seconds in the past, relative to when the rule is evaluated, at which the time range begins.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> builtins.int:
        """
        The number of seconds in the past, relative to when the rule is evaluated, at which the time range ends.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class RuleGroupRuleNotificationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactPoint":
            suggest = "contact_point"
        elif key == "groupBies":
            suggest = "group_bies"
        elif key == "groupInterval":
            suggest = "group_interval"
        elif key == "groupWait":
            suggest = "group_wait"
        elif key == "muteTimings":
            suggest = "mute_timings"
        elif key == "repeatInterval":
            suggest = "repeat_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRuleNotificationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRuleNotificationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRuleNotificationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_point: builtins.str,
                 group_bies: Optional[Sequence[builtins.str]] = None,
                 group_interval: Optional[builtins.str] = None,
                 group_wait: Optional[builtins.str] = None,
                 mute_timings: Optional[Sequence[builtins.str]] = None,
                 repeat_interval: Optional[builtins.str] = None):
        """
        :param builtins.str contact_point: The contact point to route notifications that match this rule to.
        :param Sequence[builtins.str] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. If empty, no grouping is used. If specified, requires labels 'alertname' and 'grafana_folder' to be included.
        :param builtins.str group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param builtins.str group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param Sequence[builtins.str] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param builtins.str repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        pulumi.set(__self__, "contact_point", contact_point)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> builtins.str:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping. If empty, no grouping is used. If specified, requires labels 'alertname' and 'grafana_folder' to be included.
        """
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[builtins.str]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[builtins.str]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class RuleGroupRuleRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"
        elif key == "targetDatasourceUid":
            suggest = "target_datasource_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRuleRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRuleRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRuleRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: builtins.str,
                 metric: builtins.str,
                 target_datasource_uid: Optional[builtins.str] = None):
        """
        :param builtins.str from_: The ref id of the query node in the data field to use as the source of the metric.
        :param builtins.str metric: The name of the metric to write to.
        :param builtins.str target_datasource_uid: The UID of the datasource to write the metric to.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "metric", metric)
        if target_datasource_uid is not None:
            pulumi.set(__self__, "target_datasource_uid", target_datasource_uid)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> builtins.str:
        """
        The ref id of the query node in the data field to use as the source of the metric.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def metric(self) -> builtins.str:
        """
        The name of the metric to write to.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="targetDatasourceUid")
    def target_datasource_uid(self) -> Optional[builtins.str]:
        """
        The UID of the datasource to write the metric to.
        """
        return pulumi.get(self, "target_datasource_uid")


