# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AwsCloudwatchScrapeJobCustomNamespace',
    'AwsCloudwatchScrapeJobCustomNamespaceMetric',
    'AwsCloudwatchScrapeJobService',
    'AwsCloudwatchScrapeJobServiceMetric',
    'AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter',
    'AwsResourceMetadataScrapeJobService',
    'AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilter',
    'AzureCredentialAutoDiscoveryConfiguration',
    'AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration',
    'AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration',
    'AzureCredentialResourceDiscoveryTagFilter',
    'GetAwsCloudwatchScrapeJobCustomNamespaceResult',
    'GetAwsCloudwatchScrapeJobCustomNamespaceMetricResult',
    'GetAwsCloudwatchScrapeJobServiceResult',
    'GetAwsCloudwatchScrapeJobServiceMetricResult',
    'GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobServiceResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult',
    'GetAzureCredentialAutoDiscoveryConfigurationResult',
    'GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult',
    'GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult',
    'GetAzureCredentialResourceDiscoveryTagFilterResult',
]

@pulumi.output_type
class AwsCloudwatchScrapeJobCustomNamespace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scrapeIntervalSeconds":
            suggest = "scrape_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsCloudwatchScrapeJobCustomNamespace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsCloudwatchScrapeJobCustomNamespace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsCloudwatchScrapeJobCustomNamespace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 metrics: Optional[Sequence['outputs.AwsCloudwatchScrapeJobCustomNamespaceMetric']] = None,
                 scrape_interval_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str name: The name of the custom namespace to scrape.
        :param Sequence['AwsCloudwatchScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace. Defaults to `300`.
        """
        pulumi.set(__self__, "name", name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.AwsCloudwatchScrapeJobCustomNamespaceMetric']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[builtins.int]:
        """
        The interval in seconds to scrape the custom namespace. Defaults to `300`.
        """
        return pulumi.get(self, "scrape_interval_seconds")


@pulumi.output_type
class AwsCloudwatchScrapeJobCustomNamespaceMetric(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class AwsCloudwatchScrapeJobService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceDiscoveryTagFilters":
            suggest = "resource_discovery_tag_filters"
        elif key == "scrapeIntervalSeconds":
            suggest = "scrape_interval_seconds"
        elif key == "tagsToAddToMetrics":
            suggest = "tags_to_add_to_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsCloudwatchScrapeJobService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsCloudwatchScrapeJobService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsCloudwatchScrapeJobService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 metrics: Optional[Sequence['outputs.AwsCloudwatchScrapeJobServiceMetric']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter']] = None,
                 scrape_interval_seconds: Optional[builtins.int] = None,
                 tags_to_add_to_metrics: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        :param Sequence['AwsCloudwatchScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Please note that AWS metric names must be supplied, and not their PromQL counterparts. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        :param Sequence[builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        pulumi.set(__self__, "name", name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if tags_to_add_to_metrics is not None:
            pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.AwsCloudwatchScrapeJobServiceMetric']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Please note that AWS metric names must be supplied, and not their PromQL counterparts. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[builtins.int]:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Optional[Sequence[builtins.str]]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")


@pulumi.output_type
class AwsCloudwatchScrapeJobServiceMetric(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AwsResourceMetadataScrapeJobService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceDiscoveryTagFilters":
            suggest = "resource_discovery_tag_filters"
        elif key == "scrapeIntervalSeconds":
            suggest = "scrape_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsResourceMetadataScrapeJobService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsResourceMetadataScrapeJobService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsResourceMetadataScrapeJobService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilter']] = None,
                 scrape_interval_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        :param Sequence['AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        """
        pulumi.set(__self__, "name", name)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilter']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[builtins.int]:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        """
        return pulumi.get(self, "scrape_interval_seconds")


@pulumi.output_type
class AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AzureCredentialAutoDiscoveryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceTypeConfigurations":
            suggest = "resource_type_configurations"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureCredentialAutoDiscoveryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureCredentialAutoDiscoveryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureCredentialAutoDiscoveryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type_configurations: Sequence['outputs.AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration'],
                 subscription_id: builtins.str):
        """
        :param Sequence['AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationArgs'] resource_type_configurations: The list of resource type configurations.
        :param builtins.str subscription_id: The subscription ID of the Azure account.
        """
        pulumi.set(__self__, "resource_type_configurations", resource_type_configurations)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="resourceTypeConfigurations")
    def resource_type_configurations(self) -> Sequence['outputs.AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration']:
        """
        The list of resource type configurations.
        """
        return pulumi.get(self, "resource_type_configurations")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription ID of the Azure account.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricConfigurations":
            suggest = "metric_configurations"
        elif key == "resourceTypeName":
            suggest = "resource_type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_configurations: Sequence['outputs.AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration'],
                 resource_type_name: builtins.str):
        pulumi.set(__self__, "metric_configurations", metric_configurations)
        pulumi.set(__self__, "resource_type_name", resource_type_name)

    @property
    @pulumi.getter(name="metricConfigurations")
    def metric_configurations(self) -> Sequence['outputs.AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration']:
        return pulumi.get(self, "metric_configurations")

    @property
    @pulumi.getter(name="resourceTypeName")
    def resource_type_name(self) -> builtins.str:
        return pulumi.get(self, "resource_type_name")


@pulumi.output_type
class AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration(dict):
    def __init__(__self__, *,
                 aggregations: Sequence[builtins.str],
                 dimensions: Sequence[builtins.str],
                 name: builtins.str):
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def aggregations(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class AzureCredentialResourceDiscoveryTagFilter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobCustomNamespaceResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 scrape_interval_seconds: builtins.int,
                 metrics: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobCustomNamespaceMetricResult']] = None):
        """
        :param builtins.str name: The name of the custom namespace to scrape.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace.
        :param Sequence['GetAwsCloudwatchScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> builtins.int:
        """
        The interval in seconds to scrape the custom namespace.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobCustomNamespaceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobCustomNamespaceMetricResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobServiceResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 scrape_interval_seconds: builtins.int,
                 tags_to_add_to_metrics: Sequence[builtins.str],
                 metrics: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobServiceMetricResult']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult']] = None):
        """
        :param builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        :param Sequence[builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        :param Sequence['GetAwsCloudwatchScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> builtins.int:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Sequence[builtins.str]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobServiceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobServiceMetricResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobResult(dict):
    def __init__(__self__, *,
                 aws_account_resource_id: builtins.str,
                 disabled_reason: builtins.str,
                 enabled: builtins.bool,
                 export_tags: builtins.bool,
                 id: builtins.str,
                 name: builtins.str,
                 regions: Sequence[builtins.str],
                 regions_subset_override_used: builtins.bool,
                 role_arn: builtins.str,
                 stack_id: builtins.str,
                 static_labels: Mapping[str, builtins.str],
                 custom_namespaces: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult']] = None,
                 services: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceResult']] = None):
        """
        :param builtins.str aws_account_resource_id: The ID assigned by the Grafana Cloud Provider API to an AWS Account resource that should be associated with this AWS CloudWatch Scrape Job. This can be provided by the `resource_id` attribute of the `cloudProvider.AwsAccount` resource.
        :param builtins.str disabled_reason: When the AWS CloudWatch Scrape Job is disabled, this will show the reason that it is in that state.
        :param builtins.bool enabled: Whether the AWS CloudWatch Scrape Job is enabled or not.
        :param builtins.bool export_tags: When enabled, AWS resource tags are exported as Prometheus labels to metrics formatted as `aws_<service_name>_info`.
        :param Sequence[builtins.str] regions: The set of AWS region names that this AWS CloudWatch Scrape Job is configured to scrape.
        :param builtins.bool regions_subset_override_used: When true, the `regions` attribute will be the set of regions configured in the override. When false, the `regions` attribute will be the set of regions belonging to the AWS Account resource that is associated with this AWS CloudWatch Scrape Job.
        :param builtins.str role_arn: The AWS ARN of the IAM role associated with the AWS Account resource that is being used by this AWS CloudWatch Scrape Job.
        :param Mapping[str, builtins.str] static_labels: A set of static labels to add to all metrics exported by this scrape job.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceArgs'] custom_namespaces: Zero or more configuration blocks to configure custom namespaces for the AWS CloudWatch Scrape Job to scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobServiceArgs'] services: One or more configuration blocks to dictate what this AWS CloudWatch Scrape Job should scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "aws_account_resource_id", aws_account_resource_id)
        pulumi.set(__self__, "disabled_reason", disabled_reason)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "export_tags", export_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "regions_subset_override_used", regions_subset_override_used)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "static_labels", static_labels)
        if custom_namespaces is not None:
            pulumi.set(__self__, "custom_namespaces", custom_namespaces)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="awsAccountResourceId")
    def aws_account_resource_id(self) -> builtins.str:
        """
        The ID assigned by the Grafana Cloud Provider API to an AWS Account resource that should be associated with this AWS CloudWatch Scrape Job. This can be provided by the `resource_id` attribute of the `cloudProvider.AwsAccount` resource.
        """
        return pulumi.get(self, "aws_account_resource_id")

    @property
    @pulumi.getter(name="disabledReason")
    def disabled_reason(self) -> builtins.str:
        """
        When the AWS CloudWatch Scrape Job is disabled, this will show the reason that it is in that state.
        """
        return pulumi.get(self, "disabled_reason")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether the AWS CloudWatch Scrape Job is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="exportTags")
    def export_tags(self) -> builtins.bool:
        """
        When enabled, AWS resource tags are exported as Prometheus labels to metrics formatted as `aws_<service_name>_info`.
        """
        return pulumi.get(self, "export_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        The set of AWS region names that this AWS CloudWatch Scrape Job is configured to scrape.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="regionsSubsetOverrideUsed")
    def regions_subset_override_used(self) -> builtins.bool:
        """
        When true, the `regions` attribute will be the set of regions configured in the override. When false, the `regions` attribute will be the set of regions belonging to the AWS Account resource that is associated with this AWS CloudWatch Scrape Job.
        """
        return pulumi.get(self, "regions_subset_override_used")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The AWS ARN of the IAM role associated with the AWS Account resource that is being used by this AWS CloudWatch Scrape Job.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> builtins.str:
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter(name="staticLabels")
    def static_labels(self) -> Mapping[str, builtins.str]:
        """
        A set of static labels to add to all metrics exported by this scrape job.
        """
        return pulumi.get(self, "static_labels")

    @property
    @pulumi.getter(name="customNamespaces")
    def custom_namespaces(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult']]:
        """
        Zero or more configuration blocks to configure custom namespaces for the AWS CloudWatch Scrape Job to scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "custom_namespaces")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceResult']]:
        """
        One or more configuration blocks to dictate what this AWS CloudWatch Scrape Job should scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 scrape_interval_seconds: builtins.int,
                 metrics: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult']] = None):
        """
        :param builtins.str name: The name of the custom namespace to scrape.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> builtins.int:
        """
        The interval in seconds to scrape the custom namespace.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobServiceResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 scrape_interval_seconds: builtins.int,
                 tags_to_add_to_metrics: Sequence[builtins.str],
                 metrics: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult']] = None):
        """
        :param builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        :param Sequence[builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> builtins.int:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Sequence[builtins.str]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAzureCredentialAutoDiscoveryConfigurationResult(dict):
    def __init__(__self__, *,
                 resource_type_configurations: Sequence['outputs.GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult'],
                 subscription_id: builtins.str):
        """
        :param Sequence['GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationArgs'] resource_type_configurations: The list of resource type configurations.
        :param builtins.str subscription_id: The subscription ID of the Azure account.
        """
        pulumi.set(__self__, "resource_type_configurations", resource_type_configurations)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="resourceTypeConfigurations")
    def resource_type_configurations(self) -> Sequence['outputs.GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult']:
        """
        The list of resource type configurations.
        """
        return pulumi.get(self, "resource_type_configurations")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription ID of the Azure account.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult(dict):
    def __init__(__self__, *,
                 metric_configurations: Sequence['outputs.GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult'],
                 resource_type_name: builtins.str):
        pulumi.set(__self__, "metric_configurations", metric_configurations)
        pulumi.set(__self__, "resource_type_name", resource_type_name)

    @property
    @pulumi.getter(name="metricConfigurations")
    def metric_configurations(self) -> Sequence['outputs.GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult']:
        return pulumi.get(self, "metric_configurations")

    @property
    @pulumi.getter(name="resourceTypeName")
    def resource_type_name(self) -> builtins.str:
        return pulumi.get(self, "resource_type_name")


@pulumi.output_type
class GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult(dict):
    def __init__(__self__, *,
                 aggregations: Sequence[builtins.str],
                 dimensions: Sequence[builtins.str],
                 name: builtins.str):
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def aggregations(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAzureCredentialResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


