# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RoleAssignmentArgs', 'RoleAssignment']

@pulumi.input_type
class RoleAssignmentArgs:
    def __init__(__self__, *,
                 role_uid: pulumi.Input[builtins.str],
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None):
        """
        The set of arguments for constructing a RoleAssignment resource.
        :param pulumi.Input[builtins.str] role_uid: Grafana RBAC role UID.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] service_accounts: IDs of service accounts that the role should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] teams: IDs of teams that the role should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] users: IDs of users that the role should be assigned to.
        """
        pulumi.set(__self__, "role_uid", role_uid)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if service_accounts is not None:
            pulumi.set(__self__, "service_accounts", service_accounts)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="roleUid")
    def role_uid(self) -> pulumi.Input[builtins.str]:
        """
        Grafana RBAC role UID.
        """
        return pulumi.get(self, "role_uid")

    @role_uid.setter
    def role_uid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_uid", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        IDs of service accounts that the role should be assigned to.
        """
        return pulumi.get(self, "service_accounts")

    @service_accounts.setter
    def service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "service_accounts", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        IDs of teams that the role should be assigned to.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        IDs of users that the role should be assigned to.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _RoleAssignmentState:
    def __init__(__self__, *,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_uid: Optional[pulumi.Input[builtins.str]] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None):
        """
        Input properties used for looking up and filtering RoleAssignment resources.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] role_uid: Grafana RBAC role UID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] service_accounts: IDs of service accounts that the role should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] teams: IDs of teams that the role should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] users: IDs of users that the role should be assigned to.
        """
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if role_uid is not None:
            pulumi.set(__self__, "role_uid", role_uid)
        if service_accounts is not None:
            pulumi.set(__self__, "service_accounts", service_accounts)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="roleUid")
    def role_uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Grafana RBAC role UID.
        """
        return pulumi.get(self, "role_uid")

    @role_uid.setter
    def role_uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_uid", value)

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        IDs of service accounts that the role should be assigned to.
        """
        return pulumi.get(self, "service_accounts")

    @service_accounts.setter
    def service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "service_accounts", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        IDs of teams that the role should be assigned to.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        IDs of users that the role should be assigned to.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("grafana:enterprise/roleAssignment:RoleAssignment")
class RoleAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_uid: Optional[pulumi.Input[builtins.str]] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 __props__=None):
        """
        Manages the entire set of assignments for a role. Assignments that aren't specified when applying this resource will be removed.
        **Note:** This resource is available only with Grafana Enterprise 9.2+.
        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/roles-and-permissions/access-control/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/access_control/)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_role = grafana.enterprise.Role("test_role",
            name="Test Role",
            uid="testrole",
            version=1,
            global_=True,
            permissions=[{
                "action": "org.users:add",
                "scope": "users:*",
            }])
        test_team = grafana.oss.Team("test_team", name="terraform_test_team")
        test_user = grafana.oss.User("test_user",
            email="terraform_user@test.com",
            login="terraform_user@test.com",
            password="password")
        test_sa = grafana.oss.ServiceAccount("test_sa",
            name="terraform_test_sa",
            role="Viewer")
        test = grafana.enterprise.RoleAssignment("test",
            role_uid=test_role.uid,
            users=[test_user.id],
            teams=[test_team.id],
            service_accounts=[test_sa.id])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:enterprise/roleAssignment:RoleAssignment name "{{ roleUID }}"
        ```

        ```sh
        $ pulumi import grafana:enterprise/roleAssignment:RoleAssignment name "{{ orgID }}:{{ roleUID }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] role_uid: Grafana RBAC role UID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] service_accounts: IDs of service accounts that the role should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] teams: IDs of teams that the role should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] users: IDs of users that the role should be assigned to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the entire set of assignments for a role. Assignments that aren't specified when applying this resource will be removed.
        **Note:** This resource is available only with Grafana Enterprise 9.2+.
        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/roles-and-permissions/access-control/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/access_control/)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_role = grafana.enterprise.Role("test_role",
            name="Test Role",
            uid="testrole",
            version=1,
            global_=True,
            permissions=[{
                "action": "org.users:add",
                "scope": "users:*",
            }])
        test_team = grafana.oss.Team("test_team", name="terraform_test_team")
        test_user = grafana.oss.User("test_user",
            email="terraform_user@test.com",
            login="terraform_user@test.com",
            password="password")
        test_sa = grafana.oss.ServiceAccount("test_sa",
            name="terraform_test_sa",
            role="Viewer")
        test = grafana.enterprise.RoleAssignment("test",
            role_uid=test_role.uid,
            users=[test_user.id],
            teams=[test_team.id],
            service_accounts=[test_sa.id])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:enterprise/roleAssignment:RoleAssignment name "{{ roleUID }}"
        ```

        ```sh
        $ pulumi import grafana:enterprise/roleAssignment:RoleAssignment name "{{ orgID }}:{{ roleUID }}"
        ```

        :param str resource_name: The name of the resource.
        :param RoleAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_uid: Optional[pulumi.Input[builtins.str]] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleAssignmentArgs.__new__(RoleAssignmentArgs)

            __props__.__dict__["org_id"] = org_id
            if role_uid is None and not opts.urn:
                raise TypeError("Missing required property 'role_uid'")
            __props__.__dict__["role_uid"] = role_uid
            __props__.__dict__["service_accounts"] = service_accounts
            __props__.__dict__["teams"] = teams
            __props__.__dict__["users"] = users
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/roleAssignment:RoleAssignment")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(RoleAssignment, __self__).__init__(
            'grafana:enterprise/roleAssignment:RoleAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            role_uid: Optional[pulumi.Input[builtins.str]] = None,
            service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None) -> 'RoleAssignment':
        """
        Get an existing RoleAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] role_uid: Grafana RBAC role UID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] service_accounts: IDs of service accounts that the role should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] teams: IDs of teams that the role should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] users: IDs of users that the role should be assigned to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleAssignmentState.__new__(_RoleAssignmentState)

        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["role_uid"] = role_uid
        __props__.__dict__["service_accounts"] = service_accounts
        __props__.__dict__["teams"] = teams
        __props__.__dict__["users"] = users
        return RoleAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="roleUid")
    def role_uid(self) -> pulumi.Output[builtins.str]:
        """
        Grafana RBAC role UID.
        """
        return pulumi.get(self, "role_uid")

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        IDs of service accounts that the role should be assigned to.
        """
        return pulumi.get(self, "service_accounts")

    @property
    @pulumi.getter
    def teams(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        IDs of teams that the role should be assigned to.
        """
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        IDs of users that the role should be assigned to.
        """
        return pulumi.get(self, "users")

